/***
*int2f.c -  DOS INT 2fh multiplex interrupt
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

/*
   Versions:

   1.0   28-Nov-1997    created

   Release Notes:

   Seperate the hardware, OS specifics!

   Programming Notes:

   Very limited (gets Windows version). More later...

*/

#include <dos.h>

#include "general.h"    /* UINT16 and swapHILO() */
#include "int2f.h"

#ifndef __WATCOMC__
extern UINT16 int2f(UINT16 _ax)
{
#ifndef _ASM_DEFINED
union _REGS r;
   r.x.ax = _ax;
   _int86(0x2f,&r,&r);
   return (UINT16)r.x.ax;
#else
   __asm mov   ax,_ax
   __asm int   2fh
#endif
}
#endif

extern int winver(void)
{
UINT16 v;

   v = int2f(0x1600);

   if (v == 0x1600)
      v = 0;
   else
      v = swapHILO(v);

   return v;
   /*
      example:
      short win_ver = winver();
      printf("%d.%d",win_ver>>8,win_ver&0xff);
   */
}
