/***
*init.h - initialization stuff
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   See INIT.C.
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

#ifndef INIT_H
#define INIT_H

#ifndef KEYS_H
#include "keys.h"
#endif

enum INIT_ARGS { INIT_RESTORE, INIT_VIEW };

typedef enum {
   BOOL_ARG, NUM_ARG, TEXT_ARG, LONG_ARG, KEY_ARG, BITS_ARG
} ARGTYPE;

typedef struct keywords_t {
   KEY key;                   /* "hotkey" */
   int value;                 /* option value */
   char *keyword;             /* keyword */
   ARGTYPE type;
   char *chk;
} KEYWORDS;

extern KEYWORDS kw[];

/*
   Defines to make kw easy to use. The MUST be in the SAME order as
   KEYWORDS kw[] in INIT.C.
*/

enum keywords {
   _Display, _Get, _Home, _Verify, _Write,
   _Files, _Debug, _Ascii, _Partial, _Logical, _Translate, _Filter,
   _Radix, _Signon, _Output, _IgnoreCase, _BufMask,
   _Int13, _Ioctl, _nPartitions, _Retries, _RetryChng, _TempDir,
#ifdef HEAP_CHECKING
   _HeapCheck,
#endif
   NKEYWORDS
};

enum OUTPUTIO   { O_STDIO, O_BDOS, O_BIOS, O_BIOSX };
enum BUFFERMASK { B_NONE, B_STRIP, B_MASK, B_CONV };
enum DISPLYMASK { D_NONE, D_IBM, D_ASCII };

#ifdef HEAP_CHECKING
#define HeapCheck   kw[_HeapCheck ].value
#endif
#define TempDir     kw[_TempDir   ].chk         /* note: chk */
#define RetryChng   kw[_RetryChng ].value
#define Retries     kw[_Retries   ].value
#define nPartitions kw[_nPartitions].value
#define Ioctl       kw[_Ioctl     ].value
#define Int13       kw[_Int13     ].value
#define Bufmask     kw[_BufMask   ].value
#define IgnoreCase  kw[_IgnoreCase].value
#define Output      kw[_Output    ].value
#define Signon      kw[_Signon    ].value
#define Radix       kw[_Radix     ].value
#define Filter      kw[_Filter    ].value
#define Translate   kw[_Translate ].value
#define Logical     kw[_Logical   ].value
#define Partial     kw[_Partial   ].value
#define Ascii       kw[_Ascii     ].value
#define Debug       kw[_Debug     ].value
#define Files       kw[_Files     ].value
#define Write       kw[_Write     ].value
#define Verify      kw[_Verify    ].value
#define Home        kw[_Home      ].value
#define Get         kw[_Get       ].value
#define Display     kw[_Display   ].value

#define OutputTxt    kw[_Output   ].keyword
#define SignonTxt    kw[_Signon   ].keyword
#define RadixTxt     kw[_Radix    ].keyword
#define FilterTxt    kw[_Filter   ].keyword
#define TranslateTxt kw[_Translate].keyword
#define LogicalTxt   kw[_Logical  ].keyword
#define PartialTxt   kw[_Partial  ].keyword
#define AsciiTxt     kw[_Ascii    ].keyword
#define DebugTxt     kw[_Debug    ].keyword
#define FilesTxt     kw[_Files    ].keyword
#define WriteTxt     kw[_Write    ].keyword
#define VerifyTxt    kw[_Verify   ].keyword
#define HomeTxt      kw[_Home     ].keyword
#define GetTxt       kw[_Get      ].keyword
#define DisplayTxt   kw[_Display  ].keyword

extern int initialize(char *);
extern int setkeyword(unsigned int c, KEYWORDS *kw);
extern int init_save_array(void);
extern int saveinit(char *filename);
extern int getinit(char *filename, int arg);
extern void displaykeys(KEYWORDS *kw);
extern void dkey(KEYWORDS *str);
extern void ckey(char *s, KEYWORDS *str);
extern void psw(char c, KEYWORDS *str);


#endif
