/***
*dirent.h - struct/function declarations for directory handling.
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*  This include file contains the function declarations and structure
*  declarations for the functions related to directory handling.
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

/*
   Versions:

   1.3   03-Dec-1997    consolodated type names; added enums
   1.2   13-Dec-1994    dDIR was DIR -- fixes conflict with Watcom
   1.1   13-Nov-1993    DosTime and DosDate entries were backward.
                        Attribute is as well but I havent used it yet,
                        there may be alignment problems with it as well.
   1.0   June 1993
*/

#ifndef DIRENT_H
#define DIRENT_H

#ifndef GENERAL_H
#include "general.h"
#endif

#ifdef __GNUC__
#include <stddef.h> 	/* wchar_t */
#endif

enum
{
   FILENAM = 8,
   FILETYP = 3,
   FILELEN = FILENAM+FILETYP,
   ATTR = 11,
   CLUSTL = 26,
   CLUSTH = 27,
   ERACHR = 0xE5,
   DIRCHR = '.',
   WEIRDC = 5,
   ENDDIR = 0,
   DIRATR = 0x10,
   VOLATR = 8
};

#define ROOTDIRLEN   3           /* C:\ */


#if defined (_MSC_VER) && (_MSC_VER > 600)
#pragma warning(disable:4103)
#endif

#pragma pack(1)

typedef struct file_attrib {
   unsigned rdonly:1;
   unsigned hidden:1;
   unsigned system:1;
   unsigned volume:1;
   unsigned subdir:1;
   unsigned archiv:1;
   unsigned unused:2;
   unsigned shared:8;
} ATTRIB;

typedef struct file_time {
   unsigned seconds:5;
   unsigned minutes:6;
   unsigned hours:5;
} DOSTIME;

typedef struct file_date {
   unsigned day:5;
   unsigned month:4;
   unsigned year:7;
} DOSDATE;

typedef struct dir_entry {
   BYTE name[FILENAM];
   BYTE ext[FILETYP];
   ATTRIB attr;               /* shares BYTE reserved[1]; */
   BYTE reserved[9];
   DOSTIME time;
   DOSDATE date;
   UINT16 start;
   UINT32 size;
} DOSDIR;

typedef struct lfndir {
   BYTE name[FILENAM];
   BYTE ext[FILETYP];
   ATTRIB attr;               /* shares BYTE nt; */
   BYTE ms;
   DOSTIME ctime;
   DOSDATE cdate;
   DOSDATE adate;
   ATTRIB eattr;
   DOSTIME time;
   DOSDATE date;
   UINT16 start;
   UINT32 size;
} DOSLFNDIR;

enum { LNAME1 = 5, LNAME2 = 6, LNAME3 = 2 };

typedef struct lfn {
   BYTE ord;
   wchar_t name1[5];
   ATTRIB attr;               /* shares BYTE type; */
   BYTE cksum;
   wchar_t name2[6];
   UINT16 clust;
   wchar_t name3[2];
} DOSLFN;

typedef struct ext_dir_entry {
   BYTE ff;
   BYTE reserved0[5];
   BYTE a;
   BYTE d;
   BYTE name[FILENAM];
   BYTE ext[FILETYP];
   ATTRIB attr;               /* shares BYTE reserved[1]; */
   BYTE reserved[9];
   DOSTIME time;
   DOSDATE date;
   UINT16 start;
   UINT32 size;
} DOSEXTDIR;

typedef struct fcb {
   BYTE drive;
   BYTE name[FILENAM];
   BYTE ext[FILETYP];
   UINT16 blkno;
   UINT16 recsz;
   UINT32 size;
   UINT16 date;
   UINT16 time;
   BYTE reserved[8];
   BYTE recno;
   UINT32 recnum;
} DOSFCB;

typedef struct ext_fcb {
   BYTE ff;
   BYTE reserved1[5];
   BYTE a;
   BYTE drive;
   BYTE name[FILENAM];
   BYTE ext[FILETYP];
   UINT16 blkno;
   UINT16 recsz;
   UINT32 size;
   UINT16 date;
   UINT16 time;
   BYTE reserved[8];
   BYTE recno;
   UINT32 recnum;
} DOSEXTFCB;

#pragma pack()

extern int changedir(unsigned char *buf,int sec_size);
extern void dumpdir(unsigned char *buf,int sec_size);


#endif
