/***
*console.h - definitions/declarations for hardware specific functions.
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*  BIOS Screen, BIOS Keyboard, Video memory functions, etc.
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

/*
   Versions

   1.4   07-Mar-1997    BIOSX (extended keyboard)
   1.3   12-Sep-1996    removed replicate(); put() a function;
                        BUG FIX: charouta pragma had parm [ax bx]
                        which should have been parm [ax] [bx]
   1.2   19-Nov-1995    removed unused stuff
   1.1   01-Sep-1994    cleanup
   0.1   27-Aug-1994    fixed clreol() bug
*/

#ifndef GENERAL_H
#include "general.h"    /* machine dependent and compiler */
#endif                  /*  specific stuff */


extern void initvideo(int iomode);     /* hardware/environment specific stuff */

extern int (*input)(void);             /* pointer to keyboard input function */
extern int (*output)(int);             /* pointer to console output function */
extern int (*print)(const char *,...); /* formated printing */

extern void printc(const char *s);     /* centered print */
extern void bprint(const char *s);     /* print without moving cursor */
extern void disptext(char *text[]);    /* print arrays of text */
extern void put(int i, int c);         /* replicate a character */

/* BIOS output */

extern void charout(int c);
extern void charouta(int c, int a);

/* Cursor Positioning */

extern void get_cursor(unsigned int *a, unsigned int *b);
extern void set_cursor(unsigned int a, unsigned int b);
extern void savecursor(void);
extern void restcursor(void);
extern void curright(void);
extern void curleft(void);
#ifdef __GNUC__
#define clreol my_clreol
extern void my_clreol(void);
#else
extern void clreol(void);
#endif

/* Keyboard Input */

extern int scankey(void);
extern int xscankey(void);


#ifdef __WATCOMC__

#pragma aux scankey =   \
   "xor ax,ax"          \
   "int 16h"            \
   modify [ax];

#pragma aux xscankey =  \
   "mov ah,10h"         \
   "int 16h"            \
   modify [ax];

#pragma aux clreol =    \
   "mov ax,0x0A20"      \
   "xor bh,bh"          \
   "mov cx,79"          \
   "int 0x10"           \
   modify [ax bx cx];

#pragma aux charout =   \
   "mov ah,0x0A"        \
   "xor bh,bh"          \
   "mov cx,1"           \
   "int 0x10"           \
   parm [ax]            \
   modify [bx cx];

#pragma aux charouta =  \
   "mov ah,0x09"        \
   "xor bh,bh"          \
   "mov cx,1"           \
   "int 0x10"           \
   parm [ax] [bx]       \
   modify [cx];

#endif
