/*
 *	win32\write.c		absolute disk write
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#include "win32.h"
#include "dosio.h"

/*
 * disk_write		absolute disk write (INT 26h)
 *
 */

extern int disk_write(int disk, long sec, void *buf, int nsecs)
{
DIOC_REGISTERS regs;

	regs.d.eax = disk;
	regs.d.edx = sec;			   /* (truncate is okay) */
	regs.d.ecx = nsecs;
	regs.d.ebx = (DWORD)buf;

	if (win32_device_io(VWIN32_DIOC_DOS_INT25,&regs) == 0)
		return 0;

	if (regs.x.flags & 0x0001)
		return regs.h.al;

	return -1;
}

/*
 * disk_write_ext	absolute disk write (INT 26h), > 32MB
 *
 */

extern int disk_write_ext(int disk, long sec, void *buf, int nsecs)
{
DIOC_REGISTERS regs;
struct DCB dcb;

	dcb.sector = sec;
	dcb.number = (UINT16)nsecs;
	dcb.buffer = buf;
	regs.d.eax = disk;
	regs.d.ecx = 0xFFFF;
	regs.d.ebx = (DWORD)&dcb;

	if (win32_device_io(VWIN32_DIOC_DOS_INT25,&regs) == 0)
		return 0;

	if (regs.x.flags & 0x0001)
		return regs.h.al;

	return -1;
}
