/*
 *  types.h     d_disk; compiler/OS typedefs and macros
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#ifndef TYPES_H
#define TYPES_H

#include <limits.h>

typedef unsigned char BYTE;         /* (I'm starting to dislike these...) */
typedef unsigned int UINT;
typedef short INT16;
typedef long INT32;
typedef unsigned short UINT16;
typedef unsigned long UINT32;

/* misc. */

#if LONG_MAX > INT_MAX
#define LARGE __huge                /* a neccesary evil */
#define SMALL_DATA
#else
#define LARGE
#endif

/* debugger breakpoints */

#ifdef __WATCOMC__
#pragma aux int3 = \
   "int 3";
void int3(void);
#endif

#if defined __GNUC__
#define int3() asm("int $3");
#endif

#ifdef _MSC_VER
#define int3() __asm int 3
#ifdef _WIN32
#endif
#endif

#endif
