/*
 *	dos\dos.h
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 *	02-Apr-1998 greggj
 */

#include <dos.h>
#ifdef __GNUC__
#include <go32.h>
#include <dpmi.h>
#include <sys/movedata.h>
#endif

#include "dosio.h"

#define AMIBIOSBUG

/* dump registers and DOS errors during DOS/BIOS calls */

#ifdef TRACE
void err_dump(const char *);
void reg_dump(union REGS *regs, struct SREGS *sregs);
#define DBG_err_dump(s) err_dump(s)
#define DBG_reg_dump(r,s) reg_dump(r,s)
#define DBG_0 ={0}
#ifdef __GNUC__
void dpmi_dump(__dpmi_regs *regs);
#define DBG_dpmi_dump(r) dpmi_dump(r)
#endif
#else
#define DBG_err_dump(s)
#define DBG_reg_dump(r,s)
#define DBG_dpmi_dump(r)
#define DBG_0
#endif

#ifdef __GNUC__
/* link with dosmem.c or use the macros */
int _dosmalloc(int size, int *sel);
void _setdosmem(void *buffer, int size, int selector);
void _getdosmem(void *buffer, int size, int selector);
void _dosfree(int selector);
#define dosmalloc(siz,sel)	  __dpmi_allocate_dos_memory((siz+15)>>4,sel)
#define setdosmem(b,siz,sel)  _movedatab(_my_ds(),(unsigned int)b,sel,0,siz)
#define getdosmem(b,siz,sel)  _movedatab(sel,0,_my_ds(),(unsigned int)b,siz)
#define dosfree(sel)		  __dpmi_free_dos_memory(sel)
#define _MK_FP(seg) 		  (void *)(seg << 16)
#endif
