/*
 *  dos\debug.h
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 *  02-Apr-1998 greggj  was dos.h
 */

#define AMIBIOSBUG

/* dump registers and DOS errors during DOS/BIOS calls */

#ifdef TRACE
void err_dump(const char *);
void reg_dump(union REGS *regs, struct SREGS *sregs);
#define DBG_err_dump(s) err_dump(s)
#define DBG_reg_dump(r,s) reg_dump(r,s)
#define DBG_0 ={0}
#ifdef __GNUC__
void dpmi_dump(__dpmi_regs *regs);
#define DBG_dpmi_dump(r) dpmi_dump(r)
#endif
#else
#define DBG_err_dump(s)
#define DBG_reg_dump(r,s)
#define DBG_dpmi_dump(r)
#define DBG_0
#endif
