/*
 *  d_perror.c      display d_errno mapped text
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "d_disk.h"
#include "d_error.h"

static struct {
    const char *text;
    int value;
} errors[] = {
    {"No Error",0},
    {"malloc() falure [D_ENOMEM]",D_ENOMEM},
    {"disk opened read-only [D_ERDOLY]",D_ERDONLY},
    {"Invalid Disk Handle [D_EHANDLE]",D_EHANDLE},
    {"Invalid Argument [D_EINVAL]",D_EINVAL},
    {"Unknown Unit [D_EUNIT]",D_EUNIT},
    {"Drive Not Ready [D_ENREADY]",D_ENREADY},
    {"Unknown Command [D_EINVCMD]",D_EINVCMD},
    {"Data Error (CRC) [D_ECRC]",D_ECRC},
    {"Bad Request Structure Length [D_EREQ]",D_EREQ},
    {"Seek Error [D_ESEEK]",D_ESEEK},
    {"Unknown Media Type [D_ETYPE]",D_ETYPE},
    {"Sector Not Found [D_ESECNO]",D_ESECNO},
    {"Write Fault [D_EWRITE]",D_EWRITE},
    {"Read Fault [D_EREAD]",D_EREAD},
    {"General Failure [D_EGENF]",D_EGENF},
    {"Invalid Disk Change [D_EINVCH]",D_EINVCH},
    {"Invalid command [D_EINVCMD]",D_EINVCMD},
    {"Invalid media [D_EINVMED]",D_EINVMED},
    {"Address mark not found [D_EADDR]",D_EADDR},
    {"Seek failure [D_ESEEKF]",D_ESEEKF},
    {"Controller failure [D_ECONTRL]",D_ECONTRL},
    {"Disk write protected [D_EWPROT]",D_EWPROT},
    {"Reset failure [D_ERESET]",D_ERESET},
    {"DMA error/overrun [D_EDMA]",D_EDMA},
    {"Bad sector/track detected [D_EBAD]",D_EBAD},
    {"unknown error",D_EUNKNOWN},
    {NULL,0}
};

void d_perror(const char *str)
{
int i;

    if (str && *str)
        fprintf(stderr,"%s : ",str);

    if (d_errno == D_EDOS) {
        fprintf(stderr,"%s [DOS]",strerror(errno));
        return;
    }

    for (i = 0; errors[i].text; i++)
        if (errors[i].value == d_errno)
            break;
    if (!errors[i].text)
        i = 0;

#ifndef NDEBUG
    fprintf(stderr,"%s %d",errors[i].text,d_errno);
#else
    fprintf(stderr,"%s",errors[i].text);
#endif
}
