/*
 *  d_lib.h     non-public prototypes and macros
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#ifndef D_LIB_H
#define D_LIB_H

typedef enum SYS_RETURNS {
    SYSOK = -1,
    SYSERR = 0
} SYSRESULT;

typedef enum DISK_IO_TYPES {
    INT25,
    INT25X,
    INT13,
    IOCTL,
    INT7305
} IOTYPE;

struct disk {
    int dh;             /* handle */
    int drv;            /* drive number */
    int mode;           /* mode (read, r/w, binary) */
    int media;          /* media type */
    int iotype;         /* I/O function type */
    long sec;           /* current disk position (next read) */
    int secsiz;         /* (disk i/o needs buffer size for dosmemget) */

    /* the stuff needed for logical to physical translations */

    int maxs;           /* maximum sector number [sectors per track] */
    int maxh;           /* maximum head number [number of heads] */
    int hsecs;          /* number of hidden sectors (partition sectors) */
    int t,s,h;          /* track, sector, head (of 'sec' above) */
    int phys;           /* physical drive number (if partition) */
    long offs;          /* track offset (if partition) */

    struct disk *dd;    /* link to next open disk handle */
};

#ifndef NDEBUG
void insertdisk(struct disk *d);       /* insert an open'd handle */
struct disk *removedisk(int dh);       /* remove (extract) " */
struct disk *handle_todisk(int dh);    /* handle to struct * */
void setphysical(struct disk *dd);
int diskread(struct disk *dd, void *buf, int nsecs);
#endif

#ifndef DISKLIB
#include "disklib.h"
#else
#include "..\disklib\disklib.h"
#define DISK_OK 0
#endif

#endif
