/***
*keys.h  -  IBM PC keyboard defs
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   Error messages.
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

#ifndef KEYS_H
#define KEYS_H

/* KEY DEFINITIONS */

#define INS_ON      (1<<7)
#define CAPS_LOCK   (1<<6)
#define NUM_LOCK    (1<<5)
#define SCRL_LOCK   (1<<4)
#define ALT_MSK     (1<<3)
#define CTRL_MSK    (1<<2)
#define LSHFT_MSK   (1<<1)
#define RSHFT_MSK   (1)
#define SHFT_MSK    (LSHFT_MSK|RSHFT_MSK)

/* Actual Keyboard Scan Codes plus a few extra things */

typedef enum KEY_CODES {

NUL = 0, ESC = 0x1B, CR = 13, BS = 8, TAB = 9,

RETURN = 0x1C0D, BACKSP = 0x0E08,
SHTAB  = 0x0F00, ESCAPE = 0x011B, TABKEY = 0x0F09,

F1     = 0x3B00, F2     = 0x3C00, F3     = 0x3D00,
F4     = 0x3E00, F5     = 0x3F00, F6     = 0x4000,
F7     = 0x4100, F8     = 0x4200, F9     = 0x4300,
F10    = 0x4400,

SHFTF1 = 0x5400, SHFTF2 = 0x5500, SHFTF3 = 0x5600,
SHFTF4 = 0x5700, SHFTF5 = 0x5800, SHFTF6 = 0x5900,
SHFTF7 = 0x5A00, SHFTF8 = 0x5B00, SHFTF9 = 0x5C00,
SHFTF0 = 0x5D00,

CTRLF1 = 0x5E00, CTRLF2 = 0x5F00, CTRLF3 = 0x6000,
CTRLF4 = 0x6100, CTRLF5 = 0x6200, CTRLF6 = 0x6300,
CTRLF7 = 0x6400, CTRLF8 = 0x6500, CTRLF9 = 0x6600,
CTRLF0 = 0x6700,

ALTF1  = 0x6800, ALTF2  = 0x6900, ALTF3  = 0x6A00,
ALTF4  = 0x6B00, ALTF5  = 0x6C00, ALTF6  = 0x6D00,
ALTF7  = 0x6E00, ALTF8  = 0x6F00, ALTF9  = 0x7000,
ALTF0  = 0x7100,

ALT1   = 0x7800, ALT2   = 0x7900, ALT3   = 0x7A00,
ALT4   = 0x7B00, ALT5   = 0x7C00, ALT6   = 0x7D00,
#if defined _MSC_VER && _MSC_VER < 700
ALT7   = 0x7E00, ALT8   = 0x7F00,
#else
ALT7   = 0x7E00, ALT8   = 0x7F00, ALT9   = ((int)0x8000),
#endif
ALT0   = ((int)0x8100),

ALTA   = 0x1E00, ALTB   = 0x3000, ALTC   = 0x2E00,
ALTD   = 0x2000, ALTE   = 0x1200, ALTF   = 0x2100,
ALTG   = 0x2200, ALTH   = 0x2300, ALTI   = 0x1700,
ALTJ   = 0x2400, ALTK   = 0x2500, ALTL   = 0x2600,
ALTM   = 0x3200, ALTN   = 0x3100, ALTO   = 0x1800,
ALTP   = 0x1900, ALTQ   = 0x1000, ALTR   = 0x1300,
ALTS   = 0x1F00, ALTT   = 0x1400, ALTU   = 0x1600,
ALTV   = 0x2F00, ALTW   = 0x1100, ALTX   = 0x2D00,
ALTY   = 0x1500, ALTZ   = 0x2C00,

ALTSL  = 0x3500,  /* Alt-/ (slash) */
CTLBSL = 0x001C,  /* Ctl-\ (backslash) */

UP     = 0x4800, DOWN   = 0x5000, RIGHT  = 0x4D00,
LEFT   = 0x4B00, HOME   = 0x4700, END    = 0x4F00,
PGUP   = 0x4900, PGDN   = 0x5100, INS    = 0x5200,
DEL    = 0x5300,

SUP    = 0x4838, SDOWN  = 0x5032, SRIGHT = 0x4D36,
SLEFT  = 0x4B34, SHOME  = 0x4737, SEND   = 0x4F31,
SPGUP  = 0x4939, SPGDN  = 0x5133, SINS   = 0x5230,
SDEL   = 0x532E,

CRIGHT = 0x7400, CLEFT  = 0x7300, CHOME  = 0x7700,
CEND   = 0x7500, CPGUP  = (int)0x8400,
CPGDN  = 0x7600, CDEL   = 0x5300,

NUMD   = 0x532E, NUM0   = 0x5230, NUM1   = 0x4F31,
NUM2   = 0x5032, NUM3   = 0x5133, NUM4   = 0x4B34,
NUM5   = 0x4C35, NUM6   = 0x4D36, NUM7   = 0x4737,
NUM8   = 0x4838, NUM9   = 0x4939
} KEY;

#if defined _MSC_VER && _MSC_VER < 700
#define ALT9 0x8000
#endif

/* Character Definitions */

typedef enum CONTROL_CHARS {
CTRLA  = 0x0001, CTRLB  = 0x0002, CTRLC  = 0x0003,
CTRLD  = 0x0004, CTRLE  = 0x0005, CTRLF  = 0x0006,
CTRLG  = 0x0007, CTRLH  = 0x0008, CTRLI  = 0x0009,
CTRLJ  = 0x000A, CTRLK  = 0x000B, CTRLL  = 0x000C,
CTRLM  = 0x000D, CTRLN  = 0x000E, CTRLO  = 0x000F,
CTRLP  = 0x0010, CTRLQ  = 0x0011, CTRLR  = 0x0012,
CTRLS  = 0x0013, CTRLT  = 0x0014, CTRLU  = 0x0015,
CTRLV  = 0x0016, CTRLW  = 0x0017, CTRLX  = 0x0018,
CTRLY  = 0x0019, CTRLZ  = 0x001A
} CTRL;

#endif
