/***
*int13.c -  BIOS INT 13h interface
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   BIOS Interrupt 13h calls
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

/*
   Versions:

   1.0   28-Nov-1997    created

   Release Notes:

   Seperate the hardware, OS specifics!

   Programming Notes:

   Crude and miminal...

*/

#include <limits.h>           /* CHAR_BIT */

#include <dos.h>              /* int86() */
#include <bios.h>             /* _bios_disk() */

#include "int13.h"

#ifdef DISKED
#include "init.h"
#else
int Retries = 2;
int RetryChng = 1;
#endif

static int adjdrv(int drv);

extern int int13(int cmd, int disk, int t, int s, int h, int n, char *buf)
{
int c;
unsigned i = 0;
struct _diskinfo_t blk;

   blk.drive = adjdrv(disk);
   switch (cmd)
   {
      case BIOS_READ:
      case BIOS_WRITE:
         blk.track = t;
         blk.sector = s;
         blk.head = h;
         blk.nsectors = n;
         blk.buffer = buf;
         break;
      case BIOS_RESET:
      case BIOS_STATUS:
         return _bios_disk(cmd,&blk) >> CHAR_BIT;
         break;
      default:
         return 1;
   }
   for (c = 0; c < Retries; c++)
   {
      _bios_disk(cmd,&blk);
      i = _bios_disk(BIOS_STATUS,&blk);
      if ((i >>= CHAR_BIT) == 0)
         return -1;
      if (i == 6 && !RetryChng)
         break;
   }
   return (int)i;
}

#ifndef DISKED    /* disked does not need this */

extern int int13getparam(int disk, int *t, int *s, int *h)
{
int tmp;
union REGS regs;

   regs.x.ax = 0x0800;           /* get drive parameters */
   regs.h.dl = (unsigned char)adjdrv(disk);
   int86(0x13,&regs,&regs);
   if (regs.x.cflag)
      return (int)regs.h.ah;

   if (regs.h.bl == 0)           /* no drive connected/not found */
      return -1;

   *h = regs.h.dh;
   *t = regs.h.ch;               /* low bits only */
   tmp = *s = regs.h.cl;         /* has high bits of track also */
   *s &= 0x3f;                   /* mask off track high bits */
   *t += (tmp >> 6) << 8;        /* shift and add track high bits */

   return 0;
}

#endif

/* floppys: 0 - 7Fh, hards: 80h - FFh */

static int adjdrv(int drv)
{
   if (drv > 2)
      return drv + (0x80 - 3);
   return drv - 1;
}

static struct int13_msg {
   int code;
   char *msg;
} int13_diskerr_msg[] = {
   { 0x01, "bad command" },
   { 0x02, "address mark not found" },
   { 0x03, "write-protected disk" },
   { 0x04, "sector not found" },
   { 0x05, "reset failed" },
   { 0x06, "diskette removed or changed" },
   { 0x07, "bad parameter table" },
   { 0x08, "DMA overrun" },
   { 0x09, "attempt to DMA across 64K boundary" },
   { 0x0A, "bad sector detected" },
   { 0x0B, "bad track detected" },
   { 0x0C, "unsupported track or media type not found" },
   { 0x0D, "invalid number of sectors on format" },
   { 0x0E, "control data address mark detected" },
   { 0x0F, "DMA arbitration level out of range" },
   { 0x10, "uncorrectable CRC/EEC on read" },
   { 0x11, "ECC corrected data error" },
   { 0x20, "controller failure" },
   { 0x40, "seek failed" },
   { 0x80, "timeout" },
   { 0xAA, "drive not ready" },
   { 0xBB, "undefined error" },
   { 0xCC, "write fault" },
   { 0xE0, "status error" },
   { 0xFF, "sense operation failed" },
   { 0,    "unknown error" }
};

#define nerrors (sizeof(int13_diskerr_msg)/sizeof(struct int13_msg))

extern const char *int13error(int error)
{
int i;
char *errmsg;

   for (i = 0; i < nerrors; i++)
      if (int13_diskerr_msg[i].code == error)
         break;
   if (i > nerrors)
      i = nerrors-1;

   errmsg = int13_diskerr_msg[i].msg;

   return errmsg;
}
