/*
   Nondrdts.c - '.' and '..' for directory checking .
   Copyright (C) 2002 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/

#include <stdio.h>
#include <string.h>

#include "fte.h"
#include "..\chkdrvr.h"
#include "..\struct\FstTrMap.h"

static BOOL NonDirDOTFinder(RDWRHandle handle, struct DirectoryPosition* pos,
                            struct DirectoryEntry* entry, void** structure);
static BOOL DOTRenamer(RDWRHandle handle, struct DirectoryPosition* pos,
                       struct DirectoryEntry* entry, void** structure);
static BOOL RenameDOT(RDWRHandle handle, struct DirectoryPosition* pos);
static BOOL RenameDOTDOT(RDWRHandle handle, struct DirectoryPosition* pos);

/* Checking */

RETVAL FindNonDirectoryDots(RDWRHandle handle)
{
    BOOL invalid=FALSE, *pinvalid = &invalid;

    if (!FastWalkDirectoryTree(handle, NonDirDOTFinder, (void**) &pinvalid))
       return ERROR;

    return (invalid) ? FAILED : SUCCESS;
}

static BOOL NonDirDOTFinder(RDWRHandle handle, struct DirectoryPosition* pos,
                            struct DirectoryEntry* entry, void** structure)
{
    BOOL *invalid = *((BOOL**) structure);

    if (!GetDirectory(handle, pos, entry))
       return FAIL;

    if ((IsPreviousDir(*entry) || IsCurrentDir(*entry)) &&
	((entry->attribute & FA_DIREC) == 0))
    {
       if (IsPreviousDir(*entry))
          printf(".. entry found that is not a directory\n");
       else
          printf(". entry found that is not a directory\n");

       *invalid = TRUE;
    }

    return TRUE;
}

/* Fixing */

RETVAL RenameNonDirectoryDots(RDWRHandle handle)
{
    return (FastWalkDirectoryTree(handle, DOTRenamer, NULL)) ?
           SUCCESS : ERROR;
}

static BOOL DOTRenamer(RDWRHandle handle, struct DirectoryPosition* pos,
                       struct DirectoryEntry* entry, void** structure)
{
    structure = structure;
    
    if (!GetDirectory(handle, pos, entry))
       return FAIL;

    if ((IsPreviousDir(*entry) || IsCurrentDir(*entry)) &&
	((entry->attribute & FA_DIREC) == 0))
    {
       if (IsPreviousDir(*entry))
       {
          printf(".. entry found that is not a directory\n");
          if (!RenameDOTDOT(handle, pos))
             return FAIL;
       }
       else
       {
          printf(". entry found that is not a directory\n");
          if (!RenameDOT(handle, pos))
             return FAIL;
       }
    }
    
    return TRUE;
}

static BOOL RenameDOT(RDWRHandle handle, struct DirectoryPosition* pos)
{
    struct DirectoryEntry entry;

    if (!GetDirectory(handle, pos, &entry))
       return FALSE;

    memcpy(entry.filename, "DOT     ", 8);

    if (!WriteDirectory(handle, pos, &entry))
       return FALSE;

    return TRUE;
}

static BOOL RenameDOTDOT(RDWRHandle handle, struct DirectoryPosition* pos)
{
    struct DirectoryEntry entry;

    if (!GetDirectory(handle, pos, &entry))
       return FALSE;

    memcpy(entry.filename, "DOTDOT  ", 8);

    if (!WriteDirectory(handle, pos, &entry))
       return FALSE;

    return TRUE;
}
