/*    
   Methods.c - method dialog box.
   Copyright (C) 2000 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/

#include <stdlib.h>

#include "dialog.h"
#include "methods.h"
#include "..\screen\screen.h"
#include "..\winman\control.h"
#include "..\winman\window.h"
#include "..\winman\winman.h"
#include "..\winman\controls.h"
#include "..\winman\slctbtn.h"

#include "..\..\misc\bool.h"

#include "..\..\modlgate\defrpars.h"

#include "..\helpsys\hlpindex.h"
#include "..\helpsys\idxstack.h"

#define DIALOG_X       2
#define DIALOG_Y       3
#define DIALOG_X_LEN  76
#define DIALOG_Y_LEN  20
#define SELECTION_X   DIALOG_X + 4
#define TEXT_X        DIALOG_X + (DIALOG_X_LEN / 2) + 2
#define BUTTON_LENGTH 10

#define BUTTON_X1     DIALOG_X + (DIALOG_X_LEN / 2) - BUTTON_LENGTH - 2
#define BUTTON_X2     DIALOG_X + (DIALOG_X_LEN / 2) + 1

#define BUTTON_Y      DIALOG_Y + 18
#define PUSHLEN       (DIALOG_X_LEN / 2) - 2

#define HIGHLIGHTFOR WHITE

#define AMOFCONTROLS 18
#define AMOF_METHODS  7

static struct Control controls[AMOFCONTROLS];

#define CANCELBUTTON 17

extern struct CommandButton OkButton;
extern struct CommandButton CancelButton;

#define AD &controls[9]

static struct SelectButton
 SButtons[] = 
   {{"No defragmentation",     FALSE, HIGHLIGHTFOR, PUSHLEN, 0, AD, AMOF_METHODS, NULL},
    {"Full Optimization",      FALSE, HIGHLIGHTFOR, PUSHLEN, 1, AD, AMOF_METHODS, NULL},
    {"Unfragment Files only",  FALSE, HIGHLIGHTFOR, PUSHLEN, 2, AD, AMOF_METHODS, NULL},
    {"Files first",            FALSE, HIGHLIGHTFOR, PUSHLEN, 3, AD, AMOF_METHODS, NULL},
    {"Directories first",      FALSE, HIGHLIGHTFOR, PUSHLEN, 4, AD, AMOF_METHODS, NULL},
    {"Directories with files", FALSE, HIGHLIGHTFOR, PUSHLEN, 5, AD, AMOF_METHODS, NULL},
    {"Crunch only",            FALSE, HIGHLIGHTFOR, PUSHLEN, 6, AD, AMOF_METHODS, NULL}};



static struct Window MethodWin = {DIALOG_X, DIALOG_Y,
                                  DIALOG_X_LEN, DIALOG_Y_LEN,
                                  DIALOGBACKCOLOR, DIALOGFORCOLOR,
                                  " Select optimization method ",
                                  controls,
                                  AMOFCONTROLS};

static void Initialize(void)
{
    controls[0] = CreateLabel("Do not perform any optimization",
                              DIALOGFORCOLOR, DIALOGBACKCOLOR,
                              TEXT_X, DIALOG_Y + 2);        
        
    controls[1] = CreateLabel("Fully optimizes your disk",
                              DIALOGFORCOLOR, DIALOGBACKCOLOR,
                              TEXT_X, DIALOG_Y + 4);

    controls[2] = CreateLabel("Unfragment files only,",
                              DIALOGFORCOLOR, DIALOGBACKCOLOR,
                              TEXT_X, DIALOG_Y + 6);
    
    controls[3] = CreateLabel("possibly leaving holes",
                              DIALOGFORCOLOR, DIALOGBACKCOLOR,
                              TEXT_X, DIALOG_Y + 7);
                              
    controls[4] = CreateLabel("Move all files to the front",
                              DIALOGFORCOLOR, DIALOGBACKCOLOR,
                              TEXT_X, DIALOG_Y + 9);
                              
    controls[5] = CreateLabel("Move all directories to the front",
                              DIALOGFORCOLOR, DIALOGBACKCOLOR,
                              TEXT_X, DIALOG_Y + 11);    
                               
    controls[6] = CreateLabel("Place directories and files together",
                              DIALOGFORCOLOR, DIALOGBACKCOLOR,
                              TEXT_X, DIALOG_Y + 13); 

    controls[7] = CreateLabel("Move all data to the front,",
                              DIALOGFORCOLOR, DIALOGBACKCOLOR,
                              TEXT_X, DIALOG_Y + 15);
                              
    controls[8] = CreateLabel("without defragmenting it",
                              DIALOGFORCOLOR, DIALOGBACKCOLOR,
                              TEXT_X, DIALOG_Y + 16);                               

    controls[9] = CreateSelectionButton(&SButtons[0],
                                        DIALOGFORCOLOR, DIALOGBACKCOLOR,
                                        SELECTION_X, DIALOG_Y + 2);

    controls[10] = CreateSelectionButton(&SButtons[1],
                                        DIALOGFORCOLOR, DIALOGBACKCOLOR,
                                        SELECTION_X, DIALOG_Y + 4);

    controls[11] = CreateSelectionButton(&SButtons[2],
                                        DIALOGFORCOLOR, DIALOGBACKCOLOR,
                                        SELECTION_X, DIALOG_Y + 6);

    controls[12] = CreateSelectionButton(&SButtons[3],
                                        DIALOGFORCOLOR, DIALOGBACKCOLOR,
                                        SELECTION_X, DIALOG_Y + 9);

    controls[13] = CreateSelectionButton(&SButtons[4],
                                        DIALOGFORCOLOR, DIALOGBACKCOLOR,
                                        SELECTION_X, DIALOG_Y + 11);

    controls[14] = CreateSelectionButton(&SButtons[5],
                                        DIALOGFORCOLOR, DIALOGBACKCOLOR,
                                        SELECTION_X, DIALOG_Y + 13);

    controls[15] = CreateSelectionButton(&SButtons[6],
                                        DIALOGFORCOLOR, DIALOGBACKCOLOR,
                                        SELECTION_X, DIALOG_Y + 15);

    controls[16] = CreateCommandButton(&OkButton,
                                       BUTTONFORCOLOR, BUTTONBACKCOLOR,
                                       BUTTON_X1, BUTTON_Y, TRUE, FALSE,
                                       FALSE);
     
    controls[17] = CreateCommandButton(&CancelButton,
                                       BUTTONFORCOLOR, BUTTONBACKCOLOR,
                                       BUTTON_X2, BUTTON_Y, FALSE, TRUE, 
                                       TRUE);
}

int AskOptimizationMethod(Method* method)
{
    static int Initialized = FALSE;

    int control, result, i;

    PushHelpIndex(OPTIMIZATION_METHOD_INDEX);
    
    if (!Initialized)
    {
       Initialize();
       Initialized = TRUE;
    }
     
    SetStatusBar(RED, WHITE, "                                            ");
    SetStatusBar(RED, WHITE, " Change the current optimization method.");
    
    SButtons[GetOptimizationMethod()].selected = TRUE;
    
    OpenWindow(&MethodWin);
    control = ControlWindow(&MethodWin);
    CloseWindow();

    if ((control == CANCELBUTTON) || (control == -1))
       result = FALSE;
    else
       result = TRUE;

    for (i = 0; i < AMOF_METHODS; i++)
    {
        if (SButtons[i].selected)
        {
           *method = i;
        }
    }
    
    SButtons[0].selected = FALSE;
    SButtons[1].selected = FALSE;
       
    PopHelpIndex();
    
    return result;
}