/*----------------------------------------------------------------------*/
/* Declare types:							*/
/*	byte, word, dword, off_t, seg_t, CVFP, CB, CBFP;		*/
/*	MCB, UMB_MCB, HMA_MCB, SYSDATA_MCB, PSP,			*/
/*	DEVICE_ATTR, DEVICE, DPB, STACKS, DOSLoL;			*/
/*	XMS_BLOCK, XMS_TABLE, EMS_HANDLE, EMS_MPA			*/
/* Declare macroses:							*/
/*	ASSERT_SIZE, is_CHAR_DEV, SetChar2				*/

#ifdef __TURBOC__
# pragma option -a- /* force byte alignment */
#endif

#define ASSERT_SIZE(name,cond) typedef struct { char _[(cond) ? 1 : -1]; } name;

typedef unsigned char	byte;
typedef unsigned int	word;
typedef unsigned long	dword;
typedef word		off_t;
typedef word		seg_t;
typedef const void far	*CVFP;
typedef const byte	CB;
typedef const byte far	*CBFP;

ASSERT_SIZE (_systypes_,sizeof (byte)	==   1 && sizeof (word)  ==  2 &&
			sizeof (dword)	==   4 &&
			sizeof (off_t)	==   2 && sizeof (seg_t) ==  2 &&
			sizeof (CVFP)	==   4 && sizeof (CBFP)  ==  4);

typedef SYSSTRUCT {
  byte	ID;			/* 'M'=valid, 'Z'=last block		*/
  seg_t	owner;			/* PSP segment of owner			*/
  word	size;			/* size in paragraphs			*/
  byte	gap [3];
  byte	name [8];		/* owner name (DOS 4.0+)		*/
} far MCB;

			ASSERT_SIZE (_sysmcb_, sizeof (MCB) == 16);

typedef SYSSTRUCT {
  byte	ID;			/* 'M'=valid, 'Z'=last block		*/
  seg_t	first_free;		/* 0xA for last block			*/
  word	size;			/* size in paragraphs			*/
  byte	gap [3];
  byte	name [8];		/* "UMB"=first block, "SM"=last block	*/
} far UMB_MCB;

			ASSERT_SIZE (_sysumbmcb_, sizeof (UMB_MCB) == 16);

typedef SYSSTRUCT {
  word	ID;			/* ="MS"				*/
  word	free;			/* 0=free				*/
  word	size;			/* size in bytes			*/
  off_t	next_off;		/* offset of next block in HMA or 0	*/
  byte	gap [8];
} far HMA_MCB;

			ASSERT_SIZE (_syshmamcb_, sizeof (HMA_MCB) == 16);

typedef SYSSTRUCT {
  byte	ID;
  seg_t	start;
  word	size;			/* size in paragraphs			*/
  byte	gap [3];
  byte	name [8];		/* name for ID='D' and 'I'		*/
} far SYSDATA_MCB;

			ASSERT_SIZE (_syssdmcb_, sizeof (SYSDATA_MCB) == 16);

typedef SYSSTRUCT {
  word	DOS_exit;		/* 00 =int 20 instruction (0x20CD)	*/
  seg_t	next_seg;		/* 02 segment beyond program memory	*/
  byte	gap04;			/* 04 */
  byte	CPM_call [5];		/* 05 =far call to DOS (obsolete)	*/
  CVFP	int22,			/* 0A terminate handler			*/
	int23,			/* 0E Ctrl-Break handler		*/
	int24;			/* 12 critical error handler		*/
  seg_t	parent;			/* 16 parent PSP segment		*/
  byte	default_JFT [20];	/* 18 DOS2+ file handles, -1=closed	*/
  seg_t	env_seg;		/* 2C DOS2+ environment segment		*/
  CVFP	stack;			/* 2E DOS2+ SS:SP at last INT21 call	*/
  word	JFT_size;		/* 32 DOS3+ number of entries in JFT	*/
  CBFP	JFT;			/* 34 DOS3+ current JFT address		*/
  CVFP	prev;			/* 38 DOS3+ default is FFFF:FFFFh	*/
  byte	console,		/* 3C DOS4+ (DBCS) interim console flag	*/
	truename;		/* (APPEND) TrueName flag		*/
  byte	gap3E [2];		/* 3E (OS/2, Novell NetWare)		*/
  byte	vermajor,		/* 40 DOS5+ version for INT21/30	*/
	verminor;
  byte	gap42 [14],		/* 42 (Windows3)			*/
	DOS_call [3],		/* 50 DOS2+ =int 21/retf instructions	*/
	gap53 [2];		/* 53 */
  union {
	struct xfcb _XFCB;	/* 55 can be used for FCB1 extension	*/
				/* 5C FCB for 1st cmd_line argument	*/
    struct {
	byte	gap [16];
	struct xfcb _XFCB;	/* 6C FCB for 2nd cmd_line argument	*/
    } _2;
    struct {
	byte	gap [43];
	byte	len;		/* 80 */
	byte	line [127];
    } cmd;
  } _;
} far PSP;

			ASSERT_SIZE (_syspsp_, sizeof (PSP) == 256);

#define XFCB1		_._XFCB
#define  FCB1		_._XFCB.xfcb_fcb
#define XFCB2		_._2._XFCB
#define  FCB2		_._2._XFCB.xfcb_fcb
#define cmd_line	_.cmd.line
#define cmd_len		_.cmd.len

enum {
  DEV_CHAR	= 0x8000,	/* =1 for character device		*/
				/* =0 for block device			*/
  DEV_IOCTL	= 0x4000,	/* IOCTL supported			*/
  DEV_OPEN_CLOSE    = 0x0800,	/* DOS3+ OPEN/CLOSE calls supported	*/
  DEV_IOCTL_QUERY   = 0x0080,	/* DOS5+ Generic IOCTL check supported	*/
  DEV_IOCTL_GENERIC = 0x0040,	/* DOS32+ Generic IOCTL call supported	*/

  /* character device specific */
  DEV_OUT_TILL_BUSY = 0x2000,	/* DOS3+ output until busy supported	*/
  DEV_FASTCON	= 0x0010,	/* int 29 (fast console out) supported	*/
  DEV_CLOCK	= 0x0008,	/* CLOCK$ device			*/
  DEV_NUL	= 0x0004,	/* NUL device				*/
  DEV_CONOUT	= 0x0002,	/* console output device		*/
  DEV_CONIN	= 0x0001,	/* console input device			*/

  /* block device specific */
  DEV_NONFAT	= 0x2000,	/* non-IBM format (not need FAT+BPB)	*/
  DEV_REMOTE	= 0x1000,	/* device is remote			*/
  DEV_HUGE	= 0x0002	/* DOS331+ 32-bit sectors addressing	*/
};

typedef union {
  word	x;
  byte	b [2];
} DEVICE_ATTR;

			ASSERT_SIZE (_sysdevattr_, sizeof (DEVICE_ATTR) == 2);

#define is_CHAR_DEV(attr)	((attr).b [1] & (DEV_CHAR >> 8))

typedef SYSSTRUCT device {
  struct device far *next;	/* FP_OFF (next) == -1 if last	*/
  DEVICE_ATTR attr;
  off_t	strategy_entry,
	interrupt_entry;
  union {
	byte	_name [8];
    struct {
	byte	units;
	byte	signature [7];	/* normally unused		*/
    } _block_dev;
  } _;
} far DEVICE;

			ASSERT_SIZE (_sysdev_, sizeof (DEVICE) == 18);

#define dev_name	_._name
#define block_dev	_._block_dev

typedef SYSSTRUCT dpb {
  byte	drive,				/* drive # (0=A, 1=B ...)	*/
	unit;				/* sub-unit #			*/
  word	sector_bytes;
  byte	last_sector_in_cluster,
	cluster_to_sector_shift;
  word	reserved_sectors;		/* first FAT starting sector	*/
  byte	FATs;				/* FAT copies			*/
  word	root_entries,
	data_start,			/* sector # of cluster #2	*/
	last_cluster;			/* number of clusters + 1	*/
  union {
    struct {
	byte	FAT_sectors;
	word	root_start;
	DEVICE	*dev;
	byte	media_ID,
		access_flag;		/* 0=disk accessed, -1=not	*/
	struct dpb far *next;
    } DOS2; /* DOS 2.x-3.x */
    struct {
	word	FAT_sectors;
	word	root_start;
	DEVICE	*dev;
	byte	media_ID,
		access_flag;		/* 0=disk accessed, -1=not	*/
	struct dpb far *next;		/* -1=last			*/
	word	next_search,
		free_clusters;		/* -1=unknown yet		*/
    } DOS4; /* DOS 4.x-6.x */
  } _;
} far DPB;

			ASSERT_SIZE (_sysdpb_,
				offsetof (DPB, _.DOS2)	   == 15 &&
				sizeof (((DPB*)0)->_.DOS2) == 13 &&
				sizeof (((DPB*)0)->_.DOS4) == 18 &&
				sizeof (DPB)		   == 33);


typedef SYSSTRUCT {
  word	unknown;
  word	cnt,			/* x from CONFIG.SYS/STACKS=x,y		*/
	control_size,		/* size of control block array		*/
	size;			/* y from CONFIG.SYS/STACKS=x,y		*/
  CVFP	data;
  off_t	control_off,		/* control block array offset		*/
	last_off,		/* last element offset			*/
	next_off;		/* next entry to allocate		*/
} far STACKS;

			ASSERT_SIZE (_sysstacks_, sizeof (STACKS) == 18);

typedef SYSSTRUCT {
  seg_t	first_MCB;		/* -2: segment of first MCB		*/
  DPB	*first_DPB;		/* 00 */
  CVFP	first_SFT;		/* 04 */
  DEVICE *active_clock_dev;	/* 08 */
  DEVICE *active_CON_dev;	/* 0C */
  union {
    struct {
	byte	drives;		/* 10 number of logical drives		*/
	word	max_block_sz;	/* 11 max block of any block device	*/
	CVFP	first_buffer;	/* 13 */
	DEVICE	NUL_device;	/* 17 NUL device header			*/
    } DOS2; /* DOS 2.x */
    struct {
	byte	drives;		/* 10 number of block devices		*/
	word	max_block_sz;	/* 11 max block of any block device	*/
	CVFP	first_buffer;	/* 13 */
	CVFP	CDS_table;	/* 17 CDS [lastdrive] array		*/
	byte	lastdrive;	/* 1B CONFIG.SYS/LASTDRIVE= value	*/
	CVFP	workspace;	/* 1C STRING= workspace area		*/
	word	wspace_sz;	/* 20 CONFIG.SYS/STRING= value		*/
	CVFP	FCB_table;	/* 22 FCBs array (SFT)			*/
	word	protected_FCBs;	/* 26 y from CONFIG.SYS/FCBS=x,y	*/
	DEVICE	NUL_device;	/* 28 NUL device header			*/
    } DOS30; /* DOS 3.0 */
    struct {
      struct {
	word	max_sector_sz;	/* 10 max sector of any block device	*/
	CVFP	first_buffer;	/* 12 */
	CVFP	CDS_table;	/* 16 CDS [lastdrive] array		*/
	CVFP	FCB_table;	/* 1A FCBs array (SFT)			*/
	word	protected_FCBs;	/* 1E y from CONFIG.SYS/FCBS=x,y	*/
	byte	drives,		/* 20 number of block devices		*/
		lastdrive;	/* 21 max of 5, number of block devices	*/
				/*    and CONFIG.SYS/LASTDRIVE= value	*/
	DEVICE	NUL_device;	/* 22 NUL device header			*/
	byte	joined;		/* 34 number of JOIN'ed drives		*/
      } DOS3; /* DOS 3.1-3.3 */
      struct {
	off_t	special_names;	/* 35 always 0 for DOS 5.0		*/
	union {
	  struct {
	CVFP	IFS_default,	/* 37 default handler for any IFS	*/
		IFS_chain;	/* 3B */
	  } DOS4;
	  struct {
	CVFP	setver_list;	/* 37 SETVER program list or 0		*/
	off_t	A20_fix;	/* 3B [DOS=HIGH] offset of A20 fix code	*/
	seg_t	last_PSP;	/* 3D PSP of last EXECed program if	*/
				/*    DOS in HMA, 0 if low		*/
	  } DOS5;
	} _;
	word	buffers,	/* 3F x from CONFIG.SYS/BUFFERS=x,y	*/
		ahead;		/* 41 y from CONFIG.SYS BUFFERS=x,y	*/
	byte	boot_drive;	/* 43 1=A:				*/
	byte	DWORD_moves;	/* 44 1=use DWORD moves (80386+)	*/
	word	ext_mem_kb;	/* 45 extended memory size in kb	*/
      } DOS4; /* DOS 4.0+ */
    } x; /* DOS 3.1+ */
#define xDOS4 x.DOS4._.DOS4
#define xDOS5 x.DOS4._.DOS5
    struct {
	byte	gap10 [6];	/* 10 */
	CVFP	CDS_table;	/* 16 CDS [lastdrive] array		*/
	byte	gap1A [6];	/* 1A */
	byte	drives,		/* 20 number of block devices		*/
		lastdrive;	/* 21 number of local drive letters	*/
	DEVICE	NUL_device;	/* 22 NUL device header			*/
    } NT; /* Windows NT DOS Box */
  } _;
} far DOSLoL;

		ASSERT_SIZE (_syslol_,
			offsetof (DOSLoL, _.DOS2)	== 0x10-(-2)	&&
			sizeof (((DOSLoL*)0)->_.DOS2)   == 0x17+18-0x10	&&
			sizeof (((DOSLoL*)0)->_.DOS30)  == 0x28+18-0x10	&&
			sizeof (((DOSLoL*)0)->_.x.DOS3) == 0x35-0x10	&&
			sizeof (((DOSLoL*)0)->_.x.DOS4) == 0x47-0x35	&&
			sizeof (((DOSLoL*)0)->_.x)	== 0x47-0x10	&&
			sizeof (((DOSLoL*)0)->_.NT)	== 0x34-0x10	&&
			sizeof (DOSLoL)			== 0x10-(-2)+0x47-0x10);

typedef SYSSTRUCT {
  byte	flag,
	locks;
  dword	offset_kb,
	size_kb;
} far XMS_BLOCK;	/* for INT2F/4309 */

			ASSERT_SIZE (_sysxmsblk_, sizeof (XMS_BLOCK) == 10);

typedef SYSSTRUCT {
  byte	check,
	handle_sz;
  word	handle_cnt;
  XMS_BLOCK *pb;
} far XMS_TABLE;	/* for INT2F/4309 */

			ASSERT_SIZE (_sysxmstbl_, sizeof (XMS_TABLE) == 8);

typedef struct {
  word	handle;
  word	pages;
} EMS_HANDLE;		/* for INT67/4D */

			ASSERT_SIZE (_sysemsh_, sizeof (EMS_HANDLE) == 4);

typedef struct {
  seg_t	seg;
  word	page;
} EMS_MPA;		/* for INT 67/5800 */

			ASSERT_SIZE (_sysemsmpa_, sizeof (EMS_MPA) == 4);

#if defined (__MSDOS__) || defined (__WINDOWS__) || defined (__OS2__)
# define SetChar2(p, c1, c2) (*(word*)(p) = \
				(word)(((byte)(c2) << 8) | (byte)(c1)))
#else
# define SetChar2(p, c1, c2) ((p) [0] = (c1), (p) [1] = (c2))
#endif

#ifdef __TURBOC__
# pragma option -a. /* restore byte alignment */
#endif
