LOCAL void	FAST_	total_line_fill	(void);
LOCAL void	FAST_	total_line_say	(CStr memtype);
LOCAL void	STACK_	total_line_conv	(CStr memtype, count total,
						count free, count largest);
LOCAL void	STACK_	total_line_XMS	(CStr memtype, ulong free,
						ulong largest, count shift);
LOCAL void	FAST_	total_list	(void);

/*----------------------------------------------------------------------*/

			/* "   Total -  Used =  Free (largest)" */
			/* "   -----   -----   ---------------" */
			/*  ^  ^3      ^11     ^19  ^24 ^28  ^33 */
LOCAL char s_total [35];
#define i_total    3
#define i_used    11
#define i_free    19
#define n_free    24
#define i_largest 28

LOCAL void FAST_ total_line_fill (void) {
	memfill (s_total, sizeof (s_total) - 1);
	s_total [n_free + 1] = '(';
	s_total [sizeof (s_total) - 2] = ')';
	s_total [sizeof (s_total) - 1] = '\0';
}

LOCAL void FAST_ total_line_say (CStr memtype) {
	header (0, 0, memtype); say (s_total);
}

LOCAL void STACK_ total_line_conv (CStr memtype,
				count total, count free, count largest) {
	total_line_fill ();
	scale_sz_ (total,	 4, s_total + i_total);
	scale_sz_ (total - free, 4, s_total + i_used);
	scale_sz_ (free,	 4, s_total + i_free);
	scale_sz_ (largest,	 4, s_total + i_largest);
	total_line_say (memtype);
}

LOCAL void STACK_ total_line_XMS (CStr memtype, ulong free,
						ulong largest, count shift) {
	total_line_fill ();
	scale_sz_ (free,    shift, s_total + i_free);
	scale_sz_ (largest, shift, s_total + i_largest);
	total_line_say (memtype);
}

LOCAL void FAST_ total_list (void) {
	header (1, 2,
		"     Memory type   Total -  Used =  Free (largest)\n"
		"----------------   -----   -----   ---------------");

	total_line_conv ("    Conventional",
		MEM.BASE.total_kb << 6, MEM.BASE.free, MEM.BASE.largest);

	if (MEM.UMB.state == DONE)
		total_line_conv ("     Upper (DOS)",
			MEM.UMB.total, MEM.UMB.free, MEM.UMB.largest);

	if (XMS.state == DONE && XMS.UMB.free)
		total_line_XMS ("     Upper (XMS)",
			XMS.UMB.free, XMS.UMB.largest, 4);

	if (SYS.CPU >= 2) {
		total_line_fill ();
		scale_sz_ (EXT.total,	 0, s_total + i_total);
		scale_sz  (EXT.free_kb, 10, s_total + i_free);
		total_line_say ("Extended (INT15)");
	}
	if (XMS.state == DONE) {
		total_line_XMS ("Extended (XMS16)",
			XMS.free_kb, XMS.largest_kb, 10);

	if (XMS.XMS32.state == DONE)
		total_line_XMS ("Extended (XMS32)",
			XMS.XMS32.free_kb, XMS.XMS32.largest_kb, 10);
	}
	if (EMS.state == DONE) {
		total_line_fill ();
		scale_sz_ (EMS.pages_total,	  14, s_total + i_total);
		scale_sz_ (EMS.pages_total
				- EMS.pages_free, 14, s_total + i_used);
		scale_sz  (EMS.pages_free,	  14, s_total + i_free);
		total_line_say ("  Expanded (EMS)");
	}

	header (3, 0, "----------------   -----   -----   ---------------");

	static MAP DOS_type [] = {
		{0x00, "PC-DOS"},
		{0x5E, "RxDOS"},
		{0x66, "PTS-DOS"},
		{0xEE, "DR-DOS"},
		{0xEF, "Novell DOS"},
		{0xFD, "FreeDOS"},
		{0xFF, "MS-DOS"}
	};
	static MAP loadtype [] = {
		{0x00, "low memory"},
		{0x08, "ROM"},
		{0x10, "high memory area (HMA)"},
		{0x18, "ROM and HMA"}
	};
	printf ("\n\n%s %u.%02u is resident in the %s.\n",
		MAP_GET (DOS_type, SYS.OS.OEM),
		SYS.OS.ver.h.major, SYS.OS.ver.h.minor,
		MAP_GET (loadtype, SYS.OS.flags & 0x18u));
}
