LOCAL STATE	FAST_	EMS_get		(void);
LOCAL byte	FAST_	EMS_table	(count func, void*);
LOCAL PCStr	FAST_	EMS_name	(count handle);
LOCAL void	FAST_	EMS_list_handles(count n);
LOCAL void	FAST_	EMS_list_MPA	(count n);
LOCAL void	FAST_	EMS_list	(void);

/*----------------------------------------------------------------------*/

#ifdef ASM86
# define EMS_call(f)			(AX = f, callint (0x67), AH)
#else
  LOCAL byte FAST_ EMS_call(word f)	{ AX = f; callint (0x67); return AH; }
#endif

LOCAL STATE FAST_ EMS_get (void) {
	/* check EMM presence */
	if (fstrdiff (FP (CB, FP_SEG (DOS_getvect (0x67)), 10), "EMMXXXX0"))
		return NONE;

	/* get EMM version */
	if (EMS_call (0x4600)) { say_error (MSG_EMM_call, "46h"); return ERROR; }
	EMS.verBCD = AX;

	/* get page frame segment */
	if (EMS_call (0x4100)) { say_error (MSG_EMM_call, "41h"); return ERROR; }
	EMS.frame_seg = BX;

	/* get number of pages */
	if (EMS_call (0x4200)) { say_error (MSG_EMM_call, "42h"); return ERROR; }
	EMS.pages_total = DX, EMS.pages_free = BX;
	return DONE;
}

LOCAL byte FAST_ EMS_table (count func, void *p) {
/*!*/	func = func, ES = FP_SEG (p), DI = FP_OFF (p);
	return EMS_call (func);
}

LOCAL PCStr FAST_ EMS_name (count handle) {
/*!*/	handle = handle;
	static char name_buf [8+1];
	DX = handle, ES = FP_SEG (&name_buf), DI = FP_OFF (&name_buf);
	if (EMS_call (0x5300)) name_buf [0] = 0;
	canonize_name (name_buf, (byte*)name_buf, sizeof name_buf - 1);
	return name_buf;
}

LOCAL void FAST_ EMS_list_handles (count n) {
/*!*/	EMS_HANDLE *ph = MEM_TMP (EMS_HANDLE, n = n);
	header (2, 1,
		"\t  Handle  Logical EMS pages    Name\n"
		"\t  ------  -----------------  --------\n");

	/* get pages for all handles */
	if (ph == NULL || EMS_table (0x4D00, ph)) {
		/* INT67/4C (get pages owned by handle) may be used	*/
		/* for WORD range to find all handles step by step	*/
		say ("\t\t<<table not builded>>"); new_line (); return;
	}

	count i = BX + 1;
/*!*/	for (; --(int)i; ph++) {
		printf ("\t%7u%8u  (%7luk)  %s",
			ph->handle, ph->pages, ph->pages * 16ul,
			EMS_name (ph->handle));
		new_line ();
}	}

LOCAL void FAST_ EMS_list_MPA (count n) {
/*!*/	EMS_MPA *pm = MEM_TMP (EMS_MPA, n = n);
	header (2, 1,
		"\t\t  Physical EMS page  Memory area\n"
		"\t\t  -----------------  -----------\n");

	/* get MPA array */
	if (pm == NULL || EMS_table (0x5800, pm)) {
		say ("\t\t<<table not builded>>"); new_line (); return;
	}

	count i = CX;
	while (i) {
		/* combine consecutive page/segment pairs */
		EMS_MPA *pmfirst = pm; count page = pm->page, size = 0;
		do { pm++, page++, size += 16u;
/*!*/		} while (--(int)i && page == pm->page
				  && pm [-1].seg + 1024u == pm->seg);
		page--;
		if (size == 16)
			sayv ("\t\t%6u       ( 16", page);
		else	printf ("\t\t%6u-%-6u(%3u", pmfirst->page, page, size);
		printf ("k)  %04X0-%04X0", pmfirst->seg, pm [-1].seg + 1024u);
		new_line ();
}	}

LOCAL void FAST_ EMS_list (void) {
	if (EMS.state == ERROR) return;
	header (1, 2, "     EMS version: ");
	if (EMS.state != DONE) { say ("none\n"); return; }

	printf ("%u.%u\t   Total handles:",
		EMS.verBCD >> 4, EMS.verBCD & 0x0F);

	/* get total number of handles */
	if (EMS_call (0x5402) == 0) sayv (" %u", BX);

	sayv ("\n      Page frame: %04X\t    Used handles:", EMS.frame_seg);

	/* get number of EMM handles */
	count handles_used = 0, MPA;
	if (EMS_call (0x4B00) == 0) {
		handles_used = BX;
		sayv (" %u", handles_used);
	}
	new_line ();

	/* get MPA (mappable physical address array) size */
	MPA = 0;
	if (EMS_call (0x5801) == 0) {
		MPA = CX;
		sayv ("  Mappable pages: %u", MPA);
		new_line ();
	}

	if (handles_used) EMS_list_handles (handles_used);
	if (MPA)	  EMS_list_MPA (MPA);
}
