/*
	HIMEMC.C
	
	commandline handling for HIMEM
	
	this stuff is copyrighted (c) by tom ehlert
	
	given to the FreeDOS project under GPL license	
	
*/

#define PROGRAM "HIMEM"

#include "useful.h"


extern char   far init_message[];
extern char   far vinit_message[];
extern char   far copyright[];
extern ushort far xms_num_handles;	/* default 32 */
extern char   far startup_verbose;


/* called on startup.
	handle commandline "NUMHANDLES=" ...
	...
	mode = 0 if called as driver
	mode = 1 if called as EXE
	
	return: 0         - everything fine
	        errorcode - exit code/abort driver
*/ 

int TheRealMain(int mode, char far *commandline)
{
	char far *found;
	int int15 = 0;
	
	if (mode == EXECMODE_EXE)
		startup_verbose = 1;
    
                             
	printf("%Fs", init_message); 
	printf(" ["__DATE__ "] ");
	printf("%Fs",copyright); 
	printf("\n");

	/******* commandline handling **********/
	
	if (FindCommand(commandline, "/VERBOSE", &found) )
		{ 
		startup_verbose = 1;
		}

	if (startup_verbose)
		{
		printf("%Fs\n",vinit_message);
		}

	if (FindCommand(commandline, "/NUMHANDLES=", &found) )
		{ 
		xms_num_handles = GetValue(found,10);
		if (startup_verbose)
			printf("selected num_handles=%d\n",xms_num_handles);

		if (xms_num_handles < 8)
			{
			printf("HIMEM:NUMHANDLES must be >= 8, corrected\n");
			xms_num_handles = 8;
			}			
			
		if (xms_num_handles > 128)
			{
			printf("HIMEM:NUMHANDLES must be <= 128, corrected\n");
			xms_num_handles = 128;
			}			
			
		}
		
		
	if (FindCommand(commandline, "/TESTMEM:ON", &found) ||
		FindCommand(commandline, "/TESTMEM:OFF", &found) )
		{
		if (startup_verbose)
			printf("/TESTMEM:ON|OFF not implemented - ignored\n");
		}
		
		

	if (FindCommand(commandline, "/INT15=", &found) )
		{ 
		int15 = GetValue(found,16);
		
						/* you probably intended this something to do
						   so we warn (beep) */
		
		printf("\aHIMEM:/INT15=%x - not implemented\n",int15);
		}

	if (FindCommand(commandline, "/TEST", &found))
		{
		extern XMSTESTmain(void);
		
		XMSTESTmain();
		
		return 0;
		}



	/******* commandline handling done, are there remainders **********/

	commandline = skipWhite(commandline);

	if (*commandline)
		printf("ignored commandline <%Fs>\n", commandline);



	if (mode == EXECMODE_EXE)
		{
							/* called as exe from commandline 
								do :
									usage info
									status report
									show memory statistic
									...
							*/
							
		printf("\n" 
				"HIMEM.EXE is a devicedriver and must be loaded in CONFIG.SYS\n"
				"please load HIMEM as DEVICE=HIMEM.EXE in config.sys\n"
				"\n");

		printf("commandline options available\n"
		       "   /NUMHANDLES=32\n"
		       "   /VERBOSE\n"
		       "   /TEST - tests all memory + checks the loaded XMS implementation\n"
				);				
				
		return 1;
		}											



	return 0;			/* driver can't fail */

}

 