;******************************************************************************
;       F R E E - D O S     X M S - D R I V E R
;******************************************************************************
; Written by Till Gerken for the Free-DOS project.
;
; major rework by tom ehlert
;
; If you would like to use parts of this driver in one of your projects, please
; check up with me first.
;
; I can be reached at:  Till.Gerken@ngosub0.ngo.ol.ni.schule.de (Internet)
;           2:2426/2190.16 (FidoNet)
;
; For questions concerning Free-DOS, mail the coordinator
; Morgan "Hannibal" Toal <hannibal@iastate.edu>
;
; Comments and bug reports are always appreciated.
;
; Copyright (c) 1995, Till Gerken
;******************************************************************************
; -- ORIGINAL IMPLEMENTATION NOTES --
;
; - The Protected Mode handling is very simple, it fits only for the least
;   needs
; - I didn't care about reentrancy. If this thing should be used in
;   Multitasking Environments, well, somebody got to take a look at the code.
; - INT15h, Func. 87h (Move Block) has been re-implemented to preserve
;   the state of A20. (very slow!)
; - INT15h, Func. 88h (Extended Memory Size) has been re-implemented to
;   return 0.
; - Function 0Bh (Move Block) uses it's own Protected Mode handling.
;   It doesn't provide Interrupt windows.
; - The code is not very optimised, I just wrote it down for now. Later, when
;   everything is tested, I'm going to see what can be done
; - Some ideas were taken from the original XMS driver written by
;   Mark E. Huss (meh@bis.adp.com), but everything has been completely
;   rewritten, so if there are bugs, they are mine, not his. ;)
;******************************************************************************
; -- NEW IMPLEMENTATION NOTES --
;
; - major rework done by tom ehlert, fixed
;
; - reported XMS version  reflects current implementation - 2.0
; - reported XMS internal version reflects driver version - 0.5
;
; - xms_free_handle now actually works
; - added support for protected mode operation
; - many more checks for valid requests (like valid handles,valid offsets)
; - major code cleaning
; - has chances to work in multitasking environments (not tested)
;
; - although the code is based on Till gerkens, much has been changed.
;   so the bugs are no longer due to Till Gerkens, but due to
;   tom.ehlert (tom.ehlert@ginko.de)
;
; still missing
;    support for 80286 (mostly due to long arith with 32 bit registers)
;    support for >64 MB memory
;
;******************************************************************************
;
;        fixed bug in xms_realloc_xms that caused lst handles
; version 0.6 - nov 2001
;
; 		 if someone ever decides to disable A20, EMM386 will crash
;        nearly immediately. so the code to disable A20 was disabled itself.
;		 as Bart disagreed ( tom still thinks A20 is bullshit, referring to
;        nonexisting software written 20 years ago)
;        it was reenabled and marked with ALLOWDISABLEA20. this costs 
;		 60 bytes of precious memory ;-)
;        EMM386 will void this call himself
;
;		added "C" commandline parsing
;		compatibility with free EMM386 (lmsw ax <--> mov eax,cr0)
;		added EXE capability
;		merged TEST functionality from XMSTEST
;		
;******************************************************************************


ALLOWDISABLEA20 equ 1



_TEXT	segment	byte public 'CODE'
_TEXT	ends

_DATA	segment byte public 'DATA'
_DATA	ends


_BSS	segment word public 'BSS'
_BSS	ends


_STACK	segment STACK 'STACK'
    my_stack db 1024 dup(?)       ; stack for the C - things
            
      public driver_stacktop      
label driver_stacktop
_STACK	ends


DGROUP	group	_TEXT,_DATA, _BSS,_STACK

assume	cs:DGROUP,ds:DGROUP


		extrn _startup_driver:far
		extrn _startup_exe:far




_TEXT	segment


ideal                   ; switch on ideal mode syntax
P386                    ; 386 instructions this time
;jumps


; MANIFEST constants


DRIVER_VERSION      equ '2.07'   ; revision number
DRIVER_VER          =   0207h   ; some (EMU86) software wants it that way
INTERFACE_VERSION   equ '2.00'  ; like HIMEM 2.77 - we hope :-)
INTERFACE_VER       =   200h

XMS_START           =   1088    ; XMS starts at 1088k after HMA

CMD_INIT            =   0   ; init command (used when installed)

STATUS_OK           =   0100h   ; driver is initialized and ok
STATUS_BAD          =   8000h   ; driver couldn't be installed

VDISK_IDSTR         equ "VDISK"
VDISK_IDLEN         =   5
VDISK_IDOFS         =   13h

XMS_NOT_IMPLEMENTED             =   80h
XMS_VDISK_DETECTED              =   81h
XMS_A20_FAILURE                 =   82h
XMS_DRIVER_FAILURE              =   8eh
XMS_DRIVER_FATAL                =   8fh
XMS_HMA_NOT_THERE               =   90h
XMS_HMA_IN_USE                  =   91h
XMS_HMAREQ_TOO_SMALL            =   92h
XMS_HMA_NOT_USED                =   93h
XMS_A20_STILL_ENABLED           =   94h
XMS_ALREADY_ALLOCATED           =   0a0h
XMS_NO_HANDLE_LEFT              =   0a1h
XMS_INVALID_HANDLE              =   0a2h
XMS_INVALID_SOURCE_HANDLE       = 0a3h
XMS_INVALID_SOURCE_OFFSET       = 0a4h
XMS_INVALID_DESTINATION_HANDLE  = 0a5h
XMS_INVALID_DESTINATION_OFFSET  = 0a6h
XMS_INVALID_LENGTH              =   0a7h
XMS_INVALID_OVERLAP             =   0a8h
XMS_PARITY_ERROR                =   0a9h
XMS_BLOCK_NOT_LOCKED            =   0aah
XMS_BLOCK_LOCKED                =   0abh
XMS_LOCK_COUNT_OVERFLOW         =   0ach
XMS_LOCK_FAILED                 =   0adh
XMS_ONLY_SMALLER_UMB            =   0b0h
XMS_NO_UMB_AVAILABLE            =   0b1h
XMS_UMB_SEGMENT_NR_INVALID      =    0b2h


struc   request_hdr
  req_size  db  ?       ; number of bytes stored
  unit_id   db  ?       ; unit ID code
  cmd       db  ?       ; command code
  status    dw  ?       ; status word
  rsvd      db  8 dup (?)   ; reserved
ends    request_hdr

struc   init_strc
  init_hdr  db  size request_hdr dup (?)
  units     db  ?       ; number of supported units
  end_addr  dd  ?       ; end address of resident part
  cmd_line  dd  ?       ; address of command line
ends    init_strc

struc   desc
  limit     dw  0ffffh      ; segment limit
  base0_15  dw  ?       ; low word of base address
  base16_23 db  ?       ; high byte of base address
  flags     db  93h     ; std read/write segment
  reserved  db  0
ends    desc

struc   xms_handle
  xbase     dw  ?       ; base address in kbytes
  xsize     dw  ?       ; size in kbytes
  used      db  ?       ; 1 if used
  locks     db  ?       ; lock count
ends    xms_handle

struc   xms_move_strc
  len       dd  ?       ; block length in bytes
  src_handle    dw  ?       ; source handle
  src_offset    dd  ?       ; offset into source
  dest_handle   dw  ?       ; destination handle
  dest_offset   dd  ?       ; offset into destination
ends    xms_move_strc




;******************************************************************************
; 16-bit resident code and data
;******************************************************************************


;******************************************************************************
; device driver header

        dd  -1          ; last driver in list
        dw  8000h           ; driver flags
        dw  offset strategy     ; pointer to strategy routine
        dw  offset interrupt    ; pointer to interrupt handler
        db  'XMSXXXX0'      ; device driver name

;******************************************************************************
; global data

request_ptr dd  ?           ; pointer to request header


xms_size    dw  ?           ; size of XMS in kbytes

gdt32       dw  gdt_size,dummy,0
dummy       dq  0
code16dsc   db  0ffh,0ffh,0,0,0,9ah,0,0
core32dsc   db  0ffh,0ffh,0,0,0,92h,0cfh,0
gdt_size=$-(offset dummy)

code16idx   =   08h
core32idx   =   10h

old_int15   dd  ?           ; old INT15h vector
old_int2f   dd  ?           ; old INT2fh vector

hma_used    db  0           ; set if HMA is used
hma_min     dw  0           ; minimal space in HMA that
                            ; has to be requested
a20_locks   dw  0           ; internal A20 lock count

	public _xms_num_handles 
_xms_num_handles dw  32      ; number of available handles

	public _startup_verbose
_startup_verbose db  0      ; more (debugging) output in 
							; startup phase	


;******************************************************************************
; strategy routine. is called by DOS to initialize the driver once.
; only thing to be done here is to store the address of the device driver
; request block.
; In:   ES:BX - address of request header
; Out:  nothing

proc    strategy    far
    mov [word cs:request_ptr+2],es  ; store segment addr
    mov [word cs:request_ptr],bx    ; store offset addr
    ret                 ; far return here!
endp    strategy

;******************************************************************************
; interrupt routine. called by DOS right after the strategy routine to
; process the incoming job. also used to initialize the driver.

proc    interrupt   far

label init_patch  byte           ; will be overwritten by
                                ; NOP's after init
    call near init_interrupt

    ret                 ; far return here!
endp    interrupt

;******************************************************************************
; just delays a bit

; *** OLD CODE ***
;proc   delay
;   jmp short $+2
;   jmp short $+2
;   ret
;endp   delay
; *** OLD CODE ***

proc delay
delay_start:
     in al, 64h
     jmp delay_check
delay_check:
     and al, 2
     jnz delay_start
     ret
endp delay


;******************************************************************************
; empties the keyboard processor's command queue

; *** OLD CODE ***
;proc   empty_8042
;   call    delay           ; delay a bit
;   in  al,64h
;   test    al,1            ; is there something to be read?
;   jz  no_output       ; no, go on
;   call    delay           ; yes, first delay a bit
;   in  al,60h          ; then read the output buffer
;   jmp short empty_8042    ; and try again
;no_output:
;   test    al,2            ; has it finished processing?
;   jnz empty_8042      ; no, try again
;   ret             ; yes, done
;endp   empty_8042
; *** OLD CODE ***

;******************************************************************************
; enables the A20 address line

proc enable_a20
     mov al,0d1h
     out 64h,al
     call delay
     mov al,0dfh
     out 60h,al
     call delay
     mov al,0ffh
     out 64h,al
     call delay
     ret
endp enable_a20
enable_a20end:

;******************************************************************************
; disables the A20 address line

proc disable_a20

     mov al,0d1h
     out 64h,al
     call delay
     mov al,0ddh
     out 60h,al
     call delay
     mov al,0ffh
     out 64h,al
     call delay
     ret
endp disable_a20
disable_a20end:

;******************************************************************************
; tests if the A20 address line is enabled.
; compares 256 bytes at 0:0 with ffffh:10h
; Out:  ZF=0 - A20 enabled
;   ZF=1 - A20 disabled

proc    test_a20
    push    cx si di ds es

    xor si,si
    mov ds,si

    mov di,0ffffh
    mov es,di
    mov di,10h

    mov cx,100h/4
    rep cmpsd

    pop es ds di si cx
    ret
endp    test_a20


;
; new method to test A20
;
; idea: compare my own memory with something which might be 
; at 100000:xxxx if A20 is enabled
; or  00000:xxxx if A20 is disabled
;
; if not equal --> A20 enabled
; else 
;     increment low memory
;     compare again with high memory
;     if not equal --> A20 enabled
;     else         -->
;
; assumes CS:offset  is lies in memory 0:FFFF
; AND code is loaded below e00:0
; both only true for kernel or driver code
;


; FFFF:10  == 0:0
; FFFF+400:10 == 400:0
; F800+400:7FF0+10 == 400:0
; F800+seg mylowmemoryval: 7ff0+10+offset mylowmemoryval == cs:[mylowmemoryval]
; F200+seg mylowmemoryval: e000+offset mylowmemoryval == cs:[mylowmemoryval]
           
;public lowmemoryval           
;lowmemoryval  dw 0
;highmemoryseg dw 0f200h + seg lowmemoryval

;testa20_new:

;	push ds

;	lds ax, [cs:offset lowmemoryval]	
	
;	cmp ax, [offset lowmemoryval + 0e000h]
;	jne enabled

;	inc [cs:lowmemoryval]
;	inc ax
	
;	cmp ax, [offset lowmemoryval + 0e000h]

;enabled:
;	pop ds
;	ret
		




;******************************************************************************
; Interrupt handlers
;******************************************************************************
;******************************************************************************
; new INT15h handler
;
; this no longer preserves A20 state, rather it enables it. 
; thats it.
;

proc    int15_handler
    cmp ah,88h              ; is it a ext. mem size req.?
    je  ext_mem_size
    jmp [cs:old_int15]          ; jump to old handler

ext_mem_size:
    xor ax,ax               ; no memory available
    clc                 ; no error
    iret
endp    int15_handler

;******************************************************************************
; new INT2Fh handler. Catches Func. 4300h+4310h

public  int2f_handler
proc    int2f_handler
    pushf
    cmp ah,43h
    je maybe_my2f
jmp_old2f:
    popf
    jmp [cs:old_int2f]          ; jump to old handler

maybe_my2f:
    cmp al,00h            ; is it "Installation Check"?
    jne get_driver_address
    mov al,80h              ; yes, we are installed ;)
    popf
    iret
get_driver_address:
    cmp al,10h            ; is it "Get Driver Address"?
    jne jmp_old2f
    push cs
    pop  es
    mov bx,offset xms_dispatcher
    popf
    iret


endp    int2f_handler

;******************************************************************************
; XMS functions
;******************************************************************************
; returns XMS version number
; In:   AH=0
; Out:  AX=XMS version number
;   BX=internal revision number
;   DX=1 if HMA exists, 0 if not

proc    xms_get_version
    mov ax,INTERFACE_VER
    mov bx,DRIVER_VER
    mov dx,1                ; HMA is always available
    ret
endp    xms_get_version

;******************************************************************************
; requests HMA
; In:   AH=1
;   DX=space needed in HMA (0ffffh if application tries to request HMA)
; Out:  AX=1 if successful
;   AX=0 if not successful
;     BL=80h -> function not implemented (implemented here ;) )
;     BL=81h -> VDISK is detected
;     BL=90h -> HMA does not exist
;     BL=91h -> HMA already in use
;     BL=92h -> DX less than HMA_MIN

proc    xms_request_hma
    cmp [hma_used],0            ; is HMA already used?
    mov bl,XMS_HMA_IN_USE
    jnz xrh_err
    cmp dx,[hma_min]            ; is request big enough?
    mov bl,XMS_HMAREQ_TOO_SMALL
    jb  xrh_err
    mov [hma_used],1            ; assign HMA to caller
    mov ax,1
    xor bl,bl
    ret;return_success
xrh_err:
    xor ax,ax
    ret;return_failure
endp    xms_request_hma

;******************************************************************************
; releases HMA
; In:   AH=2
; Out:  AX=1 if successful
;   AX=0 if not successful
;     BL=80h -> function not implemented
;     BL=81h -> VDISK is detected
;     BL=90h -> HMA doesn't exist
;     BL=93h -> HMA wasn't allocated

proc    xms_release_hma
    cmp [hma_used],0            ; is HMA used?
    mov bl,XMS_HMA_NOT_USED
    jz  xrh_err
    mov [hma_used],0            ; now release it
    mov ax,1
    xor bl,bl
    ret;return_success
endp    xms_release_hma

;******************************************************************************
; global A20 address line enable
; In:   AH=3
; Out:  AX=1 if successful
;   AX=0 if not successful
;     BL=80h -> function is not implemented
;     BL=81h -> VDISK is detected
;     BL=82h -> A20 failure

proc    xms_global_enable_a20
    call    enable_a20          ; enable A20
    call    test_a20            ; is it really enabled?
    jz  xge_a20_err
    mov ax,1
    xor bl,bl
    ret;return_success
xge_a20_err:
    xor ax,ax
    mov bl,XMS_A20_FAILURE
    ret;return_failure
endp    xms_global_enable_a20

;******************************************************************************
; global A20 address line disable
; In:   AH=4
; Out:  AX=1 if successful
;   AX=0 if not successful
;     BL=80h -> function is not implemented
;     BL=81h -> VDISK is detected
;     BL=82h -> A20 failure
;     BL=84h -> A20 still enabled

proc    xms_global_disable_a20

IF ALLOWDISABLEA20
    call    disable_a20         ; disable A20

    call    test_a20            ; is it really disabled?
    jnz xge_a20_err
    mov ax,1
    xor bl,bl
    ret;return_success
endif    

		xor ax,ax
        mov bl,84h					; A20 still enabled
        							; or function not implemented ??		
        ret;return_failure



endp    xms_global_disable_a20

;******************************************************************************
; enables A20 locally
; In:   AH=5
; Out:  AX=1 if A20 is enabled, 0 otherwise
;   BL=80h -> function not implemented
;   BL=81h -> VDISK is detected
;   BL=82h -> A20 failure

proc    xms_local_enable_a20
    inc [a20_locks]             ; increase lock counter
    call    test_a20            ; test if it's really enabled
    jnz local_enable_was_enabled
    call    enable_a20          ; enable it
    call    test_a20            ; test if it's really enabled
    jz  xge_a20_err
local_enable_was_enabled:
    mov ax,1
    xor bl,bl
    ret;return_success
endp    xms_local_enable_a20

;******************************************************************************
; disables A20 locally
; In:   AH=6
; Out:  AX=1 if A20 is disabled, 0 otherwise
;   BL=80h -> function not implemented
;   BL=81h -> VDISK is detected
;   BL=82h -> A20 failure

proc    xms_local_disable_a20
    dec [cs:a20_locks]          ; decrease lock counter
    jnz xld_dont_disable        ; disable only if needed

IF ALLOWDISABLEA20    
    call    disable_a20         ; disable it
ENDIF    
    call    test_a20            ; test if it's really disabled
    jnz xge_a20_err
xld_dont_disable:
    mov ax,1
    xor bl,bl
    ret;return_success
endp    xms_local_disable_a20

;******************************************************************************
; returns the state of A20
; In:   AH=7
; Out:  AX=1 if A20 is physically enabled, AX=0 if not
;   BL=00h -> function was successful
;   BL=80h -> function is not implemented
;   BL=81h -> VDISK is detected

proc    xms_query_a20
    xor ax,ax           ; suppose A20 is disabled
    call    test_a20
    jz  xqa_a20dis
    mov ax,1
xqa_a20dis:
    xor bl,bl
    ret;return_success
endp    xms_query_a20

;******************************************************************************
; searches a/next free XMS memory block
; In:   DS=CS
;   BX - offset of start handle (if search is continued)
;   CX - remaining handles (if search is continued)
; Out:  CY=1 - no free block
;     BX - offset of end of handle table
;   CY=0 - free block found
;     BX - offset of free handle
;     CX - number of remaining handles

proc    xms_find_free_block
    mov bx,offset driver_end    ; start at the beginning of the table
    mov cx,[_xms_num_handles]    ; check all handles
find_free_block:
    cmp [bx+xms_handle.used],0  ; is it used?
    jnz xms_find_next_free_block; yes, go on
    cmp [bx+xms_handle.xbase],0 ; assigned memory block or just blank?
    jnz found_block     ; assigned, return it
xms_find_next_free_block:
    add bx,size xms_handle  ; skip to next handle
    loop    find_free_block     ; check next handle
    stc             ; no free block found, error
    ret
found_block:
    clc             ; no error, return
    ret
endp    xms_find_free_block

;******************************************************************************
; searches a/next free XMS memory handle
; In:   DS=CS
;   BX - offset of start handle (if search is continued)
;   CX - remaining handles (if search is continued)
; Out:  CY=1 - no free handle
;     BX - offset of end of handle table
;   CY=0 - free handle found
;     BX - offset of free handle
;     CX - number of remaining handles

proc    xms_find_free_handle
    mov bx,offset driver_end    ; start at the beginning of the table
    mov cx,[_xms_num_handles]    ; check all handles
find_free_handle:
    cmp [bx+xms_handle.used],0      ; is it used?
    jnz xms_find_next_free_handle   ; yes, go on
    cmp [bx+xms_handle.xbase],0     ; really blank handle?
    jz  found_handle            ; found a blank handle
xms_find_next_free_handle:
    add bx,size xms_handle  ; skip to next handle
    loop    find_free_handle    ; check next handle
    stc             ; no free block found, error
    ret
found_handle:
    clc             ; no error, return
    ret
endp    xms_find_free_handle

;******************************************************************************
; xms_check_handle
; In:   DS=CS
;   DX - handle to check
;
; Out:  CY=1     - no valid handle
;         BL=0a2h  - XMS_INVALID_HANDLE
;         AX=0     - usual error return
;
;       CY=0     - no error
;
; registers destroyed - AX
;

proc    xms_check_handle
    push dx
    push si

    mov si,dx

    mov ax,dx
    sub ax,offset driver_end    ; start at the beginning of the table
    jb  xms_no_valid_handle
    xor dx,dx

    push bx                     ; what syntax does TASM support to do
    mov  bx,size xms_handle     ; div DX:AX,3 ??
    div bx
    pop bx

    or  dx,dx
    jnz xms_no_valid_handle

    cmp ax,[_xms_num_handles]    ; less then last handle ??
    jae xms_no_valid_handle

    cmp [si+xms_handle.used],0             ; is it in use ??

    je xms_no_valid_handle

    pop si
    pop dx

    ret

xms_no_valid_handle:
    pop si
    pop dx

    xor ax,ax
    mov bl,XMS_INVALID_HANDLE
    stc
    ret

endp    xms_check_handle

;******************************************************************************
; returns free XMS
; In:   AH=8
; Out:  AX=size of largest free XMS block in kbytes
;   DX=total amount of free XMS in kbytes
;   BL=0 if ok
;   BL=080h -> function not implemented
;   BL=081h -> VDISK is detected
;   BL=0a0h -> all XMS is allocated

proc    xms_query_free_xms
    push    bx cx

    xor ax,ax               ; contains largest free block
    xor dx,dx               ; contains total free XMS

    call    xms_find_free_block     ; search free block
    jc  no_free_xms

check_next:
    mov si,[bx+xms_handle.xsize]    ; get size
    add dx,si               ; update total amount
    cmp si,ax               ; check if larger than largest
    jbe not_larger
    mov ax,si               ; larger, update
not_larger:
    call    xms_find_next_free_block
    jnc check_next

    pop cx bx
    xor bl,bl
    ret;return_success

no_free_xms:
    pop cx bx
    mov bl,XMS_ALREADY_ALLOCATED
    ret;return_failure
endp    xms_query_free_xms

;******************************************************************************
; allocates an XMS block
; In:   AH=9
;   DX=amount of XMS being requested in kbytes
; Out:  AX=1 if successful
;     DX=handle
;   AX=0 if not successful
;     BL=080h -> function not implemented
;     BL=081h -> VDISK is detected
;     BL=0a0h -> all XMS is allocated
;     BL=0a1h -> no free handles left

proc    xms_alloc_xms
    push    bx cx

    call    xms_find_free_block ; see if there's a free block
    jnc check_size      ; if it is, go on

no_free_handle:
    pop cx bx
    xor ax,ax
    mov bl,XMS_NO_HANDLE_LEFT
    ret;return_failure

no_free_mem:
    pop cx bx
    xor ax,ax
    mov bl,XMS_ALREADY_ALLOCATED
    ret;return_failure

get_next_block:
    call    xms_find_next_free_block
    jc  no_free_mem
check_size:
    cmp dx,[bx+xms_handle.xsize]    ; check if it's large enough
    ja  get_next_block              ; no, get next block

    mov si,bx           ; save handle address
    mov [bx+xms_handle.used],1  ; this block is used from now on

    call    xms_find_free_handle    ; see if there's a blank handle
    jc  perfect_fit     ; no, there isn't, alloc all mem left
    mov ax,[si+xms_handle.xsize]    ; get size of old block
    sub ax,dx               ; calculate resting memory
    jz  perfect_fit         ; if it fits perfectly, go on
    mov [bx+xms_handle.xsize],ax    ; store sizes of new blocks
    mov [si+xms_handle.xsize],dx
    mov ax,[si+xms_handle.xbase]    ; get base address of old block
    add ax,dx               ; calculate new base address
    mov [bx+xms_handle.xbase],ax    ; store it in new handle
    mov [bx+xms_handle.locks],0     ; no locks on this block

perfect_fit:
    mov [si+xms_handle.locks],0     ; no locks on this block

    mov dx,si               ; return handle in DX

    pop cx bx
    mov ax,1
    xor bl,bl
    ret;return_success
endp    xms_alloc_xms

;******************************************************************************
; frees an XMS block
; In:   AH=0ah
;   DX=handle to allocated block that should be freed
; Out:  AX=1 if successful
;   AX=0 if not successful
;     BL=080h -> function not implemented
;     BL=081h -> VDISK is detected
;     BL=0a2h -> handle is invalid
;     BL=0abh -> handle is locked

proc    xms_free_xms
    call xms_check_handle       ; check if dx holds handle
    jnc free_valid_handle
    ret;return_failure

free_valid_handle:

    mov si,dx

    cmp [si+xms_handle.locks],0     ; is the block locked?
    jz  not_locked          ; no, go on
    xor ax,ax
    mov bl,XMS_BLOCK_LOCKED
    ret;return_failure


not_locked:
    push    cx dx

    cmp [si+xms_handle.xsize],0     ; is it a zero-length handle?
    jnz normal_handle
    mov [si+xms_handle.xbase],0     ; blank handle
    jmp xms_free_done

normal_handle:

                                    ; 1) see if the following block is
                                    ;    free, too

    mov ax,[si+xms_handle.xbase]    ; get base address
    add ax,[si+xms_handle.xsize]    ; calculate end-address

    call    xms_find_free_block     ; check free blocks
    jc  xms_free_done_1             ; no, was last handle
try_concat:
    cmp ax,[bx+xms_handle.xbase]    ; is it adjacent to old block?
    jne not_adjacent
    mov dx,[bx+xms_handle.xsize]    ; concat
    add ax,dx
    add [si+xms_handle.xsize],dx
    mov [bx+xms_handle.xbase],0     ; blank handle
    mov [bx+xms_handle.xsize],0
not_adjacent:
    call    xms_find_next_free_block    ; see if there are other blks
    jnc try_concat


xms_free_done_1:
                                    ; 2) see if the previous block is
                                    ;    free, too

xms_free_loop_2:
    call    xms_find_free_block     ; check free blocks
    jc  xms_free_done               ; no, was last handle


try_concat_2:
    mov ax,[bx+xms_handle.xbase]    ; is it adjacent to old block?
    add ax,[bx+xms_handle.xsize]    ;
    cmp ax,[si+xms_handle.xbase]    ;
    jne not_adjacent_2

    mov ax,[si+xms_handle.xsize]    ; concat
    add [bx+xms_handle.xsize],ax
    mov [si+xms_handle.xbase],0     ; blank handle
    mov [si+xms_handle.xsize],0
    mov [si+xms_handle.used],0      ; handle isn't used anymore
    mov si,bx
    jmp xms_free_loop_2             ; restart
not_adjacent_2:
    call    xms_find_next_free_block    ; see if there are other blks
    jnc try_concat_2



xms_free_done:
    mov [si+xms_handle.used],0      ; handle isn't used anymore
    pop dx cx
    mov ax,1
    xor bl,bl
    ret;return_success
endp    xms_free_xms

;******************************************************************************
; calculates the move address
; In:   BX - handle (0 if EDX should be interpreted as seg:ofs value)
;   EDX - offset
; Out:  EBX - absolute move address
; Modifies: ECX, EDX

proc    xms_get_move_addr
    or  bx,bx           ; translate address in EDX?
    jnz dont_translate  

						; its segment:offset in EDX
    
						; ebx = 16*(edx high) + dx
    movzx   ebx,dx          ; save offset
    xor dx,dx           ; clear lower word
    shr edx,12          ; convert segment to absolute address
    add ebx,edx			; add offset


	mov eax,ebx		    		; check that ebx(address) + ecx (length) is <= 10fff0
	add eax,ecx   	    		; 
	jc wrong_size2				; negative length might wrap
	cmp eax,10fff0h
	ja wrong_size2

	clc
    ret

    
dont_translate:			; its a handle:offset pair
    push dx
    mov  dx,bx
    call xms_check_handle
    pop  dx
    jnc  get_move_addr_1
                        ; no valid handle
    ret                 ; return with carry set

get_move_addr_1:
    push ecx            ; contains length

    add ecx,edx         ; assert length + offset < size    
    jc  wrong_size		; probably negativ length
    add ecx,1024-1      ;
    jc  wrong_size		; probably negativ length

    shr ecx,10			
    cmp cx,[bx+xms_handle.xsize]    ; compare with max offset
    ja wrong_size
    pop ecx

    movzx   ebx,[bx+xms_handle.xbase]   ; get block base address
    shl ebx,10              ; convert from kb to absolute

    add ebx,edx             ; add offset into block
    ret

wrong_size:
    pop ecx
wrong_size2:

    mov bl,XMS_INVALID_LENGTH
    xor ax,ax
    stc
    ret
endp    xms_get_move_addr

;******************************************************************************
; moves an XMS block
; In:   AH=0bh
;   DS:SI=pointer to XMS move structure
; Out:  AX=1 if successful
;   AX=0 if not successful
;     BL=080h -> function not implemented
;     BL=081h -> VDISK is detected
;     BL=082h -> A20 failure
;     BL=0a3h -> source handle is invalid
;     BL=0a4h -> source offset is invalid
;     BL=0a5h -> destination handle is invalid
;     BL=0a6h -> destination offset is invalid
;     BL=0a7h -> length is invalid
;     BL=0a8h -> move has invalid overlap
;     BL=0a9h -> parity error

proc    xms_move_xms
    push    ecx edx
    push    eax ebx



    call    test_a20            ; get A20 state
    pushf                   ; save it for later
    jnz was_enabled
    call    enable_a20          ; now enable it! - if it was disabled
was_enabled:

    mov ecx,[es:si+xms_move_strc.len]   ; get length
    test    cl,1                ; is it even?
    jnz move_invalid_length

    mov bx,[es:si+xms_move_strc.dest_handle]
    mov edx,[es:si+xms_move_strc.dest_offset]
    call    xms_get_move_addr       ; get move address
    jc  copy_dest_is_wrong
    mov edi,ebx             ; store in destination index

    mov bx,[es:si+xms_move_strc.src_handle]
    mov edx,[es:si+xms_move_strc.src_offset]
    call    xms_get_move_addr       ; get move address
    jc  copy_source_is_wrong

    mov esi,ebx                 ; store in source index

;**************************************************
; setup finished with
;   ESI = source
;   EDI = destination
;   ECX = number of words to move
;
; now we must check for potential overlap
;**************************************************

    or  ecx,ecx                 ; nothing to do ??
    jz  xms_exit_copy

    cmp esi,edi                 ; nothing to do ??
    jz  xms_exit_copy


;
; if source is greater the destination, it's ok
;     ( at least if the BIOS, too, does it with CLD)

    ja xms_move_ok_to_start

;
; no, it's less
; if (source + length > destination)
;    return ERROR_OVERLAP

    mov eax, esi
    add eax, ecx
    cmp eax, edi
    ja  move_invalid_oberlap

;
; we might be able to handle that, but are not yet
; so better don't copy
;



;   jmp use_int15               ; allways BIOS


xms_move_ok_to_start:
    SMSW    AX					; don't use mov eax,cr0
    							; this is a priviledged instruction
    test    al,1                ; are we already in PM?
    jnz use_int15               ; yes, use BIOS (or EMM386...)


;------------------------------------------------------------
; we do very interesting protected mode stuff to copy things

    cli                     ; no interrupts when doing protected mode


    lgdt    [fword cs:gdt32]        ; load GDTR
    mov eax,cr0
    or  al,1                ; set PE bit
    mov cr0,eax             ; shazamm!
    db  0eah                ; JMP FAR
    dw  offset to_pm,code16idx      ; flush IPQ and load CS sel.
to_pm:

    mov ax,core32idx
    mov ds,ax
    mov es,ax

    shr ecx,2               ; get number of DWORDS to move
    jnc dword_boundary          ; is length a DWORD multiple?
    movs    [word esi],[word edi]       ; no, move first word to adjust
dword_boundary:
    rep movs [dword esi],[dword edi]    ; now move the main block

                            ; and because not all 386's were OK,
    db      67h             ; don't remove - some x386's were buggy
    nop                     ; don't remove - some x386's were buggy


    mov eax,cr0
    and al,not 1            ; clear PE bit
    mov cr0,eax             ; shazomm!

    db  0eah                ; JMP FAR
    dw  offset to_rm
code_seg dw ?               ; flush IPQ and load CS sel.

to_rm:
    jmp xms_exit_copy

;------------------------------------------------------------------------
; we are in protected mode, use int15, ah=87 to copy things around

BIOSGDT:
            db 0,0,0,0,0,0,0,0  ; dummy GDT entry
            db 0,0,0,0,0,0,0,0  ; dummy GDT entry

            dw 0ffffh           ; source segment length
GDTsrclow   dw 0              ; 24 bit src address
GDTsrcmiddle db 0
            db 093h             ; source access rights == 94
            db  0fh         ; More type bits and bits 16-19 of source segment length.
GDTsrchigh  db  0           ; Bits 24-31 of source address.

            dw 0ffffh           ; source segment length
GDTdstlow   dw 0                ; 24 bit src address
GDTdstmiddle db 0
            db 093h             ; source access rights == 94
            db  0fh         ; More type bits and bits 16-19 of source segment length.
GDTdsthigh  db   0           ; Bits 24-31 of source address.

            db 0,0,0,0,0,0,0,0  ; dummy GDT entry
            db 0,0,0,0,0,0,0,0  ; dummy GDT entry

; entry ESI = src linear adress
; entry EDI = dst linear adress
; entry ECX = length

public use_int15
use_int15:
    mov edx,ecx

use_int15_loop:
    mov ecx,edx
    cmp ecx,1000h
    jle nomax1000
    mov ecx,1000h
nomax1000:


    cli                     ; protect BIOSGDT for reentrancy

    mov eax,esi
    mov [GDTsrclow],ax
    shr eax,010h
    mov [GDTsrcmiddle],al
    mov [GDTsrchigh],ah

    mov eax,edi
    mov [GDTdstlow],ax
    shr eax,010h
    mov [GDTdstmiddle],al
    mov [GDTdsthigh],ah

    push ecx                 ; later used again
    push esi
    push es
    push cs
    pop  es

    lea si, [BIOSGDT]
    shr cx,1                ; number of words

    clc
    mov ah,87h
    int 15h

    sti

    pop es
    pop esi
    pop ecx                 ; get length back

    jc move_a20_failure


    add edi,ecx             ; buff += copied length
    add esi,ecx

    sub edx,ecx             ; count -= copied length

    jnz use_int15_loop


;   jmp xms_exit_copy
;-------------------------------------------------------------------------




xms_exit_copy:
    popf                    ; get A20 state

    pop ebx
    pop eax

    mov ax,1                ; success


move_a20_exit:
IF ALLOWDISABLEA20
	jnz move_a20_was_enabled  ; if A20 was enabled, don't disable
    call    disable_a20       ; it was disabled, so restore state
 	move_a20_was_enabled:
ENDIF

    pop edx ecx

    ret;return_success_or_failure

                            ; common exit rouitne
move_a20_failure:
    mov bl,XMS_A20_FAILURE

xms_exit_copy_failure:
    popf                    ; get back A20 state

    mov al,bl               ; save errorcode BL , but restore EBX
    pop ebx
    mov bl,al
    pop eax
    mov ax,0                ; failure
    jmp move_a20_exit


move_invalid_oberlap:
    mov bl,XMS_INVALID_OVERLAP
    jmp xms_exit_copy_failure

move_invalid_length:
    mov bl,XMS_INVALID_LENGTH
    jmp xms_exit_copy_failure


copy_source_is_wrong:
    cmp bl,XMS_INVALID_LENGTH
    je xms_exit_copy_failure

    mov bl,XMS_INVALID_SOURCE_HANDLE
    jmp xms_exit_copy_failure

copy_dest_is_wrong:
    cmp bl,XMS_INVALID_LENGTH
    je xms_exit_copy_failure

    mov bl,XMS_INVALID_DESTINATION_HANDLE
    jmp xms_exit_copy_failure


endp    xms_move_xms

;******************************************************************************
; locks an XMS block
; In:   AH=0ch
;   DX=XMS handle to be locked
; Out:  AX=1 if block is locked
;     DX:BX=32-bit linear address of block
;   AX=0 if not successful
;     BL=080h -> function not implemented
;     BL=081h -> VDISK is detected
;     BL=0a2h -> handle is invalid
;     BL=0ach -> lock count overflow
;     BL=0adh -> lock fails

public  xms_lock_xms
proc    xms_lock_xms
    call xms_check_handle       ; check if dx holds handle
    jnc lock_valid_handle
    ret;return_failure

lock_valid_handle:
    mov si,dx
    inc [si+xms_handle.locks]   ; increase lock counter
    jnz locked_successful       ; go on if no overflow
    dec [si+xms_handle.locks]   ; decrease lock counter
    xor ax,ax
    mov bl,XMS_LOCK_COUNT_OVERFLOW  ; overflow, return with error
    ret;return_failure

locked_successful:

; real 32 bit addresses this way
;    push    eax             ; save EAX
;    movzx   eax,[si+xms_handle.xbase]   ; get block base address
;    shl eax,10              ; calculate linear address
;    mov bx,ax               ; store LSW
;    shr eax,16
;    mov dx,ax               ; store MSW
;    pop eax                 ; restore EAX

; 16 bit handling of .xbase like that
    mov bx,[si+xms_handle.xbase]   ; get block base address
    xor dx,dx
    shld dx,bx,10           ; calculate linear address
    shl  bx,10

    mov ax,1


    ret;return_success
endp    xms_lock_xms

;******************************************************************************
; unlocks an XMS block
; In:   AH=0dh
;   DX=XMS handle to unlock
; Out:  AX=1 if block is unlocked
;   AX=0 if not successful
;     BL=080h -> function not implemented
;     BL=081h -> VDISK is detected
;     BL=0a2h -> handle is invalid
;     BL=0aah -> block is not locked

public  xms_unlock_xms
proc    xms_unlock_xms
    call xms_check_handle       ; check if dx holds handle
    jnc unlock_valid_handle
    ret;return_failure

unlock_valid_handle:

    mov si,dx
    cmp [si+xms_handle.locks],0 ; check if block is locked
    jnz is_locked           ; go on if true
    xor ax,ax
    mov bl,XMS_BLOCK_NOT_LOCKED
    ret;return_failure
is_locked:
    dec [si+xms_handle.locks]   ; decrease lock counter
    mov ax,1
    xor bl,bl
    ret;return_success
endp    xms_unlock_xms

;******************************************************************************
; returns XMS handle information
; In:   AH=0eh
;   DX=XMS block handle
; Out:  AX=1 if successful
;     BH=block's lock count
;     BL=number of free XMS handles
;     DX=block's length in kbytes
;   AX=0 if not successful
;     BL=080h -> function not implemented
;     BL=081h -> VDISK is detected
;     BL=0a2h -> handle is invalid

public  xms_get_handle_info
proc    xms_get_handle_info
    call xms_check_handle   ; check handle validity
    jnc  handle_info_1
    ret;return_failure

handle_info_1:
    push    cx
    mov     si,dx
    

    xor dl,dl               ; reset free handle counter
    call    xms_find_free_handle        ; chk if there's a blank handle
    jc  nothing_free
find_next_free:
    inc dl              ; increase handle counter
    call    xms_find_next_free_handle   ; and check if there's another
    jnc find_next_free

nothing_free:
    mov bl,dl               ; store number of free handles
    mov bh,[si+xms_handle.locks]    ; store lock count
    mov dx,[si+xms_handle.xsize]    ; store block size

    pop cx
    mov ax,1
    ret;return_success
endp    xms_get_handle_info

;******************************************************************************
; reallocates an XMS block. only supports shrinking.
; In:   AH=0fh
;   BX=new size for the XMS block in kbytes
;   DX=unlocked XMS handle
; Out:  AX=1 if successful
;   AX=0 if not successful
;     BL=080h -> function not implemented
;     BL=081h -> VDISK is detected
;     BL=0a0h -> all XMS is allocated
;     BL=0a1h -> all handles are in use
;     BL=0a2h -> invalid handle
;     BL=0abh -> block is locked

public  xms_realloc_xms
proc    xms_realloc_xms
    call xms_check_handle   ; check handle validity
    jnc  realloc_xms_handle_valid
    ret;return_failure

realloc_xms_handle_valid:

    push    bx dx

    xchg    bx,dx
    cmp dx,[bx+xms_handle.xsize]
    jbe shrink_it

no_xms_handles_left:
    pop dx bx
    xor ax,ax
    mov bl,XMS_NO_HANDLE_LEFT       ; simulate a "no handle" error
    ret;return_failure

shrink_it:
    mov si,bx
    call    xms_find_free_handle        ; get blank handle
    jc  no_xms_handles_left     ; return if there's an error
    mov ax,[si+xms_handle.xsize]    ; get old size
    mov [si+xms_handle.xsize],dx
    sub ax,dx               ; calculate what's left over
    jz  dont_need_handle        ; skip if we don't need it
    add dx,[si+xms_handle.xbase]    ; calculate new base address

    mov [bx+xms_handle.xbase],dx    ; store it
    mov [bx+xms_handle.xsize],ax    ; store size
    mov [bx+xms_handle.locks],0     ; block is not locked...
    
    mov [bx+xms_handle.used],1      ; ...and not used - for a mikrosecond

	mov dx,bx						; and FREE it again -
	call xms_free_xms				; to merge it with free block list


dont_need_handle:
    pop dx bx
    mov ax,1
    xor bl,bl
    ret;return_success
endp    xms_realloc_xms

;******************************************************************************
; requests an UMB block
; In:   AH=10h
;   DX=size of requested memory block in paragraphs
; Out:  AX=1 if successful
;     BX=segment number of UMB
;     DX=actual size of the allocated block in paragraphs
;   AX=0 if not successful
;     DX=size of largest available UMB in paragraphs
;     BL=080h -> function not implemented
;     BL=0b0h -> only a smaller UMB are available
;     BL=0b1h -> no UMBs are available


;******************************************************************************
; releases an UMB block
; In:   AH=11h
;   DX=segment of UMB
; Out:  AX=1 if successful
;   AX=0 if not successful
;     BL=080h -> function not implemented
;     BL=0b2h -> UMB segment number is invalid


;******************************************************************************
; reallocates an UMB
; In:   AH=12h
;   BX=new size for UMB in paragraphs
;   DX=segment of UMB to reallocate
; Out:  AX=1 if successful
;   AX=0 if not successful
;     BL=080h -> function not implemented
;     BL=0b0h -> no UMB large enough to satisfy request
;       DX=size of largest UMB in paragraphs
;     BL=0b2h -> UMB segment is invalid

;xms_realloc_umb:
;xms_request_umb:
;xms_release_umb:
;    xor ax,ax
;    mov bl,XMS_NOT_IMPLEMENTED
;    ret;return_failure


;******************************************************************************
; XMS dispatcher
;******************************************************************************
; XMS dispatcher
; In:   AH - function number
; Out:  AX=0 -> function not supported
;   else see appr. routine

xms_table   dw  xms_get_version,xms_request_hma,xms_release_hma
            dw  xms_global_enable_a20,xms_global_disable_a20
            dw  xms_local_enable_a20,xms_local_disable_a20
            dw  xms_query_a20,xms_query_free_xms,xms_alloc_xms
            dw  xms_free_xms,xms_move_xms,xms_lock_xms,xms_unlock_xms
            dw  xms_get_handle_info,xms_realloc_xms
            
;            dw  xms_request_umb, xms_release_umb,xms_realloc_umb

proc    xms_dispatcher
    jmp short dispatcher_entry
    nop                 ;
    nop                 ; guarantee hookability
    nop                 ;
dispatcher_entry:
    pushf                       ; save flags

    cld
    cmp ah,0fh                  ; is it a supported function?
    							; UMB functions not implemented
    ja  not_supported
    
;*hook_patch:					; by design: no longer needed/wanted
;*    jmp short hook_ints
;*hook_return:

;
;real dispatcher
;
; save ds,es,si,di
; set es = USERds
; set ds = CS

    push ds         ; protect registers
    push es
    push esi        ; might get used 32 bit wide
    push edi        ;

    push ds         ; set up segment registers for internal use
    pop  es
    push cs
    pop  ds


    movzx   di,ah       ; is nowhere used as input
    shl di,1
    call [xms_table+di] ; call the handler here

    pop edi         ; restore saved registers
    pop esi

    pop es
    pop ds
    popf
    retf




not_supported:
    xor ax,ax               ; everything else fails
    mov bl,XMS_NOT_IMPLEMENTED
    popf                    ; and Yury strikes again...
    retf
;vdisk_installed:
;    xor ax,ax
;    mov bl,XMS_VDISK_DETECTED
;    popf                    ; flags should be forbidden
;    retf



;*
;* reason for doing this here (at first non version call)
;* and not at init time:
;*
;* if VDISK is installed AFTER HIMEM.EXE, VDISK will install
;* it's own INT15 handler
;* tom ehlert decided to ignore this possibility
;* and opt for smaller memory
;*
;*
;*hook_ints:
;*    or  ah,ah               ; non-version call?
;*    jz  hook_return         ; no, don't patch
;*
;*    push    ax bx cx dx ds es       ; save registers
;*
;*    push cs
;*    pop  ds
;*
;*                            ; install own INT15h
;*    mov ax,3515h            ; getvect --> es:bx
;*    int 21h
;*
;*    mov [word old_int15+2],es
;*   mov [word old_int15],bx
;*
;*    mov ax,2515h            ; setvect -->ds:dx
;*    mov dx,offset int15_handler
;*    int 21h
;*
;*    mov [word hook_patch],9090h  ; insert two NOPs
;*
;*    pop es ds dx cx bx ax       ; restore registers
;*
;*    jmp hook_return             ; and finish it

endp    xms_dispatcher

;******************************************************************************
; mark for the driver end. above has to be the resident part, below the
; transient.

	public driver_end
driver_end:




;******************************************************************************
; call an external commandline handler
; although it doesn't do anything yet, its present.
;
; feel free to implement:
;
;   NumHandles=
;   MaxMem=
;   ...
; tom
;******************************************************************************



proc DoCommandline near

                            ; install a stack, the C part will require it
    mov ax,ss
    mov bx,sp

    mov dx,cs
    mov ss,dx
    mov sp,offset DGROUP:driver_stacktop

    pusha
    push es

    les bx,[cs:request_ptr]   ; pointer to request header


    les ax, [es:di+init_strc.cmd_line]

    push es                     ; startup_driver(char far *cmdLine)
    push ax
	call _startup_driver

	add sp,4

    pop es
    popa

                            ; restore original stack, DOS requires it

    mov ss,ax
    mov sp,bx


    ret

endp DoCommandline

;******************************************************************************
; checks if VDISK is already installed
; note: HMA check is skipped because of speed and some other (weird) reasons.
; In:   nothing
; Out:  ZF=0 -> VDISK is installed
;   ZF=1 -> VDISK not installed
;
; tom:it's absolute unclear, if [13] or [12] should be checked.
;     HIMEM verifies [13], so we do that as well.
;     goto HELL, dear VDISK
;     verify only 4 bytes, should do as well
;


proc    _install_check_vdisk
    push    bx ds

    xor bx,bx           ; get interrupt vector 19h
    mov ds,bx
    lds bx,[19h*4]

	    
    cmp [dword bx],053494456h; 'VDIS'

    pop ds bx
    ret
endp    _install_check_vdisk



;******************************************************************************
; 16-bit transient code and data. only used once.
;******************************************************************************
; checks if CPU is a 386
; In:   nothing
; Out:  CY=0 - processor is a 386 or higher
;   CY=1 - processor lower than 386

proc    check_cpu
    pushf
    xor ax,ax
    push    ax
    popf
    pushf
    pop ax
    and ah,0fh
    cmp ah,0fh
    je  not386
    mov ah,7
    push    ax
    popf
    pushf
    pop ax
    and ah,7
    je  not386
    popf
    clc
    ret
not386:
    popf
    stc
    ret
endp    check_cpu

;******************************************************************************
; checks if A20 can be enabled and disabled
; Out:  CF=0 - A20 switching works
;   CF=1 - A20 failure

cant_disable_message db 'Can',27h,'t disable A20 - ignored',0dh,0ah,'$'

proc    check_a20
    call    enable_a20
    call    test_a20            ; TEST_A20 should return ZF=0
    jz  a20failed
IF ALLOWDISABLEA20    
    call    disable_a20
    call    test_a20            ; TEST_A20 should return ZF=1
    jz a20_ok
								; we can't disable A20.
								; so what ?
								; these guys are crazy anyway,
								; and we (nearly) ignore that 
									
    mov ah,9                    ; print msg
    mov dx,offset cant_disable_message
    int 21h
    
a20_ok:
ENDIF    
    clc
    ret
a20failed:
    stc
    ret
endp    check_a20



EnableA20PS2:   
	in	al,92h ; 
	or	al,2   ; switch on
	out	92h,al
				; wait until it gets on
	xor cx,cx
enableps2wait:
	in	al,92h
	test al,2
	loopz enableps2wait
	ret

EnableA20PS2End:
	
DisableA20PS2:
	in	al,92h ; 
	and	al,not 2   ; switch off
	out	92h,al
				; wait until it gets off
	xor cx,cx
disableps2wait:
	in	al,92h
	test al,2
	loopnz disableps2wait
	ret

DisableA20PS2End:



MsgPS2Detected        db 'HIMEM - trying PS/2 maschine',0dh,0ah,'$'

proc detect_and_handle_PS2

;        mov     ah,0C0h   
;        stc
;        int     15h
;        jc      noPS2            
        
;        or 		ah,ah
;        jnz		noPS2

;        test 	[byte es:bx+5],2 ; feature byte 1, bus is microchannel
;        jz      short NoPS2

        
		mov dx,offset MsgPS2Detected        
		mov ah,9
		int 21h

		cld

									; copy PS2 handler into place		

IF EnableA20PS2End - EnableA20PS2 gt enable_a20end-enable_a20
	this is an error! reserve some space
ENDIF                                                        

IF DisableA20PS2End - DisableA20PS2 gt disable_a20end-disable_a20
	this is an error! reserve some space
ENDIF                                                        

		push cs
		pop  es

		mov di, offset enable_a20
		mov si, offset EnableA20PS2
		mov cx, offset EnableA20PS2End - offset EnableA20PS2
		rep movsb
		
		

		mov di, offset disable_a20
		mov si, offset DisableA20PS2
		mov cx, offset DisableA20PS2End - offset DisableA20PS2
		rep movsb

noPS2:
        ret

endp detect_and_handle_PS2

;******************************************************************************
; initializes the driver. called only once!
; may modify DI
; In:   ES:DI - pointer to init structure
;   DS - initialized with code segment

	public _init_message,_vinit_message,_copyright

_init_message  db  'FreeDOS HIMEM ',DRIVER_VERSION,0
_copyright     db  '(c) 1995, Till Gerken 2001-2003 tom ehlert',0
_vinit_message db  'Interface : XMS ',INTERFACE_VERSION,' 80386 64MB ',0


old_dos         db  'XMS needs at least DOS version 3.00.$'
xms_twice       db  'XMS is already installed.$'
vdisk_detected  db  'VDISK has been detected.$'
no_386          db  'At least a 80386 is required.$'
a20_error       db  'Unable to switch A20 address line.$'
xms_sizeerr     db  'Unable to determine size of extended memory.$'
xms_toosmall    db  'Extended memory is too small or not available.$'

error_msg       db  ' Driver won''t be installed.',7,13,10,'$'

init_finished       db  80 dup (''),13,10,'$'

proc    initialize
    pushf
    push    ax bx cx dx si

    cld

;    mov ah,9                ; first, welcome the user!
;    mov dx,offset init_message
;    int 21h

    mov ax,3000h            ; get DOS version number
    int 21h
    xchg    ah,al               ; convert to BSD
    cmp ax,300h             ; we need at least 3.00
    mov dx,offset old_dos
    jb  error_exit

    mov ax,4300h            ; check if XMS is already
    int 2fh             ; installed
    cmp al,80h
    mov dx,offset xms_twice
    je  error_exit

    call    check_cpu           ; do we have at least a 386?
    mov dx,offset no_386
    jc  error_exit   


    call    check_a20           ; check A20
    jnc 	standard_at			; if it works, it's a standard AT
    
    call detect_and_handle_PS2

    call    check_a20           ; check A20
    mov dx,offset a20_error
    jc  error_exit

standard_at:
    call    _install_check_vdisk   ; is VDISK installed?
    mov dx,offset vdisk_detected
    jz  error_exit

    call DoCommandline          ; call some C initialization
                                ; to interpret commandline,...

                                ; get extended memory size
    clc                         ; MUST be reset,
                                ; some BIOS'es don't set/reset it.
    mov ah,88h
    int 15h
    mov dx,offset xms_sizeerr
    jc  error_exit

    mov dx,offset xms_toosmall
    sub ax,64                   ; save HIMEM area
    jc  error_exit              ; if there aren't 64k,
                                ; there's nothing to do



;
; now that martin stroemberg discovered the high 8 bits in
; the BIOS transfer routine, it should work for 32 bits as well



    mov [xms_size],ax           ; save size

    push    eax                 ; save EAX

    mov ax,cs                   ; setup descriptors
    mov [code_seg],ax           ; eliminate relocation entry
    movzx   eax,ax
    shl eax,4
    or  [dword code16dsc+2],eax
    add [dword gdt32+2],eax

    pop eax                     ; restore EAX

    push    es

    xor ax,ax                   ; get INT2Fh vector
    mov es,ax
    les bx,[es:2fh*4]
    mov [word old_int2f+2],es
    mov [word old_int2f],bx

    mov ax,252fh            ; install own INT2Fh
    mov dx,offset int2f_handler
    int 21h
    
                            ; install own INT15h
    mov ax,3515h            ; getvect --> es:bx
    int 21h

    mov [word old_int15+2],es
    mov [word old_int15],bx

    mov ax,2515h            ; setvect -->ds:dx
    mov dx,offset int15_handler
    int 21h
    

    pop es


								; driver init done    

    mov [word es:di+2+init_strc.end_addr],cs    ; set end address
    xor dx,dx
    mov ax,size xms_handle
    mul [_xms_num_handles]
    add ax,offset driver_end
    mov [word es:di+init_strc.end_addr],ax
    mov [es:di+request_hdr.status],STATUS_OK    ; we're alright
    jmp short exit

error_exit:
    mov [word es:di+2+init_strc.end_addr],cs    ; set end address
    mov [word es:di+init_strc.end_addr],0   ; now, we don't use
                            ; any space
    mov [es:di+request_hdr.status],STATUS_BAD   ; waaaah!
    mov ah,9                    ; print msg
    int 21h
    mov dx,offset error_msg
    int 21h

exit:
;               no longer nice ------------- message for noise reduction
;    mov ah,9
;    mov dx,offset init_finished
;    int 21h


;
; here, AFTER ALL MESSAGES,...
; we clear the handle table, as this may overwrite part of the code above
; but must not erase itself
; 

handle_table_end:					; handle_table_end - driver_end
									; must be >= max_handles*sizeof(handle)

;**                
;** make sure the reserved handle space is large enough
;** 

IF $ - driver_end le 128 *size xms_handle 
									; reserve enough space for the handle_table
	this is an error! serve some space after driver end ~!!							
ENDIF                
;******                
                                    ;
									; clean up and init the handle table
									;    
    
    mov cx,[_xms_num_handles]        ; get number of handles
    mov bx,offset driver_end        ; get start of handle table
clear_table:
    xor ax,ax
    mov [bx+xms_handle.xbase],ax     ; blank handle
    mov [bx+xms_handle.xsize],ax     ; blk doesn't occupy any space
    mov [bx+xms_handle.used],al      ; handle not used
    mov [bx+xms_handle.locks],al     ; handle not used
    add bx,size xms_handle
    loop    clear_table

    mov bx,offset driver_end
    mov [bx+xms_handle.xbase],XMS_START ; init first block and give
    mov ax,[xms_size]           ; it all available memory
    mov [bx+xms_handle.xsize],ax




    pop si dx cx bx ax
    popf
    ret
endp    initialize




;******************************************************************************
; init_interrupt routine. called by DOS right after the strategy routine to
; process the incoming job. also used to initialize the driver.

public  init_interrupt
proc    init_interrupt   near
    push    di es

    push cs						; DS == CS
    pop  ds

    les di,[request_ptr]        ; load address of request header

    cmp [es:di+request_hdr.cmd],CMD_INIT; do we have to initialize?
    jne done

    call    initialize          ; no, do it now!

    mov al,090h                     ; NOP
    mov [cs:init_patch], al         ; NOP out init routine
    mov [cs:init_patch+1], al       ;
    mov [cs:init_patch+2], al       ;


done:
    lds si,[request_ptr]        ; return this to DOS

    pop es di
    ret                 ; far return here!
endp    init_interrupt




;------------------------------------------------------------------------------

;*********************************************
; startpoint when executing as EXE
;*********************************************


ASMSTART_EXE:
		mov     ax, DGROUP
		mov     ds,ax

	    mov 	ss,ax
    	mov 	sp,offset DGROUP:driver_stacktop


		push  es						; startup_exe(commandline);
		mov   ax,080h
		push  ax
		call  _startup_exe
		add sp,4

										; exit
		mov   	ah,04ch					; und tschuess
		int 	21h


;***** exe done


	public _install_end
_install_end:
    
ends    _TEXT  





;******************************************************************************

end ASMSTART_EXE
