/*
 *  win32\win32.h
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#if defined __STDC__ && defined _MSC_VER
#error Windows' SHIT is not ANSI compatable (use /Ze or /ze)
#endif
#if defined __WATCOMC__ && defined NO_EXT_KEYS
#error Windows' SHIT is not ANSI compatable (do not use -za)
#endif
#pragma warning(disable:4001)   /* single line comment */
#pragma warning(disable:4115)   /* named type definition in parentheses */
#pragma warning(disable:4201)   /* nameless struct/union */
#pragma warning(disable:4209)   /* benign typedef */
#pragma warning(disable:4214)   /* bit field types other than int */
#pragma warning(disable:4515)   /* unreferenced inline function */
#define WIN32_LEAN_AND_MEAN
#define NO_INLINE_SHIT
#include <windows.h>

#include "dosio.h"

#pragma pack(1)

struct _DWORDREGS {
    DWORD ebx;
    DWORD edx;
    DWORD ecx;
    DWORD eax;
    DWORD edi;
    DWORD esi;
    DWORD flags;
    };

struct _WORDREGS {
    WORD bx, _upper_bx;
    WORD dx, _upper_dx;
    WORD cx, _upper_cx;
    WORD ax, _upper_ax;
    WORD si, _upper_si;
    WORD di, _upper_di;
    WORD flags, _upper_flags;
    };

struct _BYTEREGS {
    unsigned char bl,bh;
    unsigned short _upper_bx;
    unsigned char dl,dh;
    unsigned short _upper_dx;
    unsigned char cl,ch;
    unsigned short _upper_cx;
    unsigned char al,ah;
    unsigned short _upper_ax;
    unsigned short si, _upper_si;
    unsigned short di, _upper_di;
    unsigned short flags, _upper_flags;
    };

typedef union _DIOC_REGISTERS {
    struct _DWORDREGS d;
    struct _WORDREGS x;
    struct _BYTEREGS h;
} DIOC_REGISTERS;

#pragma pack()

extern HANDLE VxDevice;

#define VWIN32_DIOC_DOS_IOCTL (1)
#define VWIN32_DIOC_DOS_DRIVEINFO (6)
#define VWIN32_DIOC_DOS_INT13 (4)
#define VWIN32_DIOC_DOS_INT25 (2)
#define VWIN32_DIOC_DOS_INT26 (3)

int win32_ioctl(DOS_MINOR_CODE func, int data, void *buf);
int win32_device_io(DWORD control, DIOC_REGISTERS *regs);

#ifdef TRACE
void reg_dump(DIOC_REGISTERS *regs);
void err_dump(const char *);
#define DBG_err_dump(s) err_dump(s)
#define DBG_reg_dump(r) reg_dump(r)
#define DBG_0 ={0}
#else
#define DBG_err_dump(s)
#define DBG_reg_dump(r)
#define DBG_0
#endif
