/*
 *  win32\ioctl.c       perform DOS IOCTL calls
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#include "win32.h"
#include "dosio.h"

/*
 * dos_ioctl        perform DOS IOCTL call (INT 21h/440Dh)
 *
 */

extern int win32_ioctl(DOS_MINOR_CODE func, int data, void *buf)
{
DIOC_REGISTERS regs DBG_0;

    regs.d.eax = 0x440D;
    regs.d.ebx = data;
    regs.d.ecx = 0x0800 + func;
    regs.d.edx = (DWORD)buf;

    DBG_reg_dump(&regs);

    if (win32_device_io(VWIN32_DIOC_DOS_IOCTL,&regs) == 0) {
        return 0;
    }

    DBG_reg_dump(&regs);

    if (regs.x.flags & 0x0001) {
        DBG_err_dump("ioctl");
        return 0;
    }

    return -1;
}

/*
 * diskioctl        INT 21h/440Dh/61h
 *
 */

extern int diskioctl(DOS_FUNCTION cmd, int disk, int track, int sec, int head,
                     void *buf)
{
struct RWBLOCK Blk;
struct RWBLOCK *blk = &Blk;
int i;

    blk->special = 0;
    blk->head = (unsigned short)head;
    blk->track = (unsigned short)track;
    blk->sector = (unsigned short)(sec - 1);
    blk->nsecs = 1;
    blk->buffer = buf;

    i = win32_ioctl(DOS_MINOR_READ_TRACK,disk+1,blk);

    if (i == 0) i = -1;

    return i;
}
