/*
 *	dos\gcc\write.c 	absolute disk write
 *
 *	Copyright (C) 1998, Gregg Jennings
 *
 *	1.2 26-Sep-1998 greggj	Fixed BUG when `nsecs' greater than one.
 *							(i.e. forgot the ` * nsecs ')
 *	1.1 23-Sep-1998 greggj	dosmem.h, ../debug.h
 */

#include "../dosio.h"
#include "../debug.h"
#include "dosmem.h"

/*
 * disk_write		absolute disk write (INT 26h)
 *
 */

extern int disk_write(int disk, long sector, void *buffer, int nsecs,
					  int secsize)
{
__dpmi_regs regs;
int seg,sel;

	if ((seg = _dosmalloc(secsize*nsecs,&sel)) == -1)
		return 0;

	_setdosmem(buffer,secsize*nsecs,sel);

	regs.x.ax = disk;
	regs.x.dx = sector;
	regs.x.cx = nsecs;
	regs.x.ds = seg;
	regs.x.bx = 0;

	DBG_dpmi_dump(&regs);

	__dpmi_int(0x26,&regs);

	DBG_dpmi_dump(&regs);

	if (regs.x.flags & 1) {
		DBG_err_dump("write");
		dosfree(sel);
		return regs.h.al;
	}

	dosfree(sel);

	return -1;
}

/*
 * disk_write_ext	absolute disk write (INT 26h), > 32MB
 *
 */

extern int disk_write_ext(int disk, long sector, void *buffer, int nsecs,
						  int secsize)
{
__dpmi_regs regs DBG_0;
struct DCB dcb;
int seg,sel;
int bseg,bsel;

	if ((seg = dosmalloc(sizeof(struct DCB),&sel)) == -1)
		return 0;

    if ((bseg = dosmalloc(secsize*nsecs,&bsel)) == -1) {
		dosfree(sel);
		return 0;
	}

	setdosmem((void *)buffer,secsize*nsecs,bsel);

	regs.x.ax = disk;
	regs.x.cx = 0xffff;
	dcb.sector = sector;
	dcb.number = nsecs;
	dcb.buffer = _MK_FP(bseg);
	setdosmem((void *)&dcb,sizeof(struct DCB),sel);
	regs.x.ds = seg;
	regs.x.bx = 0;

	DBG_dpmi_dump(&regs);

	__dpmi_int(0x26,&regs);

	DBG_dpmi_dump(&regs);

	if (regs.x.flags & 1) {
		DBG_err_dump("write(ext)");
		dosfree(sel);
		dosfree(bsel);
		return regs.h.al;
	}

	dosfree(sel);
	dosfree(bsel);

	return -1;
}
