/*
 *	dos\gcc\read.c		absolute disk read
 *
 *	Copyright (C) 1998, Gregg Jennings
 *
 *	1.1 23-Sep-1998 greggj	dosmem.h, ../debug.h
 */

#include "../dosio.h"
#include "../debug.h"
#include "dosmem.h"

/*
 * disk_read		absolute disk read (INT 25h)
 *
 */

extern int disk_read(int disk, long sector, void *buffer, int nsecs, int secsize)
{
__dpmi_regs regs;
int seg,sel;

	if ((seg = _dosmalloc(secsize*nsecs,&sel)) == -1)
		return 0;

	regs.x.ax = disk;
	regs.x.dx = sector;
	regs.x.cx = nsecs;
	regs.x.ds = seg;
	regs.x.bx = 0;

	DBG_dpmi_dump(&regs);

	__dpmi_int(0x25,&regs);

	DBG_dpmi_dump(&regs);

	if (regs.x.flags & 1) {
		DBG_err_dump("read");
		_dosfree(sel);
		return regs.h.al;
	}

	_getdosmem(buffer,secsize*nsecs,sel);
	_dosfree(sel);

	return -1;
}

/*
 * disk_read_ext	absolute disk read (INT 25h), > 32MB
 *
 */

extern int disk_read_ext(int disk, long sector, void *buffer, int nsecs,
						 int secsize)
{
__dpmi_regs regs;
struct DCB dcb;
int seg,sel;
int bseg,bsel;

	if ((seg = dosmalloc(sizeof(struct DCB),&sel)) == -1)
		return 0;

	if ((bseg = dosmalloc(secsize*nsecs,&bsel)) == -1) {
		dosfree(sel);
		return 0;
	}

	regs.x.ax = disk;
	regs.x.cx = 0xffff;
	dcb.sector = sector;
	dcb.number = nsecs;
	dcb.buffer = _MK_FP(bseg);
	setdosmem((void *)&dcb,sizeof(struct DCB),sel);
	regs.x.ds = seg;
	regs.x.bx = 0;

	DBG_dpmi_dump(&regs);

	__dpmi_int(0x25,&regs);

	if (regs.x.flags & 1) {
		DBG_err_dump("read(ext)");
		dosfree(sel);
		dosfree(bsel);
		return regs.h.al;
	}

	getdosmem(buffer,secsize*nsecs,bsel);
	dosfree(sel);
	dosfree(bsel);

	return -1;
}
