/***
*disked.c - DISKED The DISK EDitor for MS(tm)-DOS
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   Command module.
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

/*
   Versions:

   3.4   02-Jul-1998    __GNUC__; _winmajor/_winminor; removed dos_ver;
                        fixes for clusters array
   3.3   29-Nov-1997    _FILEN; setjmp(); diskiochk(); Bufmask
   3.2   07-Mar-1997    added ALTSL; removed Debug for 'D'
   3.1   21-Feb-1997    modified '*'; added SHFTF7, SHFTF8
   3.0   20-Dec-1996    added static functions to reduce size
   2.9   13-Sep-1996    moved code for 's' into DISKLIB.C; moved code
                        for 'p', 'P', ^P, etc. into FILEIO.C
   2.8   12-Sep-1996    "%r"; made 's' a function (in DISKLIB.C);
                        big_screen was BigScreen
   2.7   25-Dec-1994    'y': view .SAV file (some command letter changes)
   2.6   04-Sep-1994    ^T, find() changes, extern reference consolodation
   2.5   18-Apr-1994    cleaning up of extern defs
                        input/output function pointers
   2.4   23-Jan-1994    moved all startup code to SETUP.C
   2.3   19-Jan-1994    'removable' test
   2.2   16-Jan-1994    '^Q', replaced 'moved' with 'disk_moved'
   2.1   04-Jan-1994    Translate if !Files for startup, Borland
   2.0   28-Nov-1993

   Release Notes:

   This is basically one huge switch/case in a loop. (It is so big
   that MSC might issue: "main() too big for global optimizations".)

   Programming Notes:

   Maybe someday most code will be put into other modules and the
   case code will be mostly function calls. I've put some command
   code into DISKLIB.C and FILEIO.C for example. One might also want
   to put some in functions after main().

   The interface I chose to use, a TTY or Teletype-like interface
   (which may seem out dated to some, but I find it extremely easy to
   use), presents some programming constructs that are hard to keep
   consistant and can be confusing :-)

*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>        /* _MAX_DIR */
#include <ctype.h>         /* isalpha() */
#include <io.h>            /* for exist() */
#include <direct.h>        /* getcwd(),chdir() */
#include <process.h>       /* spawnl() */
#include <errno.h>
#include <setjmp.h>

#include <conio.h>         /* kbhit() */
#include <dos.h>           /* _dos_set_drive() */

#include "disked.h"
#include "init.h"
#include "mylib.h"
#include "diskio.h"
#include "keys.h"
#include "alloc.h"
#include "files.h"
#include "error.h"
#include "dirent.h"
#include "direct.h"
#include "console.h"
#include "arrays.h"

static void dprint(char *s);
static int verify(char *s);
void setdir(char *dirstr, char *curdir);

jmp_buf disked_jmp;        /* address for long jump to jump to */

/* for find() - possibly may put this in another module */

struct Msg ap[]={          /* for inputing a two argument commnd */
   {" from ",3},
   {" number ",3}
};

/* shared with SETUP.C only */

char cur_dir[FILENAME_MAX];      /* current working directory */
char com_spec[FILENAME_MAX];     /* location of COMMAND.COM */
char prompt_var[FILENAME_MAX];   /* DOS prompt variable */
char ini_file[FILENAME_MAX];     /* INI file path/name */
long set_sector;                 /* startup sector number */
int files_indexed;

/* shared with SETUP.C and INIT.C */

int write_to;                    /* double protection on write */
unsigned long tagged[10];

/* shared with SETUP.C and DISKLIB.C */

int big_screen;                  /* 50 line display */
unsigned int dir_cluster;        /* start up directory cluster nu. */

/* shared with many */

unsigned int byte_cnt;           /* buffer byte count */
unsigned int max_bytes;          /* maximum buffer size */
unsigned char *save_sec;         /* duplicate sector buffer */
unsigned char *spare_sec;        /* spare sector buffer */
unsigned char *data_buf;         /* pointer to area for data buffer */

/* similar to _osmajor, _osminor */

#ifndef _MSC_VER
unsigned short _winmajor, _winminor;
#else
unsigned char __near __cdecl _winmajor;
unsigned char __near __cdecl _winminor;
#endif

#ifdef _MSC_VER
#pragma warning(disable:4100)
#endif

#ifdef ANSI_RETENTIVE
int
#else
void
#endif
main(int argc, char **argv)
{
KEY c;
int i,tempd;
char tmpstr[FILENAME_MAX];
unsigned int u,temps,tempu;
long templ;
unsigned int bufptr;            /* pointer to file buffer */
/* */
int noput,bufchk;
/* constants */
char curdir[FILENAME_MAX];
unsigned int c_disk;
int drives[MAX_DRIVE+1];        /* valid drive number array  1-MAX_DRIVE */
char *bufferfull=" buffer full ";

   tmpstr[0] = '\0';
   bufptr = 0;
   noput = TRUE;

#if defined __WATCOMC__ || defined __GNUC__
   setvbuf(stdout,NULL,_IONBF,0);      /* flush stdout every printf */
#endif

#if !defined NDEBUG && !defined __GNUC__
   printf("");    /* for alloc/free debugging; MSC will call malloc */
                  /* during first printf() */
#endif

   error.num = -1;
   bufchk = 0;

   /* get current directory, and save it for exit */

   _getcwd(cur_dir,_MAX_DIR);

   /* get current disk (c_disk) and destination disk (tempu) */

   c_disk = setup(argv,drives,&tempd);
   i = startup(c_disk,tempd);

   gettmpdir(curdir,TempDir);       /* get working directory */

   if (*curdir)
      setdir(curdir,curdir);
   else
      strcpy(curdir,cur_dir);

   if (!(Files && !Home && Translate))    /* display disk parameters */
      dparams(curdir);                   /*  if not dir display  */

   print("\n\n\t'/' for help");

   if (error.num != -1)                   /* if error */
   {
      output('\n');                       /* place the message */
      printerror(Debug);                  /*  before the dump */
   }

   drivestatus(i);                       /* display anything weird */

   if (strcmp(curdir,cur_dir) == 0)
      print("\nwarning: working directory is on current drive");

   /* the big switch... */

   for (;;)
   {
      setjmp(disked_jmp);

      if (error.num != -1)
      {
         output(' ');
         printerror(Debug);
      }

      if (disk_moved)
      {
         disk_moved = 0;
         dumpsector();
      }

      if ((i = diskiochk()) != 0)
      {
         if (bufchk == 0) output('\a');
         print("\nSector buffer check error! To ensure data integrity you should exit");
         print("\nDISKED now. Sector buffer writing has now been disabled. The sector");
         print("\nbuffer %s has changed.\n",(i == 2) ? "pointer" : "checksum");
         bufchk = 1;
      }

      c = prompt(byte_cnt,Radix);

      /* translate movement keys if file tracking is on */

      if (trackfile(&c) == -1)
         continue;

      /* do some command aliasing */

      if (c == ',') c = ALTR;
      if (c == '*') c = ALTE;

      /* check for ALT+Letter to change booleans (keywords) */

      if (setkeyword(c,kw) == 1)
      {
         if (ft_track)                    /* if file tracking */
            Get = FALSE;                  /*  Get is always OFF */
         continue;
      }

      switch (c)
      {

         case '`':
            longjmp(disked_jmp,-1);

         case '!':
            output(' ');                        /* if "File not found" */
            if (_spawnl(_P_WAIT,com_spec,NULL) != -1)
            {
               disk_moved = 1;                  /* display sector on return */
               setdir(curdir,curdir);
            }
            break;
         case F1:
            print(" Current Directory: %s\n",curdir);
            directory();
            break;
         case F2:
            if (!Files)
               break;
            if (n_files == 1)
            {
               print(" no files");
               break;
            }
            for (tempu = 1; tempu < n_files; tempu++)       /* more than 32767 files ? */
            {
               print("\n%s",gfile(tempu));
               if (_kbhit())
               {
                  if ((c = input()) == 0)
                     input();
                  else if (c == 0x1b)
                     break;
                  else if (c == ' ')
                     pause();
               }
           }
           break;

         case SHFTF1:
            dump(sec_buf,0,sec_size,128,Radix);
            break;
         case SHFTF2:
            dumpf(sec_buf,sec_size,Radix);
            break;
         case SHFTF3:
         case 'V'-'@':
            view(sec_buf,0,sec_size,NOPAUSE,Radix);
            break;
         case SHFTF4:
            dumpdir(sec_buf,sec_size);
            break;
         case SHFTF5:
            dumpboot(sec_buf);
            break;
         case ALTF0:
            help();
            break;
         case F3:
            if (!Files)
               break;
            print(" %u Files, %u Directories",n_files-1,n_dirs);
            break;
         case F4:                        /* change dir */
            print((Display) ? "change directory: " : "cd ");
            if (getstr(tmpstr,MAXSTR,_FILEN) < 1)
               break;
            setdir(tmpstr,curdir);
            break;
         case F5:                        /* re-read */
            readsector();
            disk_moved = 1;
            break;
         case F6: case F7:
         case F8: case F9:
            if (byte_cnt > (max_bytes-sec_size))
               break;
            dprint("append w/");
            tempd = 0;
            switch (c)
            {
               case F6:
                   dprint("strip");
                   tempd = B_STRIP;
                   break;
               case F7:
                   dprint("convert");
                   tempd = B_CONV;
                   break;
               case F8:
                   dprint("mask");
                   tempd = B_MASK;
                   break;
               case F9:
                   dprint("options");
                   tempd = Bufmask;
                   break;
               default:
                   break;
            }
            append(tempd,sec_buf,sec_size);
            break;
         case F10:
            if (!Files)
               break;
            if (n_files == 1)
            {
               print(" no files");
               break;
            }
            dprint("goto ");
            print("file: ");
            if (getstr(tmpstr,MAXSTR,_FILEN) < 1)
               break;
            if ((tempu = findfile(tmpstr)) != 0)
               setcluster(tempu);
            else
               print(" not found");
            break;

         case 'T'-'@':
            if (!Files) break;
            if (ft_track != 0)
            {
               filetrack(NULL,0);
               print(" file unlocked");
               break;
            }
            tempu = sectortocluster(log_sector);
            i = clusters[tempu];
            if (i && (unsigned)i <= n_files)
            {
               if (files[clusters[tempu]].dir)
               {
                  print(" can not track directories yet");
                  break;
               }
               if (!verify(" track file "))
                  break;
               tmpstr[0] = (char)cur_disk + '@';
               tmpstr[1] = ':';
               strcpy(&tmpstr[2],gfile(i));
               print(" %s",tmpstr+2);
               if ((i = filetrack(tmpstr,i)) != 1)
                  print(" lock error %d",i);
               else
                  print(" locked");
            }
            break;

         /*  **** Display ****  */

         case '\n':
            header();
            break;
         case '\r':
            if (!Ascii && !big_screen && Partial)
                  dump(sec_buf,(sec_size==128)?(0):(128),sec_size, \
                  (sec_size==512)?(384):(sec_size),Radix);
            else
               disk_moved = 1;
            break;

         case ' ':
            disk_moved = 1;
            break;
         case '\b':
            dparams(curdir);
            output('\n');
            break;
         case '/':
            disptext(command_text1);
            if (!big_screen)
               break;
            output('\n');                          /* fall through */
         case '?':
            disptext(command_text2);
            break;

         /*  **** movement ****  */

         case 'Q'-'@':                             /* go back */
            if (back_log_sector != log_sector)
            {
               dprint(" go back");
               setsector(back_log_sector);
               disk_moved = 1;
            }
            break;
         case 'H':                                 /* go start */
            dprint(" home");
            if (set_sector != -1L)
               setsector(set_sector);
            else
               rootsector();
            break;
         case HOME:                                /* go drive beginning */
            dprint(" begin");
            bootsector();
            break;
         case END:                                 /* go drive end */
            dprint(" end");
            lastsector();
            break;
         case 'b':                                 /* back sector */
         case UP:
            dprint(" back sector");
            backsector();
            break;
         case 'n':                                 /* next sector */
         case DOWN:
            dprint(" next sector");
            nextsector();
            break;
         case 'B':                                 /* back cluster */
         case LEFT:
            dprint(" back cluster");
            backcluster();
            break;
         case 'N':                                 /* next cluster */
         case RIGHT:
            dprint(" next cluster");
            nextcluster();
            break;
         case 'B'-'@':                             /* back track */
         case PGUP:
            dprint(" back track");
            backtrack();
            break;
         case 'N'-'@':                             /* next track */
         case PGDN:
            dprint(" next track");
            nexttrack();
            break;
         case 'h':                                 /* next head */
            if (max_head == 1)
               break;
            dprint(" next head");
            nexthead();
            break;
         case 'r':                                 /* range (continuous) */
         case 'R':
         case CTRLR:
            if (c == 'R')
               tempd = secs_cluster;
            else
               tempd = 1;
            if (Display)
            {
               print(" range ");
               if (c == CTRLR)
                  output('-');
               putbyte(tempd);
            }
            tempd *= (c == CTRLR) ? -1 : 1;
            range(tempd);
            break;
         case '-':                                 /* plus/minus sectors */
         case '+':
         case '=':
            dprint( (c=='-') ? " move back " : " move ahead ");
            if (getlnumb(num_sectors,&templ) <= 0)
               break;
            if (templ == 0)
               break;
            if (c == '-')
               templ *= -1;
            movesector(templ);
            break;
         case 'S'-'@':                             /* set to sector */
            dprint(" sector ");
            if (getlnumb(num_sectors,&templ) <= 0)
               break;
            setsector(templ);
            break;
         case 'S':                                 /* set to cluster */
            dprint(" cluster ");
            if (getnumb(num_clusters,&tempu) <= 0)
               break;
            if (tempu < 2)
               break;
            setcluster(tempu);
            break;
         case 's':                                 /* set physical */
             set_physical();
             break;
         case SRIGHT:                              /* back/next free cluster */
         case SLEFT:
            if (!Files)
               break;
            tempu = sectortocluster(log_sector);
            if (tempu == 0)
               tempu = 2;
            temps = (c == SLEFT) ? (-1) : (1);
            dprint( (temps == 1) ? " next" : " back");
            dprint(" free cluster");

            for (u = tempu + temps; ; u += temps)
            {
               if (u >= num_clusters)
                   u = 2;
               if (u < 2)
                   u = num_clusters;
               if (u == tempu)
                   break;
               if (clusters[u] == 0)
               {
                   setcluster(u);
                   break;
               }
            }
            break;
         case CEND:                                /* end of file */
            if (!Files)
               break;
            tempu = sectortocluster(log_sector);
            if (clusters[tempu] && (unsigned)clusters[tempu] <= n_files)
            {
               dprint(" end file");
               if ((tempu=arraylast(clusters,num_clusters,clusters[tempu])) == 0)
                  break;
               setcluster(tempu);
            }
            break;
         case CHOME:                               /* start of file */
            if (!Files)
               break;
            tempu = sectortocluster(log_sector);
            if (clusters[tempu] && (unsigned)clusters[tempu] <= n_files)
            {
               dprint(" home file");
               tempu=arrayfirst(clusters,num_clusters,clusters[tempu]);
               if (tempu == num_clusters)
                  break;
               setcluster(tempu);
            }
            break;
         case 'j':                                 /* back/next file cluster */
         case 'J':
         case CLEFT:
         case CRIGHT:
            if (!Files)
               break;
            tempu = sectortocluster(log_sector);      /* get current cluster */
            temps = (c=='j' || c==CRIGHT) ? 1 : -1;   /* set direction */
            if (clusters[tempu] == 0)
               break;
            if ((u = arraytrav(clusters,num_clusters,tempu,temps)) == tempu)
               break;                                 /* just one cluster? */
            dprint( (temps == 1) ? " next" : " back");
            dprint(" file's cluster");

            setcluster(u);                            /* got it */
            break;

          /*  **** Buffer stuff ****  */

         case 'a':
             if (byte_cnt == max_bytes)
                 break;
             dprint(" append sector");
             if ((byte_cnt + sec_size) > max_bytes)
             {
                 print(bufferfull);
                 tempu = max_bytes - byte_cnt;
             }
             else
                 tempu = sec_size;
             memcpy(data_buf+byte_cnt,sec_buf,tempu);
             byte_cnt += tempu;
             break;
         case 'A':
            if (log_sector <= data_sector)
               break;
            if (byte_cnt == max_bytes)
               break;
            dprint(" append cluster");
            savesector();

            i = clustersector(log_sector);      /* goto 1st sector */
            if (movesector(-i) != DISK_OK)
            {
               restoresector();
               break;
            }
            for (u = 0; ; u++)                  /* get it loop */
            {
               if ((byte_cnt + sec_size) > max_bytes)
                  tempu = max_bytes - byte_cnt;
               else
                  tempu = sec_size;
               memcpy(data_buf+byte_cnt,sec_buf,tempu);
               if ((byte_cnt += tempu) == max_bytes)
               {
                   print(bufferfull);
                   break;
               }
               if (u == secs_cluster-1)
                   break;
               if (nextsector() != DISK_OK)
                  break;
            }
            restoresector();
            if (readsector() != DISK_OK)
               disk_moved = 1;
            break;
         case 'A'-'@':
            if (byte_cnt == max_bytes) break;
            dprint(" append bytes");
            tempd=temps=0;                      /* tempd=from, temps=number */
            if (!get(ap,&tempd,(int *)&temps))
               break;
            if ((temps+tempd > sec_size) || temps==0)
               break;
            if (byte_cnt+temps > max_bytes)
               break;
            memcpy(data_buf+byte_cnt,sec_buf+tempd,temps);
            if ((byte_cnt += temps) == max_bytes)
               print(bufferfull);
            break;
         case 'u':
         case 'U':
            if (byte_cnt == 0)
                break;
            dprint(" unappend ");
            dprint( (c=='u') ? "sector" : "cluster");
            tempu = (c=='u') ? sec_size : cluster_size;
            if (byte_cnt < tempu)
               byte_cnt = 0;
            else
               byte_cnt -= tempu;
            break;
         case 'U'-'@':
            if (byte_cnt == 0)
                break;
            dprint(" unappend bytes ");
            if (getnumb(byte_cnt,&tempu) <= 0)
                break;
            if (byte_cnt < tempu)
                byte_cnt = 0;
            else
               byte_cnt -= tempu;
            break;
         case 'e':
         case 'E'-'@':
            if (byte_cnt == 0)
               break;
            if (Display || Verify)
               print(" empty buffer");
            if (c == 'e' && Verify && !getver("",0))
               break;
            bufptr = byte_cnt = 0;
            break;
         case 'k':
            if (save_sec == NULL)
               break;
            if (!verify(" kill changes"))
               break;
            memcpy(sec_buf,save_sec,sec_size);
            sec_bufx = chksum(sec_buf,sec_size);   /* set checksum */
            disk_moved = 1;
            break;
         case '<':
            if (spare_sec == NULL)
               break;
            if (!verify(" store sector"))
               break;
            memcpy(spare_sec,sec_buf,sec_size);
            noput = FALSE;
            break;
         case '>':
            if (spare_sec == NULL)
               break;
            if (noput)
            {
               dprint(" no sector stored");
               break;
            }
            if (!verify(" retrieve sector"))
               break;
            memcpy(sec_buf,spare_sec,sec_size);
            sec_bufx = chksum(sec_buf,sec_size);   /* set checksum */
            disk_moved = 1;
            break;
         case 'd':
         case 'v':
            if (byte_cnt == 0)
               break;
            dprint((c == 'd') ? " dump" : " view");
            dprint(" file buffer from ");
            if ((tempd = getlnumb(byte_cnt,&tempu)) < 0)
               break;
            if (tempd > 0)
            {
               if (tempu == byte_cnt)
                  break;
               bufptr = tempu;
            }
            if (c == 'd')
            {
               output('\n');
               bufptr = dump(data_buf,bufptr,byte_cnt,256,Radix);
               output('\n');
            }
            else
               bufptr = view(data_buf,bufptr,byte_cnt,PAUSE,Radix);
            break;
         case 'c':
            dprint(" change sector buffer from: ");
            if (change(sec_buf,sec_size,Radix))
            {
               sec_bufx = chksum(sec_buf,sec_size);   /* set checksum */
               disk_moved = 1;
            }
            break;
         case 'C':
            if (!byte_cnt)
               break;
            dprint(" change file buffer from ");
            change(data_buf,byte_cnt,Radix);
            break;
         case 'C'-'@':
            copy_file();
            break;
         case 'D'-'@':
            if (changedir(sec_buf,sec_size))
               sec_bufx = chksum(sec_buf,sec_size);   /* set checksum */
            break;
         case 'g':           /*** get sectors ***/
         case 'G'-'@':       /* uses tempd, tempt, i */
            if (byte_cnt == max_bytes)    /* full? */
               break;
            dprint(" get sectors ");
            if (c == 'G'-'@' || Get)
               dprint("w/move ");
            if (getbyte(&tempu) <= 0)
               break;                     /* tempd = number to get */
            savesector();
            if (tempu == 0)   /* 0 = get whole track from beginning */
            {
               tempu = max_sector;           /* count to get */
               log_sector = logicalsector(phy_track,1,phy_head);
               dprint(" (track)");
            }
            else if (tempu == 1)             /* get rest of track */
            {
               tempu = (max_sector - phy_sector) + 1;
               dprint(" (to track end)");
            }

            if (log_sector == 0)             /* kludge... */
               log_sector = num_sectors-1;
            else
               --log_sector;

            if (Display)
               output(' ');
            for (i = 1 ; i <= (int)tempu ; i++)
            {
               if (_kbhit())
                   break;
               if (Display)
                  put(print("%r",i),8);
               if ((tempd=nextsector()) != DISK_OK)
               {
                  savecursor();
                  if (!Display)
                     output(' ');
                  printerror(Debug);
                  if (!getver("continue",0))
                  {
                     put(3,8);
                     break;
                  }
                  restcursor();
                  clreol();
               }
               if ((byte_cnt+sec_size) > max_bytes)
                   break;
               memcpy(data_buf+byte_cnt,sec_buf,sec_size);
               if ((byte_cnt += sec_size) == max_bytes)
               {
                  print(bufferfull);
                  break;
               }
            }
            if (Display && tempd == DISK_OK)
               clreol();
            if (Get || c == 'G'-'@')
               nextsector();
            else
            {
               restoresector();
               readsector();
               disk_moved = 0;
            }
            break;

         /*  **** Log Drive ****  */

         case 'l':
         case 'L'-'@':
            if (c != 'l')
               tempd = cur_disk;
            else
            {
               dprint(" disk ");
               c = input();
               if (!isalpha(c))
                  break;
               tempd = toupper(c)-'@';
               if (drives[tempd]!=TRUE)
                  break;
               output(toupper(c));
               output(':');
               if (Verify && !getver("log disk",MOV_YN))
                  break;
            }
            if (newdisk(tempd))
            {
               cur_disk = tempd;
               if (avail_clusters == 0)
                  avail_clusters = get_avail_clusters();
               dparams(curdir);
            }
            if (error.num != -1)    /* if theres gonna be an error */
            {
               if (disk_moved == 1)
               {
                  output('\n');       /* put it on a new line */
                  output('\n');
               }                    /* if its bad BOOT, reset diskio flag */
               if (strcmp(error.func,"diskio") == 0)
                  diskio_error = 0;
            }
            break;

         /*  **** Misc. ****  */

         case 't':
            dprint(" number of this tag? ");
            if ((c=input()) < '0' || c > '9')
               break;
            output(c);
            if (c == '0')
            {
               for (i = 1; i < 10; i++)
                  if (tagged[i] != 0L)
                      break;
               if (i == 10)
               {
                  dprint(" no tagged sectors");
                  break;
               }
               if (getver(" clear all",0))
                  memset(tagged,0,sizeof(tagged));
               break;
            }
            tagged[c-'0'] = log_sector;
            break;
         case 'T':
            for (i = 1; i < 10; i++)
               if (tagged[i] != 0L)
                   break;
            if (i == 10)
            {
               dprint(" no tagged sectors");
               break;
            }
            dprint(" tagged sector list");
            for (i = 1; i < 10; i++)
            {
               if (!tagged[i])
                  continue;
               print(" %c:%lr",i+'0',tagged[i]);
            }
            break;

         /* Searching */

         case 'f':
         case '\\':
         case 'F'-'@':
            dprint(" find ");
            tempd = find(F_DISK,1,(c=='f') ? F_CASE : (c=='\\') ? F_NOCASE :
                                                                     F_OFFSET);
            if (tempd >= 0)
               print("\nfound at %r",tempd);
            if (tempd != ABORT)                 /* user pressed ESC */
               readsector();
            break;
         case 'F':
         case '\\'-'@':
            if (byte_cnt==0)
               break;
            dprint(" find ");
            if (find(F_BUFFER,1,(c=='F') ? F_CASE : F_NOCASE) == -1)
               print(" not found");
            break;

         /* File I/O */

         case 'P':
            put_sectors();
            break;
         case 'P'-'@':
         case 'p':
            put_file(c == 'p');
            break;
         case SHFTF7:
            put_file(2);         /* dump file buffer to disk file */
            break;
         case SHFTF8:
            put_file(3);         /* dump sector buffer to disk file */
            break;
         case 'I'-'@':
         case 'i':
            get_file(c == 'i');
            break;
         case 'I':
            insert_file(1);
            break;

         case 'w':
            if (bufchk)
               break;
            if (!write_to)
            {
               print(" must set \"write yes\" in the .INI file");
               break;
            }
            if (!Write)
            {
               print(" must turn on write allowance first (Alt-W)");
               break;
            }
            if (Display || Verify)
               print(" write sector");
            if (log_sector<dir_sector)
            {
               print("\a Warning! This is ");
               print((log_sector==0)?"the BOOT":"a FAT");
               print(" sector, ");
               if (!getver("write anyway",0))
                   break;
            }
            else if (Verify && !getver("",0))
               break;
            writesector();
            break;
         case '\'':           /* well.. it's near alt-slash */
         case ALTSL:
            dprint(" Keywords & Parameters");
            print("\n\n");
            displaykeys(kw);
            print("\n\n%-12.12s %s\n","Disk I/O",diskiofunc());
            break;
         case 'z':
         case 'Z':
            if (Display || c=='Z')
            {
               dprint(" parameters");
               dkey(kw);
               if (c=='z')
                   output('\n');
               else
                   break;
            }
            if (getstr(tmpstr,MAXSTR,_LOWER|_UPPER)>0)
               ckey(tmpstr,kw);
            break;
         case '0':case '1':case '2':case '3':
         case '4':case '5':case '6':case '7':
         case '8':case '9':
            c-=0x30;
            if (!tagged[c])
               break;
            if (Display || Verify)
               print(" goto sector %lr",tagged[c]);
            if (Verify && !getver("",0))
               break;
            if (log_sector != tagged[c])
            {
               log_sector = tagged[c];
               readsector();
               disk_moved = 1;
            }
            break;
#ifndef __GNUC__
         case 'D':
            debug();
            break;
#endif
         case 'm':
            if (!Files) break;
            tempu = sectortocluster(log_sector);
            if (clusters[tempu] && (unsigned)clusters[tempu] <= n_files)
            {
               dprint(" map file ");
               print(gfile(clusters[tempu]));
               output('\n');
               arraymap(clusters,num_clusters,clusters[tempu],Radix);
            }
            break;
         case 'M':
            if (!Files) break;
            dprint(" map free space");
            output('\n');
            if (arraymap(clusters,num_clusters,0,Radix) == 0)
               print(" no free space");
            break;

         case 'x':
            viewfile(ini_file,Display);
            break;

         case 'q':
         case '.':
         case ESC:
         case ALTX:
            if (c != ALTX && !verify(" exit DISKED"))
               break;
            _dos_setdrive(c_disk,&tempu);
            _chdir(cur_dir);
            if (files_indexed)            /* free calls are for an IDE */
            {                             /* such as QuickC that I use */
               hugefreep(files);          /* which can get confused if */
               hugefreep(clusters);       /* if you don't do this */
            }
            if (spare_sec)
               freep(spare_sec);
            if (save_sec)
               freep(save_sec);
            freep(sec_buf);
            freep(data_buf);
            output('\n');
            exit(0);
            break;
         default:
             break;
        }
    }
#ifdef ANSI_RETENTIVE
   return 0;
#endif
}

/* conditional print -- decreases EXE size */

static void dprint(char *s)
{
   if (Display) print(s);
}

static int verify(char *s)
{
   if (Display || Verify)
      print(s);
   if (Verify && !getver("",0))
      return 0;
   return 1;
}

void setdir(char *dirstr, char *curdir)
{
unsigned int u,tempu;

   if (_chdir(dirstr) == -1)
   {
      print(" tempdir \"%s\" not found ",dirstr);
      pause();
   }
   else if (dirstr[1]==':')
   {
      u = toupper(dirstr[0])-'@';
      _dos_setdrive(u,&tempu);
   }
   if (_getcwd(curdir,_MAX_DIR) == NULL)
      print(" %s",strerror(errno));
}
