/* DOS more command by dosius
 *
 * Provides stdin and filename support
 * like BSD more, if stdin is a console, reports error
 * Uses stdio (conio only to get device stats)
 * No fancy tricks, just simple coding
 *
 * This program is free software, and you are welcome to redistribute and/or
 * modify it under the terms of the GNU General Public License, version 2,
 * or (at your option) any later version, blah, blah, blah.  Who cares,
 * anyway.
 *
 * Switches: none.
 * Keys: Space scrolls full page.
 *       Enter scrolls one line.
 *       Q or q quits.
 *
 * Note:  Turbo C++ buffers the console (even if it is opened as a file).
 *        This behavior is undesired and a workaround is given.  It is called
 *        setvbuf()
 *
 * Copyright (C) 2000 Steve Nickolas, all rights reserved.
 */

#include <stdio.h>
#include <conio.h>  /* for gettextinfo() */
#include <io.h>     /* for isatty() */

int main(int argc, char** argv)
{
   FILE *altin;
   FILE *myfile;
   int nolin,curlin;
   struct text_info ti;
   char mylin[1024];
   char keypress;
   int travel;
   long my_lof;

/* Return an error if stdin is not redirected and no filename is specified. */

if (isatty(fileno(stdin))) if (argc==1)
	{
	fprintf (stderr,"usage: more [filename [...]]\n");
	return 1;
	}

/* If no filename is specified, use stdin. */

if (argc==1) {

/* If stdout is redirected, just do a 'cat' and copy stdin to stdout. */

if (!isatty(fileno(stdout)))
	{
	while (!feof(stdin)) putc(getc(stdin),stdout);
	return 0;
	}

/* Open the console for read.
   It cannot be buffered; this will just throw getch() out of kilter. */

   altin = fopen("con", "rb");
   if (setvbuf(altin, NULL, _IONBF, 0) != 0)
      {
      fprintf(stderr,"more: failed to set up console buffer\n");
      return -1;
      }

/* Get screen height.  This is used to determine how many lines can be shown
   before displaying the prompt. */

   gettextinfo(&ti);
   nolin=ti.screenheight;
   curlin=2;

/* Display the file. */

   while (!feof(stdin))
   {
	if (fgets(mylin,1024,stdin)){
	printf ("%s",mylin);
	curlin++;

     /* Show the prompt when at the end of a page. */

	if (curlin==nolin)
		{
		top:
			fflush(stdout);
                  /* Ensure that we are at the left.
                     Don't want to mess up the screen,
                     but don't want to overwrite anything either! */
			   gettextinfo(&ti);
			   if (ti.curx!=1) printf ("\n");
			printf ("-- More --");
			keypress=fgetc(altin);
			printf ("\r          \r");
			switch (keypress)
			{
			case 'Q': case 'q': return 0;
			case '\n':
			case 13:
			fgets(mylin,1024,stdin);
			printf ("%s",mylin);
			goto top;
               case ' ': curlin=1; break;
			default: goto top;
			}

		}}
   }
   /* Cleanup and exit */
   fclose(altin);
   return 0;
}

/* In this case, we handle each parameter individually. */

for (travel=1;travel<argc;travel++) {

/* Special-case more than one file.  After the first, we pause before each
   file, wait for a key. */

if (travel>1) {
   altin = fopen("con", "rb");
   if (setvbuf(altin, NULL, _IONBF, 0) != 0)
      {
      fprintf(stderr,"more: failed to set up console buffer\n");
      return -1;
      }
	printf ("-- Next --");
	keypress=fgetc(altin);
     fclose(altin);
	if (keypress=='q'||keypress=='Q') return 0;
	printf ("\r          \r");
	}

/* Open the file. */

if (!(myfile=fopen (argv[travel],"rt")))
	{
     fprintf (stderr,"more: cannot open "); perror(argv[travel]);
	break;
	}

/* Get the file length.  There is not function here, so fudge it. */

	       fseek(myfile,0,2);
	my_lof=ftell(myfile);
	       fseek(myfile,0,0);

/* If stdout is redirected, just do a 'cat' and copy the file to stdout. */

if (!isatty(fileno(stdout)))
	{
	while (!feof(myfile)) putc(getc(myfile),stdout);
	return 0;
	}

/* Open the console unbuffered.
   God, how many times must I do this? :-) */

   altin = fopen("con", "rb");
   if (setvbuf(altin, NULL, _IONBF, 0) != 0)
      {
      fprintf(stderr,"more: failed to set up console buffer\n");
      return -1;
      }

/* Get the screen height. */

   gettextinfo(&ti);
   nolin=ti.screenheight;
   curlin=2;

/* If there is more than one file, show headers for each one.
   Also, make sure they show on-screen! */

   if (argc>2) {printf ("-- %s --\n",argv[travel]); curlin+=2;}

/* Display the file. */

   while (!feof(myfile))
   {
	if (fgets(mylin,1024,myfile)){
	printf ("%s",mylin);
	curlin++;
	if (curlin==nolin)
		{
		top2:
			fflush(stdout);
			   gettextinfo(&ti);
			   if (ti.curx!=1) printf ("\n");

/* Special case:  Since we know the file size, we can show percent read.
   I know SunOS and ULTRIX more do this.  BSD more appears not to? */

			printf ("-- More (%%%d) --",(100*ftell(myfile))/my_lof);
			keypress=fgetc(altin);
			printf ("\r                 \r");
			switch (keypress)
			{
			case 'Q': case 'q': return 0;
			case '\n':
			case 13:
			fgets(mylin,1024,myfile);
			if (feof(myfile)) return 0;
			printf ("%s",mylin);
			goto top2;
               case ' ': curlin=1; break;
			default: goto top2;
			}

		}}
   }

/* Clean up. */

   fclose(myfile);
   fclose(altin);
}
return 0;
}

