/*
 * 360 - RAWRITE replacement
 * Files needed: 360.C
 * Compiler needed: Tested under Borland Turbo C++ v1.01
 *
 * This program is 'open software' and may be distributed commercially or
 * non-commercially, modified or unmodified, so long as this message remains
 * intact, and source code must be made available at no charge for all
 * modified versions.  See the GNU General Public License for more details.
 *
 * Syntax: 360 filename.ext d:
 *
 * Unlike rawrite, 360 does not check the disk type; it just writes from the
 * beginning of the file to the end of the file on the disk.  CAVEAT:  If you
 * use the wrong density disk you can do SERIOUS DAMAGE!  I have placed a
 * small degree of protection by forbidding raw writing to the hard disk --
 * which can be FATAL!
 *
 * Revision History: 2000.1002 dosius: Started program.
 *
 */

#include <ctype.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>

void main(int argc,char** argv)
{
FILE* file;
char sector[512];
long cursect;
int curbyte;

if (argc==2)
{
if (!strcmp(argv[1],"/?")) {
printf ("\
360 - Write raw images to disk.\n\
\n\
This program was designed to permit the writing of 360K disks from images,\n\
which could not be done with RAWRITE.  As long as you write to a disk of the\n\
right size (this program does not check) the output should be acceptable.\n\
I have tested it and it works rather well.\n\
\n\
This program is 'open software' and may be distributed commercially or\n\
non-commercially, modified or unmodified, so long as this message remains\n\
intact, and source code must be made available at no charge for all modified\n\
versions.  See the GNU General Public License for more details.\n\
\n\
Written by Dosius.  <<HACKWARE>> (C) 2000\n\
\n\
Syntax: 360 filename.ext d:\n\
\n\
d: may only be A: or B:  The rationale for this is that one may accidentally\n\
use this program on their hard drive and TOTALLY RUIN IT!  Needless to say,\n\
I wouldn't wish that fate on a dog.  By the way, the disk does NOT have to be\n\
360K; that is only what the program was designed for.\n\
");
return;
}
}
if (argc!=3) {fprintf (stderr,"360: Invalid number of parameters\n");return;}
if (argv[2][1]!=':' || strlen(argv[2])!=2 || toupper(*(argv[2]))>'B')
     /* You don't want to raw-write your hard drive, do you?
        Report an error for non-drive or drive past B. */
	     {fprintf (stderr,"360: Invalid drive specification\n");return;}
file=fopen(argv[1],"rb");
if (!file)   {fprintf (stderr,"360: Could not open file ");perror (argv[1]);
	      return;}
cursect=0;
printf ("\
360 - Write raw images to disk.\n\
\n\
This program was designed to permit the writing of 360K disks from images,\n\
which could not be done with RAWRITE.  As long as you write to a disk of the\n\
right size (this program does not check) the output should be acceptable.\n\
I have tested it and it works rather well.\n\
\n\
This program is 'open software' and may be distributed commercially or\n\
non-commercially, modified or unmodified, so long as this message remains\n\
intact, and source code must be made available at no charge for all modified\n\
versions.  See the GNU General Public License for more details.\n\
\n\
Written by Dosius.  <<HACKWARE>> (C) 2000\n\
");
while (!feof(file)) {
   for (curbyte=0;curbyte<512;curbyte++) sector[curbyte]=fgetc(file);
   printf ("\rSector: %d (each sector is 0.5KB)",cursect);
   if (abswrite(toupper(argv[2][0])-65,1,cursect,sector)) {
     fprintf (stderr,"\n360: Could not write to drive %c:",toupper(argv[2][0]));
     fclose(file);
     return;
   }
   cursect++;
}
fclose(file);}
