
	PAGE

;*** DO APEX LIKE DEVICE HANDLER DISPATCH ****
;DEVICE NUMBER IN NOWDEV, FUNCTION IN NOWFUN, BYTE PASSED IN AL

;DEFINE KHAND  FUNCTIONS, PUT FUNCTION IN NOWFUN BEFORE CALLING KHAND

INIFUN	EQU	0		;INITIALIZE INPUT FUNCTION
INOFUN	EQU	1		;INITIALIZE OUTPUT FUNCTION
INPFUN	EQU	2		;BYTE INPUT FUNCTION
OUTFUN	EQU	3		;BYTE OUTPUT FUNCTION
CLOFUN	EQU	4		;CLOSE OUTPUT FUNCTION
CLIFUN	EQU	5		;CLOSE INPUT FUNCTION
OIFFUN	EQU	6		;OPEN INPUT FILE FUNCTION
OOFFUN	EQU	7		;OPEN OUTPUT FILE  FUNCTION


KHAND	PROC	NEAR
	PUSH	DI			;SAVE INDEXES ACROSS DOS CALLS
	PUSH	SI
	MOV	BX,NOWDEV
	MOV	AH,BH			;PASS EXTENDED DEVICE NO. IN AH
	MOV	BH,0
	CMP	BL,8			;ILLEGAL DEVICE NUMBER?
	JA	KHAND0			;JUMP IF SO
	SHL	BX,1			;TIMES 2 FOR POINTER
	MOV	DI,DEVTAB[BX]

	MOV	BH,0
	MOV	BL,NOWFUN		;GET CURRENT FUNCTION
	SHL	BX,1			;TIMES 2 FOR POINTER

	CALL	[BX+DI]
	POP	SI			;RESTORE INDEXES
	POP	DI
	JC	KHAND0			;SKIP IF ERROR
	RET

KHAND0:	PUSH	AX			;SAVE BYTE
	MOV	AL,3			;I/O ERROR
	CALL	ERROR			;HANDLE ERROR
	POP	AX			;RESTORE BYTE
	RET
KHAND	ENDP
	PAGE

DSEG	SEGMENT WORD PUBLIC 'DATA'
NOWDEV	DW	0	;CURRENT DEVICE CHANNEL
NOWFUN	DB	0	;CURRENT FUNCTION

;TABLE OF DEVICE CHANNELS

DEVTAB	DW	CHAN0	;0 - BUFFERED CONSOLE
	DW	CHAN1	;1 - UNBUFFERED CONSOLE
	DW	CHAN2	;2 - PRINTER
	DW	CHAN3	;3 - DISK
	DW	CHAN4	;4 - SERIAL
	DW	CHAN5	;5 - FAST PRINTER
	DW	CHAN6	;6 - WINDOW CONSOLE
	DW	CHAN7	;7 - NULL DEVICE
	DW	CHAN8	;8 - PSEUDO DEVICE


;CHAN 0 FUNCTIONS, BUFFERED CONSOLE

CHAN0	DW	RESBUF	;INTIALIZE INPUT
	DW	DUMMIO	;INTIALIZE OUTPUT
	DW	BUFKEY	;INPUT BYTE
	DW	CONOUT	;OUTPUT BYTE
	DW	DUMMIO	;CLOSE OUTPUT
	DW	DUMMIO	;CLOSE INPUT


;CHAN 1 FUNCTIONS, UNBUFFERED CONSOLE

CHAN1	DW	RESKEY	;INTIALIZE INPUT
	DW	DUMMIO	;INTIALIZE OUTPUT
	DW	KEYIN	;INPUT BYTE
	DW	TVOUT	;OUTPUT BYTE
	DW	DUMMIO	;CLOSE OUTPUT
	DW	DUMMIO	;CLOSE INPUT


;CHAN 2 FUNCTIONS, PRINTER CHANNEL

CHAN2	DW	DUMMIO	;INTIALIZE INPUT
	DW	DUMMIO	;INTIALIZE OUTPUT
	DW	DUMMIO	;INPUT BYTE
	DW	PRNOUT	;OUTPUT BYTE
	DW	DUMMIO	;CLOSE OUTPUT
	DW	DUMMIO	;CLOSE INPUT
	PAGE

;CHAN 3 FUNCTIONS, DISK I/O

CHAN3	DW	DOPENI	;INTIALIZE INPUT
	DW	DOPENO	;INTIALIZE OUTPUT
	DW	DSKIN	;INPUT BYTE
	DW	DSKOUT	;OUTPUT BYTE
	DW	DCLOSO	;CLOSE OUTPUT
	DW	DUMMIO	;CLOSE INPUT


;CHAN 4 FUNCTIONS, SERIAL I/O

CHAN4	DW	DUMMIO	;INTIALIZE INPUT
	DW	DUMMIO	;INTIALIZE OUTPUT
	DW	SERIN	;INPUT BYTE
	DW	SEROUT	;OUTPUT BYTE
	DW	DUMMIO	;CLOSE OUTPUT
	DW	DUMMIO	;CLOSE INPUT


;CHAN 5 FAST BIOS PRINTER OUTPUT

CHAN5	DW	BPRNOP	;INTIALIZE INPUT
	DW	BPRNOP	;INTIALIZE OUTPUT
	DW	BPRNIN	;INPUT BYTE
	DW	BIOPRN	;OUTPUT BYTE
	DW	DUMMIO	;CLOSE OUTPUT
	DW	DUMMIO	;CLOSE INPUT


;CHAN 6 TEXT WINDOW CHANNEL

CHAN6	DW	DUMMIO	;INTIALIZE INPUT
	DW	RESWND	;INTIALIZE OUTPUT
	DW	WNDCHN	;INPUT BYTE
	DW	WNDOUT	;OUTPUT BYTE
	DW	DUMMIO	;CLOSE OUTPUT
	DW	DUMMIO	;CLOSE INPUT
	PAGE

;CHAN 7 FUNCTIONS, NULL DEVICE

CHAN7	DW	DUMMIO	;INTIALIZE INPUT
	DW	DUMMIO	;INTIALIZE OUTPUT
	DW	DUMMIO	;INPUT BYTE
	DW	DUMMIO	;OUTPUT BYTE
	DW	DUMMIO	;CLOSE OUTPUT
	DW	DUMMIO	;CLOSE INPUT


;CHAN 8 FUNCTIONS, PSEUDO DEVICE

CHAN8	DW	PSOPNI	;INTIALIZE INPUT
	DW	PSOPNO	;INTIALIZE OUTPUT
	DW	PSIN	;INPUT BYTE
	DW	PSOUT	;OUTPUT BYTE
	DW	DUMMIO	;CLOSE OUTPUT
	DW	DUMMIO	;CLOSE INPUT
DSEG	ENDS
