	PAGE

;FLOATING POINT OPCODE THAT USE 80387 COPROCESSOR
	.386
	.387
;TOS:=NOS + TOS

FADDDO	PROC	FAR
	MOV	BP,SP			;GET STACK FRAME
	FLD   QWORD PTR [BP+TOSOFF]	;LOAD TOS
	FADD  QWORD PTR [BP+RLNOS]	;OPERATE ON NOS
	FSTP QWORD PTR [BP+RLNOS]	;POP AND STORE
	FNSTSW	AX			;GET STATUS
	AND	AL,01CH			;TEST FOR ERRORS
	JZ	@F			;SKIP IF OK
	CALL	FLTERR			;HANDLE ERROR
@@:	RETF	8			;DROP TOS
FADDDO	ENDP

;TOS:=NOS - TOS

FSUBDO	PROC	FAR
	MOV	BP,SP			;GET STACK FRAME
	FLD   QWORD PTR [BP+RLNOS]	;LOAD NOS
	FSUB  QWORD PTR [BP+TOSOFF]	;OPERATE ON TOS
	FSTP QWORD PTR [BP+RLNOS]	;POP AND STORE
	FNSTSW	AX			;GET STATUS
	AND	AL,01CH			;TEST FOR ERRORS
	JZ	@F			;SKIP IF OK
	CALL	FLTERR			;HANDLE ERROR
@@:	RETF	8			;DROP TOS
FSUBDO	ENDP

	PAGE

;TOS:=NOS * TOS

FMULDO	PROC	FAR
	MOV	BP,SP			;GET STACK FRAME
	FLD   QWORD PTR [BP+TOSOFF]	;LOAD TOS
	FMUL  QWORD PTR [BP+RLNOS]	;OPERATE ON NOS
	FSTP QWORD PTR [BP+RLNOS]	;POP AND STORE
	FNSTSW	AX			;GET STATUS
	AND	AL,01CH			;TEST FOR ERRORS
	JZ	@F			;SKIP IF OK
	CALL	FLTERR			;HANDLE ERROR
@@:	RETF	8			;DROP TOS
FMULDO	ENDP


;TOS:=NOS / TOS

FDIVDO	PROC	FAR
	MOV	BP,SP			;GET STACK FRAME
	FLD   QWORD PTR [BP+RLNOS]	;LOAD NOS
	FDIV  QWORD PTR [BP+TOSOFF]	;OPERATE ON TOS
	FSTP QWORD PTR [BP+RLNOS]	;POP AND STORE
	FNSTSW	AX			;GET STATUS
	AND	AL,01CH			;TEST FOR ERRORS
	JZ	@F			;SKIP IF OK
	CALL	FLTERR			;HANDLE ERROR
@@:	RETF	8			;DROP TOS
FDIVDO	ENDP
	PAGE

;HANDLE FLOATING POINT ERRORS

FLTERR:	TEST	AX,1CH		;ANY ERRORS WE CARE ABOUT?
	JZ	FLEEXT		;SKIP IF NOT
	TEST 	AX,04H		;DIVIDE BY ZERO?
	JZ	FLEXT1		;SKIP IF NOT
	MOV	AL,DIVZER	;FLAG IT
	JMP SHORT FLEXT3

FLEXT1:	TEST	AX,08H		;OVERFLOW?
	JZ	FLEXT2		;SKIP IF NOT
	MOV	AL,FOVFL	;FLAG IT
	JMP SHORT FLEXT3

FLEXT2:	MOV	AL,FUNFL	;MUST BE UNDERFLOW
FLEXT3:	FNINIT			;CLEAR COPROCESSOR
	CALL	ERROR		;HANDLE THE ERROR
FLEEXT:	RET
	PAGE

;TOS:= NOS = TOS

FEQDO	PROC	FAR
	MOV	BP,SP			;GET STACK FRAME
	FLD	QWORD PTR [BP+RLNOS]	;LOAD TOS
	FCOMP	QWORD PTR [BP+TOSOFF]	;OPERATE ON NOS
	FNSTSW	AX			;GET COPROCESSOR STATUS
	SAHF				;MOVE STATUS TO CPU FLAG
	JE	TRUEF			;SKIP IF TRUE
	MOV	[BP+LSTWRD],WORD PTR FALVAL	;PUT FALSE VALUE UNDER EVERYTHING
	RET	14			;DROP ARGS
FEQDO	ENDP


;TOS:= NOS # TOS

FNEDO	PROC	FAR
	MOV	BP,SP			;GET STACK FRAME
	FLD	QWORD PTR [BP+RLNOS]	;LOAD TOS
	FCOMP	QWORD PTR [BP+TOSOFF]	;OPERATE ON NOS
	FNSTSW	AX			;GET COPROCESSOR STATUS
	SAHF				;MOVE STATUS TO CPU FLAG
	JNE	TRUEF			;SKIP IF TRUE
	MOV	[BP+LSTWRD],WORD PTR FALVAL	;PUT FALSE VALUE UNDER EVERYTHING
	RET	14			;DROP ARGS
FNEDO	ENDP


;TOS:= NOS >= TOS

FGEDO	PROC	FAR
	MOV	BP,SP			;GET STACK FRAME
	FLD	QWORD PTR [BP+RLNOS]	;LOAD TOS
	FCOMP	QWORD PTR [BP+TOSOFF]	;OPERATE ON NOS
	FNSTSW	AX			;GET COPROCESSOR STATUS
	SAHF				;MOVE STATUS TO CPU FLAG
	JAE	TRUEF			;SKIP IF TRUE
	MOV	[BP+LSTWRD],WORD PTR FALVAL	;PUT FALSE VALUE UNDER EVERYTHING
	RET	14			;DROP ARGS
FGEDO	ENDP

;PUT TRUE VALUE ONTO STACK

TRUEF:	MOV	[BP+LSTWRD],WORD PTR TRUVAL	;PUT TRUE VALUE UNDER EVERYTHING
	RETF	14			;DROP ARGS
	PAGE


;TOS:= NOS > TOS

FGTDO	PROC	FAR
	MOV	BP,SP			;GET STACK FRAME
	FLD	QWORD PTR [BP+RLNOS]	;LOAD TOS
	FCOMP	QWORD PTR [BP+TOSOFF]	;OPERATE ON NOS
	FNSTSW	AX			;GET COPROCESSOR STATUS
	SAHF				;MOVE STATUS TO CPU FLAG
	JA	TRUEF			;SKIP IF TRUE
	MOV	[BP+LSTWRD],WORD PTR FALVAL	;PUT FALSE VALUE UNDER EVERYTHING
	RET	14			;DROP ARGS
FGTDO	ENDP


;TOS:= NOS <= TOS

FLEDO	PROC	FAR
	MOV	BP,SP			;GET STACK FRAME
	FLD	QWORD PTR [BP+RLNOS]	;LOAD TOS
	FCOMP	QWORD PTR [BP+TOSOFF]	;OPERATE ON NOS
	FNSTSW	AX			;GET COPROCESSOR STATUS
	SAHF				;MOVE STATUS TO CPU FLAG
	JBE	TRUEF			;SKIP IF TRUE
	MOV	[BP+LSTWRD],WORD PTR FALVAL	;PUT FALSE VALUE UNDER EVERYTHING
	RET	14			;DROP ARGS
FLEDO	ENDP


;TOS:= NOS < TOS

FLTDO	PROC	FAR
	MOV	BP,SP			;GET STACK FRAME
	FLD	QWORD PTR [BP+RLNOS]	;LOAD TOS
	FCOMP	QWORD PTR [BP+TOSOFF]	;OPERATE ON NOS
	FNSTSW	AX			;GET COPROCESSOR STATUS
	SAHF				;MOVE STATUS TO CPU FLAG
	JB	TRUEF			;SKIP IF TRUE
	MOV	[BP+LSTWRD],WORD PTR FALVAL	;PUT FALSE VALUE UNDER EVERYTHING
	RET	14			;DROP ARGS
FLTDO	ENDP

	PAGE

;*********************************************************
;************ FLOATING POINT INTRINSICS ******************
;*********************************************************

;49
;REAL:=FLOAT(INTEGER)
;CONVERT THE INTEGER ON TOS TO A FLOATING POINT NUMBER
;(NOTE: THIS IS COMPILED AS AN REAL INTRINSIC
; WITH TOS ON STACK)

INTR49	LABEL	FAR
FLTFUN	PROC	FAR
	POP	DX		;SAVE RETURN ADDRESS
	POP	CX
	MOV	BP,SP		;GET STACK FRAME
	SUB	SP,6		;ADJUST STACK
	FILD WORD PTR [BP]	;GET TOS
	FSTP QWORD PTR [BP-6]	;CONVERT TO REAL AND STORE
	PUSH	CX		;REPLACE RETURN ADDRESS
	PUSH	DX
	RET
FLTFUN	ENDP

;50
;INTEGER:=FIX(REAL)
;CONVERT REAL ON TOS TO NEAREST INTEGER
;(NOTE: THIS IS COMPILED AS AN INTEGER INTRINSIC
; WITH TOS IN AX)

INTR50	LABEL	FAR
FIXFUN	PROC	FAR
	POP	DX		;SAVE RETURN ADDRESS
	POP	CX

	PUSH	AX		;RESTORE REAL ON STACK

	PUSH	CX		;RESTORE RETURN ADDRESS
	PUSH	DX
	MOV	BP,SP		;GET STACK FRAME
	FLD QWORD PTR [BP+TOSOFF]	;GET TOS
	FISTP WORD PTR [BP+TOSOFF]	;ROUND TO INTEGER AND STORE
	FSTSW	AX		;GET COPROCESSOR STATUS
	AND	AL,01DH		;TEST FOR ERRORS
	JZ	FIXFN1		;SKIP IF NO ERROR
	MOV	AL,INOVFL	;GET ERROR NUMBER
	CALL	FLEXT3		;HANDLE ERROR
FIXFN1:	MOV	AX,[BP+TOSOFF]	;PUT RESULT IN TOS
	RET	8		;DROP ARGS
FIXFUN	ENDP
	PAGE

;*********************************************
;****** TRANSCENDENTAL INTRINSICS ************
;*********************************************


;53
;TOS:=SQRT(TOS)

INTR53	LABEL	FAR
FLSQRT	PROC	FAR
	MOV	BP,SP			;GET STACK FRAME
	FLD QWORD PTR [BP+TOSOFF]	;GET TOS
	FSQRT				;DO SQRT
	FSTP QWORD PTR [BP+TOSOFF]	;STORE RESULT
	FSTSW	AX			;GET COPROCESSOR STATUS
	AND	AL,01DH		;TEST FOR ERRORS
	JZ	FLSQT1		;SKIP IF NO ERRORS
	MOV	AL,SQRERR	;FLAG THE ERROR
	CALL	FLEXT3		;HANDLE THE ERROR
FLSQT1:	RET
FLSQRT	ENDP



;54
;TOS:=LN(TOS)

INTR54	LABEL	FAR
FLLN	PROC	FAR
	FLDLN2			;GET LN(2)
	MOV	BP,SP		;GET STACK FRAME
	FLD QWORD PTR [BP+TOSOFF]	;GET TOS
	FYL2X			;DO LN(X)
	FSTP QWORD PTR [BP+TOSOFF]	;STORE RESULT	
	FSTSW	AX		;GET THE STATUS
	AND	AL,01DH		;ERRORS?
	JZ	FLLN1		;SKIP IF NO ERRORS
	MOV	AL,LNERR	;FLAG THE ERROR
	CALL	FLEXT3		;HANDLE THE ERROR
FLLN1:	RET
FLLN	ENDP
	PAGE


;55
;TOS:=EXP(TOS)
;BY USING: e^X = 2 ^ Z Where Z = (X * LOG2(e))
;CONVERT Z TO: INTEGER + FRACTION
;THEN: 2^(FRACTION) AND ADD INTEGER TO EXPONENT

INTR55	LABEL	FAR
FLEXP	PROC	FAR
	MOV	BP,SP		;GET STACK FRAME
	FLD QWORD PTR [BP+TOSOFF]	;GET TOS
	FLDL2E			;X * LOG2(e)
	FMULP	ST(1),ST
	FST	ST(1)		;DUPLICATE TOS INTO NOS
	FRNDINT			;ROUND TO INTEGER
	FSUB	ST(1),ST	;ST(1) := FRACTION(ST(1))
	FXCH			;PUT FRACTION IN ST
	F2XM1			;2 ^ X - 1
	FLD1			;LOAD 1.0
	FADDP	ST(1),ST	;PLUS 1.0
	FSCALE			;ADD IN EXPONENT
	FSTP QWORD PTR [BP+TOSOFF]	;STORE RESULT
	FSTSW	AX		;GET THE STATUS
	AND	AL,01CH		;ERRORS?
	JZ	FLEXP1		;SKIP IF NO ERRORS
	MOV	AL,EXPERR	;FLAG THE ERROR
	CALL	FLEXT3		;HANDLE THE ERROR
FLEXP1:	RET
FLEXP	ENDP

	PAGE



;56
;TOS:=SIN(TOS)

INTR56	LABEL	FAR
FLSIN	PROC	FAR
	MOV	BP,SP				;GET STACK FRAME
	FLD QWORD PTR [BP+TOSOFF]		;GET TOS
	TEST WORD PTR [BP+TOSOFF+6],08000H	;TEST SIGN TOS (CONCURRENT C/COPROCESSOR)
	FABS					;GET ABSOLUTE VALUE
	FSIN					;TAKE THE SINE
	FSTP QWORD PTR [BP+TOSOFF]		;STORE RESULT
	FSTSW	AX				;GET THE STATUS
	JZ	FLSIN1				;SKIP IF OLD TOS WAS POSITIVE
	XOR WORD PTR [BP+TOSOFF+6],08000H	;COMPLIMENT SINE
FLSIN1:	AND	AL,01CH				;ERRORS?
	JZ	FLSIN2				;EXIT IF NOT
SINERR:	MOV	AL,FOVFL			;MUST BE OVERFLOW ERROR
	CALL	FLEXT3				;HANDLE ERROR
FLSIN2:	RET
FLSIN	ENDP


;57
;TOS:=ATAN(NOS/TOS)

INTR57	LABEL	FAR
FLAT2	PROC	FAR
	MOV	BP,SP		;GET STACK FRAME
	FLD QWORD PTR [BP+RLNOS]	;GET NOS
	FLD QWORD PTR [BP+TOSOFF]	;GET TOS
	FPATAN			;DO ATAN2
	FXAM			;LOOK AT THE NUMBER TYPE
	FSTSW	AX		;GET THE STATUS
	FSTP QWORD PTR [BP+RLNOS]	;SAVE RESULT
	AND	AH,01H		;RESULT= SPECIAL?
	JZ	FLAT3		;SKIP IF NO ERRORS
	MOV	AL,AT2ERR	;FLAG THE ERROR
	CALL	FLEXT3		;HANDLE THE ERROR
FLAT3:	RET	8
FLAT2	ENDP
	PAGE

;58
;TOS:=NOS MOD TOS

INTR58	LABEL	FAR
FLMOD	PROC	FAR
	MOV	BP,SP		;GET STACK FRAME
	FLD QWORD PTR [BP+TOSOFF]	;GET TOS
	FLD QWORD PTR [BP+RLNOS]	;NOS
REMLOP:	FPREM			;DO PARTIAL REMAINDER
	FSTSW	AX		;GET THE STATUS
	SAHF			;PUT INTO CPU FLAGS
	JP	REMLOP		;LOOP UNTIL RESULT IS IN RANGE
	FSTP QWORD PTR [BP+RLNOS]	;STORE RESULT
	FSTP	ST		;CLEAN COPROCESSOR STACK
	RET	8		;DROP TOS
FLMOD	ENDP


;59
;TOS:=LOG(TOS)

INTR59	LABEL	FAR
FLLOG	PROC	FAR
	FLDLG2			;GET LOG(2)
	MOV	BP,SP		;GET STACK FRAME
	FLD QWORD PTR [BP+TOSOFF]	;GET TOS
	FYL2X			;DO LOG(X)
	FSTP QWORD PTR [BP+TOSOFF]	;STORE RESULT	
	FSTSW	AX		;GET THE STATUS
	AND	AL,01DH		;ERRORS?
	JZ	FLLOG1		;SKIP IF NO ERRORS
	MOV	AL,LNERR	;FLAG THE ERROR
	CALL	FLEXT3		;HANDLE THE ERROR
FLLOG1:	RET
FLLOG	ENDP

	PAGE

;60
;TOS:=COS(TOS)

INTR60	LABEL	FAR
FLCOS	PROC	FAR
	MOV	BP,SP			;GET STACK FRAME
	AND WORD PTR [BP+10],07FFFH	;FORCE TOS POSITIVE
	FLD QWORD PTR [BP+TOSOFF]		;GET TOS
	FCOS				;TAKE THE COSINE
	FSTP QWORD PTR [BP+TOSOFF]		;STORE RESULT
	FSTSW	AX			;GET THE STATUS
	AND	AL,01CH			;ERRORS?
	JNZ	SINERR			;EXIT IF SO
	RET
FLCOS	ENDP


;61
;TOS:=TAN(TOS)

INTR61	LABEL	FAR
FLTAN	PROC	FAR
	MOV	BP,SP			;GET STACK FRAME
	FLD QWORD PTR [BP+TOSOFF]		;GET TOS
	TEST WORD PTR [BP+10],08000H	;TEST SIGN TOS (CONCURRENT C/COPROCESSOR)
	FABS				;GET ABSOLUTE VALUE
	FPTAN				;TAKE THE TANGENT
	FSTP	ST			;DROP TOS
	FSTP QWORD PTR [BP+TOSOFF]		;STORE RESULT
	FSTSW	AX			;GET THE STATUS
	JZ	FLTAN1			;SKIP IF OLD WAS POSITIVE
	XOR WORD PTR [BP+10],08000H	;COMPLIMENT SINE
FLTAN1:	AND	AL,01CH			;ERRORS?
	JNZ	SINERR			;EXIT IF SO
	RET
FLTAN	ENDP

	PAGE

;62
;TOS:=ASIN(TOS)
;BY DOING: ATAN(X/SQRT(1-X^2))


INTR62	LABEL	FAR
FLASIN	PROC	FAR
	MOV	BP,SP		;GET STACK FRAME
	FLD QWORD PTR [BP+TOSOFF]	;GET TOS
	FST	ST(1)		;DUPLICATE TOS
	FMUL QWORD PTR [BP+TOSOFF]	;X ^ 2
	FLD1			;GET 1.0
	FSUBRP	ST(1),ST	;1 - X ^ 2
	FSQRT			;SQRT(1-X^2)
	FPATAN			;TAKE ATAN2
	FSTP QWORD PTR [BP+TOSOFF]	;STORE RESULT
	FSTSW	AX		;GET THE STATUS
	AND	AL,01CH		;ERRORS?
	JNZ	SINERR		;EXIT IF SO
	RET
FLASIN	ENDP


;63
;TOS:=ACOS(TOS)
;BY DOING: -ASIN(X) + PI/2

DSEG	SEGMENT WORD PUBLIC 'DATA'
CON2	DQ	2.0		;CONSTANT 2.0
DSEG	ENDS

INTR63	LABEL	FAR
FLACOS	PROC	FAR
	MOV	BP,SP		;GET STACK FRAME
	FLD QWORD PTR [BP+TOSOFF]	;GET TOS
	FST	ST(1)		;DUPLICATE TOS
	FMUL QWORD PTR [BP+TOSOFF]	;X ^ 2
	FLD1			;GET 1.0
	FSUBRP	ST(1),ST	;1 - X ^ 2
	FSQRT			;SQRT(1-X^2)
	FPATAN			;TAKE ATAN2
	FCHS			;COMPLIMENT SIGN
	FLD	CON2		;LOAD 2.0
	FLDPI			;GET PI
	FDIVRP	ST(1),ST	;MAKE .5 * PI
	FADDP	ST(1),ST	;ADD IN
	FSTP QWORD PTR [BP+TOSOFF]	;STORE RESULT
	FSTSW	AX		;GET THE STATUS
	AND	AL,01CH		;ERRORS?
	JNZ	SINERR		;EXIT IF SO
	RET
FLACOS	ENDP

	PAGE

;!! THESE ROUTINES MUST BE ASSEMBLED IN 8086 MODE OR THE ASSEMBLER
;WILL USE 386 JUMP INSTRUCTIONS AND THE CODE WON'T RUN ON AN 8086 !!

	.8087			
	.8086


;ROUTINES TO TEST FOR AND SETUP COPROCESSOR

DSEG	SEGMENT WORD PUBLIC 'DATA'
FPTEMP	DW	?		;TEMPORARY

MES387	DB	"!! 387 COPROCESSOR NOT FOUND !!",CR,LF
	DB	"!!   PROGRAM CANNOT BE RUN   !!",CR,LF,TSP
DSEG	ENDS

TST387:	FNINIT			;INITIALIZE USING NON-WAIT FORM
	MOV	SI,OFFSET FPTEMP;POINT TO TEMPORARY
	MOV WORD PTR [SI],5A5AH	;SET TEMP TO NON ZERO VALUE
	FNSTSW	[SI]		;GET PROCESSOR STATUS (NON-WAIT)
	CMP BYTE PTR [SI],0	;STATUS ZERO IF COPROCESSOR PRESENT
	JNE	NO387		;EXIT IF NO COPROCESSOR

;CAN WE ACCESS THE CONTROL REGISTER?

	FNSTCW	[SI]		;GET CONTROL WORD
	MOV	AX,[SI]
	AND	AX,103FH	;TEST SELECTED BITS
	CMP	AX,3FH		;CHECK THAT ONES AND ZEROS CORRECT
	JNE	NO387		;EXIT IF NO COPROCESSOR


;NO CHECK FOR 87 VS 287 VS 387

	FLD1			;FORM INFINITY (ONE DIVIDED BY ZERO)
	FLDZ
	FDIV
	FLD	ST		;DUPLICATE TOS
	FCHS			;MAKE TOS NEGATIVE INFINITY
	FCOMPP			;POS AND NEG INFINITY NOT EQUAL ON 387
	FSTSW	[SI]		;GET STATUS IN CPU FLAGS
	MOV	AX,[SI]
	SAHF
	JE	NO387		;EXIT IF 87 OR 287

;HERE IF 387

	FINIT			;REINITIALIZE
	RET

;HERE IF NO 387 IS PRESENT

NO387:	MOV	NOWDEV,0	;DISPLAY ERROR MESSAGE
	LEA	SI,MES387
	CALL	TXTLOP
	JMP	NATEXT		;EXIT OPERATING SYSTEM
