	PAGE
;*** ROUTINES TO DO HANDLE MS-DOS DISK IO *****

;FILE PARAMETERS

INHAND	DW	0		;INPUT FILE HANDLE
INBFLG	DB	"i"		;INPUT BUFFER FLAG
DINEOF	DB	0		;EOF SEEN ON BUFFERED INPUT
DINBYT	DB	0		;INPUT BYTE

OTHAND	DW	0		;OUTPUT FILE HANDLE
OTBFLG	DB	"o"		;OUTPUT BUFFER FLAG
DOTBYT	DB	0		;OUTPUT BYTE

;BUFFER FILE I/O DATA

DOTSIZ	EQU	512		;DEFINE BUFFER SIZE

DOTBUF	DB	DOTSIZ DUP(?)	;OUTPUT BUFFER
DOTEND	DW	DOTSIZ		;POINT TO END
DOTPTR	DW	0		;WORKING POINTER

DINSIZ	EQU	512		;DEFINE BUFFER SIZE

DINBUF	DB	DINSIZ DUP(?)	;INPUT BUFFER
DINEND	DW	DINSIZ		;POINT TO END
DINPTR	DW	DINSIZ		;WORKING POINTER
INPEOF	DB	0		;FLAG EOF SEEN
	PAGE

;READ A CHARACTER FROM THE DISK INPUT FILE

DSKIN	PROC	NEAR
	CMP	INBFLG,"I"		;UPPER CASE 'I'?
	JE	BUFDIN			;THEN DO BUFFERED INPUT
	MOV	AH,3FH			;SET READ FILE FUNCTION
	MOV	BX,INHAND		;GET INPUT 'HANDLE'
	MOV	CX,1			;SET READ SIZE
	MOV	DX,OFFSET DINBYT	;POINT INPUT BYTE
	CALL	DOSCAL			;DO THE READ
	JC	DSKER1			;HANDLE ERROR
	CMP	AX,0			;END OF FILE?
	JNE	DSKIN1			;SKIP IF NOT
	CMP	DINBYT,1AH		;EOF CHAR SEEN YET?
	JNE	DSKIN2			;SKIP IF NOT

	MOV	AL,DINBYT		;RETURN SOMETHING
	STC				;FLAG ERROR
	RET

DSKIN2:	MOV	DINBYT,1AH		;RETURN EOF CHAR
DSKIN1:	MOV	AL,DINBYT		;GET BYTE
	CLC
	RET

DSKER1:	JMP SHORT DSKERR		;CONNECT TO ERROR ROUTINE

DSKIN	ENDP
	PAGE

;WRITE A CHARACTER TO THE OUTPUT FILE

DSKOUT	PROC	NEAR
	CMP	OTBFLG,"O"		;UPPER CASE 'O'
	JE	BUFDOT			;THEN DO BUFFERED OUTPUT
	MOV	AH,40H			;SET WRITE FUNCTION
	MOV	BX,OTHAND		;GET OUTPUT 'HANDLE'
	MOV	CX,1			;SET WRITE SIZE
	MOV	DX,OFFSET DOTBYT	;POINT OUTPUT BYTE
	MOV	DOTBYT,AL		;PUT BYTE INTO BUFFER
	CALL	DOSCAL			;DO THE WRITE
	JC	DSKERR			;JUMP IF ERROR
	CMP	AX,0			;DISK FULL?
	JE	DSKERR			;JUMP IF SO
	RET

DSKERR:	CALL	DOSKER			;HANDLE ERROR
	RET
DSKOUT	ENDP
	PAGE

;** BUFFERED DISK FILE INPUT ***

;RESET INPUT BUFFER POINTER

RESDIB:	MOV	BX,DINSIZ
	MOV	DINPTR,BX
	MOV	DINEND,BX
	CLC
	RET

;DO BUFFERED FILE INPUT

BUFDIN:	MOV	BX,DINPTR	;GET POINTER
	CMP	BX,DINEND	;TEST EMPTY
	JE	DINNEW		;SKIP IF EMPTY

;GET A BYTE FROM BUFFER

DINBF1:	MOV	AL,DINBUF[BX]
	INC	DINPTR
	CLC
	RET

;GET A NEW BUFFER

DINNEW:	MOV	AH,3FH		;READ DOS FILE
	MOV	BX,INHAND	;POINT TO HANDLE
	MOV	CX,DINSIZ	;SET READ SIZE
	LEA	DX,DINBUF	;POINT TO START OF BUFFER
	CALL	DOSCAL		;DOS CALL
	JC	DSKER2		;HANDLE ERROR
	OR	AX,AX		;END OF FILE?
	JNZ	DINNW1		;SKIP IF NOT
	MOV	AL,1AH		;RETURN EOF
	CMP	DINEOF,AL	;ALREADY SEEN EOF?
	JE	DINNW2		;SKIP IF SO
	MOV	DINEOF,AL	;FLAG END OF FILE
	CLC			;FLAG NO ERROR
	RET
DINNW2:	STC			;FLAG ERROR
	RET

DINNW1:	MOV	DINEND,AX	;GET NUMBER READ
	MOV	BX,0		;RESTART POINTER
	MOV	DINEOF,BL	;FLAG NO EOF
	MOV	DINPTR,BX
	JMP	DINBF1

DSKER2:	JMP	DSKERR		;CONNECT TO ERROR ROUTINE
	PAGE

;** BUFFERED DISK FILE OUTPUT ***

;DO BUFFERED FILE OUTPUT

BUFDOT:	MOV	BX,DOTPTR	;GET POINTER
	MOV	DOTBUF[BX],AL	;STORE IN BUFFER
	INC	BX		;BUFFER FULL
	CMP	BX,DOTEND	;TEST FULL
	JE	FLUSH1		;FLUSH IF FULL
	MOV	DOTPTR,BX	;UPDATE POINTER
	CLC
	RET

;FLUSH THE FILE BUFFER

FLUSH:	MOV	BX,DOTPTR	;GET POINTER
FLUSH1:	MOV	AH,40H		;WRITE DOS FILE
	MOV	CX,BX		;SET WRITE SIZE
	MOV	BX,OTHAND	;POINT TO HANDLE
	LEA	DX,DOTBUF	;POINT TO START OF BUFFER
	CALL	DOSCAL		;DOS CALL
	JC	DSKER2		;HANDLE ERROR
	OR	AX,AX		;DISK FULL?
	JNZ	RESDOB		;SKIP IF NOT
	JMP	DSKERR		;HANDLE THE ERROR

;RESET OUTPUT POINTER

RESDOB:	MOV	DOTPTR,0	;RESET POINTER
	CLC			;FLAG NO ERROR
	RET
	PAGE

;FILE OPEN INTRINSIC

FOPEN	PROC	NEAR
	POP	AX			;GET OPENING MODE
	POP	DX			;GET ADDRESS OF FILE NAME
	PUSH	AX			;SAVE OPENING MODE
	CALL	PARNAM			;PARSE FILE NAME
	POP	AX			;RESTORE MODE
	CMP	AX,0			;READ MODE?
	JE	OPIDSK			;THEN DO IT
	CMP	AX,1			;WRITE MODE?
	JE	OPODSK			;THEN DO IT
	JMP	CMLRET			;ELSE RETURN

;OPEN DISK INPUT FILE

OPIDSK:	MOV	AH,3DH			;OPEN FILE FUNCTION
	MOV	AL,0H			;SET READ MODE
	JMP SHORT OPODK3		;ENTER COMMON CODE

;OPEN DISK FILE FOR OUTPUT

OPODSK:	MOV	AH,3CH			;OPEN FILE FUNCTION
	MOV	CX,0			;SET NORMAL MODE
OPODK3:	LEA	DX,WRKNAM		;POINT TO FILE NAME
	CALL	DOSCAL			;CALL DOS ROUTINE
	JNC	OPODK1			;SKIP NO ERROR
	CALL	DOSIER			;HANDLE I/O ERROR
	MOV	AX,0FFFFH		;CREATE BAD HANDLE
OPODK1:	PUSH	AX			;RETURN FILE 'HANDLE'
	JMP	CMLRET
FOPEN	ENDP
	PAGE

;SET WORKING HANDLE INTRINSIC

FSET	PROC	NEAR
	POP	AX			;GET MODE
	POP	BX			;GET HANDLE
	CMP	AL,"I"			;INPUT HANDLE?
	JE	FSETIN			;SKIP IF SO
	CMP	AL,"O"			;OUTPUT HANDLE?
	JE	FSETOT			;SKIP IF SO
	CMP	AL,"i"			;LOWER CASE?
	JE	FSETIN
	CMP	AL,"o"
	JE	FSETOT
	JMP	CMLRET			;RETURN

FSETIN:	MOV	INHAND,BX		;SET IN HANDLE
	MOV	INBFLG,AL		;SET BUFFER TYPE
	JMP	CMLRET

FSETOT:	MOV	OTHAND,BX		;SET OUTHANDLE
	MOV	OTBFLG,AL		;SET BUFFER TYPE
	JMP	CMLRET
FSET	ENDP


;CLOSE DISK FILE BY HANDLE

FCLOSE	PROC	NEAR
	POP	BX			;GET HANDLE
	CALL	CLFDSK			;ENTER COMMON CODE
	JMP	CMLRET			;RETURN
FCLOSE	ENDP
	PAGE

;OPEN INPUT FILE BY CHANNEL

DOPENI:	CMP	INBFLG,"I"	;BUFFERED INPUT?
	JNE	DOPNI1		;SKIP IF NOT
	CALL	RESDIB		;ZERO INPUT BUFFER
DOPNI1:	MOV	BX,INHAND	;GET HANDLE
REWIND:	MOV	AH,42H		;MOVE FILE POINTER FUNCTION
	MOV	AL,0		;USE ABSOLUTE METHOD
	MOV	CX,0		;POINT TO START OF FILE
	MOV	DX,0
	INT	21H		;DO IT
	MOV	DINBYT,0	;MAKE SURE INPUT BYTE IS NOT AN EOF
DOPNI2:	CLC			;IGNORE ERRORS
	RET

;OPEN OUTPUT FILE BY CHANNEL

DOPENO:	MOV	BX,OTHAND	;REWIND OUTPUT FILE
	CALL	REWIND
	CMP	OTBFLG,"O"	;BUFFERED OUTPUT?
	JNE	DOPNI2		;SKIP IF NOT
	CALL	RESDOB		;ZERO OUTPUT BUFFER
	CLC			;NO ERRORS
	RET


;CLOSE OUTPUT FILE BY CHANNEL

DCLOSO:	CMP	OTBFLG,"O"	;BUFFERED OUTPUT?
	JNE	DOPNI2		;SKIP IF NOT
	CALL	FLUSH		;OUTPUT BUFFER
	CLC
	RET

	PAGE


;PARSE AND COPY A FILE NAME STRING INTO 'WRKNAM'
;LEADING SPACES REMOVED, TERMINATOR CAN BE COMMA, RETURN OR ZERO
; SOURCE POINTED TO BY DX

NAMLEN	EQU	80		;MAXIMUM STRING LENGTH
WRKNAM	DB	NAMLEN-1 DUP(?)	;WORKING FILE NAME
	DB	0		;ZERO JUST INCASE


PARNAM	PROC	NEAR
	PUSH	DI		;SAVE PC
	CLD			;SET COPY DIRECTION
	MOV	SI,DX		;POINT TO SOURCE
	LEA	DI,WRKNAM	;POINT TO DESTINATION
	MOV	CX,NAMLEN-2	;NUMBER TO COPY

;EAT LEADING SPACES

EATSPA:	LODSB			;GET A CHAR
	CMP	AL,20H		;SPACE?
	JNE	NOTSPA		;EXIT IF NOT
	LOOP	EATSPA		;LOOP
	JMP SHORT PARST3	;NOTHING BUT SPACES?

PARST1:	LODSB			;GET NEXT CHAR
NOTSPA:	CMP	AL,0		;ZERO TERMINATOR?
	JE	PARST3
	CMP	AL,CR		;RETURN?
	JE	PARST3
	CMP	AL,","		;COMMA?
	JE	PARST3
	TEST	AL,80H		;HIGH BIT SET?
	JNZ	PARST2
	STOSB			;STORE BYTE
	LOOP	PARST1		;LOOP

PARST2:	AND	AL,7FH		;STRIP HIGH BIT
	STOSB			;STORE LAST CHAR
PARST3:	MOV	[DI], BYTE PTR 0;ZERO LAST CHAR
	POP	DI		;RETORE PC
	RET
PARNAM	ENDP
	PAGE
	PAGE


;GENERAL CLOSE FILE ROUTINE, ENTER WITH HANDLE IN BX

CLFDSK	PROC	NEAR
	MOV	AH,3EH			;CLOSE FILE FUNCTION
	CALL	DOSCAL			;CALL DOS ROUTINE
	JNC	CLFDK1			;SKIP NO ERROR
	CALL	DOSIER			;HANDLE I/O ERROR
CLFDK1:	RET
CLFDSK	ENDP
	PAGE
	PAGE


;# 31 READ(DRIVE,SECTOR,MEMORY,SIZE)
;INTRINSIC TO DO ABSOLUTE DISK READ

DUMMY	DW	0			;TO HANDLE DOS 3.3 BUG

FREAD	PROC	NEAR
	POP	CX			;GET NUMBER OF SECTORS
	POP	BX			;GET MEMORY BUFFER
	POP	DX			;STARTING SECTOR
	POP	AX			;GET DRIVE NUMBER
	PUSH	DI			;SAVE INDEXES
	PUSH	SI
	PUSH	ES
	CALL	SETPAC			;SET DOS 4.0 INFO PACKET
	MOV BYTE PTR DOSINT,25H		;SAVE INTERRUPT #
	INT	25H			;DO THE READ
	POP	ES			;FIX DOS PROBLEM!
	POP	ES
	POP	SI			;RESTORE INDEXES
	POP	DI
	JNC	FREAD1			;SKIP NO ERROR
	CMP	AX,0207H		;DOS 4.0 TYPE ERROR?
	JNE	FREAD2			;SKIP IF NOT

;TRY FOR DOS 4.0 TYPE OPERATION

	MOV	AL,DRIVE		;GET DRIVE NUMBER
	MOV	BX,OFFSET PACKET	;SET CONTROL PACKET
	MOV	CX,0FFFFH		;FLAG LARGE PARTITION MODE
	MOV	DX,0FFFFH		;FORCE ERROR IF DOS < 4.0
	PUSH	DI			;SAVE INDEXES
	PUSH	SI
	INT	25H			;DO THE READ
	POP	SI			;FIX DOS PROBLEM!
	POP	SI			;RESTORE INDEXES
	POP	DI
	JNC	FREAD1			;EXIT IF NO ERROR
FREAD2:	CALL	DOSIER			;HANDLE ERROR
FREAD1:	JMP	CMLRET			;RETURN
FREAD	ENDP


;# 30 READ(DRIVE,SECTOR,MEMORY,SIZE)
;INTRINSIC TO DO ABSOLUTE DISK WRITE

FWRITE	PROC	NEAR
	POP	CX			;GET NUMBER OF SECTORS
	POP	BX			;GET MEMORY BUFFER
	POP	DX			;STARTING SECTOR
	POP	AX			;GET DRIVE NUMBER
	PUSH	DI			;SAVE INDEXES
	PUSH	SI
	PUSH	ES
	CALL	SETPAC			;SET DOS 4.0 INFO PACKET
	MOV BYTE PTR DOSINT,26H		;SAVE INTERRUPT #
	INT	26H			;DO THE WRITE
	POP	ES			;FIX DOS PROBLEM!
	POP	ES
	POP	SI			;RESTORE INDEXES
	POP	DI
	JNC	FWRIT1			;SKIP NO ERROR
	CMP	AX,0207H		;DOS 4.0 TYPE ERROR?
	JNE	FWRIT2			;SKIP IF NOT

;TRY FOR DOS 4.0 TYPE OPERATION

	MOV	AL,DRIVE		;GET DRIVE NUMBER
	MOV	BX,OFFSET PACKET	;SET CONTROL PACKET
	MOV	CX,0FFFFH		;FLAG LARGE PARTITION MODE
	MOV	DX,0FFFFH		;FORCE ERROR IF DOS < 4.0
	PUSH	DI			;SAVE INDEXES
	PUSH	SI
	INT	26H			;DO THE WRITE
	POP	SI			;FIX DOS PROBLEM!
	POP	SI			;RESTORE INDEXES
	POP	DI
	JNC	FWRIT1			;EXIT IF NO ERROR
FWRIT2:	CALL	DOSIER			;HANDLE ERROR
FWRIT1:	JMP	CMLRET			;RETURN
FWRITE	ENDP



;SET THE INFO PACKAGE REQUIRED BY DOS 4.0 OR BETTER

SETPAC:	PUSH	AX			;SAVE AX
	MOV	DRIVE,AL		;SAVE DRIVE NUMBER
	MOV	LOGSEC,DX		;SET LOGICAL SECTOR NUMBER
	MOV WORD PTR LOGSEC+2,0
	MOV	RWNUMB,CX		;SET NUMBER TO MOVE
	MOV	AX,DS			;SET ADDRESS OF THE BUFFER
	MOV	BUFADD+2,AX
	MOV	BUFADD,BX
	MOV	BP,OFFSET DUMMY-01EH	;FIX DOS 3.3 BUG
	MOV	ES,AX
	POP	AX			;RESTORE AX
	RET


DRIVE	DB	?			;TEMPORARY FOR DRIVE NUMBER

;INFORMATION PACKET USED BY INTERRUPT 25H AND 26H IN DOS 4.0

PACKET	LABEL	WORD
LOGSEC	DW	?		;LOGICAL SECTOR OF THE OPERATION
	DW	?
RWNUMB	DW	?		;NUMBER OF BYTES TO READ OR WRITE
BUFADD	DW	?		;ADDRESS OF THE BUFFER
	DW	?

	PAGE

;ROUTINE TO CALL DOS FUNCTION, SAVING FUNCTION NUMBER FOR ERROR HANDLING

DOSCAL:	MOV BYTE PTR DOSINT,21H		;SET CURRENT INTERRUPT
	MOV	DOSFUN,AH		;GET FUNCTION NUMBER
	INT	21H			;CALL FUNCTION
	RET


;HANDLE I/O ERRORS, NOT CALLED THROUGH KHAND

DOSIER:	CALL	DOSKER			;SAVE ERROR CODES
	MOV	AL,3			;SIGNAL I/O ERROR
	JMP	ERROR			;HANDLE ERROR


;HANDLE DOS ERRORS WHEN CALLED THROUGH KHAND

DOSKER:	MOV	DOSRET,AX		;SAVE ERROR CODE
	STC				;MAKE SURE CARRY IS SET
	RET


;DO DOS OUTPUT TO THE PRINTER

PRNOUT:	MOV	DL,AL		;GET OUTPUT CHAR
	MOV	AH,5		;SET THE FUNCTION
	INT	21H		;DO IT
	CLC
	RET


;DO BIOS OUTPUT TO THE PRINTER (IT'S FIVE TIMES FASTER)

BIOPRN:	MOV	DL,AH		;GET EXTENDED DEVICE NUMBER
	MOV	DH,0
	MOV	AH,0		;SELECT BIOS PRINTER OUT FUNCTION
	INT	017H		;CALL BIOS
	CLC
	RET


;OPEN (INITIALIZE) BIOS PRINTER

BPRNOP:	MOV	DL,AH		;GET EXTENDED DEVICE NUMBER
	MOV	DH,0
	MOV	AH,1		;SELECT BIOS PRINTER INITIALIZE FUNCTION
	INT	017H		;CALL BIOS
	CLC
	RET


;INPUT STATUS FROM THE PRINTER

BPRNIN:	MOV	DL,AH		;GET EXTENDED DEVICE NUMBER
	MOV	DH,0
	MOV	AH,2		;GET PRINTER STATUS
	INT	017H		;CALL BIOS
	CLC
	RET
	PAGE

;DO SERIAL OUTPUT

SEROUT	PROC	NEAR
	MOV	DL,AH		;GET EXTENDED DEVICE NUMBER
	MOV	DH,0
	MOV	AH,1		;SERIAL OUTPUT FUNCTION
	INT	14H		;DO IT
	CLC
	RET
SEROUT	ENDP


;DO SERIAL INPUT, DATA RETURNED IN AL

SERIN	PROC	NEAR
	MOV	DL,AH		;GET EXTENDED DEVICE NUMBER
	MOV	DH,0
SERI10:	MOV	AH,2		;SERIAL INPUT FUNCTION
	INT	14H		;BIOS SERIAL PORT SYSTEM CALL
	TEST	AH,AH		;SUCCESSFUL?
	JS	SERI10		;LOOP IF NOT
	CLC
	RET
SERIN	ENDP


;INTRINSIC TO TEST FOR KEY STRIKE ON THE KEYBOARD
;RETURNS TRUE IF KEY STRUCK

CHKKEY	PROC	NEAR
	MOV	AH,1		;SET STATUS FUNCTION
	INT	16H		;CALL FUNCTION
	JZ	CHKKY1		;SKIP IF NO KEY WAITING
	PUSH	TRUE		;RETURN TRUE
	JMP	CMLRET

CHKKY1:	PUSH	FALSE		;RETURN FALSE
	JMP	CMLRET
CHKKEY	ENDP
	PAGE

;THIS ROUTINE RETURNS THE ADDRESS OF MS-DOS ENVIRONMENT INFO
;WHICH CONSISTS OF REGISTERS WHICH ARE SET
;AND SAVED BY THE SOFTWARE INTERRUPT INTRINSIC, THE CURRENT CODE
;SEGMENT AND DOS ERRORS

GETREG	PROC	NEAR
	MOV	CSREG,CS		;SAVE CODE SEGMENT
	MOV	AX,OFFSET CPUREG	;PUSH THE ADDRESS
	PUSH	AX			;RETURN THE VALUE
	JMP	OPGO			;RETURN
GETREG	ENDP


CPUREG:				;DEFINE THE REGISTER ADDRESS
AXREG	DW	0		;AX REGISTER
BXREG	DW	0		;BX REGISTER
CXREG	DW	0		;CX REGISTER
DXREG	DW	0		;DX REGISTER
DIREG	DW	0		;DI REGISTER
SIREG	DW	0		;SI REGISTER
BPREG	DW	0		;BP REGISTER
CFLAG	DW	0		;CARRY FLAG

CSREG	DW	0		;CS REGISTER
DSREG	DW	0		;DS REGISTER
SSREG	DW	0		;SS REGISTER
ESREG	DW	0		;ES REGISTER

DSGMNT	DW	0		;CURRENT DATA SEGMENT

;DOS ERROR INFORMATION

DOSINT	DB	0,0		;CURRENT DOS INTERRUPT
DOSFUN	DB	0,0		;CURRENTLY CALLED DOS FUNCTION	
DOSRET	DW	0		;CURRENT DOS ERROR RETURN CODE
PSWREG	DW	0		;PROCESSOR STATUS REGISTER

	PAGE

;THIS INTRINSIC CALLS THE SPECIFIED SOFTWARE INTERRUPT
;REGISTER ARE SET BY USER AND REGISTER VALUES RETURNED BY
;INTERRUPT ARE SAVED

SFTINT	PROC	NEAR
	POP	AX			;GET THE INTERRUPT NUMBER
	MOV	BYTE PTR INTVEC,AL	;SET IT 
	PUSH	DI			;SAVE OUR INDEXES
	PUSH	SI
	PUSH	ES			;SAVE SEGMENT REGISTERS
	PUSH	DS

	CALL	LODREG			;LOAD REGISTERS

	INT	0			;CALL THE INTERRUPT
INTVEC	EQU	$-1

	CALL	UNLREG			;UNLOAD REGISTERS
	POP	DS			;RESTORE REGISTERS
	POP	ES
	POP	SI
	POP	DI

	JNC	SFTIT1			;TEST CARRY FLAG
	MOV	CFLAG,TRUVAL		;SET ACCORDINGLY
	JMP SHORT SFTIT2
SFTIT1:	MOV	CFLAG,FALVAL

SFTIT2:
	JMP	CMLRET
SFTINT	ENDP
	PAGE

;UNLOAD HARDWARE REGISTERS INTO REGISTER ARRAY

UNLREG:	MOV	CS:AXREG,AX		;SAVE REGISTERS
	MOV	CS:BXREG,BX
	MOV	CS:CXREG,CX
	MOV	CS:DXREG,DX
	MOV	CS:SIREG,SI
	MOV	CS:DIREG,DI
	MOV	CS:ESREG,ES
	MOV	CS:DSREG,DS
	MOV	CS:BPREG,BP
	PUSHF
	POP	AX
	MOV	CS:PSWREG,AX
	RET

;LOAD REGISTERS INTO CPU

LODREG:	MOV	AX,AXREG		;SET THE REGISTERS
	MOV	BX,BXREG
	MOV	CX,CXREG
	MOV	DX,DXREG
	MOV	SI,SIREG
	MOV	DI,DIREG
	MOV	ES,ESREG
	MOV	BP,BPREG
	MOV	DS,DSREG		;WARNING: DS IS CHANGED
	RET
	PAGE

;INTRINSIC TO EXIT I2L VIA INTERRUPT RETURN

INTRET:	MOV	SP,ENTSTK
	CALL	LODREG
	IRET

;INTRINSIC TO DO A FAR JUMP TO AN EXTERNAL ROUTINE

EXTJMP:	POP	ADDVC1			;SET ADDRESS OF ROUTINE
	POP	SEGVC1			;SET SEGMENT OF ROUTINE
	MOV	SP,ENTSTK		;RESTORE STACK POINTER
	CALL	LODREG			;LOAD ALL REGISTERS
	DB	0EAH			;FAR JUMP INSTRUCTION
ADDVC1	DW	0			;OFFSET PART OF ADDRESS
SEGVC1	DW	0			;SEGMENT PART OF ADDRESS

;INTRINSIC TO DO A FAR CALL TO AN EXTERNAL ROUTINE

EXTCAL:	POP	ADDVC2			;SET ADDRESS OF ROUTINE
	POP	SEGVC2			;SET SEGMENT OF ROUTINE
	PUSH	SS			;SAVE SOME REGISTERS
	PUSH	ES
	PUSH	DS
	PUSH	DI

	CALL	LODREG			;LOAD ALL REGISTERS
	DB	9AH			;FAR CALL INSTRUCTION
ADDVC2	DW	0			;OFFSET PART OF ADDRESS
SEGVC2	DW	0			;SEGMENT PART OF ADDRESS

	CALL	UNLREG			;UNLOAD THE REGISTERS
	POP	DI			;RESTORE REGISTERS
	POP	DS
	POP	ES
	POP	SS
	JMP	CMLRET


;INTRINSIC TO CHAIN TO A NEW PROGRAM.

CHAIN	PROC	NEAR
	POP	DX		;GET FILE NAME POINTER
	CALL	EXEFUN		;CALL PROGRAM
	JMP	CMLRET		;RETURN
CHAIN	ENDP
	PAGE

;DOS FUNCTIONS

DOSMMA	EQU	4AH		;MODIFY MEMORY ALLOCATION
DOSEXE	EQU	4BH		;EXECUTE PROGRAM


;PARAMETER BLOCK FOR EXEC FUNCTION

EXEPRB	DW	0		;SEGMENT OF ENVIRONMENT BLOCK
	DW	0		;ADDRESS OF COMMAND TAIL
	DW	0		;SEGMENT OF COMMAND TAIL
	DW	0		;ADDRESS OF FCB 1
	DW	0		;SEGMENT OF FCB 1
	DW	0		;ADDRESS OF FCB 2
	DW	0		;SEGMENT OF FCB 2

;TO SAVE THE STACK POINTERS

STKSEG	DW	0		;STACK SEGMENT
STKREG	DW	0		;STACK POINTER

;EXECUTE FILE NAME POINTED TO BY DX

EXEFUN	PROC	NEAR
	MOV	CFLAG,FALVAL	;CLEAR CARRY FLAG

	PUSH	DI		;SAVE INDEXES
	PUSH	SI
	CALL	PARNAM		;PARSE FILE STRING

;RESIZE PROGRAM SO THERE ROOM FOR ANOTHER

	MOV	AH,DOSMMA	;RESIZE THIS PROGRAM
	MOV	DOSFUN,AH	;SAVE FOR ERRORS
	MOV	DOSINT,21H
	MOV	BX,4096		;TO 64K (4096 PARAGRAPHS)
	INT	21H		;CALL DOS FUNCTION
	JNC	EXEFN1		;SKIP IF NO ERROR

	MOV	DOSRET,AX	;SAVE ERROR
	MOV	CFLAG,TRUVAL	;SET CARRY FLAG
	JMP SHORT EXEXT1	;EXIT
	PAGE

;SETUP PARAMETER BLOCK FOR PROGRAM

EXEFN1:	MOV	EXEPRB,0	;SET ENVIROMENT BLOCK
	MOV	EXEPRB+2,80H	;SET COM TAIL ADDRESS
	MOV	EXEPRB+4,CS	;SET COM TAIL SEGMENT
	MOV	EXEPRB+6,5CH	;SET FCB1 ADDRESS
	MOV	EXEPRB+8,CS	;SET FCB1 SEGMENT
	MOV	EXEPRB+10,6CH	;SET FCB2 ADDRESS
	MOV	EXEPRB+12,CS	;SET FCB2 SEGMENT

;SETUP AND CALL SUBPROGRAM

	MOV	STKSEG,SS	;SAVE STACK SEGMENT
	MOV	STKREG,SP	;AND STACK POINTER

	MOV  DX,OFFSET WRKNAM	;POINT TO FILE NAME
	MOV  BX,OFFSET EXEPRB	;POINT TO PARAMETER BLOCK
	MOV	AL,0		;SET FOR LOAD AND EXECUTE
	MOV	AH,DOSEXE	;SET FUNCTION
	MOV	DOSFUN,AH	;SAVE FOR ERRORS
	INT	21H		;DO DOS CALL
	JNC	EXEXT2		;SKIP NO ERROR

	MOV	DOSRET,AX	;SAVE ERROR CODE
	MOV	CFLAG,TRUVAL	;SET CARRY FLAG

EXEXT2:	MOV	SS,STKSEG	;RESTORE STACK
	MOV	SP,STKREG
EXEXT1:	POP	SI		;RESTORE INDEXES
	POP	DI
	RET
EXEFUN	ENDP
	PAGE


;READ A MEMORY VALUE

PEEK	PROC	NEAR
	POP	BX	;GET ADDRESS
	POP	CX	;GET SEGMENT
	PUSH	ES	;SAVE ES
	MOV	ES,CX	;POINT ES AT SEGMENT
	MOV	AH,0	;ZERO HIGH HALF
	MOV AL,ES:[BX]	;READ THE LOCATION
	POP	ES	;RESTORE ES
	PUSH	AX	;RETURN THE VALUE
	JMP	CMLRET	;RETURN
PEEK	ENDP


;WRITE A MEMORY VALUE

POKE	PROC	NEAR
	POP	AX	;GET THE VALUE
	POP	BX	;GET ADDRESS
	POP	CX	;GET SEGMENT
	PUSH	ES	;SAVE ES
	MOV	ES,CX	;POINT ES AT SEGMENT
	MOV ES:[BX],AL	;READ THE LOCATION
	POP	ES	;RESTORE ES
	JMP	CMLRET	;RETURN
POKE	ENDP
