\XPLN.XPL	12-JAN-2010
\XPL0 COMPILER
\COPYRIGHT 1984-2010 P.J.R. BOYLE
\FLOATING POINT VERSION BY LOREN BLANEY
\IBM NATIVE LANGUAGE VERSION BY LARRY FISH
\
\This program is free software; you can redistribute it and/or modify it under
\ the terms of the GNU General Public License version 2 as published by the
\ Free Software Foundation.
\This program is distributed in the hope that it will be useful, but WITHOUT
\ ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
\ FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
\ details.
\You should have received a copy of the GNU General Public License along with
\ this program (in the file LICENSE.TXT); if not, write to the Free Software
\ Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\
\You can reach the authors at: loren.blaney@idcomm.com
\
\REVISIONS:
\V2.0 AUG-21-93
\V2.1 FEB-16-94, FIXED MULTIPLE "PROGRM" LABEL ERROR WHEN LINKING EXTERNAL
\ PROCEDURES. INDENT INCLUDED FILES ACCORDING TO NESTED LEVEL. FIX PROBLEM
\ WHERE LINKING MORE THAN 64K OF EPROCS.
\V2.2 FEB-28-95, 16 SIG CHARS IN A NAME; '_' IN FRONT OF PUBLIC & EXTERNAL
\ NAMES; COMMENTS IN PARENTHESIS ALLOWED AFTER ALL EXTERNAL PROCEDURE
\ DECLARATIONS; 'ADDR' OPERATOR HANDLES ARRAYS; 'EXIT' STATEMENT CAN RETURN
\ A VALUE; ETC.
\V2.2.2 MAY-27-95, ARRAY DECLARATIONS AND MULTIDIMENSIONAL CHARACTER ARRAYS.
\V2.3 JUL-01-95, RELEASED.
\V2.3.1 JUL-13-95, REMOVE UNDERLINE FOR ASSEMBLY LANGUAGE EXTERNALS.
\V2.3.2 JUL-23-95, 1600 SYMBOL NAMES, 160 QUITS AND REAL CONSTANTS. PUBLIC
\ FORWARD PROCEDURES.
\V2.4 24-FEB-2001, CLEAN UP DOSOPEN, FIX "~" IN CONSTANT CALCULATIONS.
\ FIX /L & /A SWITCHES. REMOVE "NOLOC" REMNANT. IN SEGMENT ARRAYS, RESTORE
\ DS WITH SS RATHER THAN ES. INLINE ABS, REM, SWAP, EXT & PORT FUNCTIONS.
\V2.4.1 29-JUN-2001, Allow pathnames in input files.
\V2.4.3 25-APR-2002, Fix bug caused by declaring arrays totalling more than 32K.
\ Fix abs($8000) infinite loop.
\V2.4.4 28-MAY-2002, Link with NATIVE, which fixed Ctrl-C vector.
\V2.5 31-DEC-2005, Inline assembly code ('asm'). Fixed small bug where 255
\ characters of source code after an 'include' file wasn't displayed when a
\ compile error was detected.
\V2.5.1 23-Apr-2007, Added 'string' directive to enable null-terminated strings.
\ Accept "^Z" in strings (but not an actual ^Z). Flag integer-expected error for
\ Real & Int. Don't flag EOF error for null strings ("") when conditional
\ compile is false.
\V2.6 17-Mar-2008, Added binary notation (e.g: $1e = %11110); underlines are
\ allowed in numbers (123_456.78); variables can be declared after procedures.
\V2.7 12-Jan-2010, Allow 'to' to replace ',' in 'for' loops; implement 'downto'.
\ Added arithmetic shift right operator "->>".
\
\CONTENTS:
\ MAIN--DISPLAY TITLE AND INITIALIZE
\	ERROR--DISPLAY ERROR MESSAGE AND OPTIONALLY CONTINUE
\	GETCH--GET A CHARACTER FROM THE SOURCE DEVICE
\	RATOM--READ AN ATOM FROM SOURCE DEVICE
\	SKIPIT--SKIP STATEMENT FOR ERRORS
\	HEXB--OUTPUT A HEX BYTE (IN ASCII) TO BINARY DEVICE
\	GEN--OUTPUT I2L CODE TO BINARY DEVICE
\	FIX--CHANGE A SPECIFIC I2L LOCATION TO THE CURRENT PC
\	LOOKUP--LOOK UP AN IDENTIFIER NAME IN THE SYMBOL TABLE
\	INSERT--INSERT AN IDENTIFIER INTO THE SYMBOL TABLE
\	GETCON--GET A CONSTANT (EITHER VALUE OR NAME)
\       CONEXPRESS--EVALUATES A CONSTANT EXPRESSION
\	PROCAL--PROCEDURE CALLS
\	BOOLEXP--GENERATE I2L CODE FOR A BOOLEAN EXPRESSION
\		FACTOR--GENERATE CODE FOR A FACTOR
\			STRCON--TEXT STRING CONSTANT
\			ARRAYCON--CONSTANT ARRAY
\			SPECFAC--SPECIAL FACTORS (addr,STRING)
\			IDFAC--IDENTIFIER FACTORS
\				FUNCTION--PROCEDURE AS A FACTOR
\		SHIFTEXP: GENERATE CODE FOR A SHIFT (E.G. A<<B)
\		TERM--GENERATE CODE FOR A TERM (E.G. A*B)
\			TERMX--
\		ALGEXP--ALGEBRAIC EXPRESSION (E.G. A+B)
\			ALGX--
\		LOGEXP--LOGICAL EXPRESSION (E.G. A=B)
\			LOGX--
\		BOOLTERM--BOOLEAN TERM (E.G. A&B)
\	SSTATEMENT--(FOR 'QUIT'S IN 'CASE' STATEMENTS)
\		STATEMENT--PARSE AND GENERATE CODE
\			ASSIGN--ASSIGNMENT STATEMENTS
\				ASSX--
\			CASER--CASE STATEMENTS
\				CASER2--
\	PROCEDURE--PARSE AND GENERATE CODE
\		CODDEC--'CODE' DECLARATION
\		CONDEC--'DEFINE' DECLARATION
\		VARDEC--'INT','REAL', AND 'ADDR' DECLARATIONS
\		EXTDEC--'EXTERNAL' PROCEDURE DECLARATION
\		FPRDEC--FORWARD PROCEDURE DECLARATIONS
\		PROCDEC--'PROCEDURE' DECLARATIONS

code	\THE REQUIRED INTRINSICS:
ABS=0		REM=2		RESERVE=3	SWAP=4
CHIN=7		CHOUT=8		CRLF=9		INTIN=10
INTOUT=11	TEXT=12		OPENI=13	OPENO=14
CLOSE=15	TRAP=17,	GETERR=22,	HEXOUT=27,
FSET=24,	FOPEN=29,	FCLOSE=32,	GETREG=35,
BLIT=36		PEEK=37;

code real
FLOAT=49,	RLRES=46;

integer
	INHAND,	\INPUT FILE HANDLE
	OUTHAND;\OUTPUT FILE HANDLE

integer
	COMFLG,	\PUT COMMENTS IN CODE
	IMMTYP,	\IMMEDIATE TYPE
	IMMVAL,	\IMMEDIATE VALUE
	LOCAL,	\LOCAL LABEL NUMBER
	OLDLEV,	\OLD LEVEL
	TOS;	\KEEPS TRACK OF WHERE TOS IS

def	STACKED,	\TOS IS ON THE STACK
	INREG,		\TOS IS IN THE REGISTER
	IMAGE;		\TOS HAS NOT BEEN GENERATED YET

char	FNAME;		\NAME PART OF INPUT FILE (EXCLUDING DRIVE AND PATHNAME)
			\(ASSIGNS UNIQUE NAMES TO PROCEDURE CODE SEGMENTS)
def	TV=0, KB=0, NULDEV=7, EOF=$1A, BEL=$07, EOL=$0A; \I/O STUFF
def	SYMAX=1600,	\SIZE OF THE SYMBOL TABLE
	SIGCHAR=16,	\NO. OF SIGNIFICANT CHARS IN AN IDENT
	HASHMSK=$FF,	\MASK FOR HASHES
	EMTPNT=-1,	\EMPTY SYMBOL POINTER
	BOXNUM=256,	\NUMBER OF BOXES

	RLMAX=160,	\SIZE OF REAL-CONSTANT SYMBOL TABLE
	RLSIZE=8,	\NO. OF BYTES IN A REAL NUMBER
	QUITMAX=160;	\MAXIMUM NO. OF 'QUIT'S IN A 'LOOP'

int	ERRCNT	\ERROR COUNTER
	LSTDEV	\LISTING OUTPUT DEVICE NUMBER
	SRCDEV	\SOURCE INPUT DEVICE NUMBER
	BINDEV	\BINARY OUTPUT DEVICE NUMBER
	SEGCNT	\COUNTS AND CREATE UNIQUE SEGMENT NUMBER
	DEEPER	\TRUE WHEN NESTING SEGMENTS DEEPER
	CODFLG	\FLAG: TRUE WHENEVER CODE IS GENERATED
	HASMAIN	\FLAG: THERE IS A STATEMENT IN THE MAIN PROCEDURE
	CONDITIONAL  \FLAG: CONDITIONAL COMPILE
	STRTERM	\flag: string termination (0=null, nonzero=MSB)
	CHAR	\CURRENT CHARACTER.  MOST OF THE TIME IT
		\ CONTAINS THE TERMINATOR OF THE CURRENT ATOM
	ATOM	\PRESENT ATOM DESCRIPTOR
		\CONTAINS RESERVED WORD HASH OR THE ASCII FOR
		\ A SPECIAL CHARACTER; 0 IF THE ATOM IS A
		\ CONSTANT OR AN IDENTIFIER
	ATYPE;	\PRESENT ATOM TYPE DESCRIPTOR
def	\ATYPE\ SPECIAL,IDENTIFIER,INTCON,REALCON;
char	IDENT;	\ARRAY--CURRENT IDENTIFIER NAME
int	HASH	\CURRENT IDENTIFIER HASH CODE
	LABCNT,	\LABEL COUNT (FROM NEWLAB)
	IATOM;	\VALUE OF CURRENT INTEGER CONSTANT
real	RLATOM;	\REAL CONSTANT FROM PROC "RATOM"

int	IDTYPE;	\PRESENT IDENTIFIER TYPE DESCRIPTOR
def	UNDEF=0,	\UNDEFINED ID (NO. ORDER IS CRITICAL)
	ADDRVAR=1,	\ADDRESS VARIABLE ID (TYPE = INTEGER)
	INVAR=3,	\INTEGER VARIABLE ID (ODD NOS.=INTEGER)
	RLVAR=4,	\REAL VARIABLE ID
	INCON=5,	\INTEGER CONSTANT ID
	RLCON=6,	\REAL CONSTANT ID
	INPROC=7,	\INTEGER PROCEDURE ID
	RLPROC=8,	\REAL PROCEDURE ID
	INFPROC=9,	\INTEGER FORWARD PROCEDURE ID
	RLFPROC=10,	\REAL FORWARD PROCEDURE ID
	INOPT=11,	\INTEGER OPTIMIZED PROCEDURE ID
	RLOPT=12,	\REAL OPTIMIZED PROCEDURE ID
	INEPRO=13,	\INTEGER XPL EXTERNAL PROCEDURE
	RLEPRO=14,	\REAL XPL EXTERNAL PROCEDURE
	ININT=15,	\INTEGER INTRINSIC ID
	RLINT=16,	\REAL INTRINSIC ID
	INEXT=17,	\INTEGER EXTERNAL ASSEMBLY ROUTINE ID
	RLEXT=18,	\REAL EXTERNAL ASSEMBLY ROUTINE ID
	INSEG=19,	\INTEGER SEGMENT VARIABLE ID
	RLSEG=20,	\REAL SEGMENT VARIABLE ID
	ADSEG=21,	\ADDRESS VARIABLE ID
	SHSEG=22;	\SHORT SEGMENT VARIABLE ID

int	LEV	\LEVEL OF CURRENT IDENTIFIER
	VAL	\VALUE OR ADDRESS OF CURRENT IDENTIFIER
	SYMNUM	\POSITION IN "SYMTBL" OF CURRENT IDENTIFER
	FACTYP;	\FACTOR (OR OPERAND) TYPE (REAL OR INTEGER)
def	\FACTYP\ REAL,INTEGER;
int	FIXES	\ARRAY--'QUIT' FIXES STILL OUTSTANDING
	LEVEL	\STATIC LEVEL OF CURRENT PROCEDURE
	NOSYM	\CURRENT NUMBER OF SYMBOLS IN SYMBOL TABLE
	FIXCNT	\COUNT OF THE NUMBER OF OUTSTANDING 'QUIT'S
	STKLOD	\NO. OF INTEGERS LEFT ON STACK BY 'FOR' ! 'CASE'
	OPTPROC	\BOOLEAN--GENERATE AN OPTIMIZED PROCEDURE CALL
	NORLSY	\CURRENT NUMBER OF REAL CONSTANTS IN TABLE
	LASTOP	\PREVIOUS OPCODE
	HASLAB	\KEEPS TRACK OF LABEL GENERATION
	I;	\SCRATCH
char	HEXDIGIT; \ARRAY OF HEX DIGITS (0 - F)
	\ -- SYMBOL TABLE ARRAYS --
char	SYMBOL	\IDENTIFIER NAME (IDENT)
	SYMTYP	\TYPE DESCRIPTORS (IDTYPE)
	SYMLEV;	\LEVEL (LEV)

int	SYMVAL	\VALUE OR ADDRESS (VAL)
	SYMPNT	\LIST LINKAGE POINTERS
	BOX;	\HASH BOXES (SYMBOL LIST HEADERS)

real	RLTBL;	\REAL CONSTANT TABLE


int	HANPTR,		\POINTER TO OLD INCLUDE HANDLES
	OLDHAN;		\ARRAY OF OLD INCLUDE HANDLES

def	HANMAX=8;	\MAXIMUM NESTING DEPTH OF INCLUDES

\RESERVED WORD HASHES:
def	ADRSYM=$88E4,	BEGSYM=$84C7,	CASEYM=$8053,	CODSYM=$8184,
	DEFSYM=$9CC6,	DOSYM=$0CEF,	ELSEYM=$99F3,	ENDSYM=$99A4,
	EXITYM=$9B69,	EXTNYM=$9B74,	FALSYM=$944C,	FFUNYM=$94B5,
	FORSYM=$9592,	FPRSYM=$9672,	FUNSYM=$96CE,	GESYM=$0C85,
	GETSYM=$90D4,	IFSYM=$0D46,	INTSYM=$A9B4,	LESYM=$0DE5,
	LOOPYM=$BD8F,	NOTSYM=$B594,	OFSYM=$0D86,	PROCYM=$CE2F,
	QUITYM=$CAC9,	REALYM=$C4C1,	REPSYM=$C4D0,	RETSYM=$C4D4,
	THENYM=$DD65,	TRUSYM=$DE35,	UNTSYM=$D9B4,	WHILYM=$D169,
	CHARYM=$8161,	EPRSYM=$9A72,	EFUNYM=$98B5,	PUBSYM=$CEC2,
	OTHSYM=$B2E8,	INCSYM=$A9A3,	LSLSYM=$BE0C,	LSRSYM=$BE92,
	SEGSYM=$C0C7,	SHTSYM=$C16F,	CONSYM=$818E,	ABSSYM=$8833,
	REMSYM=$C4CD,	SWAPYM=$C281,	EXTSYM=$9B74,	PORTYM=$CD92,
	STRSYM=$C2F2,	ASMSYM=$8A0D,	TOSYM=$0EEF,	DOWNYM=$9D97,
	ASRSYM=$8A12;

proc	ERROR; int N;	\SEND ERROR MESSAGE TO THE TV
int	ERR,CH,I;
char	STRING;
def	MAXERR=74;	\MAXIMUM ERROR NUMBER
begin
ERR:=RESERVE((MAXERR+1)*2);
for I:=0,MAXERR do ERR(I):="? ";	\UNUSED ERROR NOS. ="?"

ERR(1):="TOO MANY VARIABLES ";
ERR(2):="TOO MANY REAL CONSTANT NAMES ";
ERR(3):="TOO MANY NAMES ";
ERR(4):="TOO MANY 'QUITS' ";
ERR(5):="TOO MANY STATIC LEVELS ";
ERR(6):="NUMBER OUT OF RANGE ";
ERR(7):=ERR(6);		\FOR INTRINSIC DECLARATIONS
ERR(10):="UNDECLARED NAME ";
ERR(11):="NAME ALREADY DECLARED ";
ERR(20):="ILLEGAL START OF A STATEMENT ";	\IN "ASSIGN"
ERR(21):="^":=^"* ";
ERR(22):="'THEN'* ";
ERR(23):="'DO'* ";
ERR(24):="'TO' OR 'DOWNTO'* ";
ERR(26):="ILLEGAL FACTOR ";	\UNRECOGNIZABLE SPECIAL FACTOR
ERR(27):="STATEMENT STARTING WITH A CONSTANT "; \IN "ASSIGN"
ERR(28):="'UNTIL'* ";
ERR(29):="'OTHER'* ";
ERR(30):="'ELSE'* ";
ERR(31):="DIGIT* ";
ERR(33):="INTEGER VARIABLE* ";	\IN A 'FOR' STATEMENT
ERR(38):="^">^"* ";		\ASR ->>
ERR(39):="^"(^"* ";
ERR(40):="^"=^"* ";
ERR(41):="^";^"* ";
ERR(42):="CONSTANT* ";		\IN "GETCON"
ERR(43):="VARIABLE* ";		\FOR AN 'ADDR' OPERATOR
ERR(44):="^")^"* ";
ERR(45):="NAME* ";
ERR(46):="MIXED MODE ";
ERR(47):="INTEGER* ";
ERR(48):="'OF'* ";
ERR(49):="^":^"* ";
ERR(50):="^"]^"* ";
ERR(51):="NO ARGUMENTS DECLARED ";
ERR(52):="STATEMENT STARTING WITH 'ELSE' ";
ERR(53):="STATEMENT STARTING WITH 'OTHER' ";
ERR(60):="'QUIT' NOT IN A 'LOOP' ";
ERR(61):="EOF* ";
ERR(62):="EOF INSIDE A BLOCK ";
ERR(63):="EOF INSIDE A STRING ";
ERR(65):="'FPROC' & ITS 'PROC' NOT AT SAME LEVEL ";
ERR(66):="'FPROC' REFERENCE NOT FOUND ";
ERR(67):="'PROC' OR 'FUNC'* ";
ERR(68):="'EPROC'S AND 'PUBLIC'S MUST BE GLOBAL ";
ERR(69):="'INCLUDE'S NESTED TOO DEEP ";
ERR(70):="BAD FILE SPEC ";
ERR(71):="FILE NOT FOUND ";
ERR(72):="'INT', 'REAL', 'CHAR' or 'ADDR'* ";
ERR(73):="DIVIDE BY ZERO IN A CONSTANT EXPRESSION ";
ERR(74):="MATH ERROR IN A CONSTANT EXPRESSION ";

I:= 0;
if LSTDEV=8 then
	begin
	OPENI(8);
	loop	begin
		CH:=CHIN(8);		\INCLUDES CAUSE NESTED EOFs
		if CH=EOF then
			begin
			I:=I+1;
			if I>=HANMAX then quit;
			end
		else [I:=0; CHOUT(0,CH)];
		end;
	CRLF(0);
	end;

CHOUT(TV,BEL); CHOUT(TV,$0A);	\(DAMN LINEFEEDS!)
CRLF(TV);
TEXT(TV,"***** ERROR NO. "); INTOUT(TV,N); TEXT(TV," *****");
CRLF(TV);
STRING:=ERR(N);
I:=0;
loop	[CH:=STRING(I);		\OUTPUT MESSAGE
	if CH>=$80 then quit;
	if CH=^* then TEXT(TV," EXPECTED BUT NOT FOUND")
		else CHOUT(TV,CH);
	I:=I+1];
CRLF(TV);
TEXT(TV,"ATTEMPT TO CONTINUE (Y/N)? ");
OPENI(KB);
case CHIN(KB) of ^N,^n: [CLOSE(LSTDEV); exit 1] other;
BINDEV:=NULDEV;		\THERE SHALL BE NO OUTPUT FILE
ERRCNT:=ERRCNT+1;
end;	\ERROR



proc	GETCH;	\GET A CHARACTER FROM THE SOURCE DEVICE
\ FILTERS OUT COMMENTS
\(THIS PROCEDURE IS OPTIMIZED FOR SPEED.)
begin
CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR);
while CHAR=^\ do			\FILTER OUT COMMENTS
	begin
	loop	[CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR);
		case CHAR of
		  $0D:	return;		\CR
		  ^\:	[CHAR:= ^ ; return];
		  EOF:	return
		other	[]];
	end;
end;	\GETCH



proc	GETCH_;	\GET NON-UNDERLINE CHARACTER FROM THE SOURCE DEVICE
repeat GETCH until CHAR#^_;

\------------- ROUTINES TO HANDLE INCLUDES ---------------------

procedure FALLBACK;	\TERMINATE AN INCLUDE AND FALL BACK TO PREVIOUS HANDLE
begin
HANPTR:=HANPTR-1;
FCLOSE(INHAND);
INHAND:=OLDHAN(HANPTR);
\ONLY THE MAIN FILE GETS A BIG BUFFERS
FSET(INHAND,if HANPTR=0 then ^I else ^i);
end;	\FALLBACK



procedure INCLUDE;	\SET UP AN INCLUDE FILE
char NAME; define NAMMAX=80;
integer NEWHAND, I;


	procedure GETC;
	\GET CHARACTER WITH NO FILTERING
	[CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR)];


	procedure GETNAME;
	\READ FILE SPECIFICATION
	integer EXTFLG, I,K;
	char DEFEXT;
	begin
	DEFEXT:=".XPL";
	EXTFLG:=false;

	\EAT LEADING SPACES AND CONTROL CHARS
	while CHAR<=$20 do [if CHAR=EOF then ERROR(61); GETC];

	\COPY FILE NAME INTO 'NAME'
	K:=0;
	loop	begin
		case CHAR of
		  ^. : EXTFLG:=true;
		  EOL: return false;
		  ^; : quit
		other;

		NAME(K):=CHAR;
		K:=K+1;
		if K>=NAMMAX  then return false;
		GETC;
		end;

	\DEAL WITH EMPTY FILENAME
	if K=0 then return false;

	\DEAL WITH DEFAULT EXTENSIONS
	if EXTFLG then NAME(K-1):=NAME(K-1) ! $80
	else
		begin
		if (K+4)>=NAMMAX then return false;
		for I:=0,3 do NAME(K+I):=DEFEXT(I);
		end;
	return true;
	end;


begin	\INCLUDE
NAME:=RESERVE(NAMMAX);
if HANPTR>=HANMAX then
	[ERROR(69); while CHAR#^; & CHAR#EOF do GETC; return];
if not GETNAME then
	[ERROR(70); while CHAR#^; & CHAR#EOF do GETC; return];

\OPEN FILE
TRAP($FFFB);
NEWHAND:=FOPEN(NAME,0);
TRAP($FFFF);
if GETERR=3 then [ERROR(71); return];

\SAVE OLD FILE HANDLE ON STACK
OLDHAN(HANPTR):=INHAND;
HANPTR:=HANPTR+1;
INHAND:=NEWHAND;

\INCLUDE FILES ALWAYS USE SMALL BUFFERS
FSET(INHAND,^i);

TEXT(0,"INCLUDING: ");
for I:=2,HANPTR do TEXT(0,"   ");
TEXT(0,NAME); CRLF(0);
end;	\INCLUDE

\-------------------------------------------------------

fproc	CONEXPRESS;
fproc	LOOKUP, TTXT;	\FOR 'ASM'


proc	RATOM;		\READ AN ATOM
\OUTPUTS:  ATOM, ATYPE, IDENT, HASH, IATOM, CHAR, RLATOM.
\ (THIS PROCEDURE IS OPTIMIZED FOR SPEED.)
int	LEN,NEG,EXP,I,INTOVF;
real	FRACT,DENOM;

	proc	RFRACT;	\READ THE FRACTIONAL PART OF A REAL NO.
	begin
	ATYPE:=REALCON; ATOM:=0;
	GETCH_;
	FRACT:=FLOAT(0); DENOM:=FLOAT(10);	\(10.0 IS NOT SO PORTABLE)
	while CHAR>=^0 & CHAR<=^9 do
		[FRACT:=FRACT +FLOAT(CHAR-^0) /DENOM;
		DENOM:=DENOM*FLOAT(10);
		GETCH_];
	RLATOM:=RLATOM +FRACT;
	end;	\RFRACT


	proc	REXP;	\READ AN EXPONENT IF ANY
	if CHAR=^E ! CHAR=^e then
		begin
		ATYPE:=REALCON;
		GETCH_;
		if CHAR=^- then [NEG:=true; GETCH_]
			else NEG:=false;
		if CHAR=^+ then GETCH_;
		EXP:=0;
		if CHAR<^0 ! CHAR>^9 then ERROR(31);
		while CHAR>=^0 & CHAR<=^9 do
			[EXP:=EXP *10 +CHAR-^0; GETCH_];
		if NEG then EXP:= -EXP;
		while EXP>0 do
			[RLATOM:=RLATOM *FLOAT(10); EXP:=EXP-1];
		while EXP<0 do
			[RLATOM:=RLATOM /FLOAT(10); EXP:=EXP+1];
		end;	\REXP


	proc	DoAsmLine;	\Output a line of assembly code
	int	HaveComment;
	begin
	HaveComment:= false;
	while CHAR#$0D\CR\ & CHAR#^} do
		begin
		if CHAR=^; then HaveComment:= true;
		if not HaveComment then CHOUT(BINDEV,CHAR);
		GETCH;
		if CHAR>=^A & CHAR<=^Z & not HaveComment then
			begin
			RATOM;			\(ATYPE=IDENTIFIER)
			LOOKUP;
			case IDTYPE of
			  ADDRVAR, INVAR, RLVAR:
				[if IDTYPE=RLVAR then TTXT("qword ptr ");
				if LEV=0 then TTXT("heaplo+")
				else TTXT("[si]+"); \(no intermediate levels)
				INTOUT(BINDEV,VAL)];
			  INCON:
				INTOUT(BINDEV,VAL);
			  UNDEF:
				ERROR(10)
			other	ERROR(26);
			end;
		if CHAR=EOF then [ERROR(62); exit 1];
		end;
	if CHAR=$0D\CR\ then [CRLF(BINDEV); GETCH];
	if CHAR=$0A\LF\ then GETCH;
	end;	\DoAsmLine


begin	\RATOM
while CHAR<=$20\SPACE\ do
	begin	\SKIP SPACES, TABS, RETURNS, LF'S, & FF'S, ETC.
		\DON'T GO PAST EOF
	\IF HANPTR=0 THEN IT'S A HARD EOF
	if CHAR=EOF then if HANPTR>0 then FALLBACK
	else [ATYPE:=SPECIAL; ATOM:=EOF; return];
	GETCH;
	end;
if CHAR>=^a then if CHAR<=^z then			\RESERVED WORD
	[ATYPE:= SPECIAL;
	ATOM:= CHAR; GETCH;
	ATOM:= ATOM<<5|CHAR; GETCH;
	if CHAR>=^a & CHAR<=^z then [ATOM:= ATOM<<5|CHAR; GETCH];
	while CHAR>=^a & CHAR<=^z do GETCH;
	case ATOM of
	  TRUSYM: [ATYPE:=INTCON; ATOM:=0; IATOM:=true];
	  FALSYM: [ATYPE:=INTCON; ATOM:=0; IATOM:=false];
	  CONSYM: begin
		  RATOM;
		  CONEXPRESS;
		  if FACTYP=INTEGER then CONDITIONAL:= IATOM else ERROR(47);
		  while ATOM=^; do RATOM;		\EAT SEMI, IF ANY
		  loop	begin				\EAT ATOMS TIL COND=TRUE
			if CONDITIONAL \#0\ then quit;
			if ATYPE=SPECIAL then
			  if ATOM=EOF then quit
			  else if ATOM=^" then		\ignore 'con' in strings
			    begin
			    if CHAR#^" then		\null string ("")
			      loop begin
				 CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR);
				 if CHAR=EOF then [ERROR(63); exit 1];
				 if CHAR=^^ then
					[CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR)]
				 else	if CHAR=^" then quit;
				 end;
			    GETCH;
			    end;
			RATOM;
			end;
		  end;
	  STRSYM:
		begin
		RATOM;
		CONEXPRESS;
		if FACTYP=INTEGER then STRTERM:= IATOM else ERROR(47);
		while ATOM=^; do RATOM;		\eat semicolon, if any
		end;
	  ASMSYM:
	    if CONDITIONAL then
	  	begin				\INSERT IN-LINE ASSEMBLY CODE
	  	LASTOP:= -1;			\instead of call to COMMENT
	  	HASLAB:=false;
	  	CODFLG:=true;

		while CHAR=$20\SPACE\ ! CHAR=$09\TAB\ do
			[CHOUT(BINDEV,CHAR); GETCH]; \don't skip EOL
		if CHAR=^{ then
			begin
			GETCH;		\eat {
			repeat DoAsmLine until CHAR=^};
			GETCH;		\eat }
			CRLF(BINDEV);
			end
		else	DoAsmLine;
		RATOM;		\return atom following 'asm' line(s)
		end;
	  INCSYM: [INCLUDE; GETCH; RATOM]
	other	  [];
	return];
if CHAR>=^A then if CHAR<=^Z ! CHAR=^_ then		\IDENTIFIER
	begin
	ATYPE:=IDENTIFIER; ATOM:=0;
	IDENT(0):=CHAR; HASH:=CHAR; GETCH;
	LEN:=1;
	loop	begin
		if CHAR>=^a & CHAR<=^z then CHAR:= CHAR & $DF;	\UPPERCASE
		case of
		  CHAR>=^A & CHAR<=^Z,  CHAR>=^0 & CHAR<=^9,  CHAR=^_ :
			begin
			if LEN <SIGCHAR then
				[IDENT(LEN):=CHAR;
				HASH:=HASH+CHAR;
				LEN:=LEN+1];
			GETCH;
			end
		other quit;
		end;

	for LEN:=LEN,SIGCHAR-1 do
		[IDENT(LEN):=^ ; HASH:=HASH+^ ];
	HASH:=HASH & HASHMSK;
	return;
	end;
if CHAR>=^0 then if CHAR<=^9 then			\UNSIGNED INTEGER
	begin
	ATYPE:=INTCON;		\ASSUME INTEGER UNTIL SHOWN OTHERWISE
	ATOM:=0;
	INTOVF:=false;
	IATOM:=CHAR-^0;
	GETCH_;
	loop	begin
		I:=IATOM;
		if CHAR<^0 ! CHAR>^9 then quit;
		I:=IATOM*10+CHAR-^0;
		if IATOM>3276 ! IATOM=3276 & CHAR>^7 then	\"I" OVERFLOWED
			[INTOVF:=true; quit];			\OK IF IT'S REAL
		IATOM:=I;
		GETCH_;
		end;
	RLATOM:=FLOAT(IATOM);
	IATOM:=I;		\(CAN'T FLOAT(32768))
	while CHAR>=^0 & CHAR<=^9 do	\MORE DIGITS MUST BE REAL
		[RLATOM:=RLATOM*FLOAT(10) + FLOAT(CHAR-^0);
		GETCH_];
	if CHAR=^. then RFRACT;				\UNSIGNED REAL
	REXP;
	if ATYPE=INTCON & INTOVF & IATOM#$8000 then
		if CONDITIONAL then ERROR(6);
	return;
	end;
case CHAR of
^.:	[RLATOM:=FLOAT(0);				\UNSIGNED REAL
	RFRACT;
	REXP;
	return];
^$:	begin						\UNSIGNED HEX INTEGER
	ATYPE:=INTCON; ATOM:=0;
	GETCH_;
	case of
	  CHAR>=^0 & CHAR<=^9: IATOM:=CHAR-^0;
	  CHAR>=^A & CHAR<=^F: IATOM:=CHAR-$37;
	  CHAR>=^a & CHAR<=^f: IATOM:=CHAR-$57
	other [\DIGIT EXPECTED\ ERROR(31); return];
	loop	[GETCH_;
		case of
		  CHAR>=^0 & CHAR<=^9: I:=CHAR-^0;
		  CHAR>=^A & CHAR<=^F: I:=CHAR-$37;
		  CHAR>=^a & CHAR<=^f: I:=CHAR-$57
		other return;
		if IATOM>$FFF then
			if CONDITIONAL then ERROR(6);
		IATOM:=IATOM*16+I];
	end;
  ^%:	begin						\UNSIGNED BINARY INTEGER
	ATYPE:=INTCON; ATOM:=0;
	GETCH_;
	if CHAR>=^0 & CHAR<=^1 then IATOM:=CHAR-^0
	else [\DIGIT EXPECTED\ ERROR(31); return];
	loop	[GETCH_;
		if CHAR>=^0 & CHAR<=^1 then I:=CHAR-^0
		else return;
		if IATOM<0 then		\(if IATOM > $7FFF ... unsigned)
			if CONDITIONAL then ERROR(6);
		IATOM:=IATOM*2+I];
	end;
^^:	[ATYPE:=INTCON;	\META CHARACTER = INTEGER CONSTANT
	ATOM:=0;
	CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR);
	IATOM:=CHAR;
	GETCH;
	return];
^":	[ATYPE:=SPECIAL;				\SPECIAL CHARACTER
	ATOM:=CHAR;\(' AND BACKSLASH HAVE NO EFFECT IN STRINGS)
	CHAR:=CHIN(SRCDEV); CHOUT(LSTDEV,CHAR);
	return]
other;
ATYPE:=SPECIAL;						\SPECIAL CHARACTER
ATOM:=CHAR;
GETCH;
case CHAR of
  ^=:	case ATOM of
	^::	[GETCH; ATOM:=GETSYM];
	^>:	[GETCH; ATOM:=GESYM];
	^<:	[GETCH; ATOM:=LESYM]
	other;
  ^<:	[if ATOM = ^< then [GETCH; ATOM:= LSLSYM]];
  ^>:	begin
	if ATOM = ^> then [GETCH; ATOM:= LSRSYM]
	else if ATOM = ^- then
		[GETCH;
		if CHAR#^> then ERROR(38);
		GETCH;
		ATOM:= ASRSYM];
	end
other	[];
end;	\RATOM



proc	SKIPIT;
\SKIP THE REST OF A STATEMENT FOR ERROR RECOVERY
while ATOM#EOF & ATOM#^; & ATOM#ENDSYM & ATOM#^] &
	ATOM#BEGSYM & ATOM#^[ do RATOM;



proc	HEXB; int I;	\OUTPUT HEX BYTE (OPTIMIZED FOR SPEED)
begin
CHOUT(BINDEV,HEXDIGIT( (I&$FF)/16 ));
CHOUT(BINDEV,HEXDIGIT(REM(0)));
end;	\HEXB



proc	SYMOUT(SYM);	\OUTPUT SYMBOL NAME AT 'SYM'
int	SYM;
int	I, C;
begin
for I:= 0, SIGCHAR-1 do
	begin
	C:= SYMBOL(SYM);
	if C=$20 then return;
	CHOUT(BINDEV, C);
	SYM:= SYM +SYMAX;
	end;
end;	\SYMOUT

\===================================================================

proc TTXT(STR);
\OUTPUT ASSEMBLY STRINGS
char STR;
int I,CH;
begin
I:=0;
loop	begin
	CH:=STR(I);
 	if CH>127 then quit;
	if CH=^| then CRLF(BINDEV) else CHOUT(BINDEV,CH);
	I:=I+1;
	end;
CH:=CH&$7F;
if CH=^| then CRLF(BINDEV) else CHOUT(BINDEV,CH);
end;


procedure LOCOUT;
\OUTPUT CURRENT LOCAL LABEL
[TEXT(BINDEV,"LL"); INTOUT(BINDEV,LOCAL)];


proc STKTOS;
\THIS IS INVOKED AT THE START OF A GEN IF THE OP
\NEEDS TO BE SURE TOS HAS BEEN STACKED
begin
case TOS of
IMAGE:	begin
	TTXT("	MOV	AX,");
	if IMMTYP=^L then TTXT("OFFSET L");
	INTOUT(BINDEV,IMMVAL);
	TTXT("|	PUSH	AX|");
	end;

INREG:	TTXT("	PUSH	AX|")
other;
TOS:=STACKED;
end;	\STKTOS


proc PULTOS;
\THIS IS INVOKED AT THE START OF AN OP WHICH
\NEEDS TO HAVE TOS IN THE AC
int I;
begin
case TOS of
IMAGE:	begin
	TTXT("	MOV	AX,");
	if IMMTYP=^L then TTXT("OFFSET L");
	INTOUT(BINDEV,IMMVAL);
	CRLF(BINDEV);
	end;
STACKED: TTXT("	POP	AX|")
other;
TOS:=INREG;
end;	\PULTOS


procedure NEWLEVEL(L);
\LOAD A NEW LEVEL IF NEEDED
int L;
begin
if OLDLEV#L then
	begin
	TTXT("	MOV	SI,BASE");
	INTOUT(BINDEV,L/2); CRLF(BINDEV);
	OLDLEV:=L;
	end;
end;


procedure COMMENT(OPC);
integer OPC, COMTB1,COMTB2;
begin
LASTOP:=OPC;
HASLAB:=false;
CODFLG:=true;
if not COMFLG then return;

COMTB1:=
["EXIT","LOD","LDX","STO","STX","CAL","RET","JMP","JPC","HPI","ARG","IMM",
"CML","ADD","SUB","MUL","DIV","NEG","EQ","NE","GE","GT","LE","LT","FOR",
"INP","OR","AND","NOT","EOR","DBA","STD","DBX","ADR","LDI","LDA","IMS",
"CJP","JSR","RTS","DRP","CEXT","FLOD","FSTO","FIMM","FADD","FSUB","FMUL",
"FDIV","FNEG","FEQ","FNE","FGE","FGT","FLE","FLT","TRA","TRX","TRI","STT",
"MARK","ASR","LSL","LSR","LDSI","LDSB","LDSR","STSI","STSB","STSR","LSHORT",
"SSHORT","MKARRAY","ABS","FABS","REM","SWAP","EXT","PIN","POUT"];

COMTB2:=["TXT","FLT","INT","END","NUL"];

CRLF(BINDEV); TEXT(BINDEV,"; "); INTOUT(BINDEV,OPC); TEXT(BINDEV," - ");
TEXT(BINDEV,if OPC>$FA then COMTB2(OPC-$FB) else COMTB1(OPC));
CRLF(BINDEV);
end;	\COMMENT

\----------------------------------------------------------------------

proc DOEXIT;
TTXT("	MOV	SP,STKPTR|	RETF|");


proc GENEXIT;
\$00
[COMMENT(0); DOEXIT];


proc GENLOD(L,O);
\$01
int L,O;
begin
COMMENT($01);
STKTOS;
if L=0 then TTXT("	MOV	AX,HEAPLO+")
else [NEWLEVEL(L); TTXT("	MOV	AX,[SI]+")];
INTOUT(BINDEV,O); CRLF(BINDEV);
TOS:=INREG;
end;


proc GENLDX;
\$02
begin
COMMENT($02);
PULTOS;
TTXT("	POP	DI|");
TTXT("	MOV	BX,AX|	MOV	AL,[BX+DI]|	XOR	AH,AH|");
TOS:=INREG;
end;


proc GENSTO(L,O);
\$03
int L,O;
begin
COMMENT($03);
PULTOS;
if L=0 then TTXT("	MOV	HEAPLO+")
else [NEWLEVEL(L); TTXT("	MOV	[SI]+")];
INTOUT(BINDEV,O);
TTXT(",AX|");
TOS:=STACKED;
end;


proc GENSTX;
\$04
begin
COMMENT($04);
PULTOS;
TTXT("	POP	DI|	MOV	[DI],AL|");
TOS:=STACKED;
end;


procedure DOCALL(L);
int L;
begin
STKTOS;
TTXT("	CALL	L"); INTOUT(BINDEV,L); CRLF(BINDEV);
TOS:=STACKED;
OLDLEV:=-1;	\CAL MAY HAVE BOMBED IT?
end;


proc GENCAL(L);
\$05
int L;
begin
COMMENT($05);
DOCALL(L);
end;


proc GENRET(L);
\$06
int L;
begin
if LASTOP=$06 then return;	\AVOID DUPLICATE RETS
COMMENT($06);
STKTOS;
if L=0 then DOEXIT
else	begin
	TTXT("	MOV	AX,BASE"); INTOUT(BINDEV,L/2);
	TTXT("|	MOV	HP,AX|");
	TTXT("	POP	BASE"); INTOUT(BINDEV,L/2);
	TTXT("|	RETF|")
	end;
end;


proc GENJMP(L);
\$07
int L;
begin
COMMENT($07);
STKTOS;		\CLEAN UP?
TTXT("	JMP	L"); INTOUT(BINDEV,L); CRLF(BINDEV);
TOS:=STACKED;
end;


proc GENFJMP(L);
\GENERATE FAR JUMP FOR FPROCS
int L;
begin
COMMENT($07);
STKTOS;		\CLEAN UP?
TTXT("	JMP FAR PTR L"); INTOUT(BINDEV,L); CRLF(BINDEV);
TOS:=STACKED;
end;



proc GENJPC(L);
\$08
int L;
begin
COMMENT($08);
PULTOS;
TTXT("	OR	AX,AX|	JNZ	");
LOCOUT;
TTXT("|	JMP	L");
INTOUT(BINDEV,L);
CRLF(BINDEV);
LOCOUT; TTXT(":");
TOS:=STACKED;
LOCAL:=LOCAL+1;
end;


proc GENHPI(L,V);
\$09
int L,V;	\V=number of bytes to reserve
begin		\WARNING: V can appear negative because of array declarations
COMMENT($09);
\STKTOS;		\\WE NEED THE AC

\TTXT("	PUSH	BASE");
\INTOUT(BINDEV,L/2);
\TTXT("|	MOV	AX,HP|	MOV	BASE");
\INTOUT(BINDEV,L/2);
\TTXT(",AX|	ADD	HP,");

TTXT("	ADD	HP,");
INTOUT(BINDEV,V);
CRLF(BINDEV);
end;


proc GENBASE(L,V);
\$09-1/2
int L,V;	\WARNING: V is unsigned and can appear negative
begin
COMMENT($09);
STKTOS;		\WE NEED THE AC

TTXT("	PUSH	BASE");
INTOUT(BINDEV,L/2);
TTXT("|	MOV	AX,HP|	MOV	BASE");
INTOUT(BINDEV,L/2);
TTXT(",AX|");
end;


proc GENARG(V);
\$0A
int V,V1;
begin
COMMENT($0A);
STKTOS;		\WE NEED THE AC
if V<=6 then
	begin
	TTXT("	MOV	DI,HP|");
	if V>4 then TTXT("	POP	[DI]+4|");
	if V>2 then TTXT("	POP	[DI]+2|");
	TTXT("	POP	[DI]|");
	end
else
	begin
\	TTXT("	MOV	CX,");
\	INTOUT(BINDEV,V/2);
\	TTXT("|	MOV	DI,HP|@@:	POP	[DI]+");
\	INTOUT(BINDEV,V-2);
\	TTXT("|	SUB	DI,2|	LOOP	@B|");

	TTXT("	MOV	CX,");
	INTOUT(BINDEV,V/2);
	TTXT("|	MOV	DI,HP|");
	LOCOUT; TTXT(":	POP	[DI]+");
	INTOUT(BINDEV,V-2);
	TTXT("|	SUB	DI,2|	LOOP	");
	LOCOUT;
	CRLF(BINDEV);
	LOCAL:=LOCAL+1;
	end;
end;	\GENARG


proc GENIMM(F,V);
\$0B & $24
int F,V;
begin
COMMENT($0B);
STKTOS;		\CLEAN UP
IMMTYP:=F; IMMVAL:=V;
TOS:=IMAGE;
end;


proc GENCML(LABEL,TYPE,FUNC,ARG);
\$0C 
int LABEL,TYPE,FUNC,ARG;
begin
COMMENT($0C);
if ARG>0 &  TYPE=ININT then PULTOS else STKTOS;

TTXT("	CALL	INTR");
INTOUT(BINDEV, LABEL);
if LABEL=12 & STRTERM=0 then CHOUT(BINDEV, ^A);	\use alternate Text intrinsic
CRLF(BINDEV);

OLDLEV:=-1;
TOS:=if (TYPE=ININT) & FUNC  then INREG else STACKED;
end;


proc GENADD;
\$0D
begin
PULTOS;
TTXT("	POP	CX|	ADD	AX,CX|");
TOS:=INREG;
end;


proc GENSUB;
\$0E
begin
PULTOS;
TTXT("	MOV	BP,SP|	SUB	[BP],AX|");
TOS:=STACKED;
end;


proc GENMUL;
\$0F
begin
PULTOS;
TTXT("	POP	BX|	IMUL	BX|");
TOS:=INREG;
end;


proc GENDIV;
\WARNING: IF YOU MODIFY THIS ROUTINE YOU MUST
\ MODIFY "DVZHAN" IN NATIVE.XPL OR DIVIDE BY ZERO
\ WON'T BE TRAPPED PROPERLY
\$10
begin
PULTOS;
TTXT("	 MOV	BX,AX|	POP	AX|	CWD|");
TTXT("	IDIV	BX|	MOV	REMAIN,DX|");
TOS:=INREG;
end;


proc GENNEG;
\$11
begin
COMMENT($11);
PULTOS;
TTXT("	NEG	AX|");
TOS:=INREG;
end;


proc FCMP(T);
\$32-$37
int T;
int CMPT;
begin
CMPT:=["FEQDO|","FNEDO|","FGEDO|","FGTDO|","FLEDO|","FLTDO|"];
STKTOS;
TTXT("	CALL	");
TTXT(CMPT(T-$32));
TOS:=STACKED;
OLDLEV:=-1;
end;


proc ICMP(I);
\$12-$17
int I;
int CMPT;
begin
CMPT:=[
"	JE	$+3|",
"	JNE	$+3|",
"	JGE	$+3|",
"	JG	$+3|",
"	JLE	$+3|",
"	JL	$+3|"];
PULTOS;
TTXT("	POP	BX|	CMP	BX,AX|	MOV	AX,TRUVAL|");
TTXT(CMPT(I-$12));
TTXT("	INC	AX|");
TOS:=INREG;
end;


proc GENCMP(T);
\SELECT INTEGER OR REAL COMPARES
int T;
begin
COMMENT(T);
if T>$17 then FCMP(T) else ICMP(T);
end;


\For Loop now at the end of the block for speed

proc GENINP(L,O,DOWNTO);
\$19,$4A
int L,O,DOWNTO;
begin
COMMENT(if DOWNTO then $4A else $19);
STKTOS;

if DOWNTO then
	begin
	if L=0 then TTXT("	DEC	HEAPLO+")
	else [NEWLEVEL(L); TTXT("	DEC	WORD PTR [SI]+")];
	end
else	begin
	if L=0 then TTXT("	INC	HEAPLO+")
	else [NEWLEVEL(L); TTXT("	INC	WORD PTR [SI]+")];
	end;
INTOUT(BINDEV,O); CRLF(BINDEV);
end;


proc GENFOR(LEV,OFF,LAB,DOWNTO);
\$18,$49
int LEV,OFF,LAB,DOWNTO;
begin
COMMENT(if DOWNTO then $49 else $18);
if LEV=0 then TTXT("	MOV	AX,HEAPLO+") else
	TTXT("	MOV	AX,[SI]+");
INTOUT(BINDEV,OFF);
TTXT("|	MOV	BP,SP|	CMP	AX,[BP]|	");
TTXT(if DOWNTO then "JL	" else "JG	");
LOCOUT;
TTXT("|	JMP	L"); INTOUT(BINDEV,LAB); CRLF(BINDEV);
LOCOUT; TTXT(":");
TTXT("	ADD	SP,2|");

LOCAL:=LOCAL+1;
TOS:=STACKED;
end;


proc GENOR;
\$1A
begin
COMMENT($1A);
PULTOS;
TTXT("	POP	BX|	OR	AX,BX|");
TOS:=INREG;
end;


proc GENAND;
\$1B
begin
COMMENT($1B);
PULTOS;
TTXT("	POP	BX|	AND	AX,BX|");
TOS:=INREG;
end;


proc GENNOT;
\$1C
begin
COMMENT($1C);
PULTOS;
TTXT("	NOT	AX|");
TOS:=INREG;
end;


proc GENEOR;
\$1D
begin
COMMENT($1D);
PULTOS;
TTXT("	POP	CX|	XOR	AX,CX|");
TOS:=INREG;
end;


proc GENDBA;
\$1E
begin
COMMENT($1E);
PULTOS;
TTXT("	SAL	AX,1|	MOV	BP,SP|	ADD	[BP],AX|");
TOS:=STACKED;
end;


proc GENSTD;
\$1F
begin
COMMENT($1F);
PULTOS;
TTXT("	POP	DI|	MOV	[DI],AX|");
TOS:=STACKED;
end;


proc GENDBX;
\$20
begin
COMMENT($20);
PULTOS;
TTXT("	SAL	AX,1|	POP	DI|");
TTXT("	MOV	BX,AX|	MOV	AX,[BX+DI]|");
TOS:=INREG;
end;


proc GENADR(L,O);
\$21
int L,O;	\WARNING: O is unsigned and can appear negative
begin
COMMENT($21);
STKTOS;

if L=0 then
	begin
	TTXT("	LEA	AX,HEAPLO+");
	INTOUT(BINDEV,O); CRLF(BINDEV);
	end
else
	begin
	NEWLEVEL(L);
	TTXT("	MOV	AX,"); INTOUT(BINDEV,O);
	TTXT("|	ADD	AX,SI|");
	end;
TOS:=INREG;
end;


proc GENLDI;
\$22
begin
COMMENT($22);
STKTOS;
TTXT("	MOV	BX,AX|	MOV	BX,[BX]|");
TOS:=STACKED;
end;


proc GENCJP(L);
\$25
int L;
begin
COMMENT($25);
PULTOS;
TTXT("	MOV	BP,SP|	CMP	[BP],AX|	JE	");
LOCOUT;
TTXT("|	JMP	L"); INTOUT(BINDEV,L); CRLF(BINDEV);
LOCOUT; TTXT(":");
TOS:=STACKED;
LOCAL:=LOCAL+1;
end;


proc GENJSR(L);
\$26
int L;
begin
COMMENT($26);
DOCALL(L);
end;


proc GENRTS;
\$27
begin
if LASTOP=$27 then return;	\AVOID DUPLICATE RTSS
COMMENT($27);
STKTOS;		\I SUPPOSE?
TTXT("	RETF|");
TOS:=STACKED;
end;


proc GENDRP;
\$28
begin
COMMENT($28);
if TOS=STACKED	\BE SURE IT'S IN THE AC
 then TTXT("	POP	AX|");
TOS:=STACKED;	\AND THEN PRETENT IT IS NOT
end;


procedure GENCEXT(LABEL,TYPE,FUNC,ARG);		\CALL EXTERNAL XPL ROUTINE
\$29
int LABEL,TYPE,FUNC,ARG;
begin
COMMENT($29);
STKTOS;
TTXT("	CALL	_"); SYMOUT(LABEL); CRLF(BINDEV);
OLDLEV:=-1;
TOS:=STACKED;
end;



procedure GENAEXT(LABEL,TYPE,FUNC,ARG);		\CALL EXTERNAL ASSEMBLY ROUTINE
\$29 A
int LABEL,TYPE,FUNC,ARG;
begin
COMMENT($29);
STKTOS;
TTXT("	CALL	"); SYMOUT(LABEL); CRLF(BINDEV);
OLDLEV:=-1;
TOS:=STACKED;
end;



proc GENFLOD(L,O);
\$2A
int L,O;
begin
COMMENT($2A);
STKTOS;
NEWLEVEL(L);
TTXT("	MOV	BX,"); INTOUT(BINDEV,O);
TTXT("|	CALL	FLODDO|");
TOS:=STACKED;
end;


proc GENFSTO(L,O);
\$2B
int L,O;
begin
COMMENT($2B);
STKTOS;
NEWLEVEL(L);
TTXT("	MOV	BX,"); INTOUT(BINDEV,O);
TTXT("|	CALL	FSTODO|");
TOS:=STACKED;
end;


proc GENFIMM(T,V);
\$2C
int T,V;
int W,P;
begin
COMMENT($2C);
STKTOS;		\CLEAN UP
if T=^C then
	begin
	P:=addr RLATOM;
	TTXT("	MOV	BP,SP|	SUB	SP,8|");
	for W:=0,RLSIZE/2-1 do
		begin
		TTXT("	MOV	WORD PTR [BP]-");
		INTOUT(BINDEV,(W*2)+2);
		TTXT(",0");
		HEXOUT(BINDEV,P(W));
		TTXT("H|");
		end;
	end
else if T=^L then
	begin
	TTXT("	MOV	BP,SP|	SUB	SP,8|");
	TTXT("	MOV	WORD PTR [BP]-2,OFFSET L");
	INTOUT(BINDEV,V);
	TTXT("|	MOV	WORD PTR [BP]-4,0|");
	TTXT("	MOV	WORD PTR [BP]-6,0|");
	TTXT("	MOV	WORD PTR [BP]-8,0|");
	CRLF(BINDEV);
	end
else ERROR(10);
end;


proc FMATH(T);
\$2D-$30
int T,OSTR;
begin
OSTR:=["FADDDO|","FSUBDO|","FMULDO|","FDIVDO|"];

STKTOS;
TTXT("	CALL	");
TTXT(OSTR(T-$2D));
TOS:=STACKED;
OLDLEV:=-1;
end;


proc GENMTH(T);
\SELECT REAL OR INTEGER MATH OPS
int T;
begin
COMMENT(T);
if T>$11 then FMATH(T) else
	case T of
	  $0D: GENADD;
	  $0E: GENSUB;
	  $0F: GENMUL;
	  $10: GENDIV
	other;
end;	\GENMTH


proc GENFNEG;
\$31
begin
COMMENT($31);
STKTOS;
TTXT("	MOV	BP,SP|	XOR	[BP+6],8000H|");
end;


proc GENTRA;
\$38
begin
COMMENT($38);
PULTOS;
TTXT("	MOV	CL,3|	SHL	AX,CL|	POP	CX|	ADD	AX,CX|");
TOS:=INREG;
end;


proc GENTRX;
\$39
begin
COMMENT($39);
PULTOS;
TTXT("	MOV	BX,AX|	MOV	CL,3|	SHL	BX,CL|");
TTXT("	POP	DI|	MOV	AX,[BX+DI]|");
TOS:=INREG;
end;


proc GENTRI;
\$3A
begin
COMMENT($3A);
PULTOS;
TTXT("	CALL	TRIDO|");
TOS:=STACKED;
end;


proc GENSTT;
\$3B
begin
COMMENT($3B);
STKTOS;
TTXT("	CALL	STTDO|");
TOS:=STACKED;
end;


proc GENMARK;
\$3C
COMMENT($3C);


proc GENASR;
\$3D
begin
COMMENT($3D);
PULTOS;
TTXT("	MOV	CX,AX|	POP	AX|	SAR	AX,CL|");
TOS:=INREG;
end;


proc GENLSL;
\$3E
begin
COMMENT($3E);
PULTOS;
TTXT("	MOV	CX,AX|	POP	AX|	SHL	AX,CL|");
TOS:=INREG;
end;


proc GENLSR;
\$3F
begin
COMMENT($3F);
PULTOS;
TTXT("	MOV	CX,AX|	POP	AX|	SHR	AX,CL|");
TOS:=INREG;
end;



proc GENLDSI;
\$40
begin
COMMENT($40);
PULTOS;
TTXT("	SAL	AX,1|	MOV	BX,AX|	POP	DS|");
TTXT("	MOV	AX,[BX]|	MOV	BX,SS|	MOV	DS,BX|");
TOS:=INREG;
end;



proc GENLDSB;
\$41
begin
COMMENT($41);
PULTOS;
TTXT("	MOV	BX,AX|	POP	DS|	MOV	AL,[BX]|");
TTXT("	XOR	AH,AH|	MOV	BX,SS|	MOV	DS,BX|");
TOS:=INREG;
end;



proc GENLDSR;
\$42
begin
COMMENT($42);
PULTOS;
TTXT("	CALL	LDSRDO|");
TOS:=STACKED;
end;



proc GENSTSI;
\$43
begin
COMMENT($43);
PULTOS;
TTXT("	POP	BX|	SAL	BX,1|	POP	DS|");
TTXT("	MOV	[BX],AX|	MOV	BX,SS|	MOV	DS,BX|");
TOS:=STACKED;
end;



proc GENSTSB;
\$44
begin
COMMENT($44);
PULTOS;
TTXT("	POP	BX|	POP	DS|");
TTXT("	MOV	[BX],AL|	MOV	BX,SS|	MOV	DS,BX|");
TOS:=STACKED;
end;



proc GENSTSR;
\$45
begin
COMMENT($45);
STKTOS;
TTXT("	CALL	STSRDO|");
TOS:=STACKED;
end;



proc GENLSHORT;
\$46
begin
COMMENT($46);
PULTOS;
TTXT("	CALL	LSHORT|");
TOS:=STACKED;
end;



proc GENSSHORT;
\$47
begin
COMMENT($47);
STKTOS;
TTXT("	CALL	SSHORT|");
TOS:=STACKED;
end;


proc GENARY;	\ARRAY DECLARATION
\$48
begin
COMMENT($48);
STKTOS;
TTXT("	CALL	MKARRAY|");
OLDLEV:=-1;
TOS:=STACKED;
end;


proc GENABS;	\ABSOLUTE VALUE FUNCTION
\$49
begin
COMMENT($49);
PULTOS;
TTXT("	NEG	AX|	JL	$-2|");		\BEWARE OF JS AND $8000
TOS:=INREG;					\(THANKS! RUUD)
end;


proc GENFABS;	\ABSOLUTE VALUE FUNCTION OF A REAL
\$4A
begin
COMMENT($4A);
STKTOS;
TTXT("	MOV	BP,SP|	AND	BYTE PTR [BP+7],7FH|");
end;


proc GENREM;	\REMAINDER OF LAST DIVIDE
\$4B
begin
COMMENT($4B);
PULTOS;		\DISCARD TOS
TTXT("	MOV	AX,REMAIN|");
TOS:=INREG;
end;


proc GENSWAP;	\SWAP BYTES FUNCTION
\$4C
begin
COMMENT($4C);
PULTOS;
TTXT("	XCHG	AH,AL|");
TOS:=INREG;
end;


proc GENEXT;	\SIGN EXTEND FUNCTION
\$4D
begin
COMMENT($4D);
PULTOS;
TTXT("	CBW|");
TOS:=INREG;
end;


proc GENPIN;	\$4E, FUNCTION TO READ A BYTE FROM A PORT
begin		\TOS:= port(TOS);
COMMENT($4E);
PULTOS;
TTXT("	MOV	DX,AX|	IN	AL,DX|	XOR	AH,AH|");
TOS:=INREG;
end;


proc GENPOUT;	\$4F, FUNCTION TO WRITE A BYTE TO A PORT
begin
COMMENT($4F);
PULTOS;
TTXT("	POP	DX|	OUT	DX,AL|");
TOS:=STACKED;
end;


proc GENEND;
\$FE
begin
COMMENT($FE);
TTXT("CSEG	ENDS|	END|");
end;


proc GENSTART;
begin
TTXT("	INCLUDE	RUNTIME.ASM|CSEG	SEGMENT DWORD PUBLIC 'CODE'|PROGRM:|");
end;


proc GENNUL;
\$FF
[COMMENT($FF); CRLF(BINDEV)];


proc DSTART;
TTXT("|DSEG	SEGMENT WORD PUBLIC 'DATA'|");


proc DEND;
TTXT("DSEG	ENDS|");

\----------------------------------------------------------------------

proc STARTSEG(LEV,SEG);
\START A NEW CODE SEGMENT
int LEV,SEG;

	proc PUTSYMBOL;
	\OUTPUT SYMBOLS
	begin
	TTXT("CSEG");
	if LEV#0 then
		begin
		CHOUT(BINDEV,^_);
		TEXT(BINDEV,FNAME);
		CHOUT(BINDEV,^_);
		INTOUT(BINDEV,SEG);
		end;
	end;

begin
TTXT("@curseg	ENDS||");
PUTSYMBOL;
TTXT("	SEGMENT DWORD PUBLIC 'CODE'|	ASSUME	CS:");
PUTSYMBOL;
CRLF(BINDEV);
end;	\STARTSEG


proc DLABEL(N);
\MAKE DATA LABEL
int N;
begin
if HASLAB then GENNUL;
TTXT("|L");
INTOUT(BINDEV,N);
HASLAB:=true;
end;


proc FLABEL(N);
\MAKE A FAR CODE LABEL
int N;
begin
STKTOS;
DLABEL(N);
TTXT("	LABEL	FAR|");
LASTOP:=-1; OLDLEV:=-1;
end;


proc CLABEL(N);
\MAKE A CODE LABEL
int N;
begin
STKTOS;
DLABEL(N); CHOUT(BINDEV,^:);
LASTOP:=-1;
OLDLEV:=-1;
end;


proc NEWLAB;
begin
LABCNT:=LABCNT+1;
return LABCNT;
end;

\======================================================================

proc	LOOKUP;		\LOOKUP IDENTIFIER IN SYMBOL TABLE
\INPUTS: IDENT, HASH
\OUTPUTS: IDTYPE, VAL, LEV, SYMNUM.
\IF TWO IDENTIFIERS OF THE SAME NAME ARE IN THE SYMBOL TABLE
\ THEN THE MOST RECENT ENTRY IS USED.
int	I,K,PNTR;
begin
PNTR:=BOX(HASH);
loop	begin
	if PNTR=EMTPNT then [IDTYPE:=UNDEF; quit];
	I:=0; K:=PNTR;
	while IDENT(I)=SYMBOL(K) & I<SIGCHAR do
		[I:=I+1; K:=K+SYMAX];
	if I=SIGCHAR then	\FOUND
		[IDTYPE:=SYMTYP(PNTR);
		VAL:=SYMVAL(PNTR);
		LEV:=SYMLEV(PNTR);
		SYMNUM:=PNTR;		\(FOR FORWARD PROC)
		quit];
	PNTR:=SYMPNT(PNTR);
	end;
end;	\LOOKUP



proc	INSERT; int STYP,SLEV,SVAL;
\INSERT THE CURRENT IDENTIFIER INTO THE SYMBOL TABLE
\INPUTS:  STYP, SLEV, SVAL, IDENT, HASH, NOSYM, SYMBOL, & BOX.
int	I,K;
begin
LOOKUP;
if IDTYPE#UNDEF then if LEV=LEVEL then \COLLISION\ ERROR(11);
if NOSYM>=SYMAX then \TABLE FULL\ [ERROR(3); NOSYM:=SYMAX-1];
K:=NOSYM;
for I:=0,SIGCHAR-1 do [SYMBOL(K):=IDENT(I); K:=K+SYMAX];
SYMTYP(NOSYM):=STYP;
SYMLEV(NOSYM):=SLEV;
SYMVAL(NOSYM):=SVAL;
SYMPNT(NOSYM):=BOX(HASH);		\LINK BACK
BOX(HASH):=NOSYM;
NOSYM:=NOSYM+1;
end;	\INSERT



proc	GETCON;	\GET A CONSTANT--EITHER BY VALUE OR BY NAME
int	NEG;
begin
if ATOM=^+ then RATOM;
if ATOM=^- then [NEG:=true; RATOM] else NEG:=false;
case ATYPE of
  INTCON: [if NEG then IATOM:=-IATOM; FACTYP:=INTEGER];
  REALCON:[if NEG then RLATOM:=-RLATOM; FACTYP:=REAL];
  IDENTIFIER:
	begin
	LOOKUP;
	case IDTYPE of
	 INCON:	[IATOM:=if NEG then -VAL else VAL;
		FACTYP:=INTEGER];
	 RLCON:	[RLATOM:=if NEG then-RLTBL(VAL)else RLTBL(VAL);
		FACTYP:=REAL]
	other	ERROR(42);
	end
other	ERROR(42);
end;	\GETCON



proc	CONEXPRESS;	\EVALUATE CONSTANT EXPRESSIONS
\OUTPUTS FACTYP, IATOM, RLATOM
int	SFACTYP,ITEMP,IFVAR;
real	RTEMP;


	proc INTTEST;		\TEST FOR INTEGER ERRORS
	if FACTYP # INTEGER then ERROR(47);


	proc MIXTEST(TYPE);	\TEST FOR MIXED MODE ERRORS
	int TYPE;
	if TYPE#FACTYP then ERROR(46);



	proc	CFACTOR;
	begin
	if ATOM=^( then
		begin
		RATOM;
		CONEXPRESS;
		if ATOM#^) then ERROR(44);		
		end
	else GETCON;
	RATOM;
	end;	\CFACTOR



	proc	CSHIFTEXP;
	int	ITEMP;
	begin
	CFACTOR;
	ITEMP:=IATOM;
	case ATOM of
	LSLSYM:	begin
		INTTEST;
		RATOM;
		CFACTOR;
		INTTEST;
		IATOM:=ITEMP << IATOM;
		end;	
	LSRSYM:	begin
		INTTEST;
		RATOM;
		CFACTOR;
		INTTEST;
		IATOM:=ITEMP >> IATOM;
		end;
	ASRSYM:	begin
		INTTEST;
		RATOM;
		CFACTOR;
		INTTEST;
		IATOM:=ITEMP ->> IATOM;
		end
	other;
	end;	\CSHIFTEXP



	proc	CTERM;
	int	SFACTYP;
	int	ITEMP;
	real	RTEMP;
	begin
	CSHIFTEXP;
	SFACTYP:=FACTYP;
	loop	begin
		ITEMP:=IATOM; RTEMP:=RLATOM;
		case ATOM of
		  ^*:	begin
			RATOM;
			CSHIFTEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:=ITEMP * IATOM
				else RLATOM:=RTEMP * RLATOM;
			end;
		  ^/:	begin
			RATOM;
			CSHIFTEXP;
			MIXTEST(SFACTYP);
			if IATOM=0 ! RLATOM=0.0 then ERROR(73) \Divide by zero
			else if FACTYP=INTEGER then IATOM:=ITEMP / IATOM
				else RLATOM:=RTEMP / RLATOM;
			end
		other	quit;
		end;
	end;	\CTERM



	proc	CALGEXP;	\ALGEBRIAC EXPRESSION
	int	SFACTYP;
	int	ITEMP;
	real	RTEMP;
	begin
	CTERM;
	SFACTYP:=FACTYP;
	loop	begin
		ITEMP:=IATOM; RTEMP:=RLATOM;
		case ATOM of
		  ^+:	begin
			RATOM;
			CTERM;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:=ITEMP + IATOM
			else RLATOM:=RTEMP + RLATOM;
			end;
		  ^-:	begin
			RATOM;
			CTERM;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:=ITEMP - IATOM
				else RLATOM:=RTEMP - RLATOM;
			end
		other	quit;
		end;
	end;	\CALGEXP



	proc	CLOGEXP;	\'NOT' AND COMPARISONS
	int	SFACTYP;
	int	ITEMP;
	real	RTEMP;
	begin
	if ATOM=NOTSYM ! ATOM=^~ then	\UNARY 'NOT' OPERATOR
		begin
		RATOM;
		CLOGEXP;
		INTTEST;
		IATOM:= ~IATOM;
		end
	else	begin
		CALGEXP;
		SFACTYP:=FACTYP;
		ITEMP:=IATOM; RTEMP:=RLATOM;
		case ATOM of
		 ^=:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP = IATOM
			else IATOM:= RTEMP = RLATOM;
			FACTYP:=INTEGER];
		 ^#:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP # IATOM
			else IATOM:= RTEMP # RLATOM;
			FACTYP:=INTEGER];
		 ^>:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP > IATOM
			else IATOM:= RTEMP > RLATOM;
			FACTYP:=INTEGER];
		 ^<:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP < IATOM
			else IATOM:= RTEMP < RLATOM;
			FACTYP:=INTEGER];
		 GESYM:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP >= IATOM
			else IATOM:= RTEMP >= RLATOM;
			FACTYP:=INTEGER];
		 LESYM:	[RATOM;
			CALGEXP;
			MIXTEST(SFACTYP);
			if FACTYP=INTEGER then IATOM:= ITEMP <= IATOM
			else IATOM:= RTEMP <= RLATOM;
			FACTYP:=INTEGER]
		other	[];
		end;
	end;	\CLOGEXP



	proc	CBOOLTERM;	\BOOLEAN "&" EXPRESSIONS
	int	ITEMP;
	begin
	CLOGEXP;
	loop	begin
		ITEMP:=IATOM;
		if ATOM=^& then
			begin
			INTTEST;
			RATOM;
			CLOGEXP;
			INTTEST;
			IATOM:=ITEMP & IATOM;
			end
		else quit;
		INTTEST;
		end;
	end;	\CBOOLTERM



begin	\CONEXPRESS
TRAP(false);
if ATOM=IFSYM then		\'IF' EXPRESSION
	begin
	RATOM;
	CONEXPRESS;
	INTTEST;
	IFVAR:=IATOM;
	if ATOM#THENYM then ERROR(22);
	RATOM;
	CONEXPRESS;
	SFACTYP:=FACTYP;
	ITEMP:=IATOM; RTEMP:=RLATOM;
	if ATOM#ELSEYM then ERROR(30);
	RATOM;
	CONEXPRESS;
	MIXTEST(SFACTYP);
	if IFVAR then 
		if FACTYP=INTEGER then IATOM:=ITEMP
		else RLATOM:=RTEMP;
	end
else	begin
	CBOOLTERM;
	loop	begin
		ITEMP:=IATOM;
		case ATOM of
		  ^!:	begin
			INTTEST;
			RATOM;
			CBOOLTERM;
			INTTEST;
			IATOM:=ITEMP ! IATOM;
			end;
		  ^|:	begin
			INTTEST;
			RATOM;
			CBOOLTERM;
			INTTEST;
			IATOM:=ITEMP | IATOM;
			end
		other quit;
		end;
	end;
TRAP(true);
if GETERR#0 then ERROR(74);	\GENERAL MATH ERROR
end;	\CONEXPRESS



fproc	BOOLEXP;



proc	PROCAL(FUNC);
int	FUNC;	\TRUE IF FUNCTION VS PROCEDURE
int	SVAL,SLEV,ARGCNT,SID,CURSYM;
begin
SVAL:=VAL; SLEV:=LEV; SID:=IDTYPE; CURSYM:=SYMNUM;
RATOM;
ARGCNT:=0;
if ATOM=^( then
	begin
	if SID>=INPROC & SID<=RLFPROC then	\NORMAL PROCEDURE CALL
		GENMARK;		\WITH ARGS
	repeat	[RATOM; 
		BOOLEXP;
		ARGCNT:=ARGCNT +(if FACTYP=INTEGER then
			2 else RLSIZE)]
	until ATOM#^,;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
case of
SID>=INPROC & SID<=RLFPROC:	\NORMAL PROCEDURE CALL
	[if ARGCNT>0 then GENARG(ARGCNT);
	GENCAL(SVAL)]

other case SID of
ININT,RLINT: GENCML(SVAL,SID,FUNC,ARGCNT);	\INTRINSIC PROCEDURE CALL
INOPT,RLOPT:					\OPTIMIZED PROCEDURE CALL
	[if ARGCNT>0 then ERROR(51); \NO ARG DECLARED
	GENJSR(SVAL)];
INEXT,RLEXT: GENAEXT(CURSYM,SID,FUNC,ARGCNT);	\EXTERNAL ASSEMBLY CALL
INEPRO,RLEPRO:					\EXTERNAL XPL CALL
	[if ARGCNT>0 then GENARG(ARGCNT);
	GENCEXT(CURSYM,SID,FUNC,ARGCNT)]
other;
end;	\PROCAL



proc	BOOLEXP;	\BOOLEAN EXPRESSION
\OUTPUTS FACTOR TYPE (FACTYP)
int	P1,P2,SFACTYP;



proc	FACTOR;



func	STRCON;	\Generate code for a string constant and return its address
int	SPC,	\label number of starting address of string
	ASC,	\flag: last output was in ASCII format (vs. BINARY)
	CTR,	\count of characters on current line of output
	NCHAR,	\next character (one character look ahead)
	DONE;	\flag: terminating quote mark has been read in


	proc	GETNEXTCH;	\Get next chararacter
	begin
	CHAR:= NCHAR; NCHAR:= CHIN(SRCDEV);
	if NCHAR=EOF then [ERROR(63); exit 1];
	CHOUT(LSTDEV, NCHAR);
	if NCHAR=^^ then
		begin		\convert to control characters, except ^ and Del
		NCHAR:=CHIN(SRCDEV);
		if NCHAR=EOF then [ERROR(63); exit 1];
		CHOUT(LSTDEV,NCHAR);
		if NCHAR>=^@ & NCHAR<=^_ & NCHAR#^^ then NCHAR:=NCHAR-^@;
		if NCHAR>=^` & NCHAR<=^~ then NCHAR:=NCHAR-^`;
		end
	else if NCHAR=^" then	\terminating quote mark
		begin
		if STRTERM \#0\ then CHAR:= CHAR!$80;	\terminate with MSB set
		DONE:= true;
		end;
	end;	\GETNEXTCH


	proc	BINMODE;	\Output character as a decimal (binary) value
	begin
	if CTR#0 & ASC then CHOUT(BINDEV, ^");	\terminate ASCII string, if any
	if CTR#0 then CHOUT(BINDEV, ^,);	\output separator, if necessary
	INTOUT(BINDEV, CHAR);
	ASC:= false;		\no longer in ASCII mode
	end;	\BINMODE


	proc	ASCMODE;	\Output character as an ASCII value
	begin
	if CTR=0 then CHOUT(BINDEV, ^")		\begin ASCII string else
	else if not ASC then TEXT(BINDEV, ",^""); \separate binary part first
	CHOUT(BINDEV, CHAR);
	ASC:= true;		\now in ASCII mode
	end;	\ASCMODE


begin	\STRCON		Enter with CHAR = first character in string (or close ")
COMMENT($FB);
SPC:= NEWLAB;		\make a label at the starting address of the string
DLABEL(SPC);

if CHAR#^" then		\in case of null string (i.e: ""; must be 0 terminated)
	begin
	if CHAR=^^ then
		begin		\convert to control characters, except ^ and Del
		CHAR:=CHIN(SRCDEV);
		if CHAR=EOF then [ERROR(63); exit 1];
		CHOUT(LSTDEV,CHAR);
		if CHAR>=^@ & CHAR<=^_ & CHAR#^^ then CHAR:=CHAR-^@;
		if CHAR>=^` & CHAR<=^~ then CHAR:=CHAR-^`;
		end;
	NCHAR:= CHAR;			\so GETNEXTCH restores CHAR
	ASC:= false;
	DONE:= false;
	CTR:= 0;
	loop	begin
		GETNEXTCH;
		if CTR=0 then TEXT(BINDEV, "	DB	");	\new output line

		case of
		  CHAR=^', CHAR=^":	\assembler uses these for delimiters
				BINMODE;
		  CHAR>=$20:	ASCMODE;\non-control characters
		  CHAR=$09:	ASCMODE	\accept tab in ASCII, for readability
		other	BINMODE;
		CTR:= CTR+1;

		if DONE then [if ASC then CHOUT(BINDEV, ^"); quit];

		if CTR >= 40 then
			begin
			if ASC then CHOUT(BINDEV, ^");
			CRLF(BINDEV);
			CTR:= 0;
			end;
		end;	\loop
	CRLF(BINDEV);
	end;

if STRTERM = 0 then TTXT("	DB	0|");	\terminate with null

GETCH;
FACTYP:= INTEGER;
return SPC;	\return label number for starting address of string
end;	\STRCON



func	ARRAYCON;	\CONSTANT ARRAYS
int	THISEL,NEXTEL,PNTR,SPC,I,INDIRECT,SFACTYP;
def	NULL=$FFFF;
char	ENTRY,R;

	proc ARRAYX;	\(THIS MUST BE AN OPTIMIZED PROCEDURE
	begin		\ FOR THE RESERVE TO WORK PROPERLY.)
	RATOM;
	INDIRECT:=true;
	case ATOM of
	  ^[:	[ENTRY:=ARRAYCON; RATOM];
	  ^":	[ENTRY:=STRCON; RATOM]
	other	begin
		INDIRECT:=false;
		CONEXPRESS;
		if FACTYP=INTEGER then ENTRY:=IATOM
		else	[ENTRY:=RESERVE(RLSIZE);  \FACTYP=REAL
			R:=addr RLATOM;
			for I:=0,RLSIZE-1 do ENTRY(I):=R(I)];
		end;
	NEXTEL:=RESERVE(6);
	THISEL(1):=ENTRY;
	THISEL(2):=INDIRECT;
	THISEL(0):=NEXTEL;
	NEXTEL(0):=NULL;
	THISEL:=NEXTEL;
	end;


begin	\ARRAYCON
PNTR:=RESERVE(6);
THISEL:=PNTR;
THISEL(0):=NULL;
ARRAYX;
while ATOM=^, do
	[SFACTYP:=FACTYP;
	ARRAYX;
	if FACTYP#SFACTYP then \MIXED MODE\ ERROR(46)];
if ATOM#^] then ERROR(50);
COMMENT(if FACTYP=INTEGER then $FD else $FC);

SPC:=NEWLAB;
DLABEL(SPC);
while PNTR(0)#NULL do		\DUMP LIST
	begin
	ENTRY:=PNTR(1);
	if FACTYP=INTEGER then
		begin
		TTXT("	DW	");
		if PNTR(2) \INDIRECT\ then CHOUT(BINDEV,^L);
		INTOUT(BINDEV,ENTRY);
		end
	else	begin	\(FACTYP=REAL)
		if PNTR(2) \INDIRECT\ then
			begin
			TTXT("	DW	L");
			INTOUT(BINDEV,ENTRY);
			TTXT("|	DW	0,0,0|" );
			end
		else	begin
			TTXT("	DQ	");
			CHOUT(BINDEV,^0);
			for I:=0,RLSIZE-1 do HEXB(ENTRY(RLSIZE-I-1));
			CHOUT(BINDEV,^H);
			end;
		end;
	PNTR:=PNTR(0);
	CRLF(BINDEV);
	end;
return SPC;	\RETURN STARTING ADDRESS OF ARRAY
end;	\ARRAYCON



proc	SPECFAC;	\SPECIAL CHARACTER FACTOR
int	SVAL, SPC, R, SID;
begin
case ATOM of
  ^(:	[RATOM;				\PARENTHESIZED EXPRESSION
	BOOLEXP;			\(FACTOR TYPE IS UNCHANGED)
	if ATOM#^) then ERROR(44);
	RATOM];
  ^":	[DSTART;			\STRING CONSTANT
	SVAL:= STRCON;
	DEND;
	GENIMM(^L, SVAL);
	RATOM];
  ^[:	[DSTART;			\CONSTANT ARRAY
	SVAL:= ARRAYCON;
	DEND;
	if FACTYP=INTEGER then GENIMM(^L, SVAL)
	else GENFIMM(^L, SVAL);		\FACTYP=REAL
	RATOM];
  ADRSYM:
	begin				\GET ABSOLUTE HEAP ADDRESS
	RATOM;
	if ATYPE#IDENTIFIER then ERROR(45);
	LOOKUP;
	case IDTYPE of
	  INVAR, RLVAR, ADDRVAR:
		begin
		SID:= IDTYPE;
		RATOM;
		if ATOM=^( then			\INDEXED
			begin
			GENLOD(LEV, VAL);	\(EVEN FOR REALS)
			RATOM;
			BOOLEXP;		\1ST INDEX
			if FACTYP#INTEGER then ERROR(47);
			while ATOM=^, do	\MULTIPLE INDEXING
				begin
				case SID of
				  INVAR, ADDRVAR: GENDBX;
				  RLVAR: GENTRX
				other [];
				RATOM;
				BOOLEXP;
				if FACTYP#INTEGER then ERROR(47);
				end;
			case SID of
			  INVAR: GENDBA;
			  RLVAR: GENTRA;
			  ADDRVAR: GENADD
			other [];
			if ATOM#^) then ERROR(44) else RATOM;
			end
		else	GENADR(LEV, VAL);
		end;

	  UNDEF:	ERROR(10)	\(UNDECLARED NAME)
	other		ERROR(43);	\(VARIABLE EXPECTED)
	FACTYP:= INTEGER;
	end;
  ABSSYM:
	begin				\ABSOLUTE VALUE FUNCTION
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP=INTEGER then GENABS else GENFABS;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
  REMSYM:
	begin				\REMAINDER OF LAST DIVIDE
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENREM;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
  SWAPYM:
	begin				\SWAP BYTES FUNCTION
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENSWAP;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
  EXTSYM:
	begin				\SIGN EXTEND FUNCTION
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENEXT;
	if ATOM#^) then ERROR(44) else RATOM;
	end;
  PORTYM:
	begin				\READ BYTE FROM PORT
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENPIN;
	if ATOM#^) then ERROR(44) else RATOM;
	end
other	\ILLEGAL FACTOR\ ERROR(26);
end;	\SPECFAC



proc	IDFAC;		\IDENTIFIER FACTOR
int	SLEV,SVAL,SID,SINDX;
begin	\IDFAC
LOOKUP;
SID:=IDTYPE;
case IDTYPE of
UNDEF:	ERROR(10);

INVAR, RLVAR, ADDRVAR:		\VARIABLE
	begin
	if SID=RLVAR then GENFLOD(LEV,VAL) else GENLOD(LEV,VAL);
	RATOM;
	if ATOM=^( then				\IT IS INDEXED
		begin
		loop	begin
			RATOM;
			BOOLEXP;
			if FACTYP#INTEGER then ERROR(47);
			if ATOM#^, then quit;
			if SID=RLVAR then GENTRI else GENDBX;
			end;
		if ATOM#^) then ERROR(44) else RATOM;
		case SID of
		 INVAR:   GENDBX;
		 RLVAR:   GENTRI;
		 ADDRVAR: GENLDX
		other	[];
		end;
	end;

INSEG, RLSEG, ADSEG, SHSEG:	\SEGMENT VARIABLE
	begin
	SINDX:=0;			\WATCH INDEX LEVEL
	GENLOD(LEV,VAL);
	RATOM;
	if ATOM=^( then		\HANDLE FIRST INDEX
		begin
		RATOM;
		BOOLEXP;
		if FACTYP#INTEGER then ERROR(47);
		GENDBX;
		if ATOM=^, then	\HANDLE SECOND INDEX
			begin
			SINDX:=2;	\FLAG TWO INDEXES
			RATOM;
			BOOLEXP;
			if FACTYP#INTEGER then ERROR(47);
			case SID of
			  INSEG: GENLDSI;
			  ADSEG: GENLDSB;
			  RLSEG: GENLDSR;
			  SHSEG: GENLSHORT
			other;
			end;
		if ATOM#^) then ERROR(44) else RATOM;
		end;
	\FORCE REAL TO BE INTEGER WHEN THERE ARE LESS THAN 2 INDEXES
	case SID of RLSEG,SHSEG: [if SINDX<2 then SID:=INSEG] other;
	end;

INCON:	begin	\INTEGER CONSTANT IDENTIFIER
	GENIMM(^C,VAL);
	RATOM;
	end;

RLCON:	begin	\REAL CONSTANT IDENTIFIER
	RLATOM:=RLTBL(VAL); GENFIMM(^C,0);
	RATOM;
	end

other	begin	\PROCEDURES USED AS FUNCTIONS (BY DEFAULT)
	PROCAL(true);
	if SID<ININT then
		if SID&1 then GENLOD(0,0) else GENFLOD(0,0);
	end;
FACTYP:=if SID & 1 then INTEGER else REAL; \ODD IDS ARE INTEGER
end;	\IDFAC


begin	\FACTOR
while ATOM=^+ do RATOM;			\IGNORE UNARY "+"
if ATOM=^- then				\UNARY "-"
	begin
	RATOM;
	FACTOR;
	if FACTYP=INTEGER then GENNEG else GENFNEG;
	end
else	case ATYPE of
	SPECIAL:SPECFAC;
	INTCON:	[FACTYP:=INTEGER;	\INTEGER CONSTANT
		GENIMM(^C,IATOM);
		RATOM];
	REALCON:[FACTYP:=REAL;		\REAL CONSTANT
		GENFIMM(^C,0);
		RATOM]
	other	IDFAC;	\ATYPE = IDENTIFIER (BY DEFAULT)
end;	\FACTOR



proc	SHIFTEXP;

	proc SHIFTX; int INOP;
	[if FACTYP # INTEGER then \INTEGER EXPECTED\ ERROR(47);
	RATOM; FACTOR;
	if FACTYP # INTEGER then ERROR(47)];

begin	\SHIFTEXP
FACTOR;
case ATOM of
  LSLSYM: [SHIFTX; GENLSL];	\<<
  LSRSYM: [SHIFTX; GENLSR];	\>>
  ASRSYM: [SHIFTX; GENASR]	\->>
other;
end;	\SHIFTEXP



proc	TERM;
int	SFACTYP;

	proc TERMX; int INOP,RLOP;
	[RATOM; SHIFTEXP;
	if SFACTYP#FACTYP then \MIXED MODE\ ERROR(46);
	GENMTH(if FACTYP=INTEGER then INOP else RLOP)];

begin	\TERM
SHIFTEXP;
SFACTYP:=FACTYP;
loop	case ATOM of
	  ^*:	TERMX(\MUL\$0F,\MULF\$2F);
	  ^/:	TERMX(\DIV\$10,\DIVF\$30)
	other	quit;
end;	\TERM


proc	ALGEXP;		\ALGEBRIAC EXPRESSION
int	SFACTYP;

	proc ALGX; int INOP,RLOP;
	[RATOM; TERM;
	if SFACTYP#FACTYP then \MIXED MODE\ ERROR(46);
	GENMTH(if FACTYP=INTEGER then INOP else RLOP)];

begin	\ALGEXP
TERM;
SFACTYP:=FACTYP;
loop	case ATOM of
	  ^+:	ALGX(\ADD\$0D,\ADDF\$2D);
	  ^-:	ALGX(\SUB\$0E,\SUBF\$2E)
	other	quit;
end;	\ALGEXP


proc	LOGEXP;		\LOGICAL EXPRESSION
int	SFACTYP;

	proc	LOGX; int INOP,RLOP;
	[RATOM; ALGEXP;
	if SFACTYP#FACTYP then \MIXED MODE\ ERROR(46);
	GENCMP(if FACTYP=INTEGER then INOP else RLOP);
	FACTYP:=INTEGER];

begin	\LOGEXP
if ATOM=NOTSYM ! ATOM=^~ then		\UNARY 'NOT' OPERATOR
	[RATOM; LOGEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENNOT]
else	[ALGEXP;
	SFACTYP:=FACTYP;
	case ATOM of
	 ^=:	LOGX(\EQ\$12,\EQF\$32);
	 ^#:	LOGX(\NE\$13,\NEF\$33);
	 ^>:	LOGX(\GT\$15,\GTF\$35);
	 ^<:	LOGX(\LT\$17,\LTF\$37);
	 GESYM:	LOGX(\GE\$14,\GEF\$34);
	 LESYM:	LOGX(\LE\$16,\LEF\$36)
	other;	];
end;	\LOGEXP


proc	BOOLTERM;	\Boolean "&" expressions
begin
LOGEXP;
loop	begin
	if ATOM=^& then
		[if FACTYP#INTEGER then ERROR(47);
		RATOM; LOGEXP; GENAND]
	else	quit;
	if FACTYP#INTEGER then ERROR(47);
	end;
end;	\BOOLTERM


proc BEXPX; int INOP;
begin
if FACTYP # INTEGER then \INTEGER EXPECTED\ ERROR(47);
RATOM; BOOLTERM;
if FACTYP # INTEGER then ERROR(47);
end;	\BEXPX


begin	\BOOLEXP
if ATOM=IFSYM then			\'IF' EXPRESSION
	[RATOM; BOOLEXP;
	P1:=NEWLAB;
	GENJPC(P1);
	if ATOM#THENYM then ERROR(22);
	RATOM; BOOLEXP; SFACTYP:=FACTYP;
	if ATOM#ELSEYM then ERROR(30);
	P2:=NEWLAB;
	GENJMP(P2);
	CLABEL(P1);
	RATOM; BOOLEXP;
	if SFACTYP#FACTYP then \MIXED MODE\ ERROR(46);
	CLABEL(P2)]
else	begin			\BOOLEAN "!" (OR) EXPRESSIONS
	BOOLTERM;
	loop	case ATOM of
		  ^!:	[BEXPX; GENOR];
		  ^|:	[BEXPX; GENEOR]
		other quit;
	end;
end;	\BOOLEXP


proc	SSTATEMENT; int SSTK;	\(FOR 'QUIT'S IN 'CASE' STMNTS)


proc	STATEMENT;
int	P2,P3,SFIXS,SLEV,SVAL,SFACTYP,I,DOWNTO;


proc	ASSIGN;		\ASSIGNMENT STATEMENT (ALSO INCLUDES PROCEDURE CALLS)
int	SID;

	proc	ASSX;
	[if ATOM#GETSYM then ERROR(21);
	RATOM;
	BOOLEXP];	\RIGHT-HAND SIDE OF ASSIGNMENT

begin	\ASSIGN
if ATOM=PORTYM then	\port($123):= boolexp
	begin
	RATOM;
	if ATOM#^( then ERROR(39) else RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	if ATOM#^) then ERROR(44) else RATOM;
	ASSX;
	GENPOUT;
	if FACTYP#INTEGER then ERROR(47);
	return;
	end;
if ATYPE#IDENTIFIER then
	\BAD START OF A STATEMENT\ [ERROR(20); SKIPIT; return];
LOOKUP; if IDTYPE=UNDEF then [ERROR(10); SKIPIT; return];
SLEV:=LEV; SVAL:=VAL;	\SAVE THESE FOR "GEN." AN INTERIM
SID:= IDTYPE;		\ BOOLEXP MAY CHANGE LEV & VAL

case of
IDTYPE>=INPROC & IDTYPE<=RLEXT: PROCAL(false);

IDTYPE=INVAR ! IDTYPE=RLVAR ! IDTYPE=ADDRVAR:
	begin
	SFACTYP:=if IDTYPE=RLVAR then REAL else INTEGER;
	RATOM;
	if ATOM=^( then			\INDEXED
		begin
		GENLOD(SLEV,SVAL);
		RATOM;
		BOOLEXP;		\1ST INDEX
		if FACTYP#INTEGER then ERROR(47);

		while ATOM=^, do	\MULTIPLE INDEXING
			begin
			if SFACTYP=INTEGER then GENDBX else GENTRX;
			RATOM;
			BOOLEXP;
			if FACTYP#INTEGER then ERROR(47);
			end;
		if ATOM#^) then ERROR(44) else RATOM;
		case SID of
		 INVAR:   GENDBA;
		 RLVAR:   GENTRA;
		 ADDRVAR: GENADD
		other	[];

		ASSX;	\TOS NOW POINTS TO ARRAY ELEMENT
		case SID of
		 INVAR:   GENSTD;
		 RLVAR:   GENSTT;
		 ADDRVAR: GENSTX
		other	[];
		end

	else	[ASSX;
		if SFACTYP=INTEGER then GENSTO(SLEV,SVAL)
		else GENFSTO(SLEV,SVAL)];

	if FACTYP#SFACTYP then \MIXED MODE\ ERROR(46);
	end;

IDTYPE=INSEG ! IDTYPE=RLSEG ! IDTYPE=ADSEG ! IDTYPE=SHSEG:
	begin				\SEGMENT VARIABLES
	SFACTYP:=INTEGER;
	RATOM;
	if ATOM#^( then	[ASSX;GENSTO(SLEV,SVAL)]
	else	begin			\1ST INDEX
		GENLOD(SLEV,SVAL);
		RATOM;
		BOOLEXP;
		if FACTYP#INTEGER then ERROR(47);
		if ATOM=^, then		\2ND INDEX
			begin
			GENDBX;
			RATOM; BOOLEXP;
			if FACTYP#INTEGER then ERROR(47);
			if ATOM#^) then ERROR(44) else RATOM;
			ASSX;	\GET RIGHT SIDE OF ASSIGNMENT
			case SID of
			  INSEG:GENSTSI;
			  RLSEG:[GENSTSR; SFACTYP:=REAL];
			  ADSEG:GENSTSB;
			  SHSEG:[GENSSHORT; SFACTYP:=REAL]
			other;
			end
		else	begin
			GENDBA;
			if ATOM#^) then ERROR(44) else RATOM;
			ASSX;	\GET RIGHT SIDE OF ASSIGNMENT
			GENSTD;
			end;
		end;
	if FACTYP#SFACTYP then \MIXED MODE\ ERROR(46);
	end

other \STATEMENT STARTING WITH A CONSTANT\ [ERROR(27); SKIPIT];
end;	\ASSIGN


proc	CASER; int TYPE;
int	SPC1,SPC2,SPC3;


proc	CASER2;
begin
RATOM;
BOOLEXP;
if FACTYP#INTEGER then ERROR(47);
SPC1:=NEWLAB;
if TYPE=$08 then  GENJPC(SPC1) else GENCJP(SPC1);
if ATOM=^, then				\MULTIPLE LABELS
	[SPC3:=NEWLAB;
	repeat	RATOM;	\FOR MORE THAN 2 LABELS
		GENJMP(SPC3);	\2 JUMPS TO STATEMENT
		CLABEL(SPC1);
		BOOLEXP;
		if FACTYP#INTEGER then ERROR(47);
		SPC1:=NEWLAB;
		if TYPE=$08 the GENJPC(SPC1) else GENCJP(SPC1);
	until ATOM#^,;
	CLABEL(SPC3)];
if ATOM#^: then [ERROR(49); SKIPIT; return];
RATOM;
STATEMENT;
end;	\CASER2


begin	\CASER
CASER2;
SPC2:=NEWLAB;
GENJMP(SPC2);		\JUMP OUT OF CASE STATEMENT
CLABEL(SPC1);
while ATOM=^; do
	[CASER2;
	GENJMP(SPC2);	\2 JUMP EXIT (BACK THEN OUT)
	CLABEL(SPC1)];
if ATOM#ELSEYM & ATOM#OTHSYM then ERROR(29);
RATOM;
STATEMENT;
CLABEL(SPC2);
end;	\CASER


begin	\STATEMENT
case ATOM of
BEGSYM,^[:
	begin
	RATOM;
	loop	begin
		if ATOM=ELSEYM then [ERROR(52); RATOM];
		if ATOM=OTHSYM then [ERROR(53); RATOM];
		STATEMENT;
		case ATOM of
		^;:	RATOM;
		ENDSYM:	quit;
		^]:	quit;
		EOF:	[ERROR(62); exit 1]
		other	\SEMI EXPECTED\ ERROR(41);
		end;
	RATOM;		\READ PAST THE 'END'
	end;
CASEYM:	begin				\CASE STATEMENT
	RATOM;
	if ATOM=OFSYM then CASER(\JPC\$08)
	else	begin
		BOOLEXP;
		if FACTYP#INTEGER then ERROR(47);
		if ATOM#OFSYM then [ERROR(48); SKIPIT; return];
		STKLOD:=STKLOD+1;
		CASER(\CJP\$25);
		GENDRP;
		STKLOD:=STKLOD-1;
		end;
	end;
QUITYM:	begin
	for I:=SSTK,STKLOD-1 do GENDRP;
	if FIXCNT>=QUITMAX then [ERROR(4); FIXCNT:=QUITMAX-1];
	FIXES(FIXCNT):=NEWLAB;		\QUIT STATEMENT
	GENJMP(FIXES(FIXCNT));   \(WILL BE "FIXED" AT END OF 'LOOP')
	FIXCNT:=FIXCNT+1;
	RATOM;
	end;
IFSYM:	begin				\IF STATEMENT
	RATOM;
	BOOLEXP;
	P3:=NEWLAB;
	GENJPC(P3);
	if ATOM#THENYM then [ERROR(22); SKIPIT; return];
	RATOM;
	STATEMENT;
	if ATOM=ELSEYM then
		[P2:=NEWLAB;
		GENJMP(P2);
		CLABEL(P3);
		P3:=P2;
		RATOM;
		STATEMENT];
	CLABEL(P3);
	end;
REPSYM:	[P2:=NEWLAB;			\REPEAT STATEMENT
	CLABEL(P2);
	repeat RATOM; STATEMENT until ATOM#^;;
	if ATOM#UNTSYM then [ERROR(28); SKIPIT; return];
	RATOM;
	BOOLEXP;
	GENJPC(P2)];
WHILYM:	[RATOM;				\WHILE STATEMENT
	P2:=NEWLAB;
	CLABEL(P2);
	BOOLEXP;
	P3:=NEWLAB;
	GENJPC(P3);
	if ATOM#DOSYM then [ERROR(23); SKIPIT; return];
	RATOM;
	STATEMENT;
	GENJMP(P2);
	CLABEL(P3)];
RETSYM:	begin				\RETURN STATEMENT
	RATOM;
	for I:=0,STKLOD-1 do GENDRP;
	if ATOM#ELSEYM & ATOM#OTHSYM & ATOM#^; & ATOM#^] &
	    ATOM#ENDSYM & ATOM#UNTSYM then	\STORE THE RETURNED
		[BOOLEXP;		\ VALUE IN GLOBAL #0
		if FACTYP=INTEGER then GENSTO(0,0)
			else GENFSTO(0,0)];
	if OPTPROC then GENRTS
	else GENRET(LEVEL);
	end;
LOOPYM:	begin				\LOOP STATEMENT
	SFIXS:=FIXCNT;
	RATOM;
	P2:=NEWLAB;
	CLABEL(P2);
	SSTATEMENT(STKLOD);
	GENJMP(P2);
	while FIXCNT>SFIXS do	\FIX THE JUMPS FOR THE 'QUIT'S
		[FIXCNT:=FIXCNT-1; CLABEL(FIXES(FIXCNT))];
	end;
FORSYM:	begin				\FOR STATEMENT
	RATOM;
	if ATYPE#IDENTIFIER then [ERROR(33); SKIPIT; return];
	LOOKUP;
	if IDTYPE=UNDEF then ERROR(10)
	else if IDTYPE#INVAR & IDTYPE#ADDRVAR then ERROR(33);
	SLEV:=LEV; SVAL:=VAL;
	RATOM;
	if ATOM#GETSYM then [ERROR(21); SKIPIT; return];
	RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	GENSTO(SLEV,SVAL);

	DOWNTO:= false;
	if ATOM=TOSYM ! ATOM=^, then []
	else if ATOM=DOWNYM then DOWNTO:= true
	else [ERROR(24); SKIPIT; return];

	RATOM;
	BOOLEXP;
	if FACTYP#INTEGER then ERROR(47);
	if ATOM#DOSYM then [ERROR(23); SKIPIT; return];
	\New For Loop with everything at the end
	P2:=NEWLAB;
	if SLEV#0 then NEWLEVEL(SLEV);
	GENJMP(P2);
	P3:=NEWLAB;
	CLABEL(P3);
	RATOM;
	STKLOD:=STKLOD+1;
	STATEMENT;
	STKLOD:=STKLOD-1;
	GENINP(SLEV,SVAL,DOWNTO);
	CLABEL(P2);
	GENFOR(SLEV,SVAL,P3,DOWNTO);
	end;
EXITYM:	[RATOM;				\EXIT STATEMENT
	if ATOM#ELSEYM & ATOM#OTHSYM & ATOM#^; & ATOM#^] &
	    ATOM#ENDSYM & ATOM#UNTSYM then	\STORE THE RETURNED
		[BOOLEXP;			\ VALUE IN GLOBAL #0
		if FACTYP=INTEGER then GENSTO(0, 0) else GENFSTO(0, 0)];
	GENEXIT];
ELSEYM,OTHSYM,^;,^],ENDSYM,UNTSYM:	[];
EOF:	[]		\(THIS IS MOSTLY AN ACADEMIC POINT)
other	ASSIGN;
end;	\STATEMENT


begin	\SSTATEMENT
\TRICK TO ADJUST STACK (WITH DRP'S) WHEN A 'QUIT' IS IN
\ A 'CASE' STATEMENT.
STATEMENT;
end;


proc	PROCEDURE; int SSNOX;	\"SSNO" FROM "PROCDEC" FOR OPTIMIZED PROCEDURES
int	SLEVEL,		\SAVE LEVEL (COMPLICATED BY OPTIMIZED PROCEDURES)
	K,I,J,P1,
	DX,		\HEAP SPACE REQUIREMENT COUNTER (BETWEEN ARRAYS) unsigned
	DXOFF,		\VARIABLE'S OFFSET FROM BASE (=DX IF NO ARRAYS) unsigned
	HAVEGENBASE,	\FLAG: HAVE GENERATED BASE CODE FOR PROCEDURE
	HAVESTART,	\FLAG: HAVE GENERATED START-UP CODE FOR PROGRAM
	OLDCNT,		\OLD SEGMENT COUNT
	FPBASE,		\PC AT END OF DECLARATIONS
	FPROCNT;	\COUNT OF PENDING FORWARD PROCEDURES


proc	EATARGS;	\SKIP ARGUMENTS IN PARENTHESIS
begin
if ATOM=^( then
	begin
	loop	[if CHAR=^) then quit;
		if CHAR=$0D\CR\ then [ERROR(44); quit];
		GETCH];
	GETCH; RATOM;
	end;
end;	\EATARGS


proc	CODDEC;		\DECLARE INTRINSIC NAMES
int	SID;
begin
SID:=ININT;		\DEFAULT IS INTEGER INTRINSIC
RATOM;
if ATOM=REALYM then [SID:=RLINT; RATOM]
	else if ATOM=INTSYM then RATOM;
if ATYPE#IDENTIFIER then ERROR(45);
while ATYPE=IDENTIFIER do
	[RATOM;
	EATARGS;
	if ATOM#^= then ERROR(40);
	RATOM;
	GETCON; if FACTYP#INTEGER then ERROR(47);
	if IATOM<0 ! IATOM>127 then ERROR(7);
	INSERT(SID,LEVEL,IATOM);
	RATOM;
	if ATOM=^, then RATOM];
if ATOM#^; then ERROR(41) else RATOM;
end;	\CODDEC


proc	CONDEC;		\DECLARE CONSTANT NAMES
int	CNTR,SSNO;
begin
RATOM;
CNTR:=0;
if ATYPE#IDENTIFIER then ERROR(45);
while ATYPE=IDENTIFIER do
	begin
	RATOM;
	if ATOM#^= then [INSERT(INCON,LEVEL,CNTR); CNTR:=CNTR+1]
	else	begin
		SSNO:=NOSYM;
		INSERT(INCON,LEVEL,NORLSY);	\INSERT ID NOW
		RATOM;				\ FIX UP PARMS LATER
		CONEXPRESS;
		if FACTYP=INTEGER then SYMVAL(SSNO):=IATOM
		else				\FACTYP=REAL
			[SYMTYP(SSNO):=RLCON;
			if NORLSY>=RLMAX then
				[ERROR(2); NORLSY:=RLMAX-1];
			RLTBL(NORLSY):=RLATOM;
			NORLSY:=NORLSY+1];
		end;
	if ATOM=^, then RATOM;
	end;
if ATOM#^; then ERROR(41) else RATOM;
end;	\CONDEC


proc	CHECKBASE;	\GENERATE BASE INIT CODE FOR PROCEDURE, IF NOT DONE
begin
if not HAVEGENBASE then
	begin
	if not HAVESTART then
		if LEVEL=0 then [GENSTART; HAVESTART:=true];
			\BEWARE OF MORE THAN 64K OF EPROCs
	GENBASE(LEVEL,DX);
	OPTPROC:= false;
	HAVEGENBASE:= true;
	end;
end;	\CHECKBASE


proc	VARDEC; int TYPE;  \DECLARE VARIABLES--INT, REAL & ADDR
int	SDX,DIMS,T,ST;
begin
RATOM;
if ATYPE#IDENTIFIER then ERROR(45);
while ATYPE=IDENTIFIER do
	begin
	INSERT(TYPE,LEVEL,DXOFF);
	SDX:=DXOFF;
	DXOFF:=DXOFF +(if TYPE=RLVAR then RLSIZE else 2);
	DX:=   DX    +(if TYPE=RLVAR then RLSIZE else 2);
	T:=if TYPE=RLVAR then RLSIZE else 2;
	ST:= T;
	if TYPE=ADDRVAR then ST:=1;
	RATOM;
	if ATOM=^( then		\GET DIMENSIONS OF AN ARRAY
		begin
		CHECKBASE;
		if DX#0 then [GENHPI(LEVEL,DX); DX:=0];
		\WARNING: DX can appear negative becaue of array declarations)
		DIMS:= 0;
		loop	begin
			RATOM;
			CONEXPRESS;
			if FACTYP#INTEGER then ERROR(47);
			\PUSH SIZES OF EACH DIMENSION ON STACK
			GENIMM(^C,IATOM);
			DIMS:= DIMS +1;	\COUNT NUMBER OF DIMENSIONS
			if ATOM # ^, then	\last dimension of char array is
				begin		\ only a single byte per entry
				if ST=1 then T:=T>>1;
				T:=T*IATOM;
				DXOFF:=DXOFF+T;
				quit;
				end;
			T:=T*IATOM;    \ACCUMULATE BYTE COUNT FOR EACH DIMENSION
			DXOFF:=DXOFF+T;	\OFFSET FROM BASE
			end;
		if ATOM#^) then ERROR(44) else RATOM;
		\GEN CODE TO SET UP ARRAY AT RUN TIME, FOR EXAMPLE:
		\GEN CALL MakeArray([3, 5, 7, 10], 4, 2, addr ArrayName);
		GENIMM(^C,DIMS);	\NUMBER OF DIMENSIONS
		GENIMM(^C,ST);		\NUMBER OF BYTES IN EACH ELEMENT
		GENADR(LEVEL, SDX);	\ADDRESS OF POINTER TO ARRAY
		GENARY;
		end;
	if ATOM=^, then RATOM;
	end;
if ATOM#^; then ERROR(41) else RATOM;
end;	\VARDEC



procedure SEGDEC;	\DECLARE SEGMENT VARIABLES
begin
RATOM;
case ATOM of
  INTSYM: VARDEC(INSEG);
  REALYM: VARDEC(RLSEG);
  ADRSYM,CHARYM: VARDEC(ADSEG);
  SHTSYM: VARDEC(SHSEG)
other ERROR(72);
end;	\SEGDEC


proc	EXTDEC;int XPL;
\DECLARE EXTERNAL PROCEDURES
\DEFERENTIATE XPL TYPE EXTERNALS FROM ASSEMBLY
int	SID,D;
begin
\HANDLE XPL VS. ASSEMBLY TYPE EXTERNAL
\THE DEFAULT IS INTEGER EXTERNAL
SID:=if XPL then INEPRO else INEXT;

\HANDLE REAL VS INTEGER PROCEDURE
RATOM;
if ATOM=REALYM then [SID:=if XPL then RLEPRO else RLEXT; RATOM]
	else if ATOM=INTSYM then RATOM;
if ATYPE#IDENTIFIER then ERROR(45);

D:=0;
while ATYPE=IDENTIFIER do
	begin
	INSERT(SID,LEVEL,IATOM);
	RATOM;
	EATARGS;
	if ATOM=^, then RATOM;
	if REM(D/4)=0 then TTXT("|	EXTRN	")
		else TTXT(",");

	if XPL then CHOUT(BINDEV, ^_);
	SYMOUT(NOSYM-1); TTXT(":FAR");
	D:=D+1;
	end;
CRLF(BINDEV);
if ATOM#^; then ERROR(41) else RATOM;
end;	\EXTDEC


proc	FPRDEC; int OPTYPE;	\DECLARE FORWARD REFERENCED PROCEDURES
int	SID,I;
begin
SID:=INFPROC;			\DEFAULT TYPE
RATOM;
if ATOM=REALYM then [SID:=RLFPROC;RATOM]
else if ATOM=INTSYM then RATOM;
if ATYPE#IDENTIFIER then ERROR(45);
while ATYPE=IDENTIFIER do
	begin
	RATOM;
	I:=NEWLAB;
	INSERT(SID,LEVEL,I);
	FLABEL(I);
	GENFJMP(NEWLAB);
	FPROCNT:=FPROCNT+1;
	EATARGS;
	if ATOM=^, then RATOM;
	end;
if ATOM#^; then ERROR(41) else RATOM;
end;	\FPRDEC


proc	PROCDEC; int CANOPT,PUBLIC;	\DECLARE PROCEDURE NAMES
int	SNOSYM,HASH,I,K,SID,SSNO,SNORL;
begin
SID:=INPROC;			\TYPED PROCEDURE (FOR FUNCTIONS)
RATOM;
if ATOM=REALYM then [SID:=RLPROC; RATOM]
	else if ATOM=INTSYM then RATOM;
if ATYPE#IDENTIFIER then ERROR(45) else LOOKUP;

\SET UP NEXT NESTED SEGMENT
if DEEPER then OLDCNT:=SEGCNT;
DEEPER:=true;
SEGCNT:=SEGCNT+1;
STARTSEG(LEVEL+2,SEGCNT);

if IDTYPE=INFPROC ! IDTYPE=RLFPROC then
	\PROCEDURE HAS BEEN PREVIOUSLY DECLARED BY A 'FPROC' OR 'FFUNCT'
	begin
	if LEVEL#LEV then ERROR(65);	\('FPROC' & 'PROC' MUST BE SAME SCOPE)
	if PUBLIC then			\HANDLE PUBLIC PROCEDURES
		begin
		TTXT("	PUBLIC	_");
		SYMOUT(SYMNUM);
		TTXT("|_");
		SYMOUT(SYMNUM);
		TTXT(":|");
		end;
	FLABEL(VAL+1);
	SYMVAL(SYMNUM):=VAL+1;
	SYMTYP(SYMNUM):=if IDTYPE=INFPROC then INPROC else RLPROC;
	if SID#SYMTYP(SYMNUM) then \MIXED MODE\ ERROR(46);
	if VAL>=FPBASE then FPROCNT:=FPROCNT-1;
	OPTPROC:=false;
	end
else 	begin
	SSNO:=NOSYM;
	I:=NEWLAB;
	INSERT(SID,LEVEL,I);
	if PUBLIC then			\HANDLE PUBLIC PROCEDURES
		begin
		TTXT("	PUBLIC	_");
		SYMOUT(NOSYM-1);
		TTXT("|_");
		SYMOUT(NOSYM-1);
		TTXT(":|");
		end;
	FLABEL(I);
	OPTPROC:=CANOPT;
	end;

\ASSUME FOR NOW THAT PROCEDURE IS NOT OPTIMIZED AND MOVE DOWN A LEVEL
SLEVEL:=LEVEL;
LEVEL:=LEVEL+2; if LEVEL>14 then ERROR(5);
					\EAT THE ARGUMENT LIST AS A COMMENT
while CHAR#^; & CHAR#\CR\$0D do GETCH;	\SPECIAL COMMENT STOPS ON CR
if CHAR#^; then ERROR(41);
GETCH; RATOM;

SNOSYM:=NOSYM; SNORL:=NORLSY;
PROCEDURE(SSNO);	\PASS LOCATION OF PROC NAME IN CASE IT'S OPTIMIZED
if ATOM#^; then ERROR(41) else RATOM;
while NOSYM>SNOSYM do	\RESTORE SYMBOL TABLE TO PREVIOUS LEVEL
\I.E. REMOVE THE IDENTIFIERS WHICH WERE LOCAL TO THIS PROCEDURE
	[NOSYM:=NOSYM-1;
	HASH:=0; K:=NOSYM;
	for I:=0,SIGCHAR-1 do
		[HASH:=HASH+SYMBOL(K); K:=K+SYMAX];
	BOX(HASH&HASHMSK):=SYMPNT(NOSYM)];
NORLSY:=SNORL;
LEVEL:=SLEVEL;

STARTSEG(LEVEL,OLDCNT);			\END CURRENT SEGMENT
DEEPER:=false;
end;	\PROCDEC


begin	\PROCEDURE
DXOFF:= if LEVEL=0 then RLSIZE else 0;	\SAVE HEAP SPACE FOR RETURN
DX:= DXOFF;
HAVEGENBASE:= false;
HAVESTART:= false;

FPROCNT:=0;
FPBASE:=LABCNT;

repeat
  loop	case ATOM of
	INTSYM:	VARDEC(INVAR);
	ADRSYM:	VARDEC(ADDRVAR);
	CHARYM:	VARDEC(ADDRVAR);
	REALYM:	VARDEC(RLVAR);
	SEGSYM: SEGDEC;
	CODSYM:	CODDEC;
	EXTNYM:	EXTDEC(false);
	DEFSYM:	CONDEC;
	EPRSYM, EFUNYM:	if LEVEL=0 then EXTDEC(true)
			else [ERROR(68); SKIPIT]
	other	quit;

  if not HAVESTART then
	if LEVEL=0 then [GENSTART; HAVESTART:=true];
	\BEWARE OF MORE THAN 64K OF EPROCs

  \SEE IF THERE ARE ANY NESTED PROCEDURES WE NEED TO JUMP OVER
  case ATOM of PUBSYM,PROCYM,FUNSYM,FPRSYM,FFUNYM:
	begin
	P1:=NEWLAB;
	GENJMP(P1);
	end
  other P1:=0\NULL\;

  loop	case ATOM of
	PUBSYM: [if LEVEL#0 then ERROR(68);
		RATOM;
		case ATOM of PROCYM,FUNSYM:PROCDEC(false,true)
		else ERROR(67)];
	PROCYM,FUNSYM:	PROCDEC(true,false);
	FPRSYM,FFUNYM:	FPRDEC(7)
	other	quit;

  if P1#0 then CLABEL(P1);

until	ATOM#INTSYM & ATOM#ADRSYM & ATOM#CHARYM & ATOM#REALYM & ATOM#SEGSYM &
	ATOM#CODSYM & ATOM#EXTNYM & ATOM#DEFSYM & ATOM#EPRSYM & ATOM#EFUNYM;

if DXOFF#0 then OPTPROC:=false;
if OPTPROC then
	begin
	SYMTYP(SSNOX):= if SYMTYP(SSNOX)=INPROC then INOPT else RLOPT;
	LEVEL:=LEVEL-2;	\SAME LEVEL AS NESTING PROCEDURE (TRICKY!)
	end
else	begin		\RESERVE SPACE FOR LOCAL VARIABLES (IF NOT ALREADY DONE)
	if not HAVEGENBASE then GENBASE(LEVEL,DX);
	GENHPI(LEVEL,DX);
	end;

\PROCESS THE BODY
CODFLG:=false;		\IS THERE A MAIN PROCEDURE?
SSTATEMENT(STKLOD);	\(STKLOD WILL ALWAYS BE ZERO HERE)
HASMAIN:=CODFLG;

if OPTPROC then GENRTS else GENRET(LEVEL);

if FIXCNT#0 then \SOME 'QUIT'S NOT IN A 'LOOP'\ ERROR(60);
if FPROCNT#0 then \UNRESOLVED FWD REFERENCES\ ERROR(66);
end;	\PROCEDURE

\------------------------ ROUTINES TO OPEN DOS FILES ---------------------------

proc	DOSOPEN;
int	CPUREG, PSPSEG, DATASEG, T;
char	CMDTAIL;

	func	GETSWT;		\FIND, REMOVE AND RETURN A SWITCH
	int	P, T;
	begin
	for P:= 1, CMDTAIL(0) do
	    if CMDTAIL(P)=^/ then
		begin
		CMDTAIL(P):= $20;
		if P < CMDTAIL(0) then
			begin
			T:= CMDTAIL(P+1);
			if T>=^a & T<=^z then T:= T-$20; \MAKE UPPERCASE
			CMDTAIL(P+1):= $20;
			return T;
			end;
		end;
	return 0;
	end;	\GETSWT


	proc	PARSE;		\PARSE COMMAND TAIL AND SET I/O HANDLES
	char	EXTIN, EXTOUT;
	int	P, P0, EXTFLG, I;
	begin
	EXTIN:= ".XPL";   EXTOUT:= ".ASM";
	P:= 1;
	EXTFLG:= false;
	loop	begin			\PARSE COMMAND TAIL FOR EXTENSION
		if CMDTAIL(P) = ^. then
			begin
			EXTFLG:= true;
			quit;
			end;
		if CMDTAIL(P) = ^; then quit;	\IGNORE SEMICOLON
		if P > CMDTAIL(0) then quit;	\if quit then P points to CR
		P:= P + 1;
		end;

	\Back up over any trailing spaces (caused by switches)
	repeat P:= P - 1 until CMDTAIL(P) # ^ ;
	P:= P + 1;

	if not EXTFLG then		\SET EXTENSION AND INPUT HANDLE
		for I:= 0, 3 do CMDTAIL(P+I):= EXTIN(I);
	INHAND:= FOPEN(CMDTAIL+1, 0);

	for I:= 0, 3 do CMDTAIL(P+I):= EXTOUT(I);  \SET EXTENSION AND OUTPUT HANDLE
	OUTHAND:= FOPEN(CMDTAIL+1, 1);

	\COPY FILE NAME INTO FNAME
	P0:= P - 1;			\P0 points to last character in file name
	repeat	P:= P - 1;
	until	CMDTAIL(P)=^  ! CMDTAIL(P)=^\ ! CMDTAIL(P)=^:;

	P:= P + 1;			\point to first character of file name
	for I:= 0, 7 do
		begin
		FNAME(I):= CMDTAIL(P+I);
		if P+I=P0 ! I=7 then
			begin
			FNAME(I):= FNAME(I) ! $80;
			I:= 7;
			end;
		end;
	end;	\PARSE


begin	\DOSOPEN
CMDTAIL:= RESERVE($80+4);	\GET COMMAND TAIL FROM PSP
CPUREG:= GETREG;
PSPSEG:= CPUREG(11);
DATASEG:= CPUREG(12);
BLIT(PSPSEG, $80, DATASEG, CMDTAIL, $80);

loop	begin				\HANDLE SWITCHES
	T:= GETSWT;
	case T of
	  ^L:	LSTDEV:= 0;
	  ^C:	COMFLG:= true;
	  ^A:	[BINDEV:= 0; LSTDEV:= 7];
	   0:	quit			\NO MORE SWITCHES ON COMMAND LINE
	other	[TEXT(TV,"UNRECOGNIZED SWITCH: /"); CHOUT(TV, T); CRLF(TV); exit 1];
	end;
PARSE;					\PARSE COMMAND LINE AND SET HANDLES
FSET(INHAND, ^I);
FSET(OUTHAND, ^O);
end;	\DOSOPEN

\-------------------------------------------------------------------------------

begin	\MAIN--DISPLAY TITLE AND INITIALIZE
IDENT:=RESERVE(SIGCHAR);
FIXES:=RESERVE(2*QUITMAX);
SYMBOL:=RESERVE(SIGCHAR*SYMAX);	\SYMBOL TABLE
SYMTYP:=RESERVE(SYMAX);
SYMVAL:=RESERVE(SYMAX*2);
SYMLEV:=RESERVE(SYMAX);
SYMPNT:=RESERVE(SYMAX*2);
BOX:=RESERVE(BOXNUM*2);		\HASH TABLE
RLTBL:=RLRES(RLMAX);
HEXDIGIT:="0123456789ABCDEF ";

\SET INCLUDE ARRAYS
OLDHAN:=RESERVE(HANMAX*2);
HANPTR:=0;

\SET DEFAULT CHANNELS
COMFLG:=false;

TEXT(TV,"
-- XPL0 NATIVE COMPILER, VER N2.7 --
    COPYRIGHT 2010 P.J.R. BOYLE

XPL0 comes with ABSOLUTELY NO WARRANTY.
This is free software. You are welcome and encouraged to redistribute
it under certain conditions. For details see LICENSE.TXT.

");
\OPEN DOS FILES
FNAME:=RESERVE(8);
BINDEV:= 3; LSTDEV:= 8; SRCDEV:= 3;
DOSOPEN;
OPENO(BINDEV); OPENO(LSTDEV); OPENI(SRCDEV);

LABCNT:=0; LEVEL:=0;			\INITIALIZE SOME STUFF
STKLOD:=0; NOSYM:=0; NORLSY:=0; FIXCNT:=0;
for I:=0,BOXNUM do BOX(I):=EMTPNT;	\ZERO THE SYMBOL TABLE
ERRCNT:=0;
LASTOP:=$FFFF\NUL\;
HASLAB:=false;

\INTIALIZE SEGMENT STUFF
SEGCNT:=0;
DEEPER:=true;

LOCAL:=0;
OLDLEV:=$FFFF;
TOS:=STACKED;		\THE DEFAULT CASE;
CONDITIONAL:= true;
STRTERM:= -1;		\default to MSB string termination (nonzero)

GETCH; RATOM;
OPTPROC:=false;		\(FOR 2 REASONS)
PROCEDURE(0);		\COMPILE MAIN PROCEDURE, I.E. THE PROGRAM
while ATOM=^; do RATOM;
if ATOM#EOF then \MORE CODE AFTER END\ [ERROR(61); PROCEDURE(0)];

\IF PROGRAM HAS CODE IN 'MAIN' THEN MAKE IT PUBLIC
if HASMAIN then TTXT("	PUBLIC	PROGRM|");
GENEND;

CHOUT(BINDEV,EOF);
CLOSE(BINDEV);

CRLF(LSTDEV);
TEXT(LSTDEV,"ERRORS DETECTED: "); INTOUT(LSTDEV,ERRCNT); CRLF(LSTDEV);
CLOSE(LSTDEV);
CRLF(TV);

FCLOSE(OUTHAND);	\CLOSE DOS FILES
FCLOSE(INHAND);
return if ERRCNT#0 then 1 else 0;
end;	\MAIN
