	PAGE

;***************************************************************
;******* ROUTINES TO SUPPORT WINDOW TYPE APPLICATIONS  ********
;***************************************************************

;LOCAL VARIABLES

DSEG	SEGMENT WORD PUBLIC 'DATA'
WATTRB	DW	07H		;ATTRIBUTE FOR CURRENT WINDOW
WMODE	LABEL	WORD		;WINDOW MODE
	DB	0
CURMOD	DB	0		;CURSOR MODE

;WINDOW CORNERS

ULXWND	DW	0		;CURRENT UPPER LEFT COORDINATES
ULYWND	DW	0
LRXWND	DW	79		;CURRENT LOWER RIGHT COORDINATES
LRYWND	DW	24
DSEG	ENDS

;MEMORY LOCATIONS FOR BIOS PARAMETERS

CURLOC	EQU	0450H		;MEMORY LOC FOR CURSOR POSITION
MODLOC	EQU	0449H		;MEMORY LOC FOR VIDEO MODE
WIDLOC	EQU	044AH		;HOLD SCREEN WIDTH (IN CHARACTERS)
SCRPAG	EQU	0462H		;CURRENT VIDEO PAGE NUMBER
SCROFF	EQU	044EH		;OFFSET TO CURRENT VIDEO SCREEN
ROWLOC	EQU	0484H		;NUMBER OF DISPLAYED CHARACTER ROWS -1

CGALOC	EQU	0B800H		;LOCATION OF THE CGA SCREEN
MDALOC	EQU	0B000H		;LOCATION OF THE MDA SCREEN
	PAGE

;INTRINSIC TO OUTPUT A RAW STRING TERMINATED BY A SPACE + 080H

INTR71	LABEL	FAR
RAWTXT	PROC	FAR
	MOV	SISAVE,SI	;SAVE CRITICAL REGISTER
	MOV	SI,AX		;GET ADDRESS FROM TOS
	MOV	BP,SP		;GET STACK FRAME
	MOV	CX,[BP]+TOSOFF	;GET NOS
	MOV	NOWDEV,CX	;SET DEVICE #
	MOV	NOWFUN,OUTFUN
	CLD			;FORCE INCREMENT MODE
	JMP SHORT RAWTX1	;ENTER LOOP

RAWTX2:	CALL	KHAND		;OUT IT GOES
RAWTX1:	LODSB			;GET CHAR
	CMP	AL,0A0H		;LAST CHAR?
	JNZ	RAWTX2		;SKIP IF SO
	MOV	SI,SISAVE	;RESTORE CRITICAL REGISTER
	RET	2		;RETURN
RAWTXT	ENDP

;RESET WINDOW PARAMETERS FOR NORMAL FULL SCREEN

RESWND:	MOV	WMODE,0		;SET TO SCROLL AND MOVING CURSOR
	MOV	WATTRB,07H	;SET WHITE ON BLACK ATTRIBUTE
	CALL	RESFULLWND	;RESET WINDOW FOR FULL SCREEN
	MOV	AX,0200H	;SET CURSOR TO UPPER LEFT CORNER
	CALL	GETPAG		;GET SCREEN PAGE
	MOV DL,BYTE PTR ULXWND	;SET CURSOR POSITION
	MOV DH,BYTE PTR ULYWND
	INT	010H		;CALL BIOS
	CLC
	RET

;RESET WINDOW FOR FULL SCREEN

RESFULLWND:
	PUSH	ES
	XOR	AX,AX
	MOV	ES,AX
	MOV	ULXWND,AX	;SET UPPER-LEFT COORDINATES TO 0,0
	MOV	ULYWND,AX

	MOV	AL,ES:ROWLOC	;SET NUMBER OF CHARACTER ROWS -1
	MOV	LRYWND,AX
	CMP	AX,11		;IF BIOS VALUE IS TOO WEIRD THEN USE
	JLE	RFW10		; STANDARD SCREEN HEIGHT (25 ROWS)
	CMP	AX,127
	JLE	RFW20
RFW10:	MOV	LRYWND,24
RFW20:
	MOV	AX,ES:WIDLOC	;SET NUMBER OF CHARACTER COLUMNS -1
	DEC	AX
	MOV	LRXWND,AX
	CMP	AX,19		;IF BIOS VALUE IS TOO WEIRD USE STANDARD
	JLE	RFW30		; SCREEN WIDTH (80 COLUMNS)
	CMP	AX,159
	JLE	RFW40
RFW30:	MOV	LRXWND,79
RFW40:
	POP	ES
	RET
	PAGE

;SET UP A DISPLAY WINDOW FOR DEVICE CHANNEL 6
;SETWIND(UPPER_LEFT_X,UPPER_LEFT_Y,LOWER_LEFT_X,LOWER_LEFT_Y,MODE,FILL)
; MODE: 0 = SCROLL, 1 = WRAP, 2 = CLIP

INTR70	LABEL	FAR
SETWND	PROC	FAR
	MOV	BP,SP		;GET STACK FRAME
	MOV	CX,[BP+TOSOFF]	;GET NEW MODE
	MOV	WMODE,CX

	MOV	CX,[BP+INTNOS]		;GET CORNERS OF WINDOW
	MOV	LRYWND,CX
	MOV	CX,[BP+INTNOS+2]
	MOV	LRXWND,CX
	MOV	CX,[BP+INTNOS+4]
	MOV	ULYWND,CX
	MOV	CX,[BP+INTNOS+6]
	MOV	ULXWND,CX

	OR	AX,AX		;FILL SCREEN?
	JZ	SETWN1		;SKIP IF NOT

	MOV	AX,0700H	;SET AND FILL WINDOW
	call	nVidia		;compensate for nVidia card bug
	call	setbkgnd
	MOV CH,BYTE PTR ULYWND	;SET UPPER LEFT CORNER
	MOV CL,BYTE PTR ULXWND
	MOV DH,BYTE PTR LRYWND	;SET LOWER RIGHT CORNER
	MOV DL,BYTE PTR LRXWND
	INT	010H		;EXECUTE VIDEO BIOS CALL

SETWN1:	MOV	AX,0200H	;SET CURSOR TO UPPER LEFT CORNER
	CALL	GETPAG		;GET SCREEN PAGE
	MOV DL,BYTE PTR ULXWND	;SET CURSOR POSITION
	MOV DH,BYTE PTR ULYWND
	INT	010H		;CALL BIOS
	RET	10		;RETURN
SETWND	ENDP

;SET CURRENT ATTRIBUTE

INTR69	LABEL	FAR
SETATT	PROC	FAR
	MOV	WATTRB,AX	;SET CURRENT ATTRIBUTE
	RET			;RETURN
SETATT	ENDP

;INPUT CHARACTER FROM KEYBOARD, ECHO TO DEVICE CHANNEL 6

WNDCHN:	MOV	AH,0		;SET KEY INPUT FUNCTION
	INT	016H		;CALL BIOS FUNCTION
	PUSH	AX		;SAVE CHARACTER
	CALL	WNDOUT		;ECHO CHARACTER
	POP	AX		;RESTORE CHARACTER
	CLC			;FLAG NO ERROR AND RETURN
	RET
	PAGE

;OUTPUT A CHARACTER TO CURRENT WINDOW
;SETUP FOR SPEED  SO THAT:
; AL=CHAR, BH=VIDEO MODE, BL=VIDEO PAGE, CL=SCREEN WIDTH,
; DX=CURSOR POSITION, SI=INDEX TO CURSOR

WNDOUT:	PUSH	SI			;SAVE CRITICAL REGISTER
	PUSH	DI
	PUSH	ES			;SAVE ES

	XOR	BX,BX			;POINT TO LOW MEMORY
	MOV	ES,BX
	MOV	BL,ES:SCRPAG		;GET VIDEO PAGE
	XOR	BH,BH			;ZERO HIGH NIBBLE
	SHL	BX,1			;MAKE INTO INDEX
	MOV	SI,BX			;PUT IN INDEX REG
	MOV	DX,ES:CURLOC[SI]	;GET CURSOR POSITION
	MOV	BH,ES:SCRPAG		;SETUP FOR DOS CALLS
	MOV BL,BYTE PTR ES:MODLOC	;GET VIDEO MODE
	MOV	CX,ES:WIDLOC		;GET SCREEN WIDTH
	CALL	WNDMOD			;DECODE WINDOW MODE

	POP	ES			;RESTORE CRITICAL REGISTERS
	POP	DI
	POP	SI
	CLC				;FLAG EVERYTHING OK
	RET
	PAGE

;HANDLE ALL THE DIFFERENT WINDOWING MODES

WNDMOD:	CMP BYTE PTR WMODE,0		;SCROLL MODE?
	JNE	WNDOT1			;SKIP IF NOT
	JMP SHORT SCRMOD
WNDOT1:	CMP BYTE PTR WMODE,1		;WRAP AROUND MODE?
	JNE	CLPMOD			;THEN MUST BE CLIP
	JMP SHORT WRPMOD
	PAGE

;HERE TO HANDLE CLIPPED MODE

CLPMOD:	CMP	AL,CR			;CARRIAGE RETURN?
	JNE	CLPMD2			;SKIP IF NOT
	JMP SHORT WNDRET		;HANDLE RETURN

CLPMD2:	CMP	AL,LF			;LINE FEED?
	JNE	CLPMD1			;SKIP IF NOT

	CMP DH,BYTE PTR LRYWND		;OUT OF WINDOW?
	JAE	CLPEXT			;SKIP IF SO
	INC	DH			;ADVANCE LINE POINTER
	JMP SHORT WNDEXT		;THEN EXIT

CLPEXT:	RET				;THEN JUST EXIT

;HERE TO OUTPUT THE CHARACTER

CLPMD1:	CMP DL, BYTE PTR ULXWND		;CURSOR OUT OF WINDOW?
	JB	CLPEXT
	CMP DL, BYTE PTR LRXWND
	JA	CLPEXT
	CMP DH, BYTE PTR ULYWND
	JB	CLPEXT
	CMP DH, BYTE PTR LRYWND
	JA	CLPEXT

;NOW WRITE THE CHARACTER AND ATTRIBUTE TO SCREEN

	CALL	SCNWRT			;WRITE TO SCREEN
	JMP SHORT WNDEXT		;AND EXIT
	PAGE

;HERE TO HANDLE WRAP AROUND MODE WINDOWING

WRPMOD:	CMP	AL,CR			;CARRIAGE RETURN?
	JE	WNDRET			;THEN HANDLE IT
	CMP	AL,LF			;LINE FEED?
	JNE	WRPMD1			;SKIP IF NOT

	INC	DH			;ADVANCE LINE POINTER
	CMP DH,BYTE PTR LRYWND		;OUT OF WINDOW?
	JBE	WRPMD9			;EXIT IF NOT
	MOV DH,BYTE PTR ULYWND		;RESET TO LEFT EDGE
WRPMD9:	JMP SHORT WNDEXT		;THEN EXIT

WRPMD1:	CALL	SCNWRT			;WRITE TO SCREEN
	CMP	DL, BYTE PTR LRXWND	;OUT OF WINDOW?
	JBE	WRPMD2			;SKIP IF NOT
	MOV DL,BYTE PTR ULXWND		;RESET TO LEFT EDGE
WRPMD2:	JMP SHORT WNDEXT		;AND EXIT
	PAGE

;HANDLE SCROLLING WINDOWS

SCRMOD:	CMP	AL,CR			;CARRIAGE RETURN?
	JE	WNDRET			;THEN HANDLE IT
	CMP	AL,LF			;LINE FEED?
	JNE	SCRMD1			;SKIP IF NOT

SCRMD0:	INC	DH			;ADVANCE LINE POINTER
	CMP DH,BYTE PTR LRYWND		;OUT OF WINDOW?
	JBE	WNDEXT			;EXIT IF NOT
	DEC	DH			;MOVE CURSOR BACK
	JMP SHORT SCRWND		;THEN SCROOL

SCRMD1:	CALL	SCNWRT			;WRITE TO SCREEN
	CMP	DL, BYTE PTR LRXWND	;OUT OF WINDOW?
	JBE	WNDEXT			;EXIT IF NOT
	MOV DL,BYTE PTR ULXWND		;RESET TO LEFT EDGE
	JMP	SCRMD0		;THEN SCROOL WINDOW
	PAGE

WNDRET:	MOV DL,BYTE PTR ULXWND		;RESET TO LEFT EDGE OF WINDOW
WNDEXT:	CMP	CURMOD,0		;MOVING CURSOR?
	JZ	WNDXT1			;SKIP IF YES

;HERE TO JUST UPDATE CURSOR WITHOUT MOVING IT

	XOR	AX,AX			;ZERO SEGMENT REGISTER
	MOV	ES,AX
	MOV	ES:CURLOC[SI],DX	;UPDATE CURSOR POSITION
	RET

;HERE TO UPDATE CURSOR

WNDXT1:	MOV	AX,0200H		;SET NEW CURSOR POSITION
	INT	010H			;CALL BIOS
	RET

;SCROLL THE CONTENTS OF THE WINDOW

SCRWND:	CALL	WNDEXT		;RESET CURSOR
	MOV	AX,0601H	;SET TO SCROLL ONE LINE
	call	nVidia		;compensate for nVidia card bug
	call	setbkgnd
	MOV CH,BYTE PTR ULYWND	;SET UPPER LEFT CORNER
	MOV CL,BYTE PTR ULXWND
	MOV DH,BYTE PTR LRYWND	;SET LOWER RIGHT CORNER
	MOV DL,BYTE PTR LRXWND
	INT	010H		;EXECUTE VIDEO BIOS CALL
	RET
	PAGE

;WRITE CHARACTER AND ATTRIBUTE TO SCREEN
;IF MODE 0-3 OR 7 HANDLE OURSELVES, OTHERWISE LET BIOS DO IT
;INPUTS: ES, D FLAG

SCNWRT:	MOV	DI,CGALOC		;POINT CGA SCREEN
	CMP	BL,3			;IS IT CGA SCREEN?
	JLE	SCNWT2			;EXIT IF SO
	CMP	BL,7			;IS IT MDA SCREEN?
	JE	SCNWT1			;EXIT IF SO

;HERE TO HAVE BIOS HANDLE WRITING TO SCREEN

	MOV	AH,9			;SET FUNCTION
	MOV	CX,1			;WRITE ONE BYTE
	CMP	BL,13H			;256-COLOR MODE?
	MOV	BL,BYTE PTR WATTRB	; (SET THE ATTRIBUTE)
	jne	scnwt4			;jump if not mode 13h
	push	bx			;save page in bh
	mov	bh, byte ptr wattrb+1	;256 background colors
;	int	10h			;call BIOS
	call	nVidia13
	pop	bx			;restore page
	jmp	scnwt9
scnwt4:
	TEST	BL,0F0H			;IS THERE A BACKGROUND COLOR?
	JE	SCNWT0			;JUMP IF NOT
	PUSH	AX			;SAVE CHAR
	MOV	AL,BL			;SAVE FOREGROUND COLOR IN AL
	AND	AL,0FH
	SHR	BL,1			;SHIFT BACKGROUND TO FOREGROUND
	SHR	BL,1
	SHR	BL,1
	SHR	BL,1
	CMP	AL,BL			;DOES FOREGROUND = BACKGROUND COLOR
	JE	SCNWT3			;JUMP IF SO--GO XOR COLOR
	MOV	AL,0DBH			;WRITE A BLOCK IN BACKGROUND COLOR
	INT	010H			;CALL BIOS
	XOR	BL,BYTE PTR WATTRB	;GET COLOR FOR FOREGROUND
	AND	BL,00FH			;(TWO XORS WITH SAME VAL = ORIGINAL VAL)
SCNWT3:	POP	AX			;GET CHARACTER BACK
	OR	BL,080H			;SPECIFY XOR WRITE FOR BIOS
SCNWT0:	INT	010H			;CALL BIOS
scnwt9:	INC	DL			;ADVANCE X COORDINTATE
	RET

;HERE TO DO ACTUAL SCREEN WRITE
;AL=CHAR, DX=CURSOR POSITION, CL=SCREEN WIDTH

SCNWT1:	MOV	DI,MDALOC		;POINT MDA SCREEN
SCNWT2:	MOV	AH,BYTE PTR WATTRB	;LOAD ATTRIBUTE
	MOV	BP,AX			;SAVE CHAR AND ATTRIBUTE

	MOV	AL,CL			;GET SCREEN WIDTH
	MUL	DH			;WIDTH * ROWS
	ADD	AL,DL			;COLLUMN + (WIDTH * ROWS)
	ADC	AH,0			;HANDLE CARRY

	SHL	AX,1			;TIMES 2, FOR 2 BYTES PER CHAR
	ADD	AX,ES:SCROFF		;ADD IN PAGE OFFSET
	MOV	ES,DI			;POINT TO SCREEN
	MOV	DI,AX			;PUT POINTER IN INDEX

	MOV	AX,BP			;GET CHARACTER AND ATTRIBUTE
	STOSW				;STORE IN SCREEN
	INC	DL			;ADVANCE X COORDINATE
	RET

	PAGE

;ROUTINE TO HIGHLIGHT PARTS OF THE SCREEN WITH A SPECIFIC ATTRIBUTE
;WITHOUT CHANGING THE UNLYING TEXT
;HIGHLIGHT(X1,Y1,X2,Y2,ATTRIBUTE)

DSEG	SEGMENT WORD PUBLIC 'DATA'
HATTRB	DW	0		;HIGHLIGHT ATTRIBUTE
X1WIND	DW	0		;WINDOW CORNER COORDINATES
Y1WIND	DW	0
X2WIND	DW	0
Y2WIND	DW	0

OLDCUR	DW	0		;OLD CURSOR TYPE
OLDCOR	DW	0		;OLD CURSOR COORDINATE
DSEG	ENDS

INTR72	LABEL	FAR
HLIGHT	PROC	FAR
	MOV	BP,SP		;GET STACK FRAME
	MOV	HATTRB,AX	;GET THE COORDINATES AND ATTRIBUTES
	MOV	CX,[BP+TOSOFF]
	MOV	Y2WIND,CX
	MOV	CX,[BP+INTNOS]
	MOV	X2WIND,CX
	MOV	CX,[BP+INTNOS+2]
	MOV	Y1WIND,CX
	MOV	CX,[BP+INTNOS+4]
	MOV	X1WIND,CX

;SAVE OLD CURSOR AND COORDINATE

	CALL	GETPAG		;GET PAGE NUMBER INTO BH (BL IS ZEROED)
	MOV	AH,03H		;SET FUNCTION
	INT	010H		;CALL BIOS

	MOV	OLDCUR,CX	;SAVE CURSOR POSITION
	MOV	OLDCOR,DX	;SAVE CURSOR TYPE

;TURN OFF CURSOR

	MOV	AH,01H		;SET FUNCTION
	MOV	CX,2000H	;SET NO CURSOR
	INT	010H		;CALL BIOS

	MOV DH,BYTE PTR Y1WIND	;GET START Y
	MOV	CX,Y2WIND	;GET ENDING Y
	SUB	CL,DH		;CALCULATE SIZE
	INC	CX		;PLUS ONE
	PAGE

LOOP2:	PUSH	CX		;SAVE Y COUNT

	MOV DL,BYTE PTR X1WIND	;GET START X
	MOV	CX,X2WIND	;GET ENDING X
	SUB	CL,DL		;CALCULATE SIZE
	INC	CX		;PLUS ONE

LOOP1:	PUSH	CX		;SAVE X COUNT

;-------- START OF INNER PART OF LOOP ---------------------

;SET CURSOR POSITION

	MOV	AH,02H		;SELECT CURSOR FUNCTION
	INT	010H		;CALL BIOS

;READ CHARACTER AT CURSOR INTO AL (ATTRIBUTE IN AH IS IGNORED)

	MOV	AH,08H		;SELECT READ AT CURSOR FUNCTION
	INT	010H		;CALL BIOS

;REWRITE WITH NEW ATTRIBUTE

	MOV	AH,9			;SET FUNCTION
	MOV	BL,BYTE PTR HATTRB	;SET NEW ATTRIBUTE

	PUSH	ES
	XOR	CX,CX			;POINT TO LOW MEMORY
	MOV	ES,CX
	MOV	CL,BYTE PTR ES:MODLOC	;GET VIDEO MODE
	POP	ES

	CMP	CL,3			;IS IT MODES 0-3
	JBE	HILI0			;JUMP IF SO
	CMP	CL,7			;IS IT MDA SCREEN?
	JE	HILI0			;JUMP IF SO
	CMP	CL,13H			;256-COLOR MODE?
	JE	HILI0			;JUMP IF SO (BKGND=PAGE=0=BLACK)

	TEST	BL,0F0H			;IS THERE A BACKGROUND COLOR?
	JE	HILI0			;JUMP IF NOT
	PUSH	AX			;SAVE CHAR
	MOV	AL,0DBH			;WRITE A BLOCK IN BACKGROUND COLOR
	SHR	BL,1			;SHIFT BACKGROUND TO FOREGROUND
	SHR	BL,1
	SHR	BL,1
	SHR	BL,1
	MOV	CX,1			;WRITE ONE BYTE
	INT	010H			;CALL BIOS
	POP	AX			;GET CHARACTER BACK
	XOR	BL,BYTE PTR HATTRB	;GET COLOR FOR FOREGROUND
	AND	BL,00FH			;(TWO XORS WITH SAME VAL = ORIGINAL VAL)
	OR	BL,080H			;SPECIFY XOR WRITE FOR BIOS
HILI0:
	MOV	CX,1			;WRITE ONE BYTE
	INT	010H			;CALL BIOS

;-------- END OF INNER PART OF LOOP -------------------------

;ADVANCE INNER AND OUTER LOOP CONTROL

	POP	CX		;RESTORE COUNT X
	INC	DL		;ADVANCE X
	LOOP	LOOP1		;AND LOOP

	POP	CX		;RESTORE Y COUNT
	INC	DH		;ADVANCE Y
	LOOP	LOOP2		;AND LOOP
	PAGE

;RESTORE OLD CURSOR POSITION

	MOV	AH,02H		;SET BIOS FUNCTION
	MOV	DX,OLDCOR	;RESTORE COORDINATE
	INT	010H		;CALL BIOS

;RESTORE OLD CURSOR TYPE

	MOV	CX,OLDCUR	;GET OLD CURSOR TYPE
	MOV	AH,01H		;SET BIOS FUNCTION
	INT	10H		;CALL BIOS
	RET	8		;AND RETURN
HLIGHT	ENDP

	PAGE
;GET VIDEO SCREEN PAGE INTO BH

GETPAG:	PUSH	ES		;SAVE ES
	XOR	BX,BX		;POINT TO SEGMENT ZERO
	MOV	ES,BX
	MOV	BH,ES:SCRPAG	;GET SCREEN PAGE
	POP	ES		;RESTORE ES
	RET

;Set the background fill color in bh. If the video mode is text then the
; attribute provided by the Attrib intrinsic (69) can be used directly.
; But if the video mode is graphic then the high nibble of the attribute
; must be used to set the fill color. (Attemping to use a background
; color other than black (0) for modes 4, 5, 6, and 11h gives vertical
; stripes instead.) Mode 13h has 256 foreground and background colors.

setbkgnd:
	push	es			;save es
	xor	bx, bx			;point to BIOS segment
	mov	es, bx
	mov	bl, byte ptr es:MODLOC	;get video mode
	mov	bh, byte ptr WATTRB	;get attribute
	cmp	bl, 3			;skip if it's a text mode
	jbe	sw10
	cmp	bl, 7
	je	sw10

	mov	cl, 4			;get high nibble of attribute 
	shr	bh, cl
	cmp	bl, 13h			;graphic mode 13h has 256 background
	jne	sw10			; colors
	 mov	bh, byte ptr WATTRB+1
sw10:
	pop	es			;restore es
	ret


;Deal with the buggy nVidia card. Make sure VGA registers are in their default
; states (otherwise you're apt to get a screenful of vertical lines).

nVidia:	push	ax
	push	dx

	mov	dx, 3CEh
	mov	ax, 0FF08h		;enable all 8 bits in bit mask register
	out	dx, ax
	mov	ax, 0003h		;make sure xor mode is turned off
	out	dx, ax
	mov	ax, 0001h		;disable set/reset function
	out	dx, ax

	pop	dx
	pop	ax
	ret


;Routine to display a character on a mode 13h graphic screen. Noramlly interrupt
; 10h function 09h would be used, but the nVidia card doesn't handle background
; colors other than black.
;Inputs:
; al = character (0..255)
; bl = foreground color (0..255)
; bh = background color (0..255)
; [450h] = BIOS cursor position: (column in low byte and row in high byte)

nVidia13:
	push	ax		;save registers
	push	cx
	push	dx
	push	si
	push	di
	push	bp
	push	es

	push	ax		;save character that is in al
	push	bx		;save foreground and background colors
	mov	ax, 1130h	;get font table location
	mov	bh, 03h		;8x8 font
	int	10h		;es:bp:= seg:off of (256-char) font table
	pop	bx		;restore colors
	pop	ax		;restore character

;Byte:= Peek(FontSeg,  FontOff + Ch*FontHeight);
	mov	dl, 8		;8 dots of font width
	mul	dl		;character*8; ax:= al*dl
	add	ax, bp		; + offset to font table
	xchg	si, ax		;set up pointer to font bytes

;Point to location on graphic screen that corresponds to char cursor position
;di:= (row*320 + col)*8
	push	ds
	xor	ax, ax
	mov	ds, ax
	mov	ax, ds:[450h]
	pop	ds

	push	ax		;save column that is in al
	mov	al, ah		;get row
	mov	ah, 0

	mov	dx, 320
	mul	dx		;dx:ax:= ax*320
	mov	di, ax
	pop	ax		;get column
	mov	ah, 0
	add	di, ax
	shl	di, 1		;*8
	shl	di, 1
	shl	di, 1

	mov	cx, 8		;for 8 scan lines in font...
@@20:	mov	dl, 8		;for 8 dots of font width...
	mov	dh, es:[si]	;get font byte from table (es = FontSeg)

	push	es		;save FontSeg
	mov	ax, 0A000h	;point to graphic screen instead
	mov	es, ax

@@30:	shl	dh, 1		;test font bit by moving it into carry flag
	mov	al, bh		;background color
	jnc	@@35
	 mov	al, bl		;foreground color
@@35:	stosb			;write pixel to screen; es:[di++]:= al
	dec	dx		;(dh=0 when dl=0)
	jne	@@30		;loop for 8 dots of font width

	pop	es		;restore FontSeg

	inc	si		;next byte in font table
	add	di, 320-8	;next scan line down
	loop	@@20		;loop for 8 scan lines

	pop	es		;restore registers
	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	ax
	ret
