\XLINK.XPL	04-FEB-2001
\OBJECT MODULE LINKER FOR I2L AND COM FILES
\ COPYRIGHT LARRY FISH 1990-2001
\
\This program is free software; you can redistribute it and/or modify it under
\ the terms of the GNU General Public License version 2 as published by the
\ Free Software Foundation.
\This program is distributed in the hope that it will be useful, but WITHOUT
\ ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
\ FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
\ details.
\You should have received a copy of the GNU General Public License along with
\ this program (in the file LICENSE.DOC); if not, write to the Free Software
\ Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\
\You can reach me at:			Mail:	Loren Blaney
\ Email: loren_blaney@idcomm.com		502 Pine Glade Dr.
\						Nederland, CO 80466, USA
\
code
ABS=0,		RAN=1,		REM=2,		RESERVE=3,
SWAP=4,		EXTEND=5,	RESTART=6,	CHIN=7,
CHOUT=8,	CRLF=9,		INTIN=10,	INTOUT=11,
TEXT=12,	OPENI=13,	OPENO=14,	CLOSE=15,
ABORT=16,	TRAP=17,	FREE=18,	RERUN=19,
GETHP=20,	SETHP=21,	GETERR=22,	CURSOR=23,
FSET=24,	SETRUN=25,	HEXIN=26,	HEXOUT=27,
CHAIN=28,	FOPEN=29,	WRITE=30,	READ=31,
FCLOSE=32,	CHKKEY=33,	SOFTINT=34,	GETREG=35,
BLIT=36,	PEEK=37,	POKE=38,	SOUND=39,
CLEAR=40,	POINT=41,	LINE=42,	MOVE=43,
READPIX=44,	SETVID=45	FIX=50,		POUT=64,
PIN=65,		INTRET=66,	EXTJMP=67,	EXTCAL=68;

code real

RLRES=46,	RLIN=47,	RLOUT=48,	FLOAT=49,
RLABS=51,	FORMAT=52,

SQRT=53,	LN=54,		EXP=55,		SIN=56,
ATAN2=57,	MOD=58,		LOG=59,		COS=60,
TAN=61,		ASIN=62,	ACOS=63;


char
	HEXTAB;	\TABLE OF HEX CHARACTERS


integer
	CPUREG,	\HOLD CPU REGISTER FOR DOS CALLS
	FPTR,	\FILE LIST POINTER TO CURRENT INPUT FILE
	PC,	\PROGRAM COUNTER FOR LOADER
	MBASE,	\BASE FOR THE CURRENT MODULE
	OUTLOW,	\POINTER TO CURRENT OUTPUT FILE (LOW WORD)
	OUTHI;	\POINTER TO CURRENT OUTPUT FILE (HIGH WORD)


integer
	LABELS,	\ARRAY OF LABEL NAMES
	LADDRS,	\ARRAY OF LABEL ADDRESS

	REFER,	\REFERENCE NAME
	REFLOW,	\LOW WORD OF LOCATION TO BE LINKED
	REFHI,	\HIGH WORD OF LOCATION TO BE LINKED
	LABPTR,	\INDEX FOR LABELS
	REFPTR;	\INDEX FOR REFERENCES


define
	MAXREF=1000,	\MAXIMEM NUMBER OF REFERENCES
	MAXLAB=200,	\MAXIMUM NUMBER OF LABELS
	LSTSIZ=100,	\MAXIMUM FILE LIST
	LABSIZ=16;	\MAXIMUM SIZE OF LABELS


integer
	I,
	VERBOSE,\FLAGS DISPLAY ALL MESSAGES
	LSTPTR,	\FILE LIST POINTER
	LHAND,	\LIST OF INPUT HANDLESSS
	LTYPE,	\LIST OF INPUT FILE TYPES
	LNAME;	\LIST OF INPUT FILE NAMES

integer
	PHAND,	\PARENT PROGRAM HANDLE
	INHAND,	\CURRENT CHILDS PROGRAM HANDLE
	OUTHAND;\OUTPUT HANDLE

integer
	SYSINF;	\POINTS DOS/SYSTEM INFO

define
	DSK=3;	\DISK CHANNEL

define	\SOME CHARACTER DEFINITIONS

	EOF=$1A,	\END OF LINE
	CR=$0D,		\CARRIAGE RETURN
	LF=$0A,		\LINE FEED
	TAB=$09,	\HORIZONAL TAB
	SP=$20;		\SPACE


define	\EXTENSION HASHES
	XLBEXT=19610,
	I2LEXT=12949,
	COMEXT=20368;


procedure FATAL(S);
\HANDLE FATAL ERRORS
char S;
begin
TEXT(0,S);
CRLF(0);
ABORT;
end;


procedure MAKEUP(C);
\CONVERT LOWER CASE TO UPPER
integer C;
return if C>=^a & C<=^z then C-$20 else C;


procedure SCOMP(S1,S2);
\COMPARE STRINGS
char S1,S2;
int I;
for I:=0,32767 do
[if S1(I)#S2(I) then return false;
if S1(I)>$7F then return true];


procedure SCOPY(S1,S2);
\COPY STRINGS S2 INTO S1
char S1,S2;
int I;
for I:=0,32767 do
[S1(I):=S2(I);if S1(I)>$7F then return];


\----- ROUTINES TO PARSE AND OPEN FILE FROM COMMAND LINE ----


procedure FLIST;
\SETUP AND OPEN FILE LIST
addres TAIL,NAME;
int TPTR,STRPTR,NAMPTR,EXTPTR,CUREXT,TERM;
def TALMAX=127;


	procedure GETTAIL;
	\GET COMMAND TAIL FROM PSP
	integer PSEG,CSEG;
	begin
	SYSINF:=GETREG;
	PSEG:=SYSINF(11);
	CSEG:=SYSINF(12);
	BLIT(PSEG,$81,CSEG,TAIL,TALMAX);
	end;


	procedure GETSWITCH;
	\RETURN FIRST SWITCH FROM COMMAND TAIL
	int P,T;
	begin
	for P:=0,TALMAX-1 do
		case TAIL(P) of
		CR: return 0;
		^/:	begin
			TAIL(P):=SP;
			T:=TAIL(P+1);
			if P<TALMAX-1 then TAIL(P+1):=SP;
			return MAKEUP(T);
			end
		else;
	return 0;
	end;

	procedure PARSE;
	\PARSE NEXT FILENAME
	begin
	EXTPTR:=-1;
	\EAT SEPARATORS
	loop	case TAIL(TPTR) of
		SP,TAB,^+,^,:TPTR:=TPTR+1
		else quit;
	STRPTR:=TPTR;
	NAMPTR:=TPTR;
	loop
		begin
		TPTR:=TPTR+1;
		case TAIL(TPTR) of
		^:,^\:NAMPTR:=TPTR+1;
		^.:EXTPTR:=TPTR;
		^,,^+,TAB,SP,CR: quit
		else;
		end;
	if EXTPTR<0 then EXTPTR:=TPTR;

	return TAIL(TPTR);
	end;


	procedure DOOPEN(EXT,MODE,DEF);
	\OPEN FILE POINTED TO BY PARSE ROUTINE
	\IF DEF=TRUE, FORCE DEFAULT EXTENSION
	char EXT;int DEF,MODE,I,H;
	begin
	for I:=0,EXTPTR-STRPTR-1 do NAME(I):=TAIL(STRPTR+I);
	if DEF ! EXTPTR=TPTR then
		begin
		NAME(I):=^.;
		NAME(I+1):=EXT(0);
		NAME(I+2):=EXT(1);
		NAME(I+3):=EXT(2);
		I:=I+4;
		end
	else for I:=I,I+TPTR-EXTPTR-1 do NAME(I):=TAIL(STRPTR+I);
	NAME(I-1):=NAME(I-1)!$80;

	TRAP($FFFB);
	H:=FOPEN(NAME,MODE);
	TRAP($FFFF);
	if GETERR=3 then
		begin
		TEXT(0,NAME);TEXT(0," --");CRLF(0);
		FATAL("UNABLE TO OPEN");
		end;
	return H;
	end;


	procedure TESTEXT;
	\TEST EXTENSION TYPE
	int P,E1,E2,E3;
	begin
	E1:=MAKEUP(TAIL(EXTPTR+1));
	E2:=MAKEUP(TAIL(EXTPTR+2));
	E3:=MAKEUP(TAIL(EXTPTR+3));
	return E1+SWAP(E2)+E3;
	end;


	procedure GETNAME(NAME);
	\RETURN NAME PART OF FILENAME
	char NAME;int P;
	begin
	P:=0;
	loop
		begin
		NAME(P):=MAKEUP(TAIL(P+NAMPTR));
		P:=P+1;
		if (P+NAMPTR)=EXTPTR then quit;
		if P>=LABSIZ then quit;
		end;
	if P>0 then NAME(P-1):=NAME(P-1)!$80 else NAME(0):=SP!$80;
	end;





begin	\OF FLIST
TAIL:=RESERVE(TALMAX);
NAME:=RESERVE(80);
GETTAIL;
VERBOSE:=GETSWITCH=^V;
TPTR:=0;
LSTPTR:=0;
if PARSE=CR then FATAL("NO LINK FILES SPECIFIED!");
if EXTPTR#TPTR then
	if TESTEXT=COMEXT then FATAL("PARENT CANNOT BE .COM FILE");
PHAND:=DOOPEN("I2L",false,0);
OUTHAND:=DOOPEN("C2L",true,1);

loop
	begin
	TERM:=PARSE;
	if EXTPTR=TPTR then FATAL("EXTENSIONS REQUIRED");
	CUREXT:=TESTEXT;
	case CUREXT of
	 	COMEXT,I2LEXT,XLBEXT:[]
		else FATAL("BAD FILE EXTENSION");
	LTYPE(LSTPTR):=CUREXT;

	LHAND(LSTPTR):=DOOPEN("???",false,0);
	GETNAME(LNAME(LSTPTR));
	LSTPTR:=LSTPTR+1;
	if LSTPTR>=LSTSIZ then quit;
	if TERM=CR then quit;	
	end;
end;


\-------------- DISK I-O ROUTINES -----------------------


procedure DSKOUT(C);
\OUTPUT CHAR TO DISK, COUNT EACH CHAR
integer C;
begin
CHOUT(DSK,C);
OUTLOW:=OUTLOW+1;
if OUTLOW=0 then OUTHI:=OUTHI+1;
end;


procedure DBOUT(B);
\OUTPUT A BYTE TO DISK
int B;
begin
DSKOUT(HEXTAB((B>>4)&$0F));
DSKOUT(HEXTAB(B&$0F));
end;


procedure DCRLF;
\OUTPUT CRLF TO DISK
[DSKOUT(CR);DSKOUT(LF);];



procedure DWOUT(W);
\OUTPUT WORD TO DISK
int W;
begin
\NOTE: HIGH-LOW BYTE ORDER
DBOUT(SWAP(W));
DBOUT(W);
end;


procedure MAKBIN(C);
\CONVERT HEX CHAR TO BINARY
int C;
return if C>^9 then C-$37 else C-^0;



procedure DGETBYT;
\GET BYTE FROM DISK
return (MAKBIN(CHIN(DSK))<<4) ! MAKBIN(CHIN(DSK));



procedure DGETWRD;
\GET WORD FROM DISK
return SWAP(DGETBYT) ! DGETBYT;



procedure GETSTRING(S);
\READ A STRING FROM INPUT FILE
char S;int P,C;
begin
P:=0;
loop
	begin
	C:=CHIN(DSK);
	if C<$21 then quit;
	S(P):=C;
	P:=P+1;
	end;
if P>0 then S(P-1):=S(P-1)!$80 else S(0):=$A0;
if C=CR then C:=CHIN(DSK);
end;


\---------------- ROUTINES TO HANDLE FILES ---------------


procedure DOXLB;
\READ AN XPL LIBRARY AND COPY
\FILE NAMES INTO FILE LIST

char 	FILESPEC;	\FILE SPECIFICATION
def	NAMLEN=80;	\MAXIMUM FILE NAME LENGTH
int
	CHAR,		\GLOBAL CHARACTER
	SPCPTR,		\POINTS TO END OF FILESPEC
	EXTHSH,		\HASH FOR CURRENT EXTENSION
	EXTPTR,		\POINTS TO START OF EXTENSION
	NAMPTR,		\POINTS TO START OF NAME PART
	EOFLAG;		\FLAGS END OF FILE


	procedure GETCD;
	\GET A CHARACTER FROM DISK
	[CHAR:=MAKEUP(CHIN(DSK));EOFLAG:=CHAR=EOF;];


	procedure GETSPEC;
	\READ NEXT FILE SPEC FROM DISK FILE
	begin
	repeat GETCD until CHAR>SP ! EOFLAG;
	SPCPTR:=0;EXTPTR:=0;NAMPTR:=0;
	loop
		begin
		if EOFLAG then quit;
		case CHAR of 
		^,,^+,SP,TAB,CR: quit;
		   ^.: EXTPTR:=SPCPTR;
		^\,^:: NAMPTR:=SPCPTR
		else;
		FILESPEC(SPCPTR):=CHAR;
		SPCPTR:=SPCPTR+1;
		if SPCPTR>=NAMLEN then FATAL("FILE SPEC TOO LONG");
		GETCD;
		end;
	if SPCPTR#0 then FILESPEC(SPCPTR-1):=FILESPEC(SPCPTR-1) ! $80
		else FILESPEC(0):=SP ! $80;
	end;


	procedure GETHASH;
	\RETURN EXTENSION HASH
	int E1,E2,E3;
	begin
	E1:=FILESPEC(EXTPTR+1);
	E2:=FILESPEC(EXTPTR+2);
	E3:=FILESPEC(EXTPTR+3)&$7F;
	return E1+SWAP(E2)+E3;
	end;


	procedure DOOPEN;
	\OPEN CURRENT FILE SPEC
	char EXT;int DEF,MODE,I,H;
	begin
	TRAP($FFFB);
	H:=FOPEN(FILESPEC,0);
	TRAP($FFFF);
	if GETERR=3 then
		begin
		TEXT(0,FILESPEC);TEXT(0," --");CRLF(0);
		FATAL("UNABLE TO OPEN");
		end;
	return H;
	end;


	procedure GETNAME(NAME);
	\RETURN NAME PART OF FILESPEC
	char NAME;int P;
	begin
	P:=0;
	loop
		begin
		NAME(P):=FILESPEC(P+NAMPTR);
		P:=P+1;
		if (P+NAMPTR)=EXTPTR then quit;
		if P>=LABSIZ then quit;
		end;
	if P>0 then NAME(P-1):=NAME(P-1)!$80 else NAME(0):=SP!$80;
	end;


begin
FILESPEC:=RESERVE(NAMLEN);
loop
	begin
	GETSPEC;

	if EOFLAG & SPCPTR=0 then quit;
	if EXTPTR=0 then FATAL("FILES MUST HAVE EXTENSIONS");
	EXTHSH:=GETHASH;

	case EXTHSH of
	 	COMEXT,I2LEXT,XLBEXT:[]
		else FATAL("BAD FILE EXTENSION");
	LTYPE(LSTPTR):=EXTHSH;
	LHAND(LSTPTR):=DOOPEN;
	GETNAME(LNAME(LSTPTR));

	LSTPTR:=LSTPTR+1;
	if LSTPTR>=LSTSIZ then quit;
	if EOFLAG then quit;	
	end;

end;




procedure SETLABEL(L);
\SET LABEL'S VALUE TO CURRENT PC
char L;
begin
SCOPY(LABELS(LABPTR),L);
LADDRS(LABPTR):=PC;
LABPTR:=LABPTR+1;
if LABPTR>=MAXLAB then FATAL("TOO MANY EXTERNAL PROCEDURES");
end;




procedure SETREFER(L);
\SET A REFERENCE'S VALUE TO CURRENT OUTPUT POINTER
char L;
begin
SCOPY(REFER(REFPTR),L);
REFLOW(REFPTR):=OUTLOW;
REFHI(REFPTR):=OUTHI;
REFPTR:=REFPTR+1;
if REFPTR>=MAXREF then FATAL("TOO MANY REFERENCES");
DSKOUT(^*);DSKOUT(^X);DSKOUT(^X);DSKOUT(^X);DSKOUT(^X);
DCRLF;
end;




procedure DOI2L;
\PROCESS AN I2L TYPE FILE
char L;integer C,T;
begin
L:=RESERVE(LABSIZ);
loop
	begin
	C:=CHIN(DSK);

	\HANDLE SOME COMMANDS
	case C of
	^^:[DSKOUT(C);DWOUT(DGETWRD+MBASE);];
	^;:[DSKOUT(^;);T:=DGETWRD;PC:=MBASE+T;DWOUT(PC);]

	\HANDLE HEX CHARACTERS
	else if C>=^0  then
		begin
		DSKOUT(C);
		DSKOUT(CHIN(DSK));
		PC:=PC+1;
		end

	\HANDLE THE REST OF LOADER COMMANDS
	else case C of
		^*: [DSKOUT(C);DWOUT(DGETWRD+MBASE);PC:=PC+2;];
		^%: [GETSTRING(L);SETLABEL(L);];
		^#: [GETSTRING(L);SETREFER(L);PC:=PC+2;];
		^$: [MBASE:=PC;quit;]
	else DSKOUT(C);
	end;
end;



procedure DOCOM;
\PROCESS A COM TYPE FILE
int C;
begin
DCRLF;
C:=0;
TRAP($FFFB);
repeat begin
	DBOUT(CHIN(DSK));
	PC:=PC+1;
	C:=C+1;
	if REM(C/32)=0 then DCRLF;
	end
until GETERR#0;
TRAP($FFFF);
DCRLF;
MBASE:=PC;
end;


\--------------- ROUTINES TO DO ACTUAL LINKING -------------

procedure LOOKUP(S);
\LOOKUP A NAME IN LABEL TABLE
char S;int P;
begin
for P:=0,LABPTR-1 do if SCOMP(S,LABELS(P)) then return P;
return -1;
end;


procedure PATCH(P1,P2);
\PATCH REFERENCE IN OUTPUT FILE
int P1,P2;
begin
if VERBOSE then
	begin
	TEXT(0,"NAME: ");TEXT(0,LABELS(P1));
	TEXT(0,"	ADDRESS: ");HEXOUT(0,LADDRS(P1));
	TEXT(0," DISK PATCH: ");HEXOUT(0,REFHI(P2));
	TEXT(0," : ");HEXOUT(0,REFLOW(P2));
	CRLF(0);
	end;

\MOVE FILE POINTER TO POINT TO PATCH
CPUREG(0):=$4200;
CPUREG(1):=OUTHAND;
CPUREG(3):=REFLOW(P2)+1;
CPUREG(2):=if REFLOW(P2)=$FFFF then REFHI(P2)+1 else REFHI(P2);
SOFTINT($21);
HEXOUT(DSK,LADDRS(P1));
end;


procedure DISTABLES;
\DISPLAY LABELS AND REFERENCES
int P;
begin
TEXT(0,"

LABELS FOUND:

");
for P:=0,LABPTR-1 do
	begin
	TEXT(0,LABELS(P));
	TEXT(0,"	- ");
	HEXOUT(0,LADDRS(P));
	CRLF(0);
	end;

TEXT(0,"

REFERENCES FOUND:

");
for P:=0,REFPTR-1 do
	begin
	TEXT(0,REFER(P));
	TEXT(0,"	- ");
	HEXOUT(0,REFHI(P));
	TEXT(0," : ");
	HEXOUT(0,REFLOW(P));
	CRLF(0);
	end;
CRLF(0);
end;



procedure LINKUP;
\LINK UP ALL REFERENCES
int P,LAB;
begin
if VERBOSE then DISTABLES;

\MUST USE SMALL BUFFERS HERE
FSET(OUTHAND,^o);
for P:=0,REFPTR-1 do
	begin
	LAB:=LOOKUP(REFER(P));
	if LAB<0 then 
		begin
		TEXT(0,"UNABLE TO LINK: ");
		TEXT(0,REFER(P));
		CRLF(0);
		ABORT;
		end
		else PATCH(LAB,P);
	end;
end;


procedure CLOSEALL;
\CLOSE ALL INPUT FILES
int FPTR;
for FPTR:=0,LSTPTR-1 do	FCLOSE(LHAND(FPTR));



procedure PROCESS(P);
int P;
\DISPLAY CURRENT FILE BEING PROCESSED
begin
TEXT(0,"PROCESSING: ");
TEXT(0,LNAME(P));
case LTYPE(P) of
	COMEXT: TEXT(0,".COM");
	I2LEXT: TEXT(0,".I2L");
	XLBEXT: TEXT(0,".XLB")
else TEXT(0,"???");
CRLF(0);
end;


begin
CPUREG:=GETREG;
HEXTAB:="0123456789ABCDEF ";

LABELS:=RESERVE(MAXLAB*2);
for I:=0,MAXLAB-1 do LABELS(I):=RESERVE(LABSIZ);
LADDRS:=RESERVE(MAXLAB*2);

REFER:=RESERVE(MAXREF*2);
for I:=0,MAXREF-1 do REFER(I):=RESERVE(LABSIZ);
REFLOW:=RESERVE(MAXREF*2);
REFHI:=RESERVE(MAXREF*2);


LABPTR:=0;
REFPTR:=0;

OUTLOW:=0;
OUTHI:=0;
MBASE:=0;
PC:=0;

LHAND:=RESERVE(LSTSIZ*2);
LTYPE:=RESERVE(LSTSIZ*2);
LNAME:=RESERVE(LSTSIZ*2);
for I:=0,LSTSIZ-1 do LNAME(I):=RESERVE(LABSIZ);

TEXT(0,"
-- I2L/COM FILE LINKER, VER 2.4 --
     COPYRIGHT 2001 LARRY FISH

XPL0 comes with ABSOLUTELY NO WARRANTY.
This is free software. You are welcome and encouraged to redistribute
it under certain conditions. For details see LICENSE.DOC.
");

FLIST;

FSET(PHAND,^I);
FSET(OUTHAND,^O);

if VERBOSE then 
	begin
	CRLF(0);
	TEXT(0,"PROCESSING: PARENT");
	CRLF(0);
	end;

OPENI(DSK);
DOI2L;

\THIS CANNOT BE A FOR LOOP BECAUSE THE LIST MAY GROW
FPTR:=0;
loop
	begin
	if VERBOSE then PROCESS(FPTR);
	FSET(LHAND(FPTR),^I);
	OPENI(DSK);
	case LTYPE(FPTR) of
	COMEXT:[SETLABEL(LNAME(FPTR));DOCOM;];
	I2LEXT: DOI2L;
	XLBEXT: DOXLB
	else;
	FPTR:=FPTR+1;
	if FPTR>=LSTPTR then quit;
	end;

DSKOUT(^$);
DSKOUT(EOF);
CLOSE(DSK);
LINKUP;
FCLOSE(OUTHAND);
CLOSEALL;
end;
