;NMAIN.ASM	2-JUN-2012
;****** XPL NATIVE LANGUAGE RUNTIME PACKAGE  **********
;**           FOR IBM PC AND CLONES                  **
;**              VERSION 3.0 (also see XPLVER)       **
;**                                                  **
;** COPYRIGHT LARRY FISH 1989-2012                   **
;** CONTRIBUTIONS BY PETER BOYLE, LOREN BLANEY AND   **
;**    RICHARD OTTOSEN                               **
;** BASED UPON APPLE VERSIONS WRITTEN BY PETER BOYLE **
;******************************************************
;
;
;This program is free software; you can redistribute it and/or modify it under
; the terms of the GNU General Public License version 2 as published by the
; Free Software Foundation.
;This program is distributed in the hope that it will be useful, but WITHOUT
; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
; FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
; details.
;You should have received a copy of the GNU General Public License along with
; this program (in the file LICENSE.TXT); if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;You can reach the authors at: loren.blaney@gmail.com
;
;
;************************************************
;*                                              *
;* MAIN MODULE FOR NATIVE XPL0 RUN-TIME PACKAGE *
;*                                              *
;************************************************
;
;REVISIONS:
;V2.4, 12-FEB-2001, Modify to support XPLX V2.4: Preserve SI & DI registers,
; conditional assembly uses DI to hold HP. Fix Clear intrinsic for mode $6A.
; Initialize device 6 window to actual screen size (not necessarily 80x25).
; Add IRQ intrinsic (=80). Optimize declared arrays (MKARRAY). Fix rounding
; error in Rlout. Equip intrinsic recognizes 586.
;V2.4.2, 11-MAR-2002, Fix bug caused by aligning arrays on word boundaries.
; This only affected the optimized (XPLX-FLAGOPT) version.
;V2.4.3, 26-APR-2002, Fix bug: Ctrl-C & Break now restore div-by-0 vector,
; doubled Blit intrinsic speed.
;V2.4.4, 10-JUN-2002, Blit avoids screen glitches by using increment mode.
;V2.4.5, 15-SEP-2003, Modify Equip intrinsic (77) to work with Windows XP.
; Speed measurement changed by a factor of 10 (very rough). 5 = PC-XT.
;V2.4.6, 28-JUL-2004, Fix SetWin intrinsic (70) and device 6 to have correct
; background fill and scroll color when in a graphic video mode. Mode 13h has
; 256 foreground and background colors. Previously the background was always
; black (0). Point intrinsic is 0, 5 or 70 times faster depending on graphic
; mode. Horizontal line draw is up to 4 times faster for planar graphic modes
; (0Dh..12h). Fix Ctrl-Break. Compensate for nVidia bug that fills graphic
; screen with vertical bars. Set ES register to PSPSEG in Restart intrinsic.
;V2.4.7, 5-DEC-2004, Much faster ReadPix (intrinsic 44) for mode 13h.
;	 9-JUN-2005, Fix bug in Chain intrinsic where ES did not point to the
; PSP (=DS). The original code always assumed ES=DS. It no longer does.
;V2.5, 14-Feb-2006, Released.
;V2.5.1, 14-Jul-2006, Alternate Text intrinsic for null-terminated strings.
;V2.5.2, 26-Dec-2006, Fix background colors for mode 13h on nVidia card.
;V2.6, 28-Mar-2008, Ignore underlines in IntIn, HexIn, and RlIn; restore
; div-by-0, ctrl-C and ctrl-break vectors in Restart intrinsic. Return I2L
; error numbers to DOS.
;V2.7, (No changes. Changes were only to I2L version.)
;V2.8, (No changes. Changes were only to I2L version.)
;V2.9, 31-Oct-2011, More random random number generator.
;V3.0, 02-Jun-2012, Faster, even more random random number generator. Copy
; command tail into pseudo device 8. Fix 10E+000 error in scientific notation
; due to rounding, and 1000E+000 error in engineering notation. Clear and SetVid
; intrinsics set pen to upper-left corner. Fix Sound intrinsic so date advances
; at midnight.
;
;
;NAMES THE COMPILED CODE NEEDS TO KNOW ABOUT

	EXTRN PROGRM:NEAR

	PUBLIC STKPTR
	PUBLIC HP,REMAIN,HEAPLO
	PUBLIC TRUVAL,FALVAL
	PUBLIC BASE0,BASE1,BASE2,BASE3,BASE4,BASE5,BASE6,BASE7

	PUBLIC STACKLO,STACKHI

	PUBLIC INTR0,INTR1,INTR2,INTR3,INTR4,INTR5,INTR6,INTR7
	PUBLIC INTR8,INTR9,INTR10,INTR11,INTR12,INTR13,INTR14
	PUBLIC INTR15,INTR16,INTR17,INTR18,INTR19,INTR20,INTR21
	PUBLIC INTR22,INTR23,INTR24,INTR25,INTR26,INTR27,INTR28
	PUBLIC INTR29,INTR30,INTR31,INTR32,INTR33,INTR34,INTR35
	PUBLIC INTR36,INTR37,INTR38,INTR39,INTR40,INTR41,INTR42
	PUBLIC INTR43,INTR44,INTR45,INTR46,INTR47,INTR48,INTR49
	PUBLIC INTR50,INTR51,INTR52,INTR53,INTR54,INTR55,INTR56
	PUBLIC INTR57,INTR58,INTR59,INTR60,INTR61,INTR62,INTR63
	PUBLIC INTR64,INTR65,INTR66,INTR67,INTR68,INTR69,INTR70
	PUBLIC INTR71,INTR72,INTR73,INTR74,INTR75,INTR76,INTR77
	PUBLIC INTR78,INTR79,INTR80,INTR12A

	PUBLIC FLODDO,FSTODO
	PUBLIC FADDDO,FSUBDO,FMULDO,FDIVDO
	PUBLIC TRIDO,STTDO,FGTDO,FGEDO,FLTDO,FLEDO,FNEDO,FEQDO
	PUBLIC STSRDO,LDSRDO,LSHORT,SSHORT,MKARRAY
	PAGE

;THIS IS A TEMPORARY STACK TO START THE PROGRAM

STEMP	SEGMENT BYTE STACK 'STACK'
	DW	16 DUP(?)
STEMP	ENDS

CSEG	SEGMENT	DWORD PUBLIC 'CODE'	;START CODE SEGMENT
	ASSUME	CS:CSEG,DS:DSEG

START	PROC	NEAR
	PUSH	DS			;SAVE OLD DATA SEGMENT
	PUSH	AX			;SAVE AX

	MOV	AX,DSEG			;POINT TO NEW DATA SEGMENT
	MOV	DS,AX

	POP	AXREG			;SAVE REGISTER FROM STACK
	POP	DSREG

	MOV	ENTSTK,SP		;SAVE ENTRY STACK POINTER
	MOV	BXREG,BX		;SAVE ALL REGISTERS
	MOV	CXREG,CX		;FOR PARAMETER PASSING
	MOV	DXREG,DX
	MOV	DIREG,DI
	MOV	SIREG,SI
	MOV	BPREG,BP
	MOV	CSREG,CS
	MOV	SSREG,SS
	MOV	ESREG,ES
	MOV	PSPSEG,ES		;LOCATE PSP SEGMENT
	PUSHF
	POP	AX
	MOV	PSWREG,AX

	MOV	AX,DS			;INITIALIZE SEGMENT REGS
	CLI				;NO INTERRUPTS DURING STACK SETUP
	MOV	SS,AX
	MOV	SP,OFFSET STACKHI	;START STACK UNDER HEAP AND LOCALS
	STI				;RESTORE INTERRUPTS

	MOV BYTE PTR ERRNUM,0		;NO ERRORS YET
	MOV	TRAPS,0FFFFH		;TRAP ALL ERRORS

	MOV	AX,OFFSET HEAPLO
	IF	FLAGOPT
	MOV	DI,AX			;SET START OF HEAP
	ELSE
	MOV	HP,AX			;SET START OF HEAP
	ENDIF
	MOV	BASE0,AX		;PRESET LEVEL 0
	CALL	SETDVZ			;SET DIVIDE 0 VECTOR
	CALL	SETINT			;INITIALIZE INTRINSICS

	IF FLAG387			;IF 387 THEN SETUP FOR COPROCESSOR
	CALL	TST387			;SET COPROCESSOR
	ENDIF

	CALL	DOPGSZ			;CALCULATE PROGRAM SIZE
	CALL	RESIZE			;SHRINK DOS MEMORY ALLOCATION

;Copy the remainder of the command line (the command tail) into pseudo device 8
	CALL	PSOPNO			;(IN CASE OF RESTART)
	CALL	PSOPNI
	MOV	SI,81H
	CLD
NAT10:	LODSB	ES: BYTE PTR 0		;AL:= ES:[SI++]
	CALL	PSOUT
	CMP	AL,0DH			;CR
	JNE	NAT10

	CALL FAR PTR ENTRY		;CALL THE PROGRAM
	CMP	ERRNUM,0		;AN ERROR?
	JZ	NATEXT			;SKIP IF NOT
	PAGE

	MOV	NOWDEV,0		;DISPLAY RUN-TIME ERROR MESSAGE
	LEA	SI,EM0			;E.G: "ERROR 5: BAD INTRINSIC"
	CALL	TXTLOP
	MOV	AL,ERRNUM		;DISPLAY THE NUMBER
	mov	byte ptr heaplo, al	;report error to DOS
	MOV	AH,0
	CALL	PUTNMB
	MOV	BH,0
	MOV	BL,ERRNUM		;INDEX TO APPROPRIATE MESSAGE
	SAL	BX,1
	MOV	SI,ERRMSG[BX]-2
	CALL	TXTLOP
	CALL	CRLF
NATEXT:
	CALL	RESDVZ			;RESTORE DIVIDE 0 VECTOR
	CALL	RSTBRK			;RESTORE BREAK VECTOR
	MOV	AH,4CH			;TERMINATE PROCESS
	MOV	AL,BYTE PTR HEAPLO	;RETURN LOW BYTE OF GLOBAL ZERO
	INT	21H
START	ENDP

;SET UP AND ENTER THE PROGRAM

ENTRY	LABEL	FAR		;MAKE THIS FAR SO WE CAN ABORT FROM ANYWHERE
	MOV	STKPTR,SP	;SAVE STACK POINTER
	IF	FLAGOPT
	MOV	SI,DI		;POINT SI TO GLOBAL VARIABLES
	ENDIF
	JMP	PROGRM		;GO DIRECTLY TO PROGRAM
	PAGE

;SET SYSTEM DIVIDE BY ZERO VECTOR TO POINT TO OUR ROUTINE

SETDVZ:	PUSH	ES		;SAVE SEG REGS
	PUSH	DS
	MOV	AX,3500H	;READ OLD VECTOR
	INT	21H
	MOV	DVZVEC,BX	;SAVE IT
	MOV	DVZVEC+2,ES
	LEA	DX,DVZHAN	;POINT TO OUR VECTOR
	MOV	AX,SEG DVZHAN
	MOV	DS,AX
	MOV	AX,2500H
	INT	21H
	POP	DS		;RESTORE SEGMENTS
	POP	ES
	RET

;RESTORE SYSTEM DIVIDE BY ZERO VECTOR

RESDVZ:	PUSH	ES		;SAVE SEG REGS
	PUSH	DS
	MOV	AX,2500H	;SET VECTOR
	MOV	DX,DVZVEC
	MOV	DS,DVZVEC+2
	INT	21H
	POP	DS		;RESTORE SEGMENTS
	POP	ES
	RET
	PAGE

;HANDLE DIVIDE-BY-ZERO ERROR. WARNING: The 8086 and 386 have different
; ways of handling the divide-by-zero exception. In the 8086 the return
; address points to the next instruction. In the 386 it points to the IDIV
; instruction. This code deals with both circumstances.

DVZHAN:	PUSH	BX			;SAVE REGISTERS
	PUSH	CX
	PUSH	BP
	PUSH	ES
	MOV	AL,1			;SET ERROR CODE
	CALL	ERROR			;CALL ERROR ROUTINE

;HERE TO RECOVER AND CONTINUE AFTER DIVIDE BY ZERO

	MOV	BP,SP			;POINT TO STACK
	MOV	BX,[BP]+8		;GET RETURN ADDRESS OFFSET
	MOV	AX,[BP]+10		;GET SEGMENT
	MOV	ES,AX
	CMP BYTE PTR ES:[BX],89H	;"MOV REMAIN,DX" INSTRUCTION?
	JE	DVZHN1			;MUST BE 8086, SO JUST RETURN

;386 LEAVES IP POINTING TO IDIV INSTRUCTION, SO MOVE TO NEXT INSTRUCTION

	MOV	BL,ES:[BX]+1		;GET NEXT BYTE OF OPCODE
	MOV	AX,4			;BYTES TO SKIP FOR 16-BIT DISPLACEMENT
	CMP	BL,3EH			;16-BIT DISPLACEMENT?
	JE	DVZHN2			;SKIP IF SO
	AND	BX,0C0H			;MASK BITS AND USE AS AN INDEX
	MOV	CL,5
	SHR	BX,CL
	MOV	AX,SIZTAB[BX]		;GET NUMBER OF BYTES IN OPCODE
DVZHN2:	ADD	[BP]+8,AX		;ADD TO POINT TO NEXT INSTRUCTION

DVZHN1:	MOV	AX,07FFFH		;FORCE LARGEST RESULT
	SUB	DX,DX			;AND ZERO REMAINDER

	POP	ES			;RESTORE REGISTERS
	POP	BP
	POP	CX
	POP	BX
	IRET

DSEG	SEGMENT WORD PUBLIC 'DATA'
SIZTAB	DW	2			;IDIV + MOD111R/M + 0-BIT DISPLACEMENT
	DW	3			; +  8-BIT DISPLACEMENT
	DW	4			; + 16-BIT DISPLACEMENT
	DW	2			; +  0-BIT DISPLACEMENT
DSEG	ENDS

;XPL ERROR HANDLER
; A-REG CONTAINS THE ERROR NUMBER

ERROR:	MOV	ERRNUM,AL	;SAVE THE ERROR NUMBER
	MOV	DL,AL		;GET ERROR NUMBER
	MOV	CX,TRAPS	;GET TRAPS

ERR10:	SHR	CX,1		;SHIFT TRAP BITS TO CARRY
	DEC	DL		;COUNT ERROR CODES
	JNZ	ERR10		;LOOP UNTIL ZERO
	JC	EXITDO		;IF BIT IS CLEAR THEN RETURN
	RET			;THIS IS NEAR - RETURN TO AN INTRINSIC

EXITDO:	MOV	SP,STKPTR	;RESTORE STACK PTR AND RETURN
	RETF			;MUST BE FAR TO RETURN FROM ANYWHERE
	PAGE

;CALCULATE PROGRAM SIZE

DOPGSZ:	MOV	BX,CSEG		;GET START OF CODE
	MOV	AX,DSEG		;GET START OF DATA	
	SUB	AX,BX		;FIND TOTAL CODE SIZE
	ADD	AX,4113		;SIZE = (HEAP+PSP)/16+1, (HEAP=64K, PSP=256)
	MOV	PRGSIZ,AX
	RET


;RESIZE PROGRAM, SHRINKING DOS MEMORY ALLOCATION TO ACTUAL PROGRAM SIZE

RESIZE:	MOV	AH,DOSMMA	;RESIZE THIS PROGRAM
	MOV	DOSINT,21H
	MOV	BX,PRGSIZ	;SHRINK SIZE
	PUSH	ES		;SAVE ES
	MOV	ES,PSPSEG	;POINT TO PSP
	INT	21H		;CALL DOS FUNCTION
	POP	ES		;RESTORE ES
	RET
	PAGE

;$48
;ROUTINE TO RESERVE A MULTI-DIMENSIONAL ARRAY
; THIS ALSO SETS THE POINTER TO THE HEAP SPACE THAT IS RESERVED
; FOR EXAMPLE: MKARRAY( (3, 5, 7, 11), 4, 2);
; THE STACK CONTAINS:
;   THE NUMBER OF ELEMENTS IN EACH DIMENSION (3, 5, 7, 11)
;   THE NUMBER OF DIMENSIONS (4)
;   THE NUMBER OF BYTES IN EACH ELEMENT OF THE ARRAY (1=CHAR, 2=INT, 8=REAL)
;
DSEG	SEGMENT	WORD PUBLIC 'DATA'
LEVMAX	DW	0		;MAXIMUM LEVEL OF RECURSION (LAST DIMENSION)
RETADR	DW	0,0		;RETURN ADDRESS
DSEG	ENDS

MKARRAY	PROC	FAR
	POP	RETADR		;SAVE RETURN ADDRESS
	POP	RETADR+2

	IF	FLAGOPT
	PUSH	AX		;STACK THE NUMBER OF BYTES
	MOV	BX,DI		;HEAP POINTER POINTS TO POINTER TO ARRAY
	INC	AX		;ALLOCATE HEAP SPACE FOR POINTER TO ARRAY
	AND	AL,0FEH		;AX = 2 (OR 8 IF REAL)
	ADD	DI,AX
	ELSE
	POP	BX		;GET ADDRESS OF POINTER TO ARRAY
	ENDIF

	MOV	SISAVE,SI	;SAVE CRITICAL REGISTERS
	MOV	DISAVE,DI

	POP	DI		;GET NUMBER OF BYTES IN EACH ELEMENT
	POP	AX		;GET NUMBER OF DIMENSIONS
	DEC	AX		;CONVERT TO MAXIMUM INDEX OFF OF BP (LEVMAX)
	ADD	AX,AX		;DOUBLE FOR WORD ENTRIES ON THE STACK
	MOV	BP,AX
	ADD	BP,SP		;POINT TO NUMBER OF ELEMENTS IN 1ST DIMENSION
	NEG	AX
	MOV	LEVMAX,AX

	SUB	SI,SI		;SET INDEX TO POINT TO SIZE OF FIRST DIMENSION
	CALL	GENARY		;RESERVE FIRST DIMENSION OF ARRAY AND STORE ITS
				; BASE ADDRESS INTO LOCATION POINTED TO BY BX
	ADD	BP,2		;CLEAN UP STACK--DISCARD ARGUMENTS
	MOV	SP,BP

	MOV	SI,SISAVE	;RESTORE CRITICAL REGISTERS
	MOV	DI,DISAVE

	PUSH	RETADR+2	;RESTORE RETURN ADDRESS
	PUSH	RETADR
	RET			;FAR RETURN
MKARRAY	ENDP


;RECURSIVELY CALLED SUBROUTINE FOR SETTING UP A MULTI-DIMENSIONAL ARRAY.
;RESERVE AN ARRAY AND STORE ITS BASE ADDRESS INTO THE LOCATION POINTED TO
; BY THE BX REGISTER.
;REGISTER USAGE (* INDICATES INPUT VALUES):
;	AX - SCRATCH
;  *	BX - ADDRESS OF POINTER TO NEXT DIMENSION OF ARRAY
;	CX - LOOP COUNTER AND INDEX
;	DX - BASE ADDRESS OF CURRENT DIMENSION OF ARRAY
;  *	DI - NUMBER OF BYTES IN AN ELEMENT (1, 2 OR 8)
;  *	SI - INDEX TO SIZE OF EACH DIMENSION, ALSO LEVEL OF RECURSION (* -2)
;  *	BP - POINTS TO FIRST ARGUMENT ON THE STACK (SIZE OF FIRST DIMENSION)

GENARY:	MOV	AX,[BP+SI]	;GET NUMBER OF ELEMENTS FOR CURRENT DIMENSION
	MOV	CX,AX		;SAVE FOR POSSIBLE USE BY LOOP COUNTER BELOW

;RESERVE SPACE ON HEAP
	CMP	SI,LEVMAX	;IS THIS THE LAST DIMENSION?
	JG	GA02		;SKIP IF NOT
	CMP	DI,1		;IS THIS A CHAR ARRAY?
	JE	GA07		;JUMP IF SO (LAST DIMENSION IS A SINGLE BYTE)
GA02:	CMP	DI,8		;IS THIS A REAL ARRAY?
	JNE	GA05		;SKIP IF NOT
	ADD	AX,AX		;MULTIPLY ELEMENTS BY 8 BYTES PER REAL NUMBER
	JC	GA10		;CHECK FOR MEMORY OVERFLOW: ERROR IF > $FFFF
	ADD	AX,AX
	JC	GA10
GA05:	ADD	AX,AX		;MULTIPLY ELEMENTS BY 2 BYTES PER INTEGER
	JC	GA10		;CHECK FOR MEMORY OVERFLOW: ERROR IF > $FFFF
	IF	FLAGOPT
GA07:	MOV	DX,DISAVE	;DX = BASE OF RESERVED HEAP SPACE
	ADD	DISAVE,AX	;ADD NUMBER OF BYTES TO RESERVE TO HEAP POINTER
	JC	GA10		;CHECK FOR MEMORY OVERFLOW: ERROR IF > $FFFF
	MOV	AX,HEAPHI	;CHECK FOR MEMORY OVERFLOW
	CMP	DISAVE,AX
	ELSE
GA07:	MOV	DX,HP		;DX = BASE OF RESERVED HEAP SPACE
	ADD	HP,AX		;ADD NUMBER OF BYTES TO RESERVE TO HEAP POINTER
	JC	GA10		;CHECK FOR MEMORY OVERFLOW: ERROR IF > $FFFF
	MOV	AX,HEAPHI	;CHECK FOR MEMORY OVERFLOW
	CMP	HP,AX
	ENDIF
	JB	GA20		;SKIP IF OK
GA10:	MOV	AL,2		;ERROR 2: MEMORY OVERFLOW
	CALL	ERROR
GA20:	MOV	[BX],DX		;STORE BASE ADDRESS OF RESERVED SPACE INTO PTR

	CMP	SI,LEVMAX	;IS THIS THE LAST DIMENSION?
	JLE	GA90		;JUMP IF SO--DON'T RECURSE ANY LOWER

	SUB	AX,AX		;INITIALIZE INDEX TO FIRST ELEMENT
GA30:	CMP	AX,CX		;IS INDEX BEYOND LIMIT?
	JAE	GA90		;JUMP IF SO--EXIT LOOP

	SUB	SI,2		;ADVANCE INDEX TO NEXT DIMENSION SIZE ON STACK
	MOV	BX,AX		;GET INDEX FOR ELEMENT IN CURRENT DIMENSION
	CMP	DI,8		;IS THIS A REAL ARRAY?
	JNE	GA40		;SKIP IF NOT
	ADD	BX,BX		;RESERVE SPACE FOR 8 BYTES
	ADD	BX,BX
GA40:	ADD	BX,BX		;MULTIPLY BY 2 TO INDEX BY WORDS
	ADD	BX,DX		;ADD BASE ADDRESS OF RESERVED SPACE (CURRENT DIM)

	PUSH	AX		;SAVE SOME THINGS (INDEX, LIMIT, BASE ADDR)
	PUSH	CX
	PUSH	DX
	CALL	GENARY		;RESERVE NEXT DIMENSION OF ARRAY AND STORE ITS
	POP	DX		; BASE ADDRESS INTO LOCATION POINTED TO BY BX
	POP	CX		;RESTORE THINGS
	POP	AX
	ADD	SI,2		;RESTORE INDEX TO PREVIOUS DIMENSION SIZE ON STK

	INC	AX		;NEXT ELEMENT
	JMP	SHORT GA30	;LOOP FOR EACH ELEMENT IN THIS DIMENSION

GA90:	RET
	PAGE

;DEFINE SOME CHARACTERS
;DEFINED HERE SO ASSEMBLER KNOWS THEM DURING PASS ONE

CR	EQU	0DH		;DEFINE RETURN
LF	EQU	0AH		;DEFINE LINE FEED
EOF	EQU	1AH		;END OF FILE
BEL	EQU	07H		;BELL CHARACTER

;EQUIPMENT LIST INFORMATION

XPLVER	EQU	30		;XPL VERSION NUMBER *10

	IF FLAG387
XPLTYP	EQU	'7'		;XPL TYPE= NATIVE7
	ELSE
	IF FLAGNAT
XPLTYP	EQU	'S'		;XPL TYPE= SMALL NATIVE
	ELSE
XPLTYP	EQU	'N'		;XPL TYPE= NATIVE
	ENDIF
	ENDIF

DSEG	SEGMENT	WORD PUBLIC 'DATA'

;STACK IS PLACED AT THE BOTTOM OF DATA SEGMENT

	EVEN			;FORCE STACK TO BE WORD ALIGNED
STACKLO	DB	1024 DUP(?)	;START OF HARDWARE STACK
STACKHI	DW	?		;TOP OF STACK

;SETUP PARAMETERS

PRGSIZ	DW	0		;SIZE OF CURRENT PROGRAM
USRTOP	EQU	0FFFFH		;TOP USER AREA, BOTTOM OF STACK
HEAPHI	DW	USRTOP		;DEFINE END OF HEAP

;GLOBAL VARIABLES

PSPSEG	DW	0	;LOCATION OF CURRENT PSP
ENTSTK	DW	0	;STACK UPON PROGRAM ENTRY
STKPTR	DW	0	;STACK UPON MAIN PROCEDURE ENTRY
DVZVEC	DW	0	;OLD DIVIDE BY 0 VECTOR
	DW	0	;SEGMENT PART

RETTMP	DD	?	;TEMPORARY FOR RETURN ADDRESSES

	EVEN
HP	DW	0	;HEAP POINTER
REMAIN	DW	0	;REMAINDER FROM LAST DIVIDE

SISAVE	DW	0	;TEMPORARY SAVE LOCATIONS FOR SI AND DI REGISTERS
DISAVE	DW	0
TRAPS	DW	0	;ERROR TRAPS
RERUNF	DW	0	;RERUN FLAG
ERRNUM	DB	0	;ERROR CODE


;SET TRUE AND FALSE VALUES

TRUVAL	EQU	0FFFFH
FALVAL	EQU	0

;TRUE/FALSE MEMORY CONSTANT

TRUE	DW	TRUVAL
FALSE	DW	FALVAL

;DISPLAY VECTOR:		LEVEL:
	EVEN
BASE0	DW	0		;0
BASE1	DW	0		;1
BASE2	DW	0		;2
BASE3	DW	0		;3
BASE4	DW	0		;4
BASE5	DW	0		;5
BASE6	DW	0		;6
BASE7	DW	0		;7
	PAGE
;ERROR MESSAGES

TSP	EQU	' '+80H		;DEFINE TERMINATING SPACE

EM0	DB	BEL,CR,LF,'ERROR',TSP

ERRMSG	DW	EM1		;TABLE OF MESSAGE POINTERS
	DW	EM2
	DW	EM3
	DW	EM4
	DW	EM5
	DW	EM6
	DW	EM7
	DW	EM8
	DW	EM9
	DW	EM10
	DW	EM11
	DW	EM12
	DW	EM13
	DW	EM14
	DW	EM15

EM1	DB	': DIV BY 0',TSP
EM2	DB	': OUT OF MEMORY',TSP
EM3	DB	': I/O ERROR',TSP
EM4	DB	': BAD OPCODE',TSP
EM5	DB	': BAD INTRINSIC',TSP
EM6	DB	': DIV BY 0.0',TSP
EM7	DB	': OVERFLOW',TSP
EM8	DB	': UNDERFLOW',TSP
EM9	DB	': FIX OVERFLOW',TSP
EM10	DB	': SQRT < 0',TSP
EM11	DB	': LOG <= 0',TSP
EM12	DB	': EXP OVERFLOW',TSP
EM13	DB	': OVERFLOW',TSP
EM14	DB	': ATAN2(0.0,0.0)',TSP
EM15	DB	': ?',TSP
DSEG	ENDS
	PAGE

;NATIVE IS DIVIDED INTO THE FOLLOWING FILES

;NATIVE   - MASTER MODULE, GLOBAL VARIABLES
;NINTRIN1 - I2L INTRINSICS
;NINTRIN2 - I2L INTRINSICS
;NATFLT   - FLOATING POINT OPCODES, BASIC FP INTRINSICS
;NFLTOPS  - MORE FLOATING OPS AND INTRINSICS
;NFLTIO   - FLOATING POINT I/O ROUTINES
;NFPACK   - BASIC FLOATING POINT ROUTINES
;NTRANS   - TRANSCENDENTAL ROUTINES
;NKHAND   - I/O DISPATCH CODE AND TABLES
;NGRAPH   - GRAPHICS ROUTINES
;NDOS     - MS-DOS ACCESS ROUTINES
;NWINDOW  - WINDOW UTILITY ROUTINES
;NLOWIO   - LOW LEVEL UNTILITY ROUTINES
;NHEAP    - DEFINES HEAP AND STACK SEGMENTS

	INCLUDE	NINTRIN1.ASM
	INCLUDE	NINTRIN2.ASM

	IF FLAGNAT
	ELSE
	INCLUDE NATFLT.ASM
	ENDIF

	IF FLAG387			;CONDITIONAL ASSEMBLY FOR 387
	INCLUDE	NFLTOPS7.ASM
	INCLUDE	NFLTIO7.ASM

	ELSE				;CONDITIONAL FOR EMULATION
	IF FLAGNAT
	INCLUDE	NFLTNULL.ASM
	ELSE
	INCLUDE	NFLTOPS.ASM
	INCLUDE	NFLTIO.ASM
	INCLUDE	NFPACK.ASM
	INCLUDE NTRANS.ASM
	ENDIF
	ENDIF

	INCLUDE	NKHAND.ASM
	INCLUDE	NGRAPH.ASM
	INCLUDE	NDOS.ASM
	INCLUDE NWINDOW.ASM
	INCLUDE	NLOWIO.ASM
	INCLUDE NHEAP.ASM

CODEND	LABEL	WORD		;END OF CODE
CSEG	ENDS
	END	START
