\HD.XPL		15-Jul-2007		Loren Blaney	loren_blaney@idcomm.com
\Simple utility to display a Hex/ASCII dump of files
\Usage: HD filename.ext
\Compile with XPLPX (XPX), which is required for the large arrays.
\
\REVISIONS
\25-Jul-1999, V1.0, Original.
\28-Sep-2002, V1.1, Don't display extended ASCII because it messes up printer.
\16-Jan-2005, V1.2, Cleaned up for distribution with XPLPX.
\17-Feb-2005, V1.3, Display file name and its date and time at top of screen.
\15-Jul-2007, V1.4, Increase maximum size from 1000000 to 4 Meg (4194304)
\This program is free software; you can redistribute it and/or modify it under
\ the terms of the GNU General Public License version 2 as published by the
\ Free Software Foundation.
\This program is distributed in the hope that it will be useful, but WITHOUT
\ ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
\ FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
\ details.
\You should have received a copy of the GNU General Public License along with
\ this program (in the file LICENSE.TXT); if not, write to the Free Software
\ Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include	c:\cxpl\codes;	\Include code definitions for intrinsic routines
string 0;		\Use null-terminated strings (instead of MSB)

def	Lines=16;	\Number of lines shown on the display

int	CpuReg,		\Address of CPU register array (from GetReg)
	DataSeg;	\Where the .exe loader put our data
char	File;		\Array containing the input file
int	CurShape,	\Cursor shape
	FileInx,	\Index into File
	FileSize,	\Number of bytes in the file
	HexMode,	\Flag: Hex vs. ASCII mode
	ItemsPerLine,	\16 (Hex mode) or 64 (ASCII mode)
	MaxSize;	\Maximum size of file (bytes)

char	CmdTail($80);	\Copy of what's on the command line (after "HD")

def	Nul=$00, Bel=$07, BS=$08, Tab=$09, LF=$0A, FF=$0C,	\Control chars
	CR=$0D, EOF=$1A, Esc=$1B, Sp=$20, Ctrl=$40;
def	Up=-$48, Dn=-$50, Lt=-$4B, Rt=-$4D, PgUp=-$49,		\-Scan codes
	PgDn=-$51, End=-$4F, Home=-$47, Del=-$53;

\------------------------------- INPUT ROUTINES --------------------------------

func	CallInt(Int, AX, BX, CX, DX, BP, DS, ES); \Call software interrupt
int	Int, AX, BX, CX, DX, BP, DS, ES; \(unused arguments need not be passed)
begin
CpuReg(0):= AX;
CpuReg(1):= BX;
CpuReg(2):= CX;
CpuReg(3):= DX;
CpuReg(6):= BP;
CpuReg(9):= DS;
CpuReg(11):= ES;
Softint(Int);
return CpuReg(0);		\return AX register
end;	\CallInt



func	ShiftKey;		\Returns 'true' if a shift key is down
return (CallInt($16, $0200) & $03) # 0;	\Function $02



func	GetKey;			\Get character from keyboard (wait if necessary)
int	SC, Ch;			\This is a low-level routine with no echo,
begin				\ no Ctrl-C, and no cursor.
SC:= CallInt($16, $0000);	\Function $00
Ch:= SC & $FF;
if Ch = 0 then Ch:= -(SC>>8);	\Return non-ASCII chars as negative scan code
return Ch;
end;	\GetKey



func	GetKeyX;		\Get character from keyboard including
int	Ch;			\ shifted UgUp/PgDn
begin
Ch:= GetKey;
if ShiftKey then
	case Ch of
	  PgUp:	Ch:= ^9;
	  PgDn:	Ch:= ^3
	other;
return Ch;
end;	\GetKeyX



func	GetCurShape;		\Get cursor shape
begin
CallInt($10, $0300);		\Function $03
return Cpureg(2);
end;	\GetCurShape



proc	SetCurShape(Shape);	\Set cursor shape
\WARNING: $0607 does not work for monochrome mode 7. Use $0B0C instead.
\ $000D gives a solid block for all modes.
int	Shape;
CallInt($10, $0100, 0, Shape);	\Function $01



proc	ShowCursor(On);		\Turn flashing cursor off and on
int	On;	\Flag: True = cursor on; False = cursor off
int	CS;	\Own-type variable to save original cursor shape
begin
CS:= [$000D];	\Default is solid block
if On then SetCurShape(CS(0))
else	[CS(0):= GetCurShape;
	SetCurShape($2000)];
end;	\ShowCursor

\------------------------------ OUTPUT ROUTINES --------------------------------

proc	SpOut(Dev, N);		\Output N spaces to specified device
int	Dev, N;
int	I;
for I:= 1, N do ChOut(Dev, ^ );



proc	Hex2out(Dev, N);	\Output two hex digits (a byte)
int	Dev, N;
char	HexDigit;
begin
HexDigit:= "0123456789ABCDEF ";
ChOut(Dev, HexDigit(N>>4 & $0F));
ChOut(Dev, HexDigit(N & $0F));
end;	\Hex2out



proc	TimeOut(Dev, Time);	\Display time e.g: 14:25
int	Dev, Time;	\time in DOS packed format
int	H, M, S;	\hours, minutes, seconds
begin
S:= Time<<1 & $003E;		\0-58
M:= Time>>5 & $003F;		\0-59
H:= (Time>>11 & $1F);		\0-23

if H < 10 then ChOut(Dev, ^0);
IntOut(Dev, H);
ChOut(Dev, ^:);
if M < 10 then ChOut(Dev, ^0);
IntOut(Dev, M);
ChOut(Dev, ^:);
if S < 10 then ChOut(Dev, ^0);
IntOut(Dev, S);
end;	\TimeOut



proc	DateOut(Dev, Date);	\Display date e.g: 10-Feb-2005
int	Dev, Date;	\date in DOS packed format
int	D, M, Y,	\day, month, year
	I, J;
char	Str;
begin
D:= Date & $001F;		\1-31
M:= Date>>5 & $000F;		\1-12
Y:= (Date>>9 & $7F) + 1980;

IntOut(Dev, D);
ChOut(Dev, ^-);
Str:= "JanFebMarAprMayJunJulAugSepOctNovDec ";
J:= 3*(M-1);
for I:= 0, 3-1 do ChOut(Dev, Str(I+J));
ChOut(Dev, ^-);
IntOut(Dev, Y);
end;	\DateOut

\-------------------------------------------------------------------------------

proc	ShowASCII(P);	\Display a line of ASCII starting at offset P
char	P;
int	I;
\  PPPPPP:    ................................................................
begin
SpOut(0, 2);
Hex2out(0, P>>16);			\Display the offset (P)
Hex2out(0, P>>8);
Hex2out(0, P);
Text(0, ":    ");

for I:= 0, 63 do			\Display 64 bytes of ASCII
	begin
	if P+I < FileSize then 
		ChOut(0, if (File(P+I)&$7F)<=$1F ! (File(P+I)&$7F)=$7F then ^.
			  else (File(P+I)&$7F))
	else	ChOut(0, Sp);
	end;
SpOut(0, 2);				\Blank what's left behind by hex display
Crlf(0);
end;	\ShowASCII



proc	ShowHex(P);	\Display a line of hex/ASCII, starting at P
char	P;
char	L;
int	I;
\PPPPPP:  XX XX XX XX  XX XX XX XX  XX XX XX XX  XX XX XX XX    ................
begin
L:= Reserve(16);			\Line buffer

Hex2out(0, P>>16);			\Display the offset (P)
Hex2out(0, P>>8);
Hex2out(0, P);
Text(0, ":  ");
for I:= 0, 15 do			\Display 16 hex bytes
	begin
	if P+I < FileSize then 
		[L(I):= File(P+I);
		Hex2out(0, L(I))]
	else	SpOut(0, 2);
	ChOut(0, Sp);
	if (I+P & 3) = 3 then ChOut(0, Sp);
	end;
SpOut(0, 2);

for I:= 0, 15 do			\Display the corresponding ASCII
	begin
	if P+I < FileSize then 
	  ChOut(0, if (L(I)&$7F)<=$1F ! (L(I)&$7F)=$7F then ^. else (L(I)&$7F))
	else ChOut(0, Sp);
	end;
Crlf(0);
end;	\ShowHex



proc	ShowPage(P);	\Display a page of hex/ASCII starting at pointer P
char	P;
int	J;
begin
Cursor(0, 6);
for J:= 0, Lines-1 do
	begin
	if P < FileSize then
		[if HexMode then ShowHex(P) else ShowASCII(P)]
	else	[SpOut(0, 79);   Crlf(0)];
	if ChkKey then return;
	P:= P +ItemsPerLine;
	end;
end;	\ShowPage

\-------------------------------------------------------------------------------

proc	ShowFileInfo;	\Show date, time and size of file in CmdTail
int	I, J, Ch;
char	FN,		\File Name (segment address)
	DTA,		\Disk Transfer Area, in conventional memory
	DTA2(43);	\DTA in upper memory (which is in normal heap space)
begin	
\Copy file name on command line into FN, which is in conventional memory that
\ DOS can access. Also remove any leading spaces and terminate string with a 0.
FN:= Malloc($80/16);
J:= 0;
for I:= 0, $80-1 do
	begin
	Ch:= CmdTail(I);
	if Ch = CR then [Poke(FN, J, 0);  I:= $80]
	else if Ch # Sp then [Poke(FN, J, Ch);  J:= J + 1];
	end;

DTA:= Malloc(43/16+1);
CallInt($21, $1A00, 0, 0, 0, 0, DTA);		\set Disk Transfer Area address

\Look up first file name (error return if none)
if CallInt($21, $4E00, 0, $26, 0, 0, FN) & $00FF then
	 [ChOut(0, Bel);  Intout(0, CpuReg(0))\error code\;  return];
Release(FN);

Blit(DTA, 0, DataSeg, DTA2, 43);		\copy into normal heap space
Text(0, addr DTA2(30));				\display file name and its info
SpOut(0, 2);
DateOut(0, DTA2(24) + DTA2(25)<<8);
SpOut(0, 2);
TimeOut(0, DTA2(22) + DTA2(23)<<8);
SpOut(0, 2);
IntOut(0, DTA2(26) + DTA2(27)<<8 + DTA2(28)<<16 + DTA2(29)<<24);
end;	\ShowFileInfo



proc	ReadFile;	\Read input file from disk
int	I;
begin
Trap(false);				\We will handle read beyond end of file
I:= 0;
loop	begin				\Read until EOF or array full
	File(I):= Chin(3);
	if Geterr then [I:= I-1;   quit]; \Back up over automatic Ctrl-Z
	I:= I +1;
	if I = MaxSize then quit;
	end;
Trap(true);
FileSize:= I;				\Mark end of file
end;	\ReadFile



func	OpenFile;	\Open the file on the command line for input
int	HandIn;				\File handle
begin
Blit(CpuReg(11), $81, DataSeg, CmdTail, $7F);

Trap(false);				\We will handle any errors, thank you
HandIn:= FOpen(CmdTail, 0);		\Open file for input
Trap(true);
if Geterr then return false;		\Failed
FSet(HandIn, ^I);
Openi(3);
return true;				\Success
end;	\OpenFile

\-------------------------------------------------------------------------------

begin	\Main
CpuReg:= GetReg;			\Get address of CPU registers for SoftInt
DataSeg:= CpuReg(12);
MaxSize:= $400000;			\Reserve a big array to hold input file
File:= Reserve(MaxSize);

\Read in file
if not OpenFile then
	begin
	Text(0, "File not found
");	exit;
	end;
ReadFile;

ShowCursor(false);			\Turn off annoying flashing cursor

Text(0,
"^L
  HEX DUMP 1.3

  Arrows    (Shift) Page Up    (Shift) Page Down    Home    End    Tab    Esc 
");

Cursor(20, 1);
ShowFileInfo;

HexMode:= true;
ItemsPerLine:= 16;
FileInx:= 0;
loop	begin
	ShowPage(FileInx);		\Display a page of hex starting at FileInx
	case GetKeyX of			\Move according to key command
	  Up:	FileInx:= FileInx -ItemsPerLine;
	  Dn:	FileInx:= FileInx +ItemsPerLine;
	  Lt:	FileInx:= FileInx -1;
	  Rt:	FileInx:= FileInx +1;
	  PgUp:	FileInx:= FileInx -Lines*ItemsPerLine;
	  PgDn:	FileInx:= FileInx +Lines*ItemsPerLine;
	  ^9:	FileInx:= FileInx -Lines*ItemsPerLine*16;
	  ^3:	FileInx:= FileInx +Lines*ItemsPerLine*16;
	  Home:	FileInx:= 0;
	  End:	FileInx:= FileSize -Lines*ItemsPerLine;
	  Tab:	[HexMode:= not HexMode;
		ItemsPerLine:= if HexMode then 16 else 64];
	  Esc, ^C-Ctrl:	quit
	other	ChOut(0, Bel);		\Error

	if FileInx > Filesize -Lines*ItemsPerLine then	\Check limits
		FileInx:= FileSize -Lines*ItemsPerLine;
	if FileInx < 0 then FileInx:= 0;
	end;

ShowCursor(true);			\Restore flashing cursor
end;	\Main
