#ifdef TCPDEB /*debug*/
#include <stdio.h>
#include "errno.h"

void debug (char *name, int cnt, unsigned char *buf)
{
  int i,j;
  unsigned char *c,z;
  FILE *fd = fopen("debug.txt","a");
  fprintf(fd,"%s %d",name,cnt);
  while (cnt)
  {
    fprintf(fd,"\n");
    i = (cnt < 16) ? cnt : 16;
    c = buf;
    for (j=0; j<i; j++)
      fprintf(fd,"%02X ",*c++);
    while (j++<16)
      fprintf(fd,"   ");
    c = buf;
    for (j=0; j<i; j++)
      fprintf(fd,"%c",((z = (*c++ & 0x7f)) > 31) ? z : '.');
    cnt -= i;
    buf += i;
  }
  fprintf(fd,"\n");
  fclose(fd);
}
#endif

#include <string.h>
#include "netdb.h"

#include <errno.h>
#ifdef HAVE_SYS_UIO_H
#include <sys/uio.h>
#endif
#include <sys/time.h>
#include <pc.h>
/* While it's not in the pc.h header..... */
#if defined(DJGPP) && (DJGPP >= 2)
/*static*/ int gettimeofday ( struct timeval *tp, struct timezone *tzp )
{
  uclock_t ticks;

  ticks = uclock ();
  tp->tv_sec = ticks / UCLOCKS_PER_SEC;
  tp->tv_usec = ((uclock_t) (ticks % UCLOCKS_PER_SEC) * 1000000) / UCLOCKS_PER_SEC;
  return 0;
}
#else
extern int gettimeofday ( struct timeval *tp, struct timezone *tzp );
#endif
/* define it here. */

#include "socket.h"
//#include "elib.h"

#define LOCALHOSTS_ADDR ((127 << 0) + (0 << 8) + (0 << 16) + (1 << 24))

/* readfds is only used by the sockets, but pctcp.c compiles with
   warnings if socket.c is not compiled in, so I've put readfds into the
   pctcp.c file. */
extern fud_set readfds[1];

static int Status[MAXSOCKS];
static _ext_socket *Socket[MAXSOCKS];

static int SockInit = 0;
static int nSock = 0;

static int close_timeout;
static int print_debug;

/* I used 10, so that applications can assume FIRSTSOCK=10 (Though they
   shouldn't...... (i.e. for future expansion.) You are welcome to change
   it. Currently only sockets 0 are used for a devices (the console(0) and for
   BOOTP and Domain name servers (1)). */
#define FIRSTSOCK 10
/*
 Socket 0 = Console
 Socket 1 = System Socket (For Bootp, Domain name servers,....)
 Add Socket descriptions here if you modify the code.
 */

#define sFree  0
#define sDev   1
#define sAlloc 2
#define sBind  3
#define sListn 4
#define sUsed  5

void FatalError(char * err)
{
  fprintf(stderr,err);
  exit(1);
}


void
SocketClose()
{
  int i;
  if (!SockInit) return;
  for (i=FIRSTSOCK; i<nSock; i++)
  {
    close_s(i);
  }
  nSock = FIRSTSOCK;
}

int accept (int s,struct sockaddr *peername,int *peernamelen)
{
  int newsock,sock;
  struct sockaddr_in *n = (struct sockaddr_in *)peername;

  if (s == 0)
   {
    if (peername && peernamelen)
    {
      if (*peernamelen < sizeof(struct sockaddr_in))
        *peernamelen = 0;
      else
      {
        n->sin_family = AF_INET;
        n->sin_addr.s_addr = LOCALHOSTS_ADDR;
        n->sin_port = 0;
        *peernamelen = sizeof(struct sockaddr_in);
      }
    }
    return 0;
   }

  if (Status[s] != sListn)
  {
    errno = (Status[s] == sFree) ? EBADF :
            (Socket[s]->type != SOCK_STREAM) ? EOPNOTSUPP :
            EINVAL;
    return -1;
  }

  for (newsock=0; newsock<nSock; newsock++)
    if (Status[newsock] == sUsed && Socket[newsock]->lds == s &&
        Socket[newsock]->s.tcp.state != tcp_StateLISTEN)
      break;

  if (newsock==nSock)
  {
    errno = EWOULDBLOCK;
    return -1;
  }

  for (sock=newsock+1; sock<nSock; sock++)
    if (Status[sock] == sUsed && Socket[sock]->lds == s &&
        Socket[sock]->s.tcp.state != tcp_StateLISTEN)
      break;

  if (sock==nSock) { BITCLEAR(readfds,s); }

  Socket[newsock]->lds = -1;

  sock = socket (AF_INET,SOCK_STREAM,0);
  if (sock >= 0)
  {
    Socket[sock]->fds = sock;
    Socket[sock]->lds = s;
    if (!tcp_listen(&(Socket[sock]->s.tcp),Socket[s]->port,0,0,NULL,0))
      Status[sock] = sFree;
    else
      Status[sock] = sUsed;
  }

  if (peername && peernamelen)
  {
    if (*peernamelen < sizeof(struct sockaddr_in))
      *peernamelen = 0;
    else
    {
      n->sin_family = AF_INET;
      n->sin_addr.s_addr = intel(Socket[newsock]->s.tcp.hisaddr);
      n->sin_port = intel16(Socket[newsock]->s.tcp.hisport);
      *peernamelen = sizeof(struct sockaddr_in);
    }
  }
  return newsock;
}

int bind (int s, struct sockaddr *name, int namelen)
{
  struct sockaddr_in *n = (struct sockaddr_in *)name;
  if (name->sa_family != AF_INET)
  {
    errno = EFAULT;
    return -1;
  }
  if (sizeof(struct sockaddr_in) != namelen)
  {
    errno = EINVAL;
    return -1;
  }
  if (Status[s] != sAlloc && Status[s] != sBind)
  {
     errno = (Status[s] == sUsed) ? EINVAL : EBADF;
     return -1;
  }
  Socket[s]->port = intel16(n->sin_port);
  Status[s] = sBind;
  return 0;
}

int close_s (int s)
{
  int i;
  int status;

  if (Status[s] == sUsed)
  {
    sock_close(&Socket[s]->s);

    if (close_timeout) {
	_ip_delay2((sock_type *)&Socket[s]->s.tcp, close_timeout, (procref)0, &status);
    }

    if (print_debug) {
      fprintf(stderr, 
	      "wattcp: close_s: close fd(%d), status = %d.\n", s, status);
    }

    Socket[s]->lds = -1;
    /*
    if (Socket[s]->type == SOCK_DGRAM)
      Status[s] = sFree;
    */
    Status[s] = sFree;

    return 0;
  }
  if (Status[s] == sListn)
  {
    for (i=0; i<nSock; i++)
    {
      if (Status[i] == sUsed && Socket[i]->lds == s)
        close_s(i);
    }
    return 0;
  }
  if (Status[s] == sBind || Status[s] == sAlloc)
  {
    Status[s] = sFree;
    return 0;
  }
  errno = EBADF;
  return -1;
}

static int
AutoBind (int s)
{
  static int start = 0;
  unsigned short port;
  int i;

  port = 1024 + (start % 1024);

  for (i=FIRSTSOCK; i<nSock; i++)
  {
    if (Status[i] >= sBind && Socket[i]->port == port)
      {
	/*
	 * port is used, try another one
	 */
	port = 1024 + ((port+1) % 1024);
	i = FIRSTSOCK;
      }
  }
  start = (start+1) % 1024;
  Socket[s]->port = port;
  Status[s] = sBind;
  return 0;
}

// int connect (int s,struct sockaddr *peername,int peernamelen)
int connect (int s,struct sockaddr_in *peername,int peernamelen)
{
  struct sockaddr_in *n = peername;
/*  if (peername->sa_family != AF_INET)
  {
    errno = EAFNOSUPPORT;
    return -1;
  } */
  
  if (sizeof(struct sockaddr_in) != peernamelen)
  {
    errno = EINVAL;
    return -1;
  }
  /* Auto-bind if allocated.
     Ulrich Leodolter Tue Feb 21 16:35:20 1995 */
  if (Status[s] == sAlloc)
  {
    if (AutoBind (s) == -1)
      {
	errno = EINVAL;
	return -1;
      }
  }
   if (Status[s] != sBind) 
  {
    errno = (Status[s] == sFree) ? EBADF :
            (Status[s] == sUsed) ? EISCONN :
            EINVAL;
    return -1;
  } 
  Socket[s]->fds = s;
  Socket[s]->lds = -1;
  if (Socket[s]->type == SOCK_STREAM)
  {
    if (!tcp_open(&(Socket[s]->s.tcp),Socket[s]->port,
       intel(n->sin_addr.s_addr),intel16(n->sin_port),NULL))
    {
      errno = ECONNREFUSED;
      return -1;
    }
  }
  else
  {
    if (!udp_open(&(Socket[s]->s.udp),Socket[s]->port,
       intel(n->sin_addr.s_addr),intel16(n->sin_port),NULL))
    {
      errno = ECONNREFUSED;
      return -1;
    }
  }
  Status[s] = sUsed;
  while (!tcp_established(&(Socket[s]->s.tcp)))
  {
    if (tcp_tick((sock_type *) &(Socket[s]->s.tcp)) == 1)
      break;
  }
  return 0;
}

int listen (int s,int backlog)
{
  int i,sock;

  if (Status[s] != sBind)
  {
    errno = (Status[s] == sFree) ? EBADF : EINVAL;
    return -1;
  }
  if (Socket[s]->type != SOCK_STREAM)
  {
    errno = EOPNOTSUPP;
    return -1;
  }
  for (i=0; i<backlog; i++)
  {
     sock = socket (AF_INET,SOCK_STREAM,0);
     if (sock < 0) break;
     Socket[sock]->fds = sock;
     Socket[sock]->lds = s;
     if (!tcp_listen(&(Socket[sock]->s.tcp),Socket[s]->port,0,0,NULL,0))
     {
       Status[sock] = sFree;
       break;
     }
     Status[sock] = sUsed;
  }
  if (i<backlog)
  {
    for (i=0; i<nSock; i++)
    {
      if (Status[i] == sUsed && Socket[i]->lds == s)
      {
        sock_close(&(Socket[i]->s));
        Socket[i]->lds = -1;
      }
    }
    return -1;
  }
  Status[s] = sListn;
  return 0;
}

int socket (int af,int type,int protocol)
{
  int i;
  //if (af != AF_INET || (type != SOCK_STREAM && type != SOCK_DGRAM))
  if (af != AF_INET || type != SOCK_STREAM)
  {
    errno = EPROTONOSUPPORT;
    return -1;
  }

  for (i=nSock-1; i>=FIRSTSOCK; i--)
    if (Status[i] == sFree)
      nSock = i;

  for (i=FIRSTSOCK; i<MAXSOCKS; i++)
    if (Status[i] == sFree)
      break;

  if (i==MAXSOCKS)
  {
    errno = EMFILE;
    return -1;
  }

  if (i >= nSock) nSock = i+1;
  if (!Socket[i])
  {
    Socket[i] = malloc(sizeof(_ext_socket));
    if (!Socket[i])
    {
      errno = ENOBUFS;
      return -1;
    }
  }
  Status[i] = sAlloc;
  Socket[i]->type = type;
  BITCLEAR(readfds,i);

  if (print_debug) {
    fprintf(stderr, "wattcp: socket: new fd(%d).\n", i);
  }

  return i;
}

int write_s (int s, char *buf, int nbyte)
{
  int len,off,mode,n;
  sock_type *ss;

/*  if (s==0) {
     for (n=0; (buf[n] != '\0') && (n < nbyte);putchar(buf[n++]));
     fflush(stdout);
     return n;
     }
*/
  if (Status[s] != sUsed || Socket[s]->type != SOCK_STREAM)
  {
    errno = (Status[s] == sFree) ? EBADF :
            (Socket[s]->type == SOCK_STREAM) ? EPIPE :
            EBADF;
    if (print_debug) {
      fprintf(stderr, "wattcp: write_s: fd(%d) is closed.\n", s);
    }
    return -1;
  }

  ss = &(Socket[s]->s);
  len = nbyte;
  off = 0;

  mode = ss->tcp.flags & tcp_FlagPUSH;
  while ( len > 0)
  {
    if (!tcp_tick((sock_type *) &ss->tcp))
    {
      errno = EPIPE;
      if (print_debug) {
	fprintf(stderr, "wattcp: write_s: fd(%d): EPIPE.\n", s);
      }
      return -1;
    }
    ss->tcp.flags |= mode;
    n = sock_fastwrite (ss, (byte *) &buf[off], len);
    if (n==0) break;
    off += n;
    len -= n;
  }

#ifdef TCPDEB /*debug*/
  if (off > 0) debug("write",off,buf);
#endif

  if (off > 0) return off;
  if (ss->tcp.state != tcp_StateESTAB)
  {
    errno = EPIPE;
    if (print_debug) {
      fprintf(stderr, "wattcp: write_s: fd(%d) is not established.\n", s);
    }
    return -1;
  }
  errno = EWOULDBLOCK;
  return -1;
}

#ifdef HAVE_SYS_UIO_H
int writev_s (int s, struct iovec *iov, int iovcnt)
{
  int r,t=0;
  while (iovcnt)
  {
    r = write_s (s, iov->iov_base, iov->iov_len);
    if (r < 0) return r;
    t += r;
    if (r < iov->iov_len) break;
    iov++;
    iovcnt--;
  }
  return t;
}
#endif

// int read_s (int s, char *buf, int nbyte)
int read_s (int s, char *buf, int nbyte)
{
  int cnt,len,n;
  sock_type *ss;

if (s == 0) 
  	{
   	n=0;
   	while (kbhit())
    	{ 
	    buf[n++]=getkey();
      	if (buf[n-1]==13) 
      		{ buf[n++]=10; }
    	}
   	buf[n]='\0';
   	fputs(buf,stdout);
   	fflush(stdout);
   	return n;
   	}

if (Status[s] == sUsed &&
      Socket[s]->type == SOCK_STREAM &&
      Socket[s]->s.tcp.ip_type == TCP_PROTO &&
      Socket[s]->s.tcp.state == tcp_StateCLOSED &&
      Socket[s]->s.tcp.rdatalen == 0)
    {
    if (!tcp_tick((sock_type *) &(Socket[s]->s.tcp))) 
    	{
		Status[s] = sFree;
		if (print_debug) 
			{
	  		fprintf(stderr, "wattcp: read_s: fd(%d) is closed.\n", s);
			}
		return 0;
      	}
    }

if (Status[s] != sUsed || Socket[s]->type != SOCK_STREAM)
  	{
    errno = (Status[s] == sFree) ? EBADF :
            (Socket[s]->type == SOCK_STREAM) ? EPIPE :
            EBADF;
    if (print_debug) 
    	{
      	fprintf(stderr, "wattcp read_s: fd(%d) error.\n", s);
    	}
    //return -1;
    return 0;
  	}

cnt = 0;
len = nbyte;
ss = &(Socket[s]->s);

while (len > 0)
  	{
    n = sock_fastread(ss, (byte *) buf, len);
    if (n==0)
    	{
      	if (!tcp_tick((sock_type *) &ss->tcp))
      		{
        	return(cnt);
    		}
      	n = sock_fastread(ss, (byte *) buf, len);
      	if (n==0)
      		{
        	if (cnt) 
        		{
        		return cnt;
    			}
        	errno = EAGAIN;
        	return -1;
      		}
    	}
    cnt += n;
    buf += n;
    len -= n;
  	}
return (cnt);
}

int select_s (int width, fud_set * sreadfds, fud_set *writefds,
	      fud_set *exceptfds, struct timeval *timeout)
{
  int i,j,k;
  int a,n;
  long b;
  /* I don't know how to declare a pointer to an object and also
     allocate space for it, so I've done this... */
  fud_set test[1];
  fud_set read[1];
  fud_set write[1];
  fud_set closed[1];
  int nottimeout, settimeout;
  struct timeval tend,tact;

  if (!SockInit) return 0;

  n = mskcnt;
  if (width > MAXSOCKS)
    width = MAXSOCKS;
  else
  if (width < MAXSOCKS)
    n = (width+31) >> 5;

  CLEARBITS(closed);

  if (writefds && sreadfds)
    { ORBITS(test, writefds, sreadfds); }
  else
  if (sreadfds)
    { COPYBITS(sreadfds, test); }
  else
  if (writefds)
    { COPYBITS(writefds,test); }
  else
    { CLEARBITS(test); }

  for (i=0; i<n; i++)
  {
    b = (test)->fds_bits[i];
    while (b)
    {
      k = ffs(b)-1;
      j = k + (i<<5);
      if (j >= width ) break;
      if (Status[j] == sUsed) {
	if (!tcp_tick((sock_type *) &(Socket[j]->s.tcp))) {
	  /*Status[j] = sFree;*/
	  if (print_debug) {
	    fprintf(stderr, "wattcp: select_s: fd(%d) is maybe closed.\n", j);
	  }
	  BITSET(closed,j);
	}
      }
      if (Status[j] == sUsed &&
        Socket[j]->type == SOCK_STREAM &&
        Socket[j]->s.tcp.ip_type == TCP_PROTO &&
        Socket[j]->s.tcp.state == tcp_StateCLOSED &&
        Socket[j]->s.tcp.rdatalen == 0)
      {
        if (!tcp_tick((sock_type *) &(Socket[j]->s.tcp))) {
	  /*Status[j] = sFree;*/
	  if (print_debug) {
	    fprintf(stderr, "wattcp: select_s: fd(%d) is closed.\n", j);
	  }
	  BITSET(closed,j);
	}
      }
      if (Status[j] == sFree)
      {
	if (print_debug) {
	  fprintf(stderr, "wattcp: select_s: fd(%d) is free.\n", j);
	}
        //errno = EBADF;
        //return -1;
      }
      b &= ~(1<<k);
    }
  }

  if (writefds)  {CLEARBITS(write);}

  if (exceptfds)
  {
    /* set no except */
    if (n == mskcnt)
    {CLEARBITS(exceptfds);}
    else
    {
      for (i=0; i<n; i++)
        (exceptfds)->fds_bits[i] = 0;
    }
  }

  settimeout = 0;
  nottimeout = 1;
  while (nottimeout)
  {
    tcp_tick((sock_type *) NULL);

    (readfds)->fds_bits[0] &= ~(1);
    if (kbhit())
     (readfds)->fds_bits[0] |= (1);

    /* ready position */
    a = 0;

    /* ready to write */
    if (writefds)
    {
      /* Console is always writeable */
      if ((writefds)->fds_bits[0] & ( 1 << 0)) { BITSET(write,0);a++; }

      for (i=0; i<n; i++)
      {
        b = (writefds)->fds_bits[i];
        while(b)
        {
          k = ffs(b)-1;
          j = k + (i<<5);
          if (j>=width ) break;
          if (j>=FIRSTSOCK)
           if (Socket[j]->s.tcp.datalen == 0)
           {
             a++;
             BITSET(write,j);
           }
          b &= ~(1<<k);
        }
      }
    }

    /* ready to read */
    if (sreadfds)
    {
      MASKANDSETBITS(read,sreadfds,readfds);
      ORBITS(read, read, closed);
      if (ANYSET(read))
      {
        for (i=0; i<n; i++)
        {
          b = (read)->fds_bits[i];
          while(b)
          {
            k = ffs(b)-1;
            j = k + (i<<5);
            if (j>=width) break;
            a++;
            b &= ~(1<<k);
          }
        }
      }
    }

    /* ready */
    if (a) break;

    if (timeout)
    {
      if (!settimeout)
      {
        if (timeout->tv_sec < 0 || timeout->tv_sec > 100000000)
        {
          errno = EINVAL;
          return -1;
        }
        if (timeout->tv_usec < 0 || timeout->tv_usec > 1000000)
        {
          errno = EINVAL;
          return -1;
        }
        gettimeofday(&tend,0);
        tend.tv_sec += timeout->tv_sec;
        tend.tv_usec += timeout->tv_usec;
        if (tend.tv_usec >= 1000000)
        {
          tend.tv_usec -= 1000000;
          tend.tv_sec ++;
        }
        settimeout = 1;
      }
      else
      {
        for (i=0; i<n; i++)
        {
          b = (test)->fds_bits[i];
          while (b)
          {
            k = ffs(b)-1;
            j = k + (i<<5);
            if (j >= width) break;

            if (Status[j] == sUsed &&
              Socket[j]->type == SOCK_STREAM &&
              Socket[j]->s.tcp.ip_type == TCP_PROTO &&
              Socket[j]->s.tcp.state == tcp_StateCLOSED &&
              Socket[j]->s.tcp.rdatalen == 0)
            {
              if (!tcp_tick((sock_type *) &(Socket[j]->s.tcp))) {
                /*Status[j] = sFree;*/
	        if (print_debug) {
	          fprintf(stderr, "fd(%d) is closed.\n", j);
	        }
		BITSET(closed,j);
	      }
            }
            if (Status[j] == sFree)
            {
	      if (print_debug) {
		fprintf(stderr, "wattcp: select_s: fd(%d) is free.\n", j);
	      }
              //errno = EBADF;
              //return -1;
            }
            b &= ~(1<<k);
          }
        }
      }
      gettimeofday(&tact,0);
      if (tend.tv_sec > tact.tv_sec) continue;
      if (tend.tv_sec == tact.tv_sec && tend.tv_usec > tact.tv_usec) continue;
      nottimeout = 0;
    }
  }

if (a)
  {
    if (n == mskcnt)
    {
      if (sreadfds) {COPYBITS(read,sreadfds);}
      if (writefds) {COPYBITS(write,writefds);}
    }
    else
    {
      for (i=0; i<n; i++)
      {
        if (sreadfds) sreadfds[i] = read[i];
        if (writefds) writefds[i] = write[i];
      }
    }
  }
else
 {
   if (n == mskcnt)
   {
     if (sreadfds) CLEARBITS(sreadfds);
     if (writefds) CLEARBITS(writefds);
   }
   else
   {
     for (i=0; i<n; i++)
     {
       if (sreadfds) (sreadfds)->fds_bits[i] = 0;
       if (writefds) (writefds)->fds_bits[i] = 0;
     }
   }
 }


#ifdef TCPDEB /*debug*/
{
FILE *fd = fopen("debug.txt","a");
fprintf(fd,"%d",a);
if (writefds) fprintf(fd," w=%X",(writefds)->fds_bits[0]);
if (sreadfds) fprintf(fd," r=%X",(sreadfds)->fds_bits[0]);
fprintf(fd,"\n");
fclose(fd);
}
#endif
  return a;
}

int recvfrom (int s,char *buf,int len,int flags,struct sockaddr *from,int *fromlen)
{
  return 0;
}

int sendto (int s,char *buf,int len,int flags,struct sockaddr *to,int tolen)
{
  return 0;
}

int getpeername_s(int s, struct  sockaddr *peername, int *peernamelen)
{
  struct sockaddr_in *n = (struct sockaddr_in *)peername;

  if (s == 0)
   { if (peername && peernamelen)
     { if (*peernamelen < sizeof(struct sockaddr_in))
        *peernamelen = 0;
       else
       { n->sin_family = AF_INET;
         n->sin_addr.s_addr = LOCALHOSTS_ADDR;
         n->sin_port = 0;
         *peernamelen = sizeof(struct sockaddr_in);
       }
     }
     return 0;
   }

  if (Status[s] != sUsed) return -1;
  if (!peername || !peernamelen) return -1;
  {
    if (*peernamelen < sizeof(struct sockaddr_in))
    {
      *peernamelen = 0;
      return -1;
    }
    n->sin_family = AF_INET;
    n->sin_addr.s_addr = intel(Socket[s]->s.tcp.hisaddr);
    n->sin_port = intel16(Socket[s]->s.tcp.hisport);
    *peernamelen = sizeof(struct sockaddr_in);
  }
  return 0;
}

int getsockname_s(int s, struct  sockaddr *name, int *len)
{
    struct sockaddr_in *n = (struct sockaddr_in *)name;

    if (!name || !len) return -1;

    if (*len < sizeof(struct sockaddr_in)) {
	*len = 0;
	return -1;
    }
    if (Status[s] == sUsed) {
	n->sin_family = AF_INET;
	n->sin_addr.s_addr = intel(Socket[s]->s.tcp.myaddr);
	n->sin_port = intel16(Socket[s]->s.tcp.myport);
    } else if (Status[s] == sBind) {
	if (!Socket[s]->port) {
	    AutoBind(s);
	}
	n->sin_port = intel16(Socket[s]->port);
    } else {
	*len = 0;
	return -1;
    }
    *len = sizeof(struct sockaddr_in);
    return 0;
}

struct hostent *gethostbyname(char *name)
{
  static struct hostent h;
  static char *h_addr_list[2];
  static longword host;

  if (!strcmp(name, "localhost") || 
      (_hostname && !strcmp(name, _hostname))) {
    host = htonl(my_ip_addr);
    h_addr_list[0] = (char *)&host;
    h_addr_list[1] = (char *)0;
    h.h_addr_list = h_addr_list;
    h.h_length = sizeof(longword);
    return &h;
  } else if ((host = resolve(name))) {
    host = htonl(host);
    h_addr_list[0] = (char *)&host;
    h_addr_list[1] = (char *)0;
    h.h_addr_list = h_addr_list;
    h.h_length = sizeof(longword);
    return &h;
  } else {
    return (struct hostent *)0;
  }
}

struct hostent *gethostbyaddr(char *name, int len, int af)
{
  static struct hostent h;
  h.h_name = "<unknown>";
  return &h;
}

int setsockopt(int s, int level, int optname, const void *optval, int optlen)
{
  return -1;
}

int getsockopt(int s, int level, int optname, void *optval, int *optlen)
{
  return -1;
}

int gethostname_s(char *name, int len)
{
  /*printf("gethostname_s: %s\n", _hostname); */

  if (_hostname) {
    if (len < strlen(_hostname)) {
      *name = 0;
      return -1;
    } else {
      strcpy(name, _hostname);
      return 0;
    }
  } else {
    *name = 0;
    return -1;
  }
}
