/*
Copyright (c) 1998, 1999 Wabasoft  All rights reserved.

This software is furnished under a license and may be used only in accordance
with the terms of that license. This software and documentation, and its
copyrights are owned by Wabasoft and are protected by copyright law.

THIS SOFTWARE AND REFERENCE MATERIALS ARE PROVIDED "AS IS" WITHOUT WARRANTY
AS TO THEIR PERFORMANCE, MERCHANTABILITY, FITNESS FOR ANY PARTICULAR PURPOSE,
OR AGAINST INFRINGEMENT. WABASOFT ASSUMES NO RESPONSIBILITY FOR THE USE OR
INABILITY TO USE THIS SOFTWARE. WABASOFT SHALL NOT BE LIABLE FOR INDIRECT,
SPECIAL OR CONSEQUENTIAL DAMAGES RESULTING FROM THE USE OF THIS PRODUCT.

WABASOFT SHALL HAVE NO LIABILITY OR RESPONSIBILITY FOR SOFTWARE ALTERED,
MODIFIED, OR CONVERTED BY YOU OR A THIRD PARTY, DAMAGES RESULTING FROM
ACCIDENT, ABUSE OR MISAPPLICATION, OR FOR PROBLEMS DUE TO THE MALFUNCTION OF
YOUR EQUIPMENT OR SOFTWARE NOT SUPPLIED BY WABASOFT.
*/

// NOTE: To build, define either WIN32 or UNIX by uncommenting one
// of the following lines (best : define in the Makefile)

//#define WIN32 1
//#define UNIX 1

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#ifdef WIN32
#include <windows.h>
#define unlink(path) _unlink(path)
#define WRITE_FLAGS "wb"
#define READ_FLAGS "rb"
#endif

#ifdef UNIX
#include <unistd.h>
#define WRITE_FLAGS "w"
#define READ_FLAGS "r"
#endif

static void exitError(int num);
static unsigned char *readFileIntoMemory(char *path);
static void loadBmpIcon(char *path);
static void genName(char *exeFile, char *name);
static void genCreator(char *name, char *creator);
static void copyright();
static void usage();

typedef struct WarpIdStruct
	{
	char pdbCreator[5];
	char name[31];
	} WarpId;

static WarpId *warps;
static char prcCreator[5];
static char prcName[31];
static char *prcIcon = NULL;
static char *className = NULL;
static char *warpFile = NULL;
static char *ceWarpDir = NULL;
static char *ceWabaPath = "\\Program Files\\waba\\waba.exe";

static int defWidth = 0;
static int defHeight = 0;
static int classHeapSize = 14000;
static int objectHeapSize = 8000;
static int stackSize = 1500;
static int nativeStackSize = 300;
static int numWarps;

static int quiet = 0;

static char *prcPath = NULL;
static char *lnkPath = NULL;

static int creatorOffset = 64;
static int launchOffset = 1219;
static int bitmapOffset = 1512;
static int nameOffset = 1774;

static unsigned char bytes[] =
    {
     83, 116, 117,  98,   0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
      0,   0,   0,   1,   0,   1, 178,   6,  35, 104, 
    178,   6,  35, 104,   0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
     97, 112, 112, 108,  88,  89,  88,  89,   0,   0, 
      0,   0,   0,   0,   0,   0,   0,   7,  99, 111, 
    100, 101,   0,   1,   0,   0,   0, 150, 100,  97, 
    116,  97,   0,   0,   0,   0,   4, 136, 116,  65, 
     73,  66,   3, 232,   0,   0,   5, 216, 116,  70, 
     82,  77,   3, 232,   0,   0,   6, 104, 116,  65, 
     73,  78,   3, 232,   0,   0,   6, 238,  99, 111, 
    100, 101,   0,   0,   0,   0,   7,  14, 116, 118, 
    101, 114,   3, 232,   0,   0,   7,  38,   0,   0, 
      0,   0,   0,   1,  72, 122,   0,   4,   6, 151, 
      0,   0,   3,  86,  78, 117,  47,   3,  79, 239, 
    255, 214,  54,  47,   0,  54,  72, 111,   0,  34, 
     63,  60,   0,   1,  47,  60, 112, 115, 121, 115, 
     78,  79, 162, 123,  32,  47,   0,  44, 176, 175, 
      0,  60,  79, 239,   0,  10, 100,   0,   0, 150, 
     48,   3,   2,  64,   0,  12,  12,  64,   0,  12, 
    102,   0,   0, 130,  12, 175,   2,   0,   0,   0, 
      0,  34, 100, 118,  72, 111,   0,  38,  72, 111, 
      0,  36,  31,  60,   0,   1,  47,  60, 109, 101, 
    109, 114,  47,  60,  97, 112, 112, 108,  72, 111, 
      0,  18,  31,  60,   0,   1,  78,  79, 160, 120, 
     74, 175,   0,  62,  79, 239,   0,  24, 102,  20, 
     72, 109, 254, 230,  63,  60,   0,  29,  72, 109, 
    254, 222,  78,  79, 160, 132,  79, 239,   0,  10, 
     74, 175,   0,  38, 103,  46,  66, 167,  66, 103, 
     47,  47,   0,  44,  63,  47,   0,  42,  78,  79, 
    160, 167,  54,   0,  74,  67,  79, 239,   0,  12, 
    103,  20,  72, 109, 254, 250,  63,  60,   0,  29, 
     72, 109, 254, 222,  78,  79, 160, 132,  79, 239, 
      0,  10,  48,  60,   5,  12,  96,   2, 112,   0, 
     79, 239,   0,  42,  38,  31,  78, 117,  72, 231, 
     16,  56,  79, 239, 255, 216,  72, 111,   0,  34, 
     72, 111,   0,  42,  31,  60,   0,   1,  47,  60, 
     87,  65,  66,  65,  47,  60,  76,  97, 117, 110, 
     72, 111,   0,  18,  31,  60,   0,   1,  78,  79, 
    160, 120,  54,   0,  74,  67,  79, 239,   0,  24, 
    102,  14,  47,  47,   0,  34,  63,  47,   0,  42, 
     78,  79, 160,  66,  92,  79,  66,  39,  47,  60, 
     76,  97, 117, 110,  47,  60,  87,  65,  66,  65, 
     72, 109, 255,  98,  66, 103,  78,  79, 160,  65, 
     54,   0,  74,  67,  79, 239,   0,  16, 103,   6, 
     48,   3,  96,   0,   0, 194,  63,  60,   0,   3, 
     47,  60,  87,  65,  66,  65,  47,  60,  76,  97, 
    117, 110,  78,  79, 160, 117,  36,  72,  32,  10, 
     79, 239,   0,  10, 102,   8,  48,  60,   5,   7, 
     96,   0,   0, 156,  66, 111,   0,  32,  72, 120, 
      0,  80,  72, 111,   0,  36,  47,  10,  78,  79, 
    160,  85,  38,  72,  32,  11,  79, 239,   0,  12, 
    102,   6,  48,  60,   5,   7,  96, 120,  47,  11, 
     78,  79, 160,  33,  40,  72,  72, 120,   0,  80, 
     72, 109, 255,  16,  66, 167,  47,  12,  78,  79, 
    160, 118,  47,  11,  78,  79, 160,  34,  31,  60, 
      0,   1,  66, 103,  47,  10,  78,  79, 160,  94, 
     47,  10,  78,  79, 160,  74,  72, 111,   0,  70, 
     72, 111,   0,  78,  31,  60,   0,   1,  47,  60, 
     87,  65,  66,  65,  47,  60,  97, 112, 112, 108, 
     72, 111,   0,  54,  31,  60,   0,   1,  78,  79, 
    160, 120,  54,   0,  74,  67,  79, 239,   0,  60, 
    103,   4,  48,   3,  96,  22,  66, 167,  63,  60, 
    157, 212,  47,  47,   0,  40,  63,  47,   0,  48, 
     78,  79, 160, 167,  79, 239,   0,  12,  79, 239, 
      0,  40,  76, 223,  28,   8,  78, 117,  47,  10, 
     36, 111,   0,   8,  48,  18,   4,  64,   0,  24, 
    103,   6,  85,  64, 103,   2,  96,  72,  78,  79, 
    161, 115,  47,   8,  78,  79, 161, 113,  63,  60, 
      0,  60,  47,  60,   0,  35,   0,   8,  72, 109, 
    255, 106,  78,  79, 162,  32,  63,  60,   0,  73, 
     47,  60,   0,  35,   0,   8,  72, 109, 255, 142, 
     78,  79, 162,  32,  63,  60,   0,  86,  47,  60, 
      0,  35,   0,   8,  72, 109, 255, 178,  78,  79, 
    162,  32, 112,   1,  79, 239,   0,  34,  96,   2, 
    112,   0,  36,  95,  78, 117,  72, 231,  24,  32, 
     79, 239, 255, 230,  54,  47,   0,  42,  56,  47, 
      0,  48,  74,  67, 103,   6, 112,   0,  96,   0, 
      0, 204,  63,   4,  47,  60,   2,   0,   0,   0, 
     78, 186, 253, 122,  54,   0,  74,  67,  92,  79, 
    103,   8,  48,  67,  32,   8,  96,   0,   0, 176, 
     78, 186, 254,  48,  62, 128,  74,  87, 103,  10, 
     63,  60,   3, 232,  78,  79, 161, 155,  84,  79, 
    118,   0,  96,   0,   0, 142,  72, 120,   0, 100, 
     72, 111,   0,   6,  78,  79, 161,  29,  72, 111, 
      0,  10,  78,  79, 160, 169,  74,   0,  79, 239, 
      0,  12, 102, 112,  72,  87,  72, 111,   0,   6, 
     66, 167,  78,  79, 161, 191,  74,   0,  79, 239, 
      0,  12, 102,  92,  48,  47,   0,   2,   4,  64, 
      0,   9, 103,  12,   4,  64,   0,  13, 103,  62, 
     83,  64, 103,  24,  96,  60,  12, 111,   3, 233, 
      0,  10, 102,   2, 118,   1,  72, 111,   0,   2, 
     78,  79, 161, 160,  88,  79,  96,  48,  56,  47, 
      0,  10,  63,   4,  78,  79, 161, 111,  36,  72, 
     47,  10,  78,  79, 161, 116,  72, 122, 254, 222, 
     47,  10,  78,  79, 161, 159,  79, 239,   0,  14, 
     96,  14, 118,   1,  96,  10,  72, 111,   0,   2, 
     78,  79, 161, 160,  88,  79,  74,  67, 103,   0, 
    255, 112, 112,   0,  79, 239,   0,  26,  76, 223, 
      4,  24,  78, 117,  47,   3,  79, 239, 255, 244, 
     72,  87,  72, 111,   0,   8,  72, 111,   0,  16, 
     78,  79, 160, 143,  54,   0,  74,  67,  79, 239, 
      0,  12, 103,  26,  72, 109, 255, 228,  63,  60, 
      0,  60,  72, 109, 255, 214,  78,  79, 160, 132, 
    112,   0,  79, 239,   0,  22,  38,  31,  78, 117, 
     32, 111,   0,   8,  48,  40,   0,   6,   2,  64, 
      0,   4, 103,  16,  72, 122,   0,  14,  72, 122, 
      0,   4,   6, 151,   0,   0,   0,  64,  78, 117, 
     32, 111,   0,   8,  63,  40,   0,   6,  47,  40, 
      0,   2,  63,  16,  72, 122,   0,  14,  72, 122, 
      0,   4,   6, 151, 255, 255, 254, 164,  78, 117, 
     38,   0,  47,  47,   0,   8,  47,  47,   0,  16, 
     47,  47,   0,  24,  78,  79, 160, 144,  32,   3, 
     79, 239,   0,  32,  38,  31,  78, 117,  78, 117, 
      0,   0,   1,  68, 255, 255, 254, 222, 133,  83, 
    116, 117,  98,  46,  99,  65, 143,  67, 111, 117, 
    108, 100,  32, 110, 111, 116,  32, 102, 105, 110, 
    100,  32,  97,  32, 112,  65, 145,  67, 111, 117, 
    108, 100,  32, 110, 111, 116,  32, 108,  97, 117, 
    110,  99, 104,  32,  97,  32, 112,  65, 207, 108, 
     97, 117, 110,  99, 104,  49,  50,  51,  49,  50, 
     51,  49,  50,  51,  49,  50,  51,  49,  50,  51, 
     49,  50,  51,  49,  50,  51,  49,  50,  51,  49, 
     50,  51,  49,  50,  51,  49,  50,  51,  49,  50, 
     51,  49,  50,  51,  49,  50,  51,  49,  50,  51, 
     49,  50,  51,  49,  50,  51,  49,  50,  51,  49, 
     50,  51,  49,  50,  51,  49,  50,  51,  49,  50, 
     51,  49,  50,  51,  49,  50,  51,  49,  50,  65, 
    133,  76,  97, 117, 110,  99, 104,  65, 133,  73, 
     39, 109,  32, 115, 111,  32, 114, 148, 121,  44, 
     32,  98, 117, 116,  32, 116, 104, 105, 115,  32, 
    112, 114, 111, 103, 114,  97, 109,  32, 110,  32, 
    101, 198, 100, 115,  32,  97,   0,  97,  32,  87, 
     97,  98,  97,  32,  86, 105, 114, 116, 117,  97, 
    108,  32,  77,  97,  99, 104, 105, 110, 101,  32, 
    116, 111,  32, 114, 117, 110,  32,  97, 110, 100, 
     32,  73,   0,  99,  97, 110,  39, 116,  32, 102, 
    105, 110, 100,  32, 111, 110, 101,  32, 111, 110, 
     32, 116, 104, 105, 115,  32, 100, 101, 118, 105, 
     99, 101,  46,  35,  32,  64, 142,  83, 116,  97, 
    114, 116, 117, 112,  67, 111, 100, 101,  46,  99, 
      0,  69,  32, 114, 141, 111, 114,  32, 108,  97, 
    117, 110,  99, 104, 105, 110, 103,  32,  97,  32, 
    112, 135, 108, 105,  99,  97, 116, 105, 111, 110, 
     64,   0,   0,   0,   0,  40,   0,   0,   0,   0, 
     40,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0,   0,  32,   0,  32, 
      0,   4,   0,   0,   0,   0,   0,   0,   0,   0, 
      0,   0,   7, 255, 255, 224,   7, 255, 255, 224, 
      7, 255, 255, 224,   7, 255, 255, 224,   7, 255, 
    255, 224,   7, 255, 255, 224,   7, 255, 255, 224, 
      7, 255, 255, 224,   7, 255, 255, 224,   7, 255, 
    255, 224,   7, 255, 255, 224,   7, 255, 255, 224, 
      7, 255, 255, 224,   7, 255, 255, 224,   7, 255, 
    255, 224,   7, 255, 255, 224,   7, 255, 255, 224, 
      7, 255, 255, 224,   7, 255, 255, 224,   7, 255, 
    255, 224,   7, 255, 255, 224,   7, 255, 255, 224, 
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0,   0,   0,  18,   0, 
      0,   0,   0,   0,   0, 160,   0, 160,   0,   0, 
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
      3, 232, 128,   0,   0,   0,   0,   0,   0,   0, 
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
      0,   0,   0,   2,   0,  24, 226, 204,   9,   3, 
      0,   0,   0,  80,   1,   3,   0,   0,   0, 108, 
      0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
      0,   0,  87,  97,  98,  97,  86,  77,  32,  77, 
    105, 115, 115, 105, 110, 103,   0,   0,   3, 233, 
      0,   2,   0, 148,   0,  42,   0,  11,   0,  24, 
    227,   8, 201,   0,   0,   0,   0,   0,  67, 108, 
    111, 115, 101,   0,  78,  65,  77,  69,  53,  54, 
     55,  56,  57,  48,  49,  50,  51,  52,  53,  54, 
     55,  56,  57,  48,  49,  50,  51,  52,  53,  54, 
     55,  56,  57,  48,   0,   0,   0,   0,   0,  48, 
      0,   0,   1,  40,   0,   0,   0,   8,   0,   0, 
      0,  32,   0,   0,  63,  60,   0,   1, 169, 240, 
     49,  46,  48,   0 
    };

int main(int argc, char *argv[])
	{
	char *arg, *exefile, c;
	int i, j, n;

	if (argc < 2)
		usage();

	// parse options
	for (i = 1; i < argc; i++)
		{
		arg = argv[i];
		if (arg[0] != '/' || strlen(arg) < 2)
			break;
		switch(arg[1])
			{
			case '?':
				usage();
				break;
			case 'q':
			case 'Q':
				quiet = 1;
				break;
			case 'i':
			case 'I':
				if (++i == argc)
					{
					printf("ERROR: no icon file specified\n");
					exitError(-1);
					}
				arg = argv[i];
				prcIcon = arg;
				break;
			case 'p':
			case 'P':
				if (++i == argc)
					{
					printf("ERROR: no directory specified for /p option\n");
					exitError(-1);
					}
				ceWarpDir = argv[i];
				break;
			case 'w':
			case 'W':
			case 'h':
			case 'H':
			case 'l':
			case 'L':
			case 'm':
			case 'M':
			case 's':
			case 'S':
			case 't':
			case 'T':
				if (++i == argc)
					{
					printf("ERROR: bad #\n");
					exitError(-1);
					}
				c = arg[1];
				arg = argv[i];
				n = atoi(arg);
				if (n == 0)
					{
					printf("ERROR: bad #\n");
					exitError(-1);
					}
				if (c == 'l' || c == 'L') classHeapSize = n;
				else if (c == 'm' || c == 'M') objectHeapSize = n;
				else if (c == 's' || c == 'S') stackSize = n;
				else if (c == 't' || c == 'T') nativeStackSize = n;
				else if (c == 'w' || c == 'W') defWidth = n;
				else if (c == 'h' || c == 'H') defHeight = n;
				break;
			default:
				printf("ERROR: unknown option %s\n", argv[i]);
				exitError(-1);
			}
		}

	if (i == argc)
		{
		printf("ERROR: no output file specified\n");
		exitError(-1);
		}
	exefile = argv[i++];
	genName(exefile, prcName);
	if (ceWarpDir == NULL)
		{
		ceWarpDir = malloc(15 + strlen(prcName) + 1);
		strcpy(ceWarpDir, "\\Program Files\\");
		strcat(ceWarpDir, prcName);
		}

	// create PRC path names
	n = strlen(exefile);
	prcPath = malloc(n + 4 + 1);
	strcpy(prcPath, exefile);
	strcat(prcPath, ".prc");

	// create lnk path names
	lnkPath = malloc(n + 4 + 1);
	strcpy(lnkPath, exefile);
	strcat(lnkPath, ".lnk");

	if (i == argc)
		{
		printf("ERROR: no main window class specified\n");
		exitError(-1);
		}
	// convert . to / in className to make it a class path
	n = strlen(argv[i]);
	className = malloc(n + 1);
	strcpy(className, argv[i++]);
	for (j = 0; j < n; j++)
		{
		if (className[j] == '.')
			className[j] = '/';
		}
	if (i == argc)
		{
		printf("ERROR: no warp file specified\n");
		exitError(-1);
		}
	numWarps = argc - i;
	warps = (WarpId *)malloc(sizeof(WarpId) * numWarps);
	for (j = 0; j < numWarps; j++)
		{
		warpFile = argv[i++];
		if (strlen(warpFile) > 4 && warpFile[strlen(warpFile) - 4] == '.')
			{
			printf("ERROR: warp files should be specified without extensions such as %s\n",
				&warpFile[strlen(warpFile) - 4]);
			exitError(-1);
			}
		genName(warpFile, warps[j].name);
		// first warp is the application warp file
		if (j == 0)
			genCreator(warps[j].name, prcCreator);
		genCreator(warps[j].name, warps[j].pdbCreator);
		}
	if (!quiet)
		{
		copyright();

		printf("output files: %s %s\n", prcPath, lnkPath);
		printf("class name: %s\n", className);
		if (numWarps > 1)
			{
			printf("libraries: ");
			for (j = 1; j < numWarps; j++)
				printf("%s ", warps[j].name);
			printf("\n");
			}
		printf("PalmOS PRC name: %s\n", prcName);
		printf("PalmOS PRC creator: %s\n", prcCreator);
		printf("PalmOS PRC icon: ");
		if (prcIcon)
			printf("%s\n", prcIcon);
		else
			printf("<default>\n");
		printf("WindowsCE warp directory: %s\n", ceWarpDir);
		printf("class heap size: %d\n", classHeapSize);
		printf("object heap size: %d\n", objectHeapSize);
		printf("native stack size: %d\n", nativeStackSize);
		printf("stack size: %d\n", stackSize);
		}

	if (bytes[0] != 'S')
		{
		printf("ERROR: bad bytes 0\n");
		exitError(-2);
		}
	n = strlen(prcName);
	for (i = 0; i < 30; i++)
		{
		if (i <= n)
			bytes[i] = prcName[i];
		else
			bytes[i] = 0;
		}
	
	if (bytes[64] != 'X')
		{
		printf("ERROR: bad bytes 1\n");
		exitError(-2);
		}
	strncpy(&bytes[64], prcCreator, 4);

	// launch string is 60 chars (launch..)
	if (bytes[launchOffset] != 'l')
		{
		printf("ERROR: bad bytes 2\n");
		exitError(-3);
		}
	{
	char launchBuf[256];

	for (i = 0; i < 80; i++)
		launchBuf[i] = ' ';
	sprintf(launchBuf, "/l %d /m %d /s %d /t %d %s", classHeapSize,
		objectHeapSize, stackSize, nativeStackSize, className);
	for (j = 0; j < numWarps; j++)
		{
		strcat(launchBuf, " ");
		strcat(launchBuf, warps[j].pdbCreator);
		if (strlen(launchBuf) > 79)
			{
			printf("ERROR: launch string too long\n");
			exitError(-8);
			}
		}
//	if (!quiet)
//		printf("launch string: %s\n", launchBuf);
	for (i = 0; i < 80; i++)
		bytes[launchOffset + i] = launchBuf[i];
	}

	if (bytes[bitmapOffset] != 7 || bytes[bitmapOffset + 1] != 255)
		{
		printf("ERROR: bad bytes 3\n");
		exitError(-4);
		}
	if (prcIcon != NULL)
		{
		i = strlen(prcIcon);
		if (i > 4 && !strcmp(&prcIcon[i - 4], ".bmp"))
			loadBmpIcon(prcIcon);
		else
			{
			printf("ERROR: unknown icon type %s\n", prcIcon);
			exitError(-1);
			}
		}

	if (bytes[nameOffset] != 'N')
		{
		printf("ERROR: bad bytes 4\n");
		exitError(-5);
		}
	n = strlen(prcName);
	for (i = 0; i < 30; i++)
		{
		if (i <= n)
			bytes[nameOffset + i] = prcName[i];
		else
			bytes[nameOffset + i] = ' ';
		}

	// write out PRC file
	{
	FILE *file;

	if (!quiet)
		printf("...writing %s\n", prcPath);
	file = fopen(prcPath, WRITE_FLAGS);
	if (file == NULL)
		{
		printf("ERROR: can't open output file\n");
		exitError(-5);
		}
	fwrite(bytes, sizeof(bytes), 1, file);
	fclose(file);
	}

	// write out lnk file
	{
	FILE *file;
	char buf[256], buf2[256];

	if (!quiet)
		printf("...writing %s\n", lnkPath);
	file = fopen(lnkPath, "wb");
	if (file == NULL)
		{
		printf("ERROR: can't open output file\n");
		exitError(-5);
		}
	sprintf(buf, "\"%s\" /w %d /h %d /l %d /m %d /s %d /t %d %s",
		ceWabaPath, defWidth, defHeight, classHeapSize, objectHeapSize,
		stackSize, nativeStackSize, className);
	for (j = 0; j < numWarps; j++)
		{
		n = strlen(buf);
		if (n + strlen(ceWarpDir) + strlen(warps[j].name) + 9 >= 256)
			{
			printf("ERROR: launch string too long\n");
			exitError(-8);
			}
		sprintf(&buf[n], " \"%s\\%s.wrp\"", ceWarpDir, warps[j].name);
		}
	sprintf(buf2, "%d#%s", strlen(buf), buf);
	fprintf(file, buf2);
	fclose(file);
	}

	if (!quiet)
		printf("...done\n");
	return 0;
	}

static void exitError(int num)
	{
	if (prcPath)
		unlink(prcPath);
	exit(num);
	}

static unsigned char *readFileIntoMemory(char *path)
	{
	FILE *file;
	char *buf;
	size_t size;

	file = fopen(path, READ_FLAGS);
	if (!file)
		return NULL;
	fseek(file, 0L, SEEK_END); 
	size = ftell(file);
	buf = (char *)malloc(size);
	if (buf)
		{
		fseek(file, 0L, SEEK_SET);
		if (fread(buf, 1, size, file) != size)
			{
			free(buf);
			buf = NULL;
			}
		}
	fclose(file);
	return buf;
	}

#define uint32 unsigned int
#define uint16 unsigned short

#define getWUInt32(b) (uint32)( (uint32)((b)[3])<<24 | (uint32)((b)[2])<<16 | (uint32)((b)[1])<<8 | (uint32)((b)[0]) )
#define getWUInt16(b) (uint16)( (uint16)((b)[1])<<8 | (uint16)((b)[0]) )

static void loadBmpIcon(char *path)
	{
	unsigned char *bmp;
	uint32 bmpBitmapOffset, infoSize, compression, width, height, colorsUsed;
	uint16 bpp;
	int bmpScanLen, colorsReversed, x, y, bitmapPos;
	static int v[4] = { 3, 8, 8, 3 };

	// read bmp file into memory
	bmp = readFileIntoMemory(path);
	if (!bmp)
		{
		printf("ERROR: can't read file %s\n", path);
		exitError(-1);
		}
	// validate bmp image
	if (bmp[0] != 'B' || bmp[1] != 'M')
		{
		printf("ERROR: %s is not a BMP file\n", path);
		exitError(-1);
		}

	bmpBitmapOffset = getWUInt32(&bmp[10]);
	infoSize = getWUInt32(&bmp[14]);
	if (infoSize != 40)
		{
		printf("ERROR: Unsupported old-style BMP format\n");
		exitError(-1);
		}

	width = getWUInt32(&bmp[18]);
	height = getWUInt32(&bmp[22]);
	if (width != 22 || height != 22)
		{
		printf("ERROR: .bmp icon file is not 22x22 (%d %d)\n", width, height);
		exitError(-1);
		}
	bpp = getWUInt16(&bmp[28]);
	if (bpp != 1)
		{
		printf("ERROR: BMP image is not black and white (1 bit per pixel)\n");
		exitError(-1);
		}
	compression = getWUInt32(&bmp[30]);
	if (compression != 0)
		{
		printf("ERROR: BMP uses unsupported compression type\n");
		exitError(-1);
		}
	colorsUsed = getWUInt32(&bmp[46]);
	if (colorsUsed > 2)
		{
		printf("ERROR: BMP contains a color map\n");
		exit(-1);
		}

	colorsReversed = 1;
	if (colorsUsed == 2)
		{
		uint32 col1, col2;

		col1 = getWUInt32(&bmp[14 + 40]);
		col2 = getWUInt32(&bmp[14 + 44]);
		if (col1 == 0)
			;
		else if (col2 == 0)
			colorsReversed = 0;
		}

	//... 7 255 255 224 ... ( 22 rows)
	bitmapPos = bitmapOffset;
	bmpScanLen = (width + 7) / 8; // # bytes
	bmpScanLen = ((bmpScanLen + 3) / 4) * 4; // end on 32 bit boundry
	for (y = 0; y < 22; y++)
		{
		unsigned char *bbyte;
		int col, bbit;

		bbit = 7;
		bbyte = &bmp[bmpBitmapOffset + (22 - y - 1) * bmpScanLen];
		if (colorsReversed)
			for (x = 0; x < bmpScanLen; x++)
				bbyte[x] ^= 0xFF;

		for (col = 0; col < 4; col++)
			{
			int byte, vi;

			byte = 0;
			for (vi = 0; vi < v[col]; vi++)
				{
				byte = byte << 1;
				if (((1 << bbit) & *bbyte) != 0)
					byte |= 0x01;
				if (bbit == 0)
					{
					bbit = 7;
					bbyte++;
					}
				else
					bbit--;
				}
			if (col == 3)
				byte = byte << 5;
			bytes[bitmapPos++] = byte;
			}
		}
	}

static void genName(char *exeFile, char *name)
	{
	int i, n;

	// get the tail end of the warp file to get its name
	i = strlen(exeFile) - 1;
	while (i > 0 && exeFile[i] != '/' && exeFile[i] != '\\')
		i--;
	if (i)
		i++; // skip slash
	if (exeFile[i] == '"')
		i++; // skip start quote
	n = strlen(exeFile) - i;
	if (exeFile[strlen(exeFile) - 1] == '"')
		n--; // skip end quote
	if (!n || n > 30)
		{
		printf("ERROR: exe file name must be less than 31 characters\n");
		exit(-1);
		}
	strncpy(name, &exeFile[i], n);
	name[n] = 0;
	}

static void genCreator(char *name, char *creator)
	{
	int i, n, hash;

	n = strlen(name);
	hash = 0;
	for (i = 0; i < n; i++)
		hash += name[i];
	for (i = 0; i < 4; i++)
		{
		creator[i] = (hash % 26) + 'a';
		if (hash & 64)
			creator[i] += ('A' - 'a');
		hash = hash / 2;
		}
	creator[4] = 0;
	}

static void copyright()
	{
	printf("Wabasoft (TM) Waba Launch Executable Generator   Version 1.50.0\n");
	printf("Copyright (C) Wabasoft 1998, 1999. All rights reserved\n");
	printf("\n");
	}

static void usage()
	{
	copyright();
	printf("Usage: exegen [options] exefile	main-window-class warpfile [warpfile2 ...]\n");
	printf("\n");
	printf("Options:\n");
	printf("  /?   Displays usage text\n");
	printf("  /h   Assign height of application's main window\n");
	printf("  /i   Assign PalmOS PRC icon (e.g. /i sample.bmp)\n");
	printf("  /l   Assign size of class heap (e.g. /l 10000)\n");
	printf("  /m   Assign size of object heap (e.g. /m 20000)\n");
	printf("  /p   Full path to directory containing warp file under WindowsCE\n");
	printf("  /s   Assign size of stack (e.g. /s 2000)\n");
	printf("  /t   Assign size of native stack (e.g. /t 50)\n");
	printf("  /w   Assign width of application's main window\n");
	printf("\n");
	printf("This program generates a WindowsCE application shortcut .lnk file and\n");
	printf("a PalmOS .prc application. These files are used to launch (start up) a\n");
	printf("Waba program.\n");
	printf("\n");
	printf("File extensions are generated automatically. For example, if you specify\n");
	printf("myapp as the exefile, a myapp.lnk and myapp.prc will be created.\n");
	printf("\n");
	printf("The /w and /h parameters define the default width and height of the\n");
	printf("application's window. The value of 0 for either will cause the main window\n");
	printf("to appear at a default size which is different on each platform.\n");
	printf("\n");
	printf("The /p parameter defines the full path to the directory which will contain\n");
	printf("the warp file under WindowsCE. This path is placed in the shortcut (.lnk)\n");
	printf("file so the application will know where to find it's warp file.\n");
	printf("\n");
	printf("For PalmOS, if no icon is defined, a black box is used. Any icon given must\n");
	printf("be in .bmp format. A PalmOS PRC creator and PRC name will be assigned based\n");
	printf("on the warpfile and exefile respectively. The exefile must be 30 characters\n");
	printf("or less.\n");
	printf("\n");
	printf("The sizes specified are used by the WabaVM to determine how much memory\n");
	printf("to allocate for the app. The size of the class heap defaults to %dK.\n",
		classHeapSize / 1000);
	printf("The size of the object heap defaults to %dK. The size of the stack\n",
		objectHeapSize / 1000);
	printf("defaults to %d bytes. The size of the native stack defaults to %d bytes.\n",
		stackSize, nativeStackSize);
	printf("\n");
	printf("Examples:\n");
	printf("   exegen /i s.bmp /p \"\\Program Files\\Scribble\" Scribble ScribbleApp scribble\n");
	printf("   exegen /w 160 /h 160 /m 20000 Calc CalcWindow calc mathlib\n");
	exitError(0);
	}


