
/******************************************************************************
    PING - internet diagnostic tool
    Copyright (C) 1991, University of Waterloo
    portions Copyright (C) 1990, National Center for Supercomputer Applications

    This program is free software; you can redistribute it and/or modify
    it, but you may not sell it.

    This program is distributed in the hope that it will be useful,
    but without any warranty; without even the implied warranty of
    merchantability or fitness for a particular purpose.

        Erick Engelke                   or via E-Mail
        Faculty of Engineering
        University of Waterloo          Erick@development.watstar.uwaterloo.ca
        200 University Ave.,
        Waterloo, Ont., Canada
        N2L 3G1

******************************************************************************/

#include <stdio.h>
#include <std.h>
#include <gppconio.h>
#include <pc.h>

#include "socket.h"

#include "sock_ini.c"
#include "pctcp.c"
#include "pcconfig.c" 
#include "pcarp.c" 
#include "pcbootp.c" 
#include "pcicmp.c" 
#include "udp_dom.c" 
#include "bsdname.c" 
#include "socket.c"

//#include "pcstat.c" 
#include "sock_dbu.c" 
#include "select.c" 
#include "udp_nds.c" 
//#include "wattcpd.c" 
#include "pcbuf.c"
#include "pcbsd.c"
#include "pcsed.c"
#include "pcrecv.c"
#include "elib.c"
#include "pcpkt.c"
#include "fragment.c"
#include "ethernet.c"
#include "pcping.c"

extern unsigned long set_timeout(unsigned short );

longword sent = 0L;
longword received = 0L;
longword tot_delays = 0L;
longword last_rcvd = 0L;
char *name;

void stats()
{
    longword temp;

    puts("\nPing Statistics");
    printf("Sent        : %lu \n", sent );
    printf("Received    : %lu \n", received );
    if (sent)
        printf("Success     : %lu \n", (100L*received)/sent);
    if (!received)
        printf("There was no response from %s\n", name );
    else {
        temp = ( tot_delays * 2813L)/(512L*received + 1);
        printf("Average RTT : %lu.%02lu seconds\n", temp / 100L, temp % 100L);
    }
    exit( received ? 0 : 1 );
}

void help()
{
    puts("PING [-s|/s] [-d|/d] hostname [number]");
    exit( 3 );
}
