/*
Copyright (C) 2001 by Mohan Embar

http://www.thisiscool.com/

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later version. 

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU General Public License for more details. 

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA. 
*/

typedef int FontID;
typedef char Char;
typedef uint16 Word;
typedef uint16 SWord;
typedef void* WinHandle;
typedef void* WinPtr;
typedef enum {scrCopy, scrXOR, scrAND, scrOR} ScrOperation;

#define stdFont 0
#define boldFont 1

#define screenFormat 0

#define true 1
#define false 0

typedef struct
{
    int x;
    int y;
} Point;

typedef struct
{
    Point topLeft;
    Point extent;
} RectangleType;

typedef RectangleType *RectanglePtr;

#ifdef _WIN32

// Font

static FontID FntSetFont(int n) {return 0;}
static int FntBaseLine() {return 0;}
static int FntDescenderHeight() {return 0;}
static int FntLineHeight() {return 0;}
static int FntCharWidth(Char ch) {return 0;}
static int FntCharsWidth(char* psz, Word wCount) {return 0;}

// Window

static WinHandle WinCreateOffscreenWindow
(
    SWord wWidth,
    SWord wHeight,
    int nFormat,
    Word* pwError
)
{
    return NULL;
}
static void WinDeleteWindow(WinHandle hwnd, int nSomething)
{}
static void WinDrawLine(int nX1,int nY1, int nX2, int nY2)
{}
static void WinEraseLine(int nX1,int nY1, int nX2, int nY2)
{}
static WinHandle WinGetDrawWindow()
{
    return NULL;
}
static void WinSetDrawWindow(WinHandle hwnd)
{}
static void WinEraseWindow()
{}
static void WinDrawRectangle(RectanglePtr prct, int nRounded)
{}
static void WinEraseRectangle(RectanglePtr prct, int nRounded)
{}
static void WinGetClip(RectanglePtr prct)
{}
static void WinClipRectangle(RectanglePtr prct)
{}
static void WinSetClip(RectanglePtr prct)
{}
static void WinDrawChars(char* psz, int16 nLen, int nX, int nY) {}
static void WinEraseChars(char* psz, int16 nLen, int nX, int nY) {}
static void WinCopyRectangle
(
    WinHandle hSrc,
    WinHandle hDest,
    RectanglePtr prct,
    int nDstX,
    int nDstY,
    ScrOperation eMode
)
{}

static char* initPalmEmul()
{
    return 0;
}

static void donePalmEmul()
{
}

#else

#include <grx20.h>

// Font

static GrFont* pfntPlain;
static GrFont* pfntBold;

static GrFont* pfntCurrent;
int nCurrentFontID;

static GrColor clrCurrent;

static void GetCoords
(
    RectanglePtr prct,
    int* pnX1,
    int* pnY1,
    int* pnX2,
    int* pnY2
)
{
    *pnX1 = prct->topLeft.x;
    *pnY1 = prct->topLeft.y;
    *pnX2 = prct->topLeft.x + prct->extent.x - 1;
    *pnY2 = prct->topLeft.y + prct->extent.y - 1;
    if (*pnX2 == g_mainWinWidth-1)
        *pnX2 = g_mainWinWidth;
    if (*pnY2 == g_mainWinHeight-1)
        *pnY2 = g_mainWinHeight;
}

static GrColor getCurrentColor()
{
    return getVMIsColor() ? clrCurrent : GrBlack();
}

static void setCurrentColor(int rgb)
{
	int r, g, b;
	
	r = rgb >> 16;
	g = (rgb >> 8) & 0xFF;
	b = rgb & 0xFF;
    clrCurrent = GrAllocColor(r,g,b);
}

static FontID FntSetFont(int n)
{
    int nOldID = nCurrentFontID;
    switch (n)
    {
        case stdFont:
        {
            pfntCurrent = pfntPlain;
            break;
        }
        case boldFont:
        {
            pfntCurrent = pfntBold;
            break;
        }
    }
    nCurrentFontID = n;
    return nOldID;
}

static int FntBaseLine()
{
    return pfntCurrent->h.baseline;
}

static int FntDescenderHeight()
{
    return
        pfntCurrent->h.height
        -
        pfntCurrent->h.baseline;
}

static int FntLineHeight()
{
    return pfntCurrent->h.height;
}

static int FntCharWidth(Char ch)
{
    return GrFontCharWidth(pfntCurrent,ch);
}

static int FntCharsWidth(char* psz, Word wCount)
{
    return GrFontStringWidth(pfntCurrent,psz,wCount,0);
}

// Window

static WinHandle WinCreateOffscreenWindow
(
    SWord wWidth,
    SWord wHeight,
    int nFormat,
    Word* pwError
)
{
    WinHandle hwnd = (WinHandle) GrCreateContext(wWidth,wHeight,NULL,NULL);
#ifdef DEBUGVERBOSE
    fprintf(pfilLog, "WWW: Created offscreen window %d, %d, %d\n", (int) hwnd, (int) wWidth, (int) wHeight);
    fflush(pfilLog);
#endif
    *pwError = 0;
    return hwnd;
}

static void WinDeleteWindow(WinHandle hwnd, int nSomething)
{
    GrDestroyContext((GrContext*) hwnd);
}

static void WinDrawLine(int nX1,int nY1, int nX2, int nY2)
{
#ifdef DEBUGVERBOSE
    fprintf(pfilLog, "WinDrawLine(%d,%d,%d,%d)\n",nX1,nY1,nX2,nY2);
    fflush(pfilLog);
#endif
    GrLine(nX1,nY1,nX2,nY2,getCurrentColor());
}

static void WinEraseLine(int nX1,int nY1, int nX2, int nY2)
{
#ifdef DEBUGVERBOSE
    fprintf(pfilLog, "WinEraseLine(%d,%d,%d,%d)\n",nX1,nY1,nX2,nY2);
    fflush(pfilLog);
#endif
    GrLine(nX1,nY1,nX2,nY2,GrWhite());
}

static GrContext* pCurContext = NULL;

static WinHandle WinGetDrawWindow()
{
    WinHandle hwnd = (WinHandle) pCurContext;
#ifdef DEBUGVERBOSE
    fprintf(pfilLog, "WWW: Getting draw window %d\n", (int) hwnd);
    fprintf(pfilLog, "WWW: Screen context: %d\n", (int) GrScreenContext());
    fflush(pfilLog);
#endif
    return hwnd;
}

static void WinSetDrawWindow(WinHandle hwnd)
{
#ifdef DEBUGVERBOSE
    fprintf(pfilLog, "WWW: Setting draw window to %d\n", (int) hwnd);
    fflush(pfilLog);
#endif
    GrSetContext(pCurContext = (GrContext*) hwnd);
}

static void WinDrawRectangle(RectanglePtr prct, int nRounded)
{
    int nX1, nY1, nX2, nY2;
    GetCoords(prct,&nX1,&nY1,&nX2,&nY2);

#ifdef DEBUGVERBOSE
    fprintf(pfilLog, "WinDrawRectangle(%d,%d,%d,%d)\n",nX1,nY1,nX2,nY2);
    fflush(pfilLog);
#endif
    GrFilledBox(nX1,nY1,nX2,nY2,getCurrentColor());
}

static void DrawCursor(RectanglePtr prct)
{
    int nX1, nY1, nX2, nY2;
    GrColor clrCurrent;
    static GrColor clrCursor = 1;

    GetCoords(prct,&nX1,&nY1,&nX2,&nY2);
    if (clrCursor==1)
        clrCursor = getVMIsColor() ? GrAllocColor(0,0,255) : GrBlack();

    clrCurrent = GrPixel(nX1,nY1);
#ifdef DEBUGVERBOSE
    fprintf(pfilLog, "clrCurrent = %d, clrCursor = %d\n", clrCurrent, clrCursor);
    fflush(pfilLog);
#endif

    if (clrCurrent != clrCursor)
        GrFilledBox(nX1,nY1,nX2,nY2, clrCursor);
    else
        GrFilledBox(nX1,nY1,nX2,nY2, GrWhite());

#ifdef DEBUGVERBOSE
    fprintf(pfilLog, "DrawCursor(%d,%d,%d,%d)\n",nX1,nY1,nX2,nY2);
    fflush(pfilLog);
#endif
}

static void WinEraseRectangle(RectanglePtr prct, int nRounded)
{
    int nX1, nY1, nX2, nY2;
    GetCoords(prct,&nX1,&nY1,&nX2,&nY2);

#ifdef DEBUGVERBOSE
    fprintf(pfilLog, "WinEraseRectangle(%d,%d,%d,%d)\n",nX1,nY1,nX2,nY2);
    fflush(pfilLog);
#endif

    GrFilledBox(nX1,nY1,nX2,nY2,GrWhite());
}

static void WinEraseWindow()
{
    GrFilledBox(0,0,g_mainWinWidth,g_mainWinHeight,GrWhite());
}

static void WinGetClip(RectanglePtr prct)
{
    int x1, y1, x2, y2;
    GrGetClipBox(&x1,&y1,&x2,&y2);
    if (x2>g_mainWinWidth) x2=g_mainWinWidth;
    if (y2>g_mainWinHeight) y2=g_mainWinHeight;
    prct->topLeft.x = x1;
    prct->topLeft.y = y1;
    prct->extent.x = x2-x1;
    prct->extent.y = y2-y1;
}

static int min(int nX, int nY)
{
    if (nX < nY)
        return nX;
    else
        return nY;
}

static void swap(int nX, int nY)
{
    int nTmp;
    nTmp = nX;
    nX = nY;
    nY = nTmp;
}

static void DoClip(int nCur1, int nCur2, int n1, int n2, int* pnNew1, int* pnNew2)
{
    int nTmp;

    if (nCur1 > n1)
    {
        swap(nCur1,n1);
        swap(nCur2,n2);
    }

    // nCur1 <= n1
    if (nCur2 < n1)
    {
        *pnNew1 = n1;
        *pnNew2 = n1;
    }

    // nCur2 >= n1
    *pnNew1 = n1;
    *pnNew2 = min(n2,nCur2);
}

static void WinClipRectangleC(GrContext* pContext, RectanglePtr prct)
{
    int nCurX1, nCurX2, nCurY1, nCurY2;
    int nX1, nY1, nX2, nY2;
    int nNewX1, nNewY1, nNewX2, nNewY2;

    GrGetClipBoxC(pContext,&nCurX1,&nCurY1,&nCurX2,&nCurY2);
    nX1 = prct->topLeft.x;
    nY1 = prct->topLeft.y;
    nX2 = nX1 + prct->extent.x;
    nY2 = nY1 + prct->extent.y;

    DoClip(nCurX1,nCurX2,nX1,nX2,&nNewX1,&nNewX2);
    DoClip(nCurY1,nCurY2,nY1,nY2,&nNewY1,&nNewY2);

    prct->topLeft.x = nNewX1;
    prct->extent.x = nNewX2 - nNewX1;
    prct->topLeft.y = nNewY1;
    prct->extent.y = nNewY2 - nNewY1;

#ifdef DEBUGVERBOSE
    fprintf(pfilLog, "WinClipRectangle(%d,%d,%d,%d): CUR\n",nCurX1,nCurY1,nCurX2,nCurY2);
    fprintf(pfilLog, "WinClipRectangle(%d,%d,%d,%d): ARG\n",nX1,nY1,nX2,nY2);
    fprintf(pfilLog, "WinClipRectangle(%d,%d,%d,%d): NEW\n",nNewX1,nNewY1,nNewX2,nNewY2);
    fflush(pfilLog);
#endif
}

static void WinClipRectangle(RectanglePtr prct)
{
    WinClipRectangleC(pCurContext,prct);
}

static void WinSetClip(RectanglePtr prct)
{
    int nX1, nY1, nX2, nY2;
    GetCoords(prct,&nX1,&nY1,&nX2,&nY2);

#ifdef DEBUGVERBOSE
    fprintf(pfilLog, "WinSetClip(%d,%d,%d,%d)\n",nX1,nY1,nX2,nY2);
    fflush(pfilLog);
#endif

    GrSetClipBox(nX1,nY1,nX2,nY2);
}

static void WinDrawChars(char* psz, int16 nLen, int nX, int nY)
{
	GrTextOption opt;
	memset(&opt,0,sizeof(opt));

	opt.txo_font   = pfntCurrent;
    opt.txo_bgcolor.v = GrNOCOLOR;
    opt.txo_fgcolor.v = getCurrentColor();
    GrDrawString(psz,nLen,nX,nY,&opt);
}

static void WinEraseChars(char* psz, int16 nLen, int nX, int nY)
{
	GrTextOption opt;
	memset(&opt,0,sizeof(opt));

	opt.txo_font   = pfntCurrent;
    opt.txo_bgcolor.v = GrNOCOLOR;
    opt.txo_fgcolor.v = GrWhite();
    GrDrawString(psz,nLen,nX,nY,&opt);
}

static void WinCopyRectangle
(
    WinHandle hSrc,
    WinHandle hDest,
    RectanglePtr prct,
    int nDstX,
    int nDstY,
    ScrOperation eMode
)
{
    int nX1, nY1, nX2, nY2;
    GrColor op;
    RectangleType rct;

    GetCoords(prct,&nX1,&nY1,&nX2,&nY2);
#ifdef DEBUGVERBOSE
    fprintf(pfilLog, "WinCopyRectangle(%d,%d,%d,%d)\n",nX1,nY1,nX2,nY2);
    fflush(pfilLog);
#endif

    switch (eMode)
    {
        case scrCopy:
            op = GrWRITE;
            break;
        case scrXOR:
            op = GrXOR;
            break;
        case scrAND:
            op = GrAND;
            break;
        case scrOR:
            op = GrOR;
            break;
    }

#ifdef DEBUGVERBOSE
    fprintf(pfilLog, "op = %d\n", op);
    fprintf(pfilLog, "nDstX = %d, nDstY = %d\n", nDstX, nDstY);
    fflush(pfilLog);
#endif

    // Respect the clipping bounds of the destination
    // context.
    if (hDest == GrScreenContext())
    {
        rct.topLeft.x = nDstX;
        rct.extent.x = nX2 - nX1;
        rct.topLeft.y = nDstY;
        rct.extent.y = nY2 - nY1;
        WinClipRectangle(&rct);
        nX2 = nX1 + rct.extent.x;
        nY2 = nY1 + rct.extent.y;
    }
    
    GrBitBlt
    (
        (GrContext*) hDest,
        nDstX,
        nDstY,
        (GrContext*) hSrc,
        nX1,
        nY1,
        nX2,
        nY2,
        op
    );
}

static char szError[50];

static char* initFonts()
{
    pfntPlain = GrLoadFont("helv11.fnt");
    if (!pfntPlain)
        return strcpy(szError, "Couldn't load plain font.");

    pfntBold = GrLoadFont("helv11b.fnt");
    if (!pfntBold)
        return strcpy(szError, "Couldn't load bold font.");

    FntSetFont(stdFont);

    return 0;
}
#include <pc.h>
static char* initPalmEmul()
{
    char* psz;
    int i;
    
    // Go into graphics mode
	GrSetMode(GR_default_graphics);
    GrSetContext(GrScreenContext());

    nXltOffX = (GrScreenX()-g_mainWinWidth) >> 1;
    nXltOffY = (GrScreenY()-g_mainWinHeight) >> 1;
    
    pCurContext =
        GrCreateSubContext
        (
            nXltOffX,
            nXltOffY,
            g_mainWinWidth + nXltOffX,
            g_mainWinHeight + nXltOffY,
            GrScreenContext(),
            NULL
        );
    GrSetContext(pCurContext);

    GrSetClipBox(0,0,g_mainWinWidth,g_mainWinHeight);

    // Initialize our bold and plain fonts
    psz = initFonts();
    if (psz) return psz;

    // Draw our main window rectangle
    WinEraseWindow();

    return 0;
}

static void donePalmEmul()
{
    // Release our fonts
    GrUnloadFont(pfntBold);
    GrUnloadFont(pfntPlain);

    // Go back into text mode
	GrSetMode(GR_default_text);
}

#endif
