;=============================================================================
; Insight, real-mode debugger for MS DOS / PC DOS / FreeDOS.
; Copyright (c) Victor M. Gamayunov, Sergey Pimenov, 1993, 96, 97, 2002.
; Modifications by Oleg O. Chukaev (2006 - 2008).
;-----------------------------------------------------------------------------
; colors.inc
; Constants: colors.
;-----------------------------------------------------------------------------
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
; 
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
; 02111-1307, USA.
;=============================================================================

%include	"data\colors_k.inc"

;=============================================================================
; Main screen
;-----------------------------------------------------------------------------
atMainWindow		equ	MAIN_BG*16+MAIN_FG
atTitle			equ	MAIN_BG*16+TITLE_FG
atCPUborder		equ	MAIN_BG*16+BORDER_FG
atCPUName		equ	MAIN_BG*16+CPU_NAME_FG

;atCmdNormal		equ	atNormInstr
;atCmdSelected		equ	atSelInstr
;atBP_and_Cur		equ	atBrkSelInstr
;atBreakPoint		equ	atBrkInstr

atNormAddr		equ	MAIN_BG*16+ADDR_FG
atNormOpcode		equ	MAIN_BG*16+OP_FG
atNormInstr		equ	MAIN_BG*16+INS_FG
atNormNumber		equ	MAIN_BG*16+NUM_FG
atNormArrow		equ	MAIN_BG*16+ARR_FG
atNormDisable		equ	MAIN_BG*16+DIS_FG
                	
atSelAddr		equ	CPU_S_BG*16+ADR_S_FG
atSelOpcode		equ	CPU_S_BG*16+OP_S_FG
atSelInstr		equ	CPU_S_BG*16+INS_S_FG
atSelNumber		equ	CPU_S_BG*16+NUM_S_FG
atSelArrow		equ	CPU_S_BG*16+ARR_S_FG
atSelDisable		equ	CPU_S_BG*16+DIS_S_FG

atBrkAddr		equ	CPU_B_BG*16+ADR_B_FG
atBrkOpcode		equ	CPU_B_BG*16+OP_B_FG
atBrkInstr		equ	CPU_B_BG*16+INS_B_FG
atBrkNumber		equ	CPU_B_BG*16+NUM_B_FG
atBrkArrow		equ	CPU_B_BG*16+ARR_B_FG
atBrkDisable		equ	CPU_B_BG*16+DIS_B_FG

atBrkDisAddr		equ	RED*16+DARK_GRAY
atBrkDisOpcode		equ	RED*16+DARK_GRAY
atBrkDisInstr		equ	RED*16+DARK_GRAY
atBrkDisNumber		equ	RED*16+DARK_GRAY
atBrkDisArrow		equ	RED*16+WHITE
atBrkDisDisable		equ	RED*16+DARK_GRAY

atBrkSelAddr		equ	MAGENTA*16+WHITE
atBrkSelOpcode		equ	MAGENTA*16+WHITE
atBrkSelInstr		equ	MAGENTA*16+WHITE
atBrkSelNumber		equ	MAGENTA*16+WHITE
atBrkSelArrow		equ	MAGENTA*16+WHITE
atBrkSelDisable		equ	MAGENTA*16+DARK_GRAY

atBrkDSAddr		equ	MAGENTA*16+DARK_GRAY
atBrkDSOpcode		equ	MAGENTA*16+DARK_GRAY
atBrkDSInstr		equ	MAGENTA*16+DARK_GRAY
atBrkDSNumber		equ	MAGENTA*16+DARK_GRAY
atBrkDSArrow		equ	MAGENTA*16+WHITE
atBrkDSDisable		equ	MAGENTA*16+DARK_GRAY

atNFAddr		equ	MAIN_BG*16+YELLOW
atNFOpcode		equ	MAIN_BG*16+YELLOW
atNFInstr		equ	MAIN_BG*16+YELLOW
atNFNumber		equ	MAIN_BG*16+YELLOW
atNFArrow		equ	MAIN_BG*16+WHITE
atNFDisable		equ	MAIN_BG*16+LIGHT_GRAY

;atCmdNormal		equ	LIGHT_GREEN
;atCmdSelected		equ	LIGHT_GRAY*16
;atBreakPoint		equ	RED*16+WHITE
;atBP&Cur		equ	MAGENTA*16+WHITE

atAsmLine		equ	BLACK*16+WHITE

atCodeMark		equ	MAIN_BG*16+CODE_MARK_FG

atRegName		equ	MAIN_BG*16+NAME_FG
atRegValue		equ	MAIN_BG*16+VALUE_FG
atRegNewValue		equ	MAIN_BG*16+NEW_VALUE_FG

atFlagValue		equ	MAIN_BG*16+VALUE_FG
atFlagNewValue		equ	MAIN_BG*16+NEW_VALUE_FG

atDumpAddr		equ	MAIN_BG*16+ADDR_FG
atDumpValue		equ	MAIN_BG*16+VALUE_FG
atDumpZero		equ	MAIN_BG*16+DUMP_ZERO_FG
atDumpCursor		equ	DUMP_CUR_BG*16+DUMP_CUR_FG

atStackName		equ	MAIN_BG*16+NAME_FG
atStackAddr		equ	MAIN_BG*16+ADDR_FG
atStackValue		equ	MAIN_BG*16+VALUE_FG

atMemAddr		equ	MAIN_BG*16+WHITE
atMemValue		equ	MAIN_BG*16+YELLOW

atCurUnasmAddr		equ	MAIN_BG*16+UNASM_ADDR_FG

atDataWatchMem		equ	MAIN_BG*16+DATA_WATCH_FG

atAssembler		equ	LIGHT_GRAY*16+WHITE
atsAssembler		equ	LIGHT_GRAY*16+WHITE
atBrkAssembler		equ	MAGENTA*16+LIGHT_CYAN
atsBrkAssembler		equ	MAGENTA*16+LIGHT_CYAN

;=============================================================================
; Menu.
;-----------------------------------------------------------------------------
atMenuBorder		equ	MEUN_BG*16+MENU_BORDER_FG
atMenuNorm		equ	MEUN_BG*16+MENU_TXT_FG
atMenuNormHot		equ	MEUN_BG*16+MENU_HOT_FG
atMenuNormDis		equ	MEUN_BG*16+MENU_DIS_FG
atMenuSel		equ	MENU_S_BG*16+MENU_S_TXT_FG
atMenuSelHot		equ	MENU_S_BG*16+MENU_S_HOT_FG
atMenuSelDis		equ	MENU_S_BG*16+MENU_S_DIS_FG

;=============================================================================
; Horizontal menu.
;-----------------------------------------------------------------------------
atHMenuNorm		equ	MEUN_BG*16+MENU_TXT_FG
atHMenuNormHot		equ	MEUN_BG*16+MENU_HOT_FG
atHMenuSel		equ	MENU_S_BG*16+MENU_S_TXT_FG
atHMenuSelHot		equ	MENU_S_BG*16+MENU_S_HOT_FG

;=============================================================================
; Input line.
;-----------------------------------------------------------------------------
atInputLine		equ	INPUT_BG*16+INPUT_FG
atsInputLine		equ	INPUT_S_BG*16+INPUT_S_FG

;=============================================================================
; Message box / Error box.
;-----------------------------------------------------------------------------
atMessageBox		equ	MSG_BOX_BG*16+MSG_BOX_B_FG
atMessageBoxTitle	equ	MSG_BOX_BG*16+MSG_BOX_T_FG
atMessage		equ	MSG_BOX_BG*16+MSG_BOX_M_FG

atErrorBox		equ	ERR_BOX_BG*16+ERR_BOX_B_FG
atErrorBoxTitle		equ	ERR_BOX_BG*16+ERR_BOX_T_FG
atErrorMsg		equ	ERR_BOX_BG*16+ERR_BOX_M_FG

;=============================================================================
; Dialog windows.
;-----------------------------------------------------------------------------
atDialogWindow		equ	DIALOG_BG*16+DIALOG_B_FG
atDialogWindowTitle	equ	DIALOG_BG*16+DIALOG_T_FG
atShadow		equ	WINDOW_SH_BG*16+WINDOW_SH_FG

;=============================================================================
; Buttons.
;-----------------------------------------------------------------------------
atPushButton		equ	BUTTON_BG*16+BLACK
atlPushButton		equ	BUTTON_BG*16+YELLOW
atsPushButton		equ	BUTTON_BG*16+WHITE
atlsPushButton		equ	BUTTON_BG*16+YELLOW
atPushButtonDef		equ	BUTTON_BG*16+BLUE
atlPushButtonDef	equ	BUTTON_BG*16+YELLOW
atButtonShadow		equ	DIALOG_BG*16+BLACK

;=============================================================================
; Labels.
;-----------------------------------------------------------------------------
atLabel			equ	DIALOG_BG*16+BLACK
atlLabel		equ	DIALOG_BG*16+YELLOW
atsLabel		equ	DIALOG_BG*16+WHITE
atlsLabel		equ	DIALOG_BG*16+YELLOW

;=============================================================================
; String list.
;-----------------------------------------------------------------------------
atListNormal		equ	LIST_BG*16+LIST_FG
atListSelected		equ	LIST_S_BG*16+LIST_S_FG
atListDefault		equ	LIST_BG*16+LIST_D_FG

;=============================================================================
; Check boxes.
;-----------------------------------------------------------------------------
atCheckBoxes		equ	CB_RB_BG*16+CB_RB_T_FG
atsCheckBoxes		equ	CB_RB_BG*16+CB_RB_S_FG
atlCheckBoxes		equ	CB_RB_BG*16+CB_RB_H_FG

;=============================================================================
; Radio buttons.
;-----------------------------------------------------------------------------
atRadioButtons		equ	CB_RB_BG*16+CB_RB_T_FG
atsRadioButtons		equ	CB_RB_BG*16+CB_RB_S_FG
atlRadioButtons		equ	CB_RB_BG*16+CB_RB_H_FG

;=============================================================================
; E0F
;=============================================================================

