;=============================================================================
; toggle_breakpoint
;-----------------------------------------------------------------------------
toggle_breakpoint:
		mov	si,[cur_line_ip]
		call	check_bp
		jc	@@set
		mov	byte [bx+BP_ACTIVE],BP_UNUSED
		jmp	@@ok
@@set:
		mov	bx,bp1
		mov	cx,MAX_BREAKPOINTS
@@next_bp:
		cmp	byte [bx+BP_ACTIVE],BP_UNUSED
		jne	@@skip
		mov	ax,[unasm_seg]
		mov	[bx+BP_SEG],ax
		mov	ax,[cur_line_ip]
		mov	[bx+BP_OFFS],ax
		mov	byte [bx+BP_SET],0
		call	test_breakpoint
		jc	@@not
		mov	byte [bx+BP_ACTIVE],BP_ENABLED
		jmp	@@ok
@@not:
		mov	si,bp_not_in_ram
		call	_error_message
		jmp	@@ok
@@skip:
		add	bx,SIZEOF_BREAKPOINT
		loop	@@next_bp

		mov	si,many_bp_msg
		call	_error_message
@@ok:
		jmp	update_commands
;=============================================================================
; toggle_activity
;-----------------------------------------------------------------------------
toggle_activity:
		mov	si,[cur_line_ip]
		call	check_bp
		jnc	@@toggle
		jmp	beep

@@toggle:
		cmp	byte [bx+BP_ACTIVE],BP_ENABLED
		mov	byte [bx+BP_ACTIVE],BP_DISABLED
		je	@@exit

		mov	byte [bx+BP_ACTIVE],BP_ENABLED
@@exit:
		jmp	update_commands
;=============================================================================
; set_all_breaks
;-----------------------------------------------------------------------------
set_all_breaks:
		mov	bx,bp1
		mov	cx,MAX_BREAKPOINTS

@@next_bp:
		cmp	byte [bx+BP_ACTIVE],BP_UNUSED
		je	@@skip
		mov	byte [bx+BP_ACTIVE],al

@@skip:
		add	bx,SIZEOF_BREAKPOINT
		loop	@@next_bp
		jmp	update_commands
;=============================================================================
; clear_all_breaks
;-----------------------------------------------------------------------------
clear_all_breaks:
		mov	al,BP_UNUSED
		jmp	set_all_breaks
;=============================================================================
; enable_all_breaks
;-----------------------------------------------------------------------------
enable_all_breaks:
		mov	al,BP_ENABLED
		jmp	set_all_breaks
;=============================================================================
; disable_all_breaks
;-----------------------------------------------------------------------------
disable_all_breaks:
		mov	al,BP_DISABLED
		jmp	set_all_breaks
;=============================================================================
; test_breakpoint
;-----------------------------------------------------------------------------
test_breakpoint:
		push	ax
		push	si
		push	es
		cli
		mov	es,[bx+BP_SEG]
		mov	si,[bx+BP_OFFS]
		mov	al,[es:si]
		mov	byte [es:si],0cch
		cmp	byte [es:si],0cch
		je	@@ok
		stc
@@ok:
		mov	[es:si],al
		sti
		pop	es
		pop	si
		pop	ax
		ret
;=============================================================================
; check_bp
;-----------------------------------------------------------------------------
check_bp:
		push	ax
		push	cx
		mov	bx,bp1
		mov	cx,MAX_BREAKPOINTS
@@next_bp:
		cmp	byte [bx+BP_ACTIVE],BP_UNUSED
		je	@@skip
		cmp	si,[bx+BP_OFFS]
		jne	@@skip
		mov	ax,[unasm_seg]
		cmp	ax,[bx+BP_SEG]
		jne	@@skip
		cmp	byte [bx+BP_ACTIVE],BP_ENABLED
		jmp	@@exit
@@skip:
		add	bx,SIZEOF_BREAKPOINT
		loop	@@next_bp
		stc
@@exit:
		pop	cx
		pop	ax
		ret
;=============================================================================

