{
    Free Pascal port of the OpenPTC C++ library.
    Copyright (C) 2001-2003  Nikolay Nikolov (nickysn@users.sourceforge.net)
    Original C++ version by Glenn Fiedler (ptc@gaffer.org)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

Constructor TPTCCopy.Create;

Begin
  If Not Hermes_Init Then
    Raise TPTCError.Create('could not initialize hermes');
  m_flags := HERMES_CONVERT_NORMAL;
  m_handle := Hermes_ConverterInstance(m_flags);
  If m_handle = 0 Then
    Raise TPTCError.Create('could not create hermes converter instance');
End;

Destructor TPTCCopy.Destroy;

Begin
  Hermes_ConverterReturn(m_handle);
  Hermes_Done;
  Inherited Destroy;
End;

Procedure TPTCCopy.request(Const source, destination : TPTCFormat);

Var
  hermes_source_format, hermes_destination_format : PHermesFormat;

Begin
  hermes_source_format := @source.Fformat;
  hermes_destination_format := @destination.Fformat;
  If Not Hermes_ConverterRequest(m_handle, hermes_source_format,
     hermes_destination_format) Then
    Raise TPTCError.Create('unsupported hermes pixel format conversion');
End;

Procedure TPTCCopy.palette(Const source, destination : TPTCPalette);

Begin
  If Not Hermes_ConverterPalette(m_handle, source.m_handle,
	 destination.m_handle) Then
    Raise TPTCError.Create('could not set hermes conversion palettes');
End;

Procedure TPTCCopy.copy(Const source_pixels : Pointer; source_x, source_y,
		   source_width, source_height, source_pitch : Integer;
		   destination_pixels : Pointer; destination_x, destination_y,
		   destination_width, destination_height, destination_pitch : Integer);

Var
  source : Pointer;

Begin
{$IFDEF DEBUG}
{
  This checking is performed only when DEBUG is defined,
  and can be used to track down errors early caused by passing
  nil pointers to surface and console functions.

  Even though technicially it is the users responsibility
  to ensure that all pointers are non-nil, it is useful
  to provide a check here in debug build to prevent such
  bugs from ever occuring.

  The checking function also tests that the source and destination
  pointers are not the same, a bug that can be caused by copying
  a surface to itself. The nature of the copy routine is that
  this operation is undefined if the source and destination memory
  areas overlap.
}
  If source_pixels = Nil Then
    Raise TPTCError.Create('nil source pointer in copy');
  If destination_pixels = Nil Then
    Raise TPTCError.Create('nil destination pointer in copy');
  If source_pixels = destination_pixels Then
    Raise TPTCError.Create('identical source and destination pointers in copy');
{$ELSE DEBUG}
    { in release build no checking is performed for the sake of efficiency. }
{$ENDIF DEBUG}
  source := source_pixels;
  If Not Hermes_ConverterCopy(m_handle, source, source_x, source_y,
	  source_width, source_height, source_pitch, destination_pixels,
	  destination_x, destination_y, destination_width, destination_height,
	  destination_pitch) Then
    Raise TPTCError.Create('hermes conversion failure');
End;

Function TPTCCopy.option(Const _option : String) : Boolean;

Begin
  If (_option = 'attempt dithering') And ((m_flags And HERMES_CONVERT_DITHER) = 0) Then
  Begin
    m_flags := m_flags Or HERMES_CONVERT_DITHER;
    update;
    option := True;
    Exit;
  End;
  If (_option = 'disable dithering') And ((m_flags And HERMES_CONVERT_DITHER) <> 0) Then
  Begin
    m_flags := m_flags And (Not HERMES_CONVERT_DITHER);
    update;
    option := True;
    Exit;
  End;
  option := False;
End;

Procedure TPTCCopy.update;

Begin
  Hermes_ConverterReturn(m_handle);
  m_handle := Hermes_ConverterInstance(m_flags);
  If m_handle = 0 Then
    Raise TPTCError.Create('could not update hermes converter instance');
End;
