{
           LoadFont, a bitmap font loader for 32-bit FreeDOS

                Copyright (C) 2005 by Francesco Zamblera
                  under the GNU General Public License

                           vilnergoy@yahoo.it


    This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

    This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

   This program is similar to Kurt Zammit's GNUCHCP. The difference are:
   -it is compiled with 32-bit FreePASCAL, and uses 32-bit memory extensions;
   -it loads the upper 128 characters (ASCII 128-255), and leaves the lower
       128 ones intact. You can visualize the upper 128 characters using a
       keyboard driver.
}


Program LoadFont;

Uses Dos, Go32;

var     reg    : registers;

Procedure AllocBuffer (var selector: word; var segment: word; size: LongInt);
var result: longint;
begin
 result := global_dos_alloc (size);
 selector := word(result);
 segment := word(result shr 16)
end;

Procedure Load (filename: string);
var     f: file of byte;
        n: byte;
        selector, segment, offset: word;

begin
 assign(f,filename); reset(f);
 AllocBuffer(selector,segment,2048);
 for Offset := 0 to 2047 do begin
                                read(f,n);
                                dosmemput(segment,offset,n,1)
                            end;
 reg.ah := $11;
 reg.al := $10;
 reg.bh := 16;
 reg.bl := 0;
 reg.cx := 128;
 reg.dx := 128;
 reg.es := segment;
 reg.bp := 0;
 intr($10,reg);
 global_dos_free(selector)
end;

Procedure UnLoad;
begin
 reg.ah := $11;
 reg.al := 04;
 reg.bx := 0;
 intr($10,reg)
end;

begin
 if ParamStr(1) = '-r'
        then UnLoad
        else Load (ParamStr(1))
end.
