{
****************************************************************
****************************************************************
**                                                            **
**          FLISP,  a LISP interpreter for FreeDOS            **
**                                                            **
**          Copyright (C) 2005 by Francesco Zamblera          **
**           under the GNU General Public License             **
**                                                            **
**                       Version 1.0                          **
**                                                            **
****************************************************************
****************************************************************

    This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

    This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    Contact me at

    vilnergoy@yahoo.it
}




{---------------------------------------}
UNIT Header;

{---------------------------------------}
INTERFACE

{---------------------------------------}
TYPE Symbol = string[16];

     SymType = (_int, _char, _id, _op, _list, _null, _spec, _float,
                _ratio, _string, _file, _struct, _array);

     OpCodes = (_two_stars, _three_stars,
                _add, _mul, _sub, _div, _random, _setq, _format,
               _print, _princ, _terpri, _readln, _read, _writeln, _write,
               _type_of,
                _dotimes, _dolist, _doloop, _loop, _return,
                _quote, _backquote, _comma,_at,
               _defun, _defmacro,
               _load, _quit, _bye, _car, _cdr, _cons, _eval, _lst, _let,
               _let_star,
                 _eq, _ne, _lt, _gt, _le, _ge, _eq_atom, _str_eq, _str_ne,
                 _str_gt, _str_lt, _boundp, _if, _cond,
               _sqrt, _sin, _cos, _help, _coerce,
               _open, _close, _symbol_name, _make_symbol, _lambda,
               _catch, _throw, _write_func, _save_func, _init_file,
               _sf, _refresh, _do,
               _do_star, _load_font, _load_keyb, _unload_font,
               _unload_keyb, _exp);

     directions = (_input, _output, _undef);

     PCell = ^Cell;
     PCellList = ^CellList;
     PVarTable = ^VarTable;

     Cell = record
             case  Flag: SymType of
                  _int: (int : integer);
                  _ratio: (num, denom: integer);
                  _float: (float: real);
                  _char: (ch : char);
                  _id: (varname : string);
                  _op: (opcode : OpCodes);
                  _list: (list : PCellList);
                  _spec: (t: boolean);
                  _string: (str: string);
                  _file: (Descriptor: string);
                  _struct: (strname: string;
                            r: PVarTable)
                 end;

     CellList = record
              Data: Cell;
              Next: PCellList
             end;

     VarTable = record
              varname: string;
              value: cell;
              next: PVarTable
             end;

     PFuncTable = ^FuncTable;
     FuncTable = record
               FuncName: string;
               FuncParam, FuncBody : cell;
               IsMacro: boolean;
               next : PFuncTable
              end;

      FileCell = record
        FileVar: text;
        IsOpen: boolean;
        dir: directions;
        pos: integer;
        Name,Descriptor: string
      end;

      GlobalRes = ^NonLocalExit;
      NonLocalExit = record
       name: string;
       value: cell;
       next: GlobalRes
     end;

     PLocalVar = ^LocalVar;
     localvar = record
       p: PVarTable;
       next: PLocalVar
     end;



{---------------------------------------}
CONST Tab = ^I;
      CR = ^M;
      LF = ^J;
      NL = ^M + ^J;
      MAXFILES = 20;
      KEYWORDS = 76;
      TYPES = 13;
      KWlist: array [1..KEYWORDS] of Symbol =
              ('**','***',
               '+','*','-','/', 'RANDOM', 'SETQ', 'FORMAT','PRINT', 'PRINC',
              'TERPRI', 'READ-LINE', 'READ', 'WRITE-LINE', 'WRITE',
              'TYPE-OF', 'DOTIMES', 'DOLIST', 'DOLOOP', 'LOOP', 'RETURN',
              'QUOTE', 'BACKQUOTE','COMMA', 'COMMA-AT', 'DEFUN', 'DEFMACRO',
              'LOAD','QUIT', 'BYE', 'CAR', 'CDR', 'CONS', 'EVAL', 'LIST',
              'LET', 'LET*', '=','/=','<', '>', '<=', '>=', 'EQ',
              'STRING=', 'STRING/=', 'STRING>', 'STRING<', 'BOUNDP',
              'IF', 'COND', 'SQRT', 'SIN', 'COS', 'HELP', 'COERCE',
              'OPEN','CLOSE', 'SYMBOL-NAME', 'MAKE-SYMBOL', 'LAMBDA',
              'CATCH','THROW', 'WRITE-FUNC','SAVE-FUNC', 'INIT-FILE',
              'SF','REFRESH',
              'DO', 'DO*', 'LOAD-FONT', 'LOAD-KEYB', 'UNLOAD-FONT',
              'UNLOAD-KEYB', 'EXP');
      TypeNames : array [1..TYPES] of Symbol =
               ('FIXNUM', 'CHAR', 'ID', 'OP', 'LST', 'NULL', 'SPEC',
                'FLOAT', 'RATIO', 'STRING', 'FILE','STRUCT','ARRAY');


{---------------------------------------}
VAR Look : char;
    Exit_Code, stop: Boolean;

    InputFile, OutputFile: Integer;

    Code: PCellList;
    Result: Cell;
    Counter: Integer;

    PreviousRes: Array [1..3] of Cell;

    GlobalVar: PVarTable;
    FuncTab : PFuncTable;

    Files: array [-MAXFILES..MAXFILES] of FileCell;

    thrown,Break : boolean;
    FileID, DeskFileID: integer;
    GlobalResult: GlobalRes;
    AssignedDesktop: boolean;

{---------------------------------------}
IMPLEMENTATION

begin
end.

