// ͻ
//    TEST-PROGRAM FOR THE VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C    
// Ķ
//           (C) Detlef Reimers, JUNE 1999, dreimers@aol.com          
// ͼ
#include <vesa.h>

#define rnd(n)  rand() % n

// Ŀ
//  Global variables.                                                 
// 
#define stars 400
#define depth 400
#define width 8000

// Ŀ
//  Global strings.                                                   
// 
char * info[2] =
{
  "STARFIELD ANIMATION",
  "MODE %d: %dx%d"
};

// Ŀ
//  SCREEN: Set up a screen with infos and a border.                  
// 
void screen(void)
{
  int k;

  k = hor - 141 - 8*(hor/1000) - 8*(ver/1000);

  setcol(blue, 0, 23, 35);
  
  rect ( 0, 0, hor - 1, ver - 1, lwhite);
  hline(20, 1, hor - 1, lwhite);
  frect( 1, 1, hor - 2, 19, blue);
  print( 5, 7, lwhite , 16, info[0]);
  print( k, 7, lwhite , 16, info[1], mode, hor, ver);

  clip(2, 21, hor - 2, ver - 2);
}

// Ŀ
//  Demo: This shoes a simple 3D Starfield Simulation.                
// 
void demo(int m)
{
  int i, h, v, w;
  int sx[stars], sy[stars], sz[stars];
  int osx[stars], osy[stars];

  gmode(m);
  screen();

  h = hor >> 1;
  v = ver >> 1;
  w = width >> 1;

  for (i = 0; i < stars; i++)
  {
    osx[i] = 0;
    osy[i] = 0;
    sx[i] = (rnd(width) - w) << 2;
    sy[i] = (rnd(width) - w) << 2;
    sz[i] = rnd(depth) + 1;
  }

  while (!key())
  {
    for(i = 0; i < stars; i++)
    {
      if (osx[i] < hor)
        plot(osx[i], osy[i], black);

      sz[i]--;

      if (sz[i] == 0)
        sz[i] = depth;

      osx[i] = ((sx[i] + sx[i]) / sz[i]) + h;
      osy[i] = ((sy[i] + sy[i]) / sz[i]) + v;

      if (osx[i] < hor)
        plot(osx[i], osy[i], lwhite);
    }
  }
}

// Ŀ
//  Main: It runs the demo function at several resolutions.           
// 
void main(void)
{
  demo(257);
  demo(259);
  demo(261);

  tmode();
}

