// ͻ
//    TEST-PROGRAM FOR THE VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C    
// Ķ
//           (C) Detlef Reimers, JUNE 1999, dreimers@aol.com          
// ͼ
#include <vesa.h>

#define rnd(n)  rand() % n

// Ŀ
//  Global strings.                                                   
// 
char * info[13] =
{
  "MODE %d: %dx%d", "PRINT", "PLOT", "LINE", "BEZIER", "HLINE",
  "VLINE", "RECT", "FRECT", "CIRCLE", "FCIRCLE", "ELLIPSE", "VESALIB"
};

// Ŀ
//  SCREEN: Set up the screen with infos and border.                  
// 
void screen(int n)
{
  int k;

  k = hor - 141 - 8*(hor/1000) - 8*(ver/1000);

  noclip();

  setcol( blue, 0, 23, 35);

  frect (2, 19, hor - 2, ver - 2, black);
  frect (1,  1, hor - 2, 17, blue);
  rect  (0,  0, hor - 1, ver - 1, lwhite);
  line  (0, 18, hor - 1, 18, lwhite);
  print (5,  6, lwhite,  16, info[n]);
  print (k,  6, lwhite,  16, info[0], mode, hor, ver);

  clip  (4, 22, hor - 5, ver - 5);
}

// Ŀ
//  Test: This switches to all the avalaible functions.               
// 
void test(int n)
{
  int i, j, h, v;

  if (n == 1)
    for(i = 0; i < 20; i++)
      print(rnd(xmax-28), rnd(ymax), rnd(256), rnd(256), info[12]);

  else if (n == 2)
    for(i = 0; i < 1000; i++)
      plot(rnd(xmax), rnd(ymax), rnd(256));

  else if (n == 3)
    for(i = 0; i < 100; i++)
      line(rnd(xmax), rnd(ymax), rnd(xmax), rnd(ymax), rnd(256));

  else if (n == 4)
    for(i = 0; i < 100; i++)
    {
      for (j = 0; j < 4; j++)
      {
        bez[j][0] = rnd(xmax);
        bez[j][1] = rnd(ymax);
      }
      bezier(5, rnd(256));
    }

  else if (n == 5)
    for(i = 0; i < 100; i++)
      hline(rnd(ymax), rnd(xmax), rnd(xmax), rnd(256));

  else if (n == 6)
    for(i = 0; i < 100; i++)
      vline(rnd(xmax), rnd(ymax), rnd(ymax), rnd(256));

  else if (n == 7)
    for(i = 0; i < 100; i++)
    {
      h = rnd(xmax);
      v = rnd(ymax);
      rect(h, v, h+rnd(160), v+rnd(160), rnd(256));
    }

  else if (n == 8)
    for(i = 0; i < 100; i++)
    {
      h = rnd(xmax);
      v = rnd(ymax);
      frect(h, v, h+rnd(160), v+rnd(160), rnd(256));
    }

  else if (n == 9)
    for(i = 0; i < 100; i++)
      circle(rnd(xmax), rnd(ymax), rnd(80), rnd(256));

  else if (n == 10)
    for(i = 0; i < 100; i++)
      fcircle(rnd(xmax), rnd(ymax), rnd(80), rnd(256));

  else if (n == 11)
    for(i = 0; i < 100; i++)
      ellipse(rnd(xmax), rnd(ymax), rnd(80), rnd(80), rnd(256));
}

// Ŀ
//  Demo: This function selects the test functions.                   
// 
void demo(int m)
{
  int n;

  gmode(m);

  for (n = 1 ; n < 12; n++)
  {
    screen(n);
    while(!key())
      test(n);
  }
}

// Ŀ
//  Main: This runs the demo function at several resolutions.         
// 
void main(void)
{
  demo(257);
  demo(259);
  demo(261);
  demo(292);
  demo(263);

  tmode();
}

