// ͻ
//    TEST-PROGRAM FOR THE VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C    
// Ķ
//           (C) Detlef Reimers, JUNE 1999, dreimers@aol.com          
// ͼ
#include <vesa.h>

#define rnd(n)  rand() % n
#define abs(a)  ((a < 0) ? -a : a)

// Ŀ
//  Global variables.                                                 
// 
#define ctop    lwhite                          // top text color
#define cbot    lwhite                          // bottom text color
#define ctxt    16                              // bodytext color
#define ctit    lwhite                          // text title color
#define cpic    44                              // pict title color
#define cshd    16                              // underline color
#define cudl    lwhite                          // underline color

int x[ 5] = { 20, 120, 145, 520, 780};          // Object x-coordinates
int y[10] = { 20,  80, 180, 245, 255,           // Object y-coordinates
             290, 355, 430, 530, 580};

int    cx =  600; int  cy = 150;                // Ball coordinates
int    dx =    4; int  dy =  -4;                // Ball displacements

int bx[4] = {-2, 3, 2,-3};                      // Bezier displacements
int by[4] = {-2, 2,-2, 2};                      // of control points

// Ŀ
//  Global strings.                                                   
// 
char * title[] =
{
  "VESALIB 1.4 for PACIFIC-C",
  "INTRODUCTION",
  "(C) 1999, Detlef Reimers",
  "MODE 103h: 800x600 PIXEL",
  "CIRCLES",
  "PIXELS",
  "RECTS",
  "BALL ANIMATION",
  "BEZIER ANIMATION",
  "WELCOME TO THE VESA GRAPHICS LIBRARY",
  "SOME NOTES ABOUT THE DEMO PROGRAMS"
};
  
char * infos[] =
{
  "This is a graphics library for VESA modes.",
  "Supported resolutions are from 640x400 up",
  "to 1280x1024 pixel, all with 256 colors.",
  "The library is written in assembly language",
  "for AS86 from HighSoft. It uses the small",
  "memory modell and needs at least a 80386.",
  "VESALIB is public domain, but the advanced",
  "routines (circle, ellipse and bezier) are",
  "my own copyright.",
  "To compile the library, start RUN.BAT and",
  "choose the option [c] or [p]. That's it!"
};

char * demos[] =
{
  "The demo programs show the usage of almost",
  "every library function. I've put a lot of",
  "effort into this example files. You can use",
  "and change them freely. Try to figure out,",
  "how to get special effects. This intro file",
  "uses the rectangle clipping together with",
  "many other functions. Try the bezier files,",
  "to see how PostScript draws characters.",
  "If you like nice palettes, run PALETTE. It",
  "uses a special palette for beautyful output.",
  "S3-card users should use VBE20 and SPEEDUP",
  "to get maximum performance without flicker.",
  "Please, read the documentation to get full",
  "library information and much more.",
  "",
  "I wish you happy programming with VESALIB!"
};

// Ŀ
//  SCREEN: Set up the screen background and place the text.          
// 
void screen(void)
{
  int i;

  setcol(blue ,  0, 23, 35);                    // For top & bottom
  setcol(black, 45, 45, 45);                    // For Background

  frect(0,       0,  hor-1,  ver-1, black);     // Screen rect
  frect(0,       0,  hor-1,   y[0], blue);      // Top rect
  frect(0,    y[9],  hor-1,  ver-1, blue);      // Bottom rect

  rect (0,       0,  hor-1,  ver-1, lwhite);    // Screen frame
  rect (0,       0,  hor-1,   y[0], lwhite);    // Top frame
  rect (0,    y[9],  hor-1,  ver-1, lwhite);    // Bottom frame

  frect(x[0], y[1],   x[1],   y[2], cshd);      // Circles rect
  frect(x[0], y[4],   x[1],   y[6], cshd);      // Lines rect
  frect(x[0], y[7],   x[1],   y[8], cshd);      // Pixels rect

  rect (x[0], y[1], x[1]-1, y[2]-1, lwhite);    // Circles frame
  rect (x[0], y[4], x[1]-1, y[6]-1, lwhite);    // Lines frame
  rect (x[0], y[7], x[1]-1, y[8]-1, lwhite);    // Pixels frame

  frect(x[3], y[1], x[4]+1, y[3]+1, cshd);      // Ball rect
  frect(x[3], y[5], x[4]+1, y[8]+1, cshd);      // Spline rect

  rect (x[3], y[1], x[4],     y[3], lwhite);    // Ball frame
  rect (x[3], y[5], x[4],     y[8], lwhite);    // Spline frame

  hline(     1,        1,    hor-2, cshd);      // These are some
  hline(y[0]+1,        1,    hor-2, cshd);      // 3D-effect lines
  hline(y[9]+1,        1,    hor-2, cshd);      // in the top, the
  vline(     1,        1,   y[0]-1, cshd);      // bottom fields
  vline(     1,   y[0]+1,   y[9]-1, cshd);      // and inside the
  vline(     1,   y[9]+1,    ver-2, cshd);      // main rectangle

  hline(y[1]-6,     x[2], x[2]+286, cudl);      // Underline Info title
  hline(y[1]-5,   x[2]+1, x[2]+287, cshd);      // Info line shadow
  hline(y[5]-6,     x[2], x[2]+270, cudl);      // Underline Demo title
  hline(y[5]-5,   x[2]+1, x[2]+271, cshd);      // Demo line shadow

  print(     10,        7, ctop, 16, title[0]); // Top left title
  print(hor-105,        7, ctop, 16, title[1]); // Top right title
  print(     10,   ver-14, cbot, 16, title[2]); // Bottom left title
  print(hor-202,   ver-14, cbot, 16, title[3]); // Bottom right title

  print(x[0]+10,  y[1]-16, cpic, 16, title[4]); // Circles title
  print(x[0]+10,  y[4]-16, cpic, 16, title[5]); // Lines title
  print(x[0]+10,  y[7]-16, cpic, 16, title[6]); // Pixels title

  print(x[4]-122, y[1]-16, cpic, 16, title[7]); // Ball title
  print(x[4]-138, y[5]-16, cpic, 16, title[8]); // Spline title

  print(x[2],     y[1]-16, ctit, 16, title[ 9]); // Info title
  print(x[2],     y[5]-16, ctit, 16, title[10]); // Demo title

  for (i = 0; i < 11; i++)
    print(x[2], y[1]+15*i+5, ctxt, 0, infos[i]); // Info body text

  for (i = 0; i < 16; i++)
    print(x[2], y[5]+15*i+5, ctxt, 0, demos[i]); // Demo body text
}

// Ŀ
//  SPLINE: Shows a pseudo-3D effect with an animated bezier spline.  
// 
void spline(int n)
{
  int i;

  clip(x[3]+1, y[5]+1, x[4]-1, y[8]-1);

  if (n == 1)
  {
    for (i = 0; i < 4; i++)
    {
      if (bez[i][0] <= x[3] - 30 | bez[i][0] >= x[4] + 30)
        bx[i] = -bx[i];
      if (bez[i][1] <= y[5] - 30 | bez[i][1] >= y[8] + 30)
        by[i] = -by[i];

      bez[i][0] = bez[i][0] + bx[i];
      bez[i][1] = bez[i][1] + by[i];
    }
    line   (bez[0][0], bez[0][1], bez[1][0], bez[1][1], 4);
    line   (bez[3][0], bez[3][1], bez[2][0], bez[2][1], 4);
    bezier (5, 48);
    fcircle(bez[0][0], bez[0][1], 2, 44);
    fcircle(bez[1][0], bez[1][1], 2, 32);
    fcircle(bez[2][0], bez[2][1], 2, 32);
    fcircle(bez[3][0], bez[3][1], 2, 44);
  }
  else
  {
    line   (bez[0][0], bez[0][1], bez[1][0], bez[1][1], cshd);
    line   (bez[3][0], bez[3][1], bez[2][0], bez[2][1], cshd);
    bezier (5, cshd);
    fcircle(bez[0][0], bez[0][1], 2, cshd);
    fcircle(bez[1][0], bez[1][1], 2, cshd);
    fcircle(bez[2][0], bez[2][1], 2, cshd);
    fcircle(bez[3][0], bez[3][1], 2, cshd);
  }
}

// Ŀ
//  BALL: Bounces a 3D-ball in a rectangle on the right.              
// 
void ball(int n)
{
  clip(x[3]+1, y[1]+1, x[4]-1, y[3]-1);

  if (n == 1)
  {
    if (cx <= x[3] + 15 + abs(dx) | cx >= x[4] - 15 - abs(dx))
      dx = -dx;

    if (cy <= y[1] + 15 + abs(dy) | cy >= y[3] - 15 - abs(dy))
      dy = -dy;

    cx = cx + dx;
    cy = cy + dy;

    fcircle(cx  , cy  , 15, 40);
    fcircle(cx+5, cy-5,  5, 12);
    fcircle(cx+5, cy-5,  4, 64);
    fcircle(cx+5, cy-5,  3, 86);
    fcircle(cx+5, cy-5,  1, 15);
  }
  else
    fcircle(cx, cy, 15, cshd);
}

// Ŀ
//  RANDOM: Shows random pixels, lines and circles at the left.       
// 
void random(void)
{
  int i, h, v;

  clip(x[0]+2, y[1]+2, x[1]-2, y[2]-2);

  for ( i = 0; i < 4; i++)
    fcircle(rnd(x[1]), rnd(y[2]), rnd(30), rnd(256));

  clip(x[0]+2, y[4]+2, x[1]-2, y[6]-2);

  for ( i = 0; i < 400; i++)
    plot(rnd(x[1]), rnd(y[6]), rnd(256));

  clip(x[0]+2, y[7]+2, x[1]-2, y[8]-2);

  for ( i = 0; i < 4; i++)
  {
    h = rnd(x[1]);
    v = rnd(y[8]+50);
    frect(h, v, h+rnd(60), v+rnd(60), rnd(256));
  }
}

// Ŀ
//  MAIN: Do some nice animations and random patterns.                
// 
void main(void)
{
  gmode(259);
  screen();

  bez[0][0] = 600;  bez[0][1] = 400;
  bez[1][0] = 600;  bez[1][1] = 300;
  bez[2][0] = 700;  bez[2][1] = 500;
  bez[3][0] = 700;  bez[3][1] = 400;

  while(!key())
  {
    random();
    ball(1);
    spline(1);

    retrace();

    ball(2);
    spline(2);
  }
  
  tmode();
}
