// ͻ
//    TEST-PROGRAM FOR THE VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C    
// Ķ
//           (C) Detlef Reimers, JUNE 1999, dreimers@aol.com          
// ͼ
#include <math.h>
#include <vesa.h>

#define abs(a)  ((a < 0) ? -a : a)

// Ŀ
//  Global variables.                                                 
// 
float x1,  x2,  y1,  y2;
float ax,  bx,	ay,  by,  c1, c2, d, dx, y;
int   sx1, sx2, sy1, sy2, sx, sy, fnum, fcol, tcol, pcol;

// Ŀ
//  Global strings.                                                   
// 
char * titl[] =
{
  "FUNCTION GRAPHING",
  "MODE %d: %dx%d",
  "A SIMPLE MATH-PLOTTER",
  "SELECT FUNCTION & MOVE POINT"
};

char * info[] =
{
  "This demo shows, how to plot",
  "simple math functions. The  ",
  "graph has to be scaled and  ",
  "clipped to the destination  ",
  "rectangle.                  ",
  "The grid lines are drawn at ",
  "integer values of x and y.  ",
  "",
  "To change from math space to",
  "screen space, we use two",
  "linear functions:",
  "",
  "",
  "",
  "By inserting x1, x2, y1 and y2",
  "we can solve these equations.",
  "Note: y1 corresponds to sy2",
  "and y2 corresponds to sy1.",
  "The solutions are the scaling",
  "functions:",
  "",
  "",
  "",
  "",
  "",
  " Type a number from 0 to 9",
  "  to plot a specific function.",
  " Use left/right arrows to",
  "  move the point and tangent",
  "  line.",
  " Use up/down arrows to move",
  "  to leftmost/rightmost point."
};

char * math[] =
{
  "sx = ax * x + bx",
  "sy = ay * y + by",
  "ax = (sx2 - sx1)/(x2 - x1)",
  "ay =-(sy2 - sy1)/(y2 - y1)",
  "bx =  sx1 - ax * x1",
  "by =  sy1 - ay * y2"
};

char * equ[] =
{
  "y=(x-7)(x-1)e^(0.4x-2)",
  "y=e(-0.25x)sin(3x)",
  "y=0.05(x+5)(x-3)(x-7)",
  "y=8cos(x/4)sin(4x)",
  "y=5sin(x+sin(2x))",
  "y=7sin(2x)/x-5",
  "y=0.01(x-8)(x-5)(x+2)(x+7)",
  "y=6(1-cos(2x))/x",
  "y=8(x+sin(x))e^(-xx)",
  "y=8cos(0.5xx)"

};

// Ŀ
//  SCREEN: Set up a screen frame with a title a draw a grid.         
// 
void screen(void)
{
  int k;

  k = hor - 141 - 8*(hor/1000) - 8*(ver/1000);

  setcol(black, 40, 40, 40);
  setcol(blue,   0, 23, 35);

  frect (sx1,   sy1,   sx2,   sy2,   16);
  rect  (sx1,   sy1,   sx2,   sy2,   lwhite);
  hline (sy2+1, sx1,   sx2+1,        16);
  vline (sx2+1, sy1+1, sy2,          16);
  rect  (0,     0,     hor-1, ver-1, lwhite);
  hline (20,    1,     hor-1,        lwhite);
  frect (1,     1,     hor-2, 19,    blue);

  print (5, 7, lwhite, 16, titl[0]);
  print (k, 7, lwhite, 16, titl[1], mode, hor, ver);

  print (15, 33, lwhite, 16, titl[2]);
  hline (44, 15, 183, lwhite);
  hline (45, 16, 184, 16);

  for (k = 0; k < 25; k++)
    print(15, 60 + 15*k, 16, 0, info[k]);

  for (k = 0; k < 2; k++)
    print(35, 232 + 15*k, blue, 0, math[k]);

  for (k = 2; k < 6; k++)
    print(35, 337 + 15*k, blue, 0, math[k]);

  print (15, ver - 152, lwhite, 16, titl[3]);
  hline (ver - 141, 15, 239, lwhite);
  hline (ver - 140, 16, 240, 16);

  for (k = 0; k < 7; k++)
    print(15, ver - 125 + 15*k, 16, 0, info[k+25]);
}

// Ŀ
//  SCALE: This calculates the scaling factors, needed for changing   
//         from math space into graph space.                          
// 
void scale(void)
{
  ax =  (sx2 - sx1) / (x2 - x1);
  ay = -(sy2 - sy1) / (y2 - y1);
  bx =   sx1 - ax * x1;
  by =   sy1 - ay * y2;
}

// Ŀ
//  AXIS: This draws the axes and a grid with labels.                 
// 
void axis(int c1, int c2, int c3)
{
  int i;

  for (i = x1 + 1; i < x2; i += 1)
  {
    sx = ax * i + bx;
    vline(sx, sy1, sy2, c1);
    if ((i < 0) & (i % 2 == 0))
      print(sx - 8, by + 4, c3, 0, "%d", i);
    if ((i > 0) & (i % 2 == 0))
      print(sx - 2, by + 4, c3, 0, "%d", i);
  }

  for (i = y1 + 1; i < y2; i += 1)
  {
    sy = ay * i + by;
    hline(sy, sx1, sx2, c1);
    if ((i < 0) & (i % 2 == 0))
      print(bx - 18, sy - 3, c3, 0, "%d", i);
    if ((i > 0) & (i % 2 == 0))
      print(bx - 10, sy - 3, c3, 0, "%d", i);
  }

  hline(by, sx1, sx2, c2);
  vline(bx, sy1, sy2, c2);

}

// Ŀ
//  FUNC: This calculates function values from the arguments.         
// 
float func(float x, int n)
{
  if (n == 0)
    y = (x-7)*(x-1)*exp(0.4*x-2);

  if (n == 1)
  {
    y = sin(3*x);
    y = y*exp(-0.25*x);
  }

  if (n == 2)
    y = 0.05*(x+5)*(x-3)*(x-7);

  if (n == 3)
  {
    y = 8*cos(x/4);
    y = y*sin(4*x);
  }

  if (n == 4)
    y = 5*sin(x+sin(2*x));

  if (n == 5)
    y = 7*sin(2*x)/x-5;

  if (n == 6)
    y = 0.01*(x-8)*(x-5)*(x+2)*(x+7);

  if (n == 7)
  {
    y = 1-cos(2*x);
    y = 6*y/x;
  }

  if (n == 8)
  {
    y = (x+sin(x));
    y = 8*y*exp(-0.5*x*x);
  }

  if (n == 9)
    y = 8*cos(0.5*x*x);

  return(y);
}

// Ŀ
//  DERIVE: This calculates the first derivative at the given point.  
// 
float derive(float x)
{
  float yu, yo;

  yu = func(x-0.01, fnum);
  yo = func(x+0.01, fnum);

  return(50 * (yo - yu));
}

// Ŀ
//  COORD: This calculates the screen coordinates from the x- and     
//         y-values.                                                  
// 
void coord(float x, int n)
{
  y  = func(x, n);

  sx = ax * x + bx;
  sy = ay * y + by;
}

// Ŀ
//  GRAPH: This actually plots the function graph to the screen area, 
//         defined by (sx1, sy1) and (sx2, sy2). It uses the moveto/  
//         lineto combination, which is very handy for this task.     
// 
void graph(int n)
{
  float x;

  dx = 2 * (x2 - x1) / (sx2 - sx1);

  coord(x1, n);
  moveto(sx, sy);

  for (x = x1; x <= x2; x += dx)
  {
    coord(x, n);
    lineto(sx, sy, fcol);
  }
}

// Ŀ
//  TANGENT: Draws a curve tangente at the given point.	       
// 
void tangent(float x, int l)
{
  float a, lx, ly;

  a = atan(d);
  lx = l * cos(a);
  ly = l * sin(a);

  sx = ax * (x-lx) + bx;
  sy = ay * (y-ly) + by;

  moveto(sx, sy);

  sx = ax * (x+lx) + bx;
  sy = ay * (y+ly) + by;

  lineto(sx, sy, tcol);
}

// Ŀ
//  POINT: Show curvepoint and coordinate values.		       
// 
void point(float x)
{

  coord(x, fnum);
  d = derive(x);

  clip(sx1, sy2+5, sx2, sy2+20);
  frect(sx1, sy2+5, sx2, sy2+16, black);
  print(sx-24, sy2+5, lcyan, 16, "y'=%+.3f", d);
  noclip();
  frect(sx2-180, sy1-12, sx2, sy1-2, black);
  print(sx2-180, sy1-12, lcyan, 16, "x=%+.3f", x);
  print(sx2- 80, sy1-12, lcyan, 16, "y=%+.3f", y);
  clip(sx1+1, sy1+1, sx2-1, sy2-1);

  pmode(3);
//  frect(sx-2, sy-2, sx+2, sy+2, pcol);
  fcircle(sx, sy, 2, pcol);
  tangent(x, 5);
  pmode(0);

//  clip(sx1+1, sy1+1, sx2-1, sy2-1);
}

// Ŀ
//  CHOOSE: This plots a specific function [0..9].                    
// 
void choose()
{
  int k;

  k = waitkey();
  if ((k > 47) & (k < 58))
  {
    frect(sx1, sy1, sx2, sy2, 16);
    axis(21, red, 102);
    noclip();
    frect(sx1, sy1 - 12, sx2, sy1 - 2, black);
    print(sx1 + 5, sy1 - 12, yellow, 16, equ[k - 48]);
    clip(sx1+1, sy1+1, sx2-1, sy2-1);
    graph(k - 48);
    fnum = k - 48;
    point(0);
    c1	= 0;
  }

  if (k == 77)
  {
    point(c1);

    if (c1 < x2)
      c2 = c1 + 0.05;
    else
      c2 = c1;

    point(c2);
    c1 = c2;
  }

  if (k == 75)
  {
    point(c1);

    if (c1 > x1)
      c2 = c1 - 0.05;
    else
      c2 = c1;

    point(c2);
    c1 = c2;
  }

  if (k == 80)
  {
    point(c1);
    c2 = x1;
    point(c2);
    c1 = c2;
  }

  if (k == 72)
  {
    point(c1);
    c2 = x2;
    point(c2);
    c1 = c2;
  }
}

// Ŀ
//  MAIN: Draws the grid and the characters "A" and "B".              
// 
void main(void)
{
  gmode (259);

  fcol = 48;
  tcol = 60 ^ 16;
  pcol = yellow ^ 16;

  x1  = -10;  x2  = 10;
  y1  = -10;  y2  = 10;
  sx1 = 270;  sx2 = hor - 10;
  sy1 =  45;  sy2 = ver - 20;

  screen();
  scale();

  clip(sx1+1, sy1+1, sx2-1, sy2-1);

  axis(21, red, 102);
  noclip();
  print(sx1 + 5, sy1 - 12, yellow, 16, equ[0]);
  clip(sx1+1, sy1+1, sx2-1, sy2-1);
  graph(0);
  fnum = 0;
  point(0);
  c1  = 0;

  while (1)
    choose();

  waitkey();
  tmode();
}

