// ͻ
//    TEST-PROGRAM FOR THE VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C    
// Ķ
//           (C) Detlef Reimers, JUNE 1999, dreimers@aol.com          
// ͼ
#include <vesa.h>

// Ŀ
//  Global variables.                                                 
// 
byt  pal[256][3];

// Ŀ
//  Global strings.                                                   
// 
char * info[2] =
{
  "ELLIPSE PATTERN",
  "MODE %d: %dx%d"
};

// Ŀ
//  Palette: Set up our own palette colors.                           
// 
void palette(void)
{
  long x, y;

  for(x = 0; x < 256 ; x++)
  {
    y = x & 63;
    
    if (x & 64)
      y = 63 - y;
    
    pal[x][0] = y;
    pal[x][1] = y * y / 63;
    y = (x >> 1) & 63;
    
    if (x & 128)
      y = 63 - y;
    
    pal[x][2] = y;
  }
}

// Ŀ
//  SCREEN: Set up a screen with infos and a border.                  
// 
void screen(void)
{
  int k;

  k = hor - 141 - 8*(hor/1000) - 8*(ver/1000);

  palette();
  setpal(*pal);
  setcol(blue, 0, 23, 35);
  setcol(lwhite, 63, 63, 63);
  setcol(black, 20, 20, 20);
  retrace();

  rect ( 0, 0, hor - 1, ver - 1, lwhite);
  hline(20, 1, hor - 1, lwhite);
  frect( 1, 1, hor - 2, 19, blue);
  print( 5, 7, lwhite , 16, info[0]);
  print( k, 7, lwhite , 16, info[1], mode, hor, ver);
}

// Ŀ
//  Demo: It shows a pattern made with colored ellipses.              
// 
void demo(int m)
{
  int i, h, v, c;

  gmode(m);

  v = ver/2 - 15;
  h = hor/2;

  screen();
  
  for (i = 0 ; i <= v; i += 8)
  {
    c = (i >> 1) + 7;
    if (c == 15)
      c++;
    ellipse(h, v + 24, i, v - i, c);
  }
  waitkey();
}

// Ŀ
//  Main: It runs the demo function at several resolutions.           
// 
void main()
{
  demo(257);
  demo(259);
  demo(261);

  tmode();
}

