// ͻ
//    TEST-PROGRAM FOR THE VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C    
// Ķ
//           (C) Detlef Reimers, JUNE 1999, dreimers@aol.com          
// ͼ
#include <vesa.h>

// Ŀ
//  Global strings.                                                   
// 
char * info[2] =
{
  "256 COLOR PALETTE",
  "MODE %d: %dx%d"
};

// Ŀ
//  SCREEN: Set up a screen with infos and a border.                  
// 
void screen(void)
{
  int k;

  k = hor - 141 - 8*(hor/1000) - 8*(ver/1000);

  setcol(255, 0, 23, 35);
  
  rect ( 0, 0, hor - 1, ver - 1, lwhite);
  hline(20, 1, hor - 1, lwhite);
  frect( 1, 1, hor - 2, 19, 255);
  print( 5, 7, lwhite, 16, info[0]);
  print( k, 7, lwhite, 16, info[1], mode, hor, ver);

  clip(2, 21, hor - 2, ver - 2);
}

// Ŀ
//  Demo: Shows a screen with all 256 colors with their numbers.      
// 
void demo(int m)
{
  int i, j, h, v, c;

  gmode(m);
  screen();

  h = hor - 2;
  v = ver - 22;
  c = 0;

  for (i = 0 ; i < 16; i++)
    for (j = 0; j < 16; j++)
    {
      frect(j*h/16+1, i*v/16+1+20, (j+1)*h/16-1, (i+1)*v/16-1+20, c++);
      print(j*h/16+6, i*v/16+24, 28, 16, "%d", c-1);
    }
  waitkey();
}

// Ŀ
//  Main: It runs the demo function at several resolutions.           
// 
void main()
{
  demo(257);
  demo(259);
  demo(261);

  tmode();
}

