; ͻ
; 		VESA GRAPHICS LIBRARY 1.4 FOR PACIFIC-C 	       
; Ķ
; 	    (C) Detlef Reimers, JUNE 1999, dreimers@aol.com	       
; ͼ
        .186
        .globl  small_data
        .globl  small_code

; Ŀ
;   Global functions.                                                 
; 
        .psect  _TEXT,class=CODE

        .globl  _printf
        .globl  _main
        .globl  _vinf
        .globl  _mode
        .globl  _hor
        .globl  _ver
        .globl  _bits
        .globl  _gran
        .globl  _line
        .globl  _bank
        .globl  _plan
        .globl  _col
        .globl  _info

; Ŀ
;   Vinf: This function calls the VESA function 4f01h for infos.      
; 
_vinf:
	push	bp
        mov     bp,sp
	push	di

	mov	_mode,dx	; save	graph mode
	mov	ax,#4f01h	; call VESA function
        mov     cx,dx           ; copy the graph mode
        mov     di,#buff        ; get buffer offset
        mov     bx,#seg(buff)   ; get buffer segment
        mov     es,bx           ; save in segment register
        int     #10h

	mov	ch,es:[di]		; get all informations
        and     ch,#1                   ; mask out all graph modes
        mov     _info,ch                ;   not supported by your card
        mov     cx,es:4[di]
        mov     _gran,cx
        mov     cx,es:16[di]
        mov     _line,cx
        mov     cx,es:18[di]
        mov     _hor,cx
        mov     cx,es:20[di]
        mov     _ver,cx
        mov     cl,es:24[di]
        mov     ch,#0
        mov     _plan,cx
        mov     cl,es:25[di]
        mov     ch,#0
        mov     _bits,cx
        mov     cl,es:26[di]
        mov     ch,#0
        mov     _bank,cx
        mov     cl,es:27[di]
        mov     ch,#0
        mov     _col,cx

        cmp     ah,#0                   ; if the VESA function returns
        brne    3f                      ;   nothing, we go to the next
        cmp     _info,#0,word           ; also if there is no info
        bre     3f                      ;   we go to the next mode
        push    _col,word               ; otherwise we print everything
        push    _plan,word              ;   to the screen
        push    _bank,word
        push    _bits,word
        push    _gran,word
        push    _line,word
        push    _ver,word
        push    _hor,word
        push    _mode,word
        mov     cx,#text
        push    cx
        call    _printf
3:
	pop	di
        leave
        ret

; Ŀ
;   Main: This calls the VESA info function and draws the title line. 
; 
_main:  enter   2,0
        mov     -2[bp],#100h,word
        mov     cx,#titl
        push    cx
        call    _printf
1:      mov     dx,-2[bp]
        call    _vinf
        inc     -2[bp],word
        cmp     -2[bp],#130h,word
        brl     1b
        leave
        ret

; Ŀ
;   The data section: VESA-Definitions and special variables.         
; 
        .psect  data, global

_info:  .word   0
_mode:  .word   0
_hor:   .word   0
_ver:   .word   0
_line:  .word   0
_gran:  .word   0
_bits:  .word   0
_bank:  .word   0
_plan:  .word   0
_col:   .word   0

titl:	.byte	10,10,9,"       THESE ARE THE MODES SUPPORTED BY YOUR VIDEO CARD",10,10,10
        .byte   9," MODE   HOR x  VER  LINE  GRAN  BITS  BANK  PLAN   COL ",10
        .byte   9,"",10,0
text:   .byte   9,"%4Xh  %4d x %4d  %4d  %3dk  %4d  %4d  %4d  %4d",10,0

; Ŀ
;   The bss section: We need a buffer, to which the VESA information  
;                    will copied.                                     
; 
        .psect  bss, global

        .align  2
buff:	.blkb	30
        .end

; 

